/*
 * Decompiled with CFR 0.152.
 */
package avail.project;

import avail.anvil.AvailWorkbench;
import avail.anvil.environment.GlobalEnvironmentSettings;
import avail.anvil.environment.LocationsKt;
import java.io.File;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.environment.AvailEnvironment;
import org.availlang.artifact.environment.location.InvalidLocation;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.artifact.environment.project.AvailProjectV1;
import org.availlang.artifact.environment.project.LocalSettings;
import org.availlang.json.JSONFriendly;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lavail/project/AvailProjectWorkbenchRunner;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "avail"})
public final class AvailProjectWorkbenchRunner {
    @NotNull
    public static final AvailProjectWorkbenchRunner INSTANCE = new AvailProjectWorkbenchRunner();

    private AvailProjectWorkbenchRunner() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void main(@NotNull String[] args2) throws Exception {
        void $this$main_u24lambda_u240;
        JSONFriendly jSONFriendly;
        Intrinsics.checkNotNullParameter(args2, "args");
        Pair<File, String> pair = switch (args2.length) {
            case 0 -> new Pair<File, String>(new File(AvailEnvironment.INSTANCE.getProjectRootDirectory("") + File.separator + "avail-config.json"), "Anvil");
            case 1 -> new Pair<File, String>(new File(args2[0]), "Anvil");
            case 2 -> {
                System.setProperty("apple.awt.application.name", args2[1]);
                new File(args2[0]);
                yield new Pair<File, String>(new File(args2[0]), args2[1]);
            }
            default -> throw new RuntimeException("Avail project runner expects either\n\t0 arguments: The Avail Project config file, `environment-config.json`, is at the project directory where this is being run from\n\t1 argument: The path, with name, of the project config file.\n\t2 arguments: The path, with name, of the project config file and the name of the app.");
        };
        File configFile = pair.getFirst();
        System.setProperty("apple.awt.application.name", (String)pair.getSecond());
        LocationsKt.setupEnvironment();
        try {
            String string2 = configFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue(string2, "configFile.absolutePath");
            jSONFriendly = AvailProject.Companion.from(string2);
        }
        catch (Exception e) {
            System.err.println("Error parsing project:\n" + ExceptionsKt.stackTraceToString(e));
            jSONFriendly = new AvailProjectV1("Unknown project", true, new InvalidLocation("", "Unable to parse config file: " + e, ""), new LocalSettings("", null, null, 6, null), null, null, null, null, 240, null);
        }
        AvailProject availProject = jSONFriendly;
        System.setProperty("darkMode", String.valueOf(availProject.getDarkMode()));
        JSONFriendly e = jSONFriendly = GlobalEnvironmentSettings.Companion.getGlobalSettings();
        AvailWorkbench.Companion companion = AvailWorkbench.Companion;
        boolean bl = false;
        String string3 = configFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string3, "configFile.absolutePath");
        $this$main_u24lambda_u240.add(availProject, string3);
        String string4 = configFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string4, "configFile.absolutePath");
        AvailWorkbench.Companion.launchSoloWorkbench$default(companion, (GlobalEnvironmentSettings)jSONFriendly, availProject, string4, null, false, 24, null);
    }
}

