/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import org.jetbrains.annotations.NotNull;

public final class SignatureBuildingComponents {
    @NotNull
    public static final SignatureBuildingComponents INSTANCE = new SignatureBuildingComponents();

    private SignatureBuildingComponents() {
    }

    @NotNull
    public final String javaLang(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return "java/lang/" + name;
    }

    @NotNull
    public final String javaUtil(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return "java/util/" + name;
    }

    @NotNull
    public final String javaFunction(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return "java/util/function/" + name;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] constructors(String ... signatures) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(signatures, "signatures");
        String[] $this$map$iv = signatures;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add("<init>(" + (String)it + ")V");
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @NotNull
    public final Set<String> inJavaLang(@NotNull String name, String ... signatures) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(signatures, "signatures");
        return this.inClass(this.javaLang(name), Arrays.copyOf(signatures, signatures.length));
    }

    @NotNull
    public final Set<String> inJavaUtil(@NotNull String name, String ... signatures) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(signatures, "signatures");
        return this.inClass(this.javaUtil(name), Arrays.copyOf(signatures, signatures.length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> inClass(@NotNull String internalName, String ... signatures) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        Intrinsics.checkNotNullParameter(signatures, "signatures");
        String[] stringArray = signatures;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv;
            void var9_9 = item$iv = $this$mapTo$iv[j];
            Collection collection2 = destination$iv;
            boolean bl = false;
            collection2.add(internalName + '.' + (String)it);
        }
        return (Set)destination$iv;
    }

    @NotNull
    public final String signature(@NotNull String internalName, @NotNull String jvmDescriptor2) {
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        Intrinsics.checkNotNullParameter(jvmDescriptor2, "jvmDescriptor");
        return internalName + '.' + jvmDescriptor2;
    }

    @NotNull
    public final String jvmDescriptor(@NotNull String name, @NotNull List<String> parameters2, @NotNull String ret) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(ret, "ret");
        return name + '(' + CollectionsKt.joinToString$default(parameters2, "", null, null, 0, null, jvmDescriptor.1.INSTANCE, 30, null) + ')' + this.escapeClassName(ret);
    }

    private final String escapeClassName(String internalName) {
        return internalName.length() > 1 ? 'L' + internalName + ';' : internalName;
    }

    public static final /* synthetic */ String access$escapeClassName(SignatureBuildingComponents $this, String internalName) {
        return $this.escapeClassName(internalName);
    }
}

