/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.environment.location;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.environment.AvailEnvironment;
import org.availlang.artifact.environment.location.AvailLocation;
import org.availlang.artifact.environment.location.ProjectHome;
import org.availlang.artifact.environment.location.Scheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/availlang/artifact/environment/location/ProjectConfig;", "Lorg/availlang/artifact/environment/location/ProjectHome;", "path", "", "projectFileName", "scheme", "Lorg/availlang/artifact/environment/location/Scheme;", "projectHome", "rootNameInJar", "(Ljava/lang/String;Ljava/lang/String;Lorg/availlang/artifact/environment/location/Scheme;Ljava/lang/String;Ljava/lang/String;)V", "editable", "", "getEditable", "()Z", "fullPathNoPrefix", "getFullPathNoPrefix", "()Ljava/lang/String;", "getProjectFileName", "relativeLocation", "Lorg/availlang/artifact/environment/location/AvailLocation;", "relativePath", "locationType", "Lorg/availlang/artifact/environment/location/AvailLocation$LocationType;", "avail-artifact"})
public class ProjectConfig
extends ProjectHome {
    @NotNull
    private final String projectFileName;
    private final boolean editable;

    public ProjectConfig(@NotNull String path, @NotNull String projectFileName, @NotNull Scheme scheme, @NotNull String projectHome, @Nullable String rootNameInJar) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(projectFileName, "projectFileName");
        Intrinsics.checkNotNullParameter((Object)scheme, "scheme");
        Intrinsics.checkNotNullParameter(projectHome, "projectHome");
        super(path, scheme, projectHome, rootNameInJar);
        this.projectFileName = projectFileName;
        this.editable = scheme != Scheme.JAR;
    }

    @NotNull
    protected final String getProjectFileName() {
        return this.projectFileName;
    }

    @Override
    @NotNull
    public String getFullPathNoPrefix() {
        return AvailEnvironment.INSTANCE.projectConfigPath(this.projectFileName, this.getProjectHome()) + File.separator + this.getPath();
    }

    @Override
    public boolean getEditable() {
        return this.editable;
    }

    @Override
    @NotNull
    public AvailLocation relativeLocation(@NotNull String relativePath, @NotNull Scheme scheme, @NotNull AvailLocation.LocationType locationType) {
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        Intrinsics.checkNotNullParameter((Object)scheme, "scheme");
        Intrinsics.checkNotNullParameter((Object)locationType, "locationType");
        return new ProjectConfig(this.getPath() + File.separator + relativePath, this.getProjectHome(), scheme, this.getProjectHome(), this.getRootNameInJar());
    }
}

