/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.environment.location;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.environment.location.AvailLocation;
import org.availlang.artifact.environment.location.Scheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ \u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/availlang/artifact/environment/location/ProjectHome;", "Lorg/availlang/artifact/environment/location/AvailLocation;", "path", "", "scheme", "Lorg/availlang/artifact/environment/location/Scheme;", "projectHome", "rootNameInJar", "(Ljava/lang/String;Lorg/availlang/artifact/environment/location/Scheme;Ljava/lang/String;Ljava/lang/String;)V", "editable", "", "getEditable", "()Z", "fullPathNoPrefix", "getFullPathNoPrefix", "()Ljava/lang/String;", "getProjectHome", "relativeLocation", "relativePath", "locationType", "Lorg/availlang/artifact/environment/location/AvailLocation$LocationType;", "avail-artifact"})
public class ProjectHome
extends AvailLocation {
    @NotNull
    private final String projectHome;
    private final boolean editable;

    public ProjectHome(@NotNull String path, @NotNull Scheme scheme, @NotNull String projectHome, @Nullable String rootNameInJar) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter((Object)scheme, "scheme");
        Intrinsics.checkNotNullParameter(projectHome, "projectHome");
        super(AvailLocation.LocationType.project, scheme, path, rootNameInJar);
        this.projectHome = projectHome;
        this.editable = scheme != Scheme.JAR;
    }

    @NotNull
    protected final String getProjectHome() {
        return this.projectHome;
    }

    @Override
    @NotNull
    public String getFullPathNoPrefix() {
        return this.projectHome + File.separator + this.getPath();
    }

    @Override
    public boolean getEditable() {
        return this.editable;
    }

    @Override
    @NotNull
    public AvailLocation relativeLocation(@NotNull String relativePath, @NotNull Scheme scheme, @NotNull AvailLocation.LocationType locationType) {
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        Intrinsics.checkNotNullParameter((Object)scheme, "scheme");
        Intrinsics.checkNotNullParameter((Object)locationType, "locationType");
        return new ProjectHome(this.getPath() + File.separator + relativePath, scheme, this.projectHome, this.getRootNameInJar());
    }
}

