/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil;

import avail.anvil.AvailWorkbench;
import avail.anvil.CodeGuide;
import avail.anvil.FileEditor;
import avail.anvil.MenuBarBuilder;
import avail.anvil.MenuBuilder;
import avail.anvil.Stylesheet;
import avail.anvil.SwingHelperKt;
import avail.anvil.WorkbenchFrame;
import avail.anvil.actions.FindAction;
import avail.anvil.shortcuts.FileEditorShortcut;
import avail.anvil.shortcuts.KeyboardShortcut;
import avail.anvil.text.CodePane;
import avail.anvil.text.FileEditorKit;
import avail.anvil.text.MarkToDotRange;
import avail.anvil.text.TextKitsKt;
import avail.anvil.window.LayoutConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.List;
import java.util.TimerTask;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u0000 G*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001GB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000101J\u0010\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106J\b\u00107\u001a\u000204H\u0002J\b\u00108\u001a\u000204H\u0002J\u001e\u00109\u001a\u0002042\u0014\b\u0002\u0010:\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002040;H\u0004J\b\u0010<\u001a\u000204H\u0014J\r\u0010=\u001a\u000204H\u0010\u00a2\u0006\u0002\b>J\u0006\u0010?\u001a\u000204J#\u0010@\u001a\u0002042\u0014\b\u0002\u0010A\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002040;H \u00a2\u0006\u0002\bBJ\u0006\u0010C\u001a\u000204J\u0006\u0010D\u001a\u000204J\u0010\u0010E\u001a\u0002042\b\u0010F\u001a\u0004\u0018\u000101R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006H"}, d2={"Lavail/anvil/FileEditor;", "CE", "Lavail/anvil/WorkbenchFrame;", "workbench", "Lavail/anvil/AvailWorkbench;", "fileLocation", "", "frameTitle", "(Lavail/anvil/AvailWorkbench;Ljava/lang/String;Ljava/lang/String;)V", "autoSave", "", "getAutoSave", "()Z", "caretRangeLabel", "Ljavax/swing/JLabel;", "codeGuide", "Lavail/anvil/CodeGuide;", "getCodeGuide", "()Lavail/anvil/CodeGuide;", "getFileLocation", "()Ljava/lang/String;", "firstUnsavedEditTime", "", "lastEditTime", "lastSaveTime", "layoutConfiguration", "Lavail/anvil/window/LayoutConfiguration;", "getLayoutConfiguration$avail", "()Lavail/anvil/window/LayoutConfiguration;", "<set-?>", "Lavail/anvil/text/MarkToDotRange;", "range", "getRange$avail", "()Lavail/anvil/text/MarkToDotRange;", "shortcuts", "", "Lavail/anvil/shortcuts/KeyboardShortcut;", "getShortcuts", "()Ljava/util/List;", "sourcePane", "Lavail/anvil/text/CodePane;", "getSourcePane$avail", "()Lavail/anvil/text/CodePane;", "sourcePaneScroll", "Ljavax/swing/JLayer;", "Ljavax/swing/JScrollPane;", "getWorkbench", "()Lavail/anvil/AvailWorkbench;", "add", "Ljava/awt/Component;", "comp", "addWindowListener", "", "l", "Ljava/awt/event/WindowListener;", "editorChanged", "eventuallySave", "finalizeInitialization", "afterTextLoaded", "Lkotlin/Function1;", "forceWrite", "highlightCode", "highlightCode$avail", "pack", "populateSourcePane", "then", "populateSourcePane$avail", "refreshShortcuts", "save", "setLocationRelativeTo", "c", "Companion", "avail"})
public abstract class FileEditor<CE>
extends WorkbenchFrame {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AvailWorkbench workbench;
    @NotNull
    private final String fileLocation;
    private final boolean autoSave;
    private long firstUnsavedEditTime;
    private long lastEditTime;
    private long lastSaveTime;
    @NotNull
    private final LayoutConfiguration layoutConfiguration;
    @NotNull
    private MarkToDotRange range;
    @NotNull
    private final JLabel caretRangeLabel;
    @NotNull
    private final CodePane sourcePane;
    @NotNull
    private final JLayer<JScrollPane> sourcePaneScroll;
    @NotNull
    public static final String generalFileEditor = "file-editor";

    /*
     * WARNING - void declaration
     */
    public FileEditor(@NotNull AvailWorkbench workbench, @NotNull String fileLocation, @NotNull String frameTitle) {
        void $this$_init__u24lambda_u246;
        JMenuBar jMenuBar;
        void $this$sourcePane_u24lambda_u242;
        CodePane codePane;
        Intrinsics.checkNotNullParameter((Object)workbench, (String)"workbench");
        Intrinsics.checkNotNullParameter((Object)fileLocation, (String)"fileLocation");
        Intrinsics.checkNotNullParameter((Object)frameTitle, (String)"frameTitle");
        super(frameTitle);
        this.workbench = workbench;
        this.fileLocation = fileLocation;
        this.autoSave = true;
        this.layoutConfiguration = LayoutConfiguration.Companion.getInitialConfiguration();
        this.caretRangeLabel = new JLabel();
        CodePane codePane2 = codePane = new CodePane(this.workbench, false, new FileEditorKit(this.workbench), 2, null);
        FileEditor fileEditor = this;
        boolean bl = false;
        $this$sourcePane_u24lambda_u242.addCaretListener(arg_0 -> FileEditor.sourcePane$lambda$2$lambda$0((CodePane)$this$sourcePane_u24lambda_u242, this, arg_0));
        Iterable $this$forEach$iv = Reflection.getOrCreateKotlinClass(FileEditorShortcut.class).getSealedSubclasses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KClass it = (KClass)element$iv;
            boolean bl2 = false;
            FileEditorShortcut fileEditorShortcut = (FileEditorShortcut)it.getObjectInstance();
            if (fileEditorShortcut == null) continue;
            InputMap inputMap = $this$sourcePane_u24lambda_u242.getInputMap();
            Intrinsics.checkNotNullExpressionValue((Object)inputMap, (String)"inputMap");
            fileEditorShortcut.addToInputMap(inputMap);
        }
        $this$sourcePane_u24lambda_u242.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ FileEditor<CE> this$0;
            {
                this.this$0 = $receiver;
            }

            public void insertUpdate(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileEditor.access$editorChanged(this.this$0);
            }

            public void changedUpdate(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileEditor.access$editorChanged(this.this$0);
            }

            public void removeUpdate(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileEditor.access$editorChanged(this.this$0);
            }
        });
        $this$sourcePane_u24lambda_u242.putClientProperty(generalFileEditor, this);
        $this$sourcePane_u24lambda_u242.setText(FilesKt.readText$default((File)new File(this.fileLocation), null, (int)1, null));
        fileEditor.sourcePane = codePane;
        this.sourcePaneScroll = SwingHelperKt.scrollTextWithLineNumbers(this.sourcePane, this.workbench, this.workbench.getGlobalSettings().getEditorGuideLines());
        this.range = TextKitsKt.markToDotRange(this.sourcePane);
        this.caretRangeLabel.setText(this.range.toString());
        MenuBarBuilder.Companion this_$iv = MenuBarBuilder.Companion;
        boolean $i$f$createMenuBar = false;
        JMenuBar it$iv = jMenuBar = new JMenuBar();
        boolean bl3 = false;
        MenuBarBuilder menuBarBuilder = new MenuBarBuilder(it$iv);
        fileEditor = this;
        boolean bl4 = false;
        $this$_init__u24lambda_u246.menu("Edit", (Function1<? super MenuBuilder, Unit>)((Function1)new Function1<MenuBuilder, Unit>(this){
            final /* synthetic */ FileEditor<CE> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MenuBuilder $this$menu) {
                Intrinsics.checkNotNullParameter((Object)$this$menu, (String)"$this$menu");
                $this$menu.item(new FindAction(this.this$0.getWorkbench(), this.this$0));
            }
        }));
        SwingHelperKt.addWindowMenu((MenuBarBuilder)$this$_init__u24lambda_u246, this);
        fileEditor.setJMenuBar(jMenuBar);
        this.setLocationRelativeTo(this.workbench);
    }

    @Override
    @NotNull
    public final AvailWorkbench getWorkbench() {
        return this.workbench;
    }

    @NotNull
    protected final String getFileLocation() {
        return this.fileLocation;
    }

    public boolean getAutoSave() {
        return this.autoSave;
    }

    @NotNull
    protected abstract List<KeyboardShortcut> getShortcuts();

    @Override
    @NotNull
    public LayoutConfiguration getLayoutConfiguration$avail() {
        return this.layoutConfiguration;
    }

    @NotNull
    public final MarkToDotRange getRange$avail() {
        return this.range;
    }

    @NotNull
    public final CodePane getSourcePane$avail() {
        return this.sourcePane;
    }

    public final void refreshShortcuts() {
        this.sourcePane.getInputMap().clear();
        Iterable $this$forEach$iv = this.getShortcuts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyboardShortcut it = (KeyboardShortcut)element$iv;
            boolean bl = false;
            InputMap inputMap = this.sourcePane.getInputMap();
            Intrinsics.checkNotNullExpressionValue((Object)inputMap, (String)"sourcePane.inputMap");
            it.addToInputMap(inputMap);
        }
        this.sourcePane.registerKeystrokes$avail();
        SwingUtilities.invokeLater(() -> FileEditor.refreshShortcuts$lambda$4(this));
    }

    public abstract void populateSourcePane$avail(@NotNull Function1<? super CE, Unit> var1);

    public static /* synthetic */ void populateSourcePane$avail$default(FileEditor fileEditor, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: populateSourcePane");
        }
        if ((n & 1) != 0) {
            function1 = populateSourcePane.1.INSTANCE;
        }
        fileEditor.populateSourcePane$avail(function1);
    }

    private final CodeGuide getCodeGuide() {
        Object object = this.sourcePane.getClientProperty(CodeGuide.class.getName());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type avail.anvil.CodeGuide");
        return (CodeGuide)object;
    }

    public void highlightCode$avail() {
        Stylesheet stylesheet = this.workbench.getStylesheet();
        this.sourcePane.setBackground(this.sourcePane.computeBackground$avail(stylesheet));
        this.sourcePane.setForeground(this.sourcePane.computeForeground$avail(stylesheet));
        this.getCodeGuide().setGuideColor(this.getCodeGuide().computeColor());
    }

    private final void editorChanged() {
        long editTime = this.lastEditTime;
        this.lastEditTime = System.currentTimeMillis();
        if (editTime <= this.lastSaveTime) {
            this.firstUnsavedEditTime = this.lastEditTime;
            if (this.getAutoSave()) {
                this.eventuallySave();
            }
        }
    }

    public final void save() {
        SwingUtilities.invokeLater(() -> FileEditor.save$lambda$5(this));
    }

    private final void eventuallySave() {
        if (!this.getAutoSave()) {
            return;
        }
        long maximumStaleness = 10000L;
        long idleBeforeWrite = 200L;
        this.workbench.getRuntime().getTimer().schedule(new TimerTask(this, maximumStaleness, idleBeforeWrite){
            final /* synthetic */ FileEditor<CE> this$0;
            final /* synthetic */ long $maximumStaleness;
            final /* synthetic */ long $idleBeforeWrite;
            {
                this.this$0 = $receiver;
                this.$maximumStaleness = $maximumStaleness;
                this.$idleBeforeWrite = $idleBeforeWrite;
            }

            public void run() {
                SwingUtilities.invokeLater(() -> eventuallySave.1.run$lambda$0(this.this$0, this.$maximumStaleness, this.$idleBeforeWrite));
            }

            private static final void run$lambda$0(FileEditor this$0, long $maximumStaleness, long $idleBeforeWrite) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if (FileEditor.access$getLastEditTime$p(this$0) < FileEditor.access$getLastSaveTime$p(this$0)) {
                    return;
                }
                long now = System.currentTimeMillis();
                if (now - FileEditor.access$getFirstUnsavedEditTime$p(this$0) > $maximumStaleness) {
                    this$0.forceWrite();
                } else if (now - FileEditor.access$getLastEditTime$p(this$0) > $idleBeforeWrite) {
                    this$0.forceWrite();
                } else {
                    FileEditor.access$eventuallySave(this$0);
                }
            }
        }, idleBeforeWrite);
    }

    protected void forceWrite() {
        File file2 = new File(this.fileLocation);
        String string2 = this.sourcePane.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sourcePane.text");
        FilesKt.writeText$default((File)file2, (String)string2, null, (int)2, null);
        this.lastSaveTime = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    protected final void finalizeInitialization(@NotNull Function1<? super CE, Unit> afterTextLoaded) {
        void $this$finalizeInitialization_u24lambda_u247;
        GroupLayout groupLayout;
        Intrinsics.checkNotNullParameter(afterTextLoaded, (String)"afterTextLoaded");
        JPanel panel = new JPanel(new BorderLayout(20, 20));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(panel.getBackground());
        this.populateSourcePane$avail(afterTextLoaded);
        this.range = TextKitsKt.markToDotRange(this.sourcePane);
        this.caretRangeLabel.setText(this.range.toString());
        this.sourcePane.getUndoManager$avail().discardAllEdits();
        GroupLayout groupLayout2 = groupLayout = new GroupLayout(panel);
        JPanel jPanel = panel;
        boolean bl = false;
        $this$finalizeInitialization_u24lambda_u247.setAutoCreateGaps(true);
        $this$finalizeInitialization_u24lambda_u247.setHorizontalGroup($this$finalizeInitialization_u24lambda_u247.createParallelGroup().addComponent(this.sourcePaneScroll).addComponent(this.caretRangeLabel, GroupLayout.Alignment.TRAILING));
        $this$finalizeInitialization_u24lambda_u247.setVerticalGroup($this$finalizeInitialization_u24lambda_u247.createSequentialGroup().addComponent(this.sourcePaneScroll).addComponent(this.caretRangeLabel));
        jPanel.setLayout(groupLayout);
        this.setMinimumSize(new Dimension(650, 350));
        this.setPreferredSize(new Dimension(800, 1000));
        this.add(panel);
        this.pack();
        this.setVisible(true);
    }

    public static /* synthetic */ void finalizeInitialization$default(FileEditor fileEditor, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: finalizeInitialization");
        }
        if ((n & 1) != 0) {
            function1 = finalizeInitialization.1.INSTANCE;
        }
        fileEditor.finalizeInitialization(function1);
    }

    @Override
    public final void addWindowListener(@Nullable WindowListener l) {
        super.addWindowListener(l);
    }

    @Override
    public final void setLocationRelativeTo(@Nullable Component c) {
        super.setLocationRelativeTo(c);
    }

    @Override
    @NotNull
    public final Component add(@Nullable Component comp) {
        Component component = super.add(comp);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"super.add(comp)");
        return component;
    }

    @Override
    public final void pack() {
        super.pack();
    }

    private static final void sourcePane$lambda$2$lambda$0(CodePane $this_apply, FileEditor this$0, CaretEvent it) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        StyledDocument doc = $this_apply.getStyledDocument();
        this$0.range = TextKitsKt.markToDotRange($this_apply);
        int dot = this$0.range.getDotPosition().getOffset();
        Element element = doc.getCharacterElement(dot);
        Object styleName = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (Intrinsics.areEqual((Object)styleName, (Object)"default")) {
            Element leftElement = doc.getCharacterElement(Math.max(dot - 1, 0));
            styleName = leftElement.getAttributes().getAttribute(StyleConstants.NameAttribute);
        }
        this$0.caretRangeLabel.setText(styleName + " " + this$0.range);
    }

    private static final void refreshShortcuts$lambda$4(FileEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.sourcePane.revalidate();
    }

    private static final void save$lambda$5(FileEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.forceWrite();
    }

    public static final /* synthetic */ long access$getLastEditTime$p(FileEditor $this) {
        return $this.lastEditTime;
    }

    public static final /* synthetic */ long access$getLastSaveTime$p(FileEditor $this) {
        return $this.lastSaveTime;
    }

    public static final /* synthetic */ long access$getFirstUnsavedEditTime$p(FileEditor $this) {
        return $this.firstUnsavedEditTime;
    }

    public static final /* synthetic */ void access$eventuallySave(FileEditor $this) {
        $this.eventuallySave();
    }

    public static final /* synthetic */ void access$editorChanged(FileEditor $this) {
        $this.editorChanged();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lavail/anvil/FileEditor$Companion;", "", "()V", "generalFileEditor", "", "fileEditor", "Lavail/anvil/FileEditor;", "Ljava/awt/event/ActionEvent;", "getFileEditor$avail", "(Ljava/awt/event/ActionEvent;)Lavail/anvil/FileEditor;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileEditor<?> getFileEditor$avail(@NotNull ActionEvent $this$fileEditor) {
            Intrinsics.checkNotNullParameter((Object)$this$fileEditor, (String)"<this>");
            Object object = $this$fileEditor.getSource();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JTextPane");
            Object object2 = ((JTextPane)object).getClientProperty(FileEditor.generalFileEditor);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type avail.anvil.FileEditor<*>");
            return (FileEditor)object2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

