/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.environment;

import avail.anvil.environment.GlobalEnvironmentSettingsV1;
import avail.anvil.environment.LocationsKt;
import avail.anvil.projects.KnownAvailProject;
import avail.anvil.settings.KeyboardShortcutOverride;
import avail.anvil.settings.ShortcutSettings;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.environment.AvailEnvironment;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.artifact.environment.project.StylingGroup;
import org.availlang.artifact.environment.project.StylingSelection;
import org.availlang.artifact.environment.project.TemplateGroup;
import org.availlang.json.JSONFriendly;
import org.availlang.json.JSONObject;
import org.availlang.json.JSONWriter;
import org.availlang.json.UtilityKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 G2\u00020\u0001:\u0001GJ\u0018\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u000eH\u0016J\u0010\u0010C\u001a\u00020?2\u0006\u0010D\u001a\u00020\u000eH\u0016J\b\u0010E\u001a\u00020?H\u0016J\b\u0010F\u001a\u00020?H\u0016R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u0004\u0018\u00010\u000eX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u0010R\u0018\u0010\u001b\u001a\u00020\u000eX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u0010\"\u0004\b\u001d\u0010\u0012R \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020 0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140$X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\fR\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00140(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\fR\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\fR\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\fR\u0018\u00100\u001a\u00020\u000eX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010\u0010\"\u0004\b2\u0010\u0012R\u0012\u00103\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0012\u00106\u001a\u000207X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\u00020;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u0082\u0001\u0001H\u00a8\u0006I\u00c0\u0006\u0003"}, d2={"Lavail/anvil/environment/GlobalEnvironmentSettings;", "Lorg/availlang/json/JSONFriendly;", "codePaneFontSize", "", "getCodePaneFontSize", "()F", "setCodePaneFontSize", "(F)V", "editorGuideLines", "", "", "getEditorGuideLines", "()Ljava/util/List;", "favorite", "", "getFavorite", "()Ljava/lang/String;", "setFavorite", "(Ljava/lang/String;)V", "favoriteKnownProject", "Lavail/anvil/projects/KnownAvailProject;", "getFavoriteKnownProject", "()Lavail/anvil/projects/KnownAvailProject;", "fileContent", "getFileContent$annotations", "()V", "getFileContent", "font", "getFont", "setFont", "keyboardShortcutOverrides", "", "Lavail/anvil/settings/KeyboardShortcutOverride;", "getKeyboardShortcutOverrides", "()Ljava/util/Map;", "knownProjects", "", "getKnownProjects", "()Ljava/util/Set;", "knownProjectsByAlphaAscending", "", "getKnownProjectsByAlphaAscending", "knownProjectsByAlphaDescending", "getKnownProjectsByAlphaDescending", "knownProjectsByLastOpenedAscending", "getKnownProjectsByLastOpenedAscending", "knownProjectsByLastOpenedDescending", "getKnownProjectsByLastOpenedDescending", "palette", "getPalette", "setPalette", "serializationVersion", "getSerializationVersion", "()I", "shortcutSettings", "Lavail/anvil/settings/ShortcutSettings;", "getShortcutSettings", "()Lavail/anvil/settings/ShortcutSettings;", "stylingSelection", "Lorg/availlang/artifact/environment/project/StylingSelection;", "getStylingSelection", "()Lorg/availlang/artifact/environment/project/StylingSelection;", "add", "", "project", "Lorg/availlang/artifact/environment/project/AvailProject;", "path", "removeProject", "id", "resetToDefaultShortcuts", "saveToDisk", "Companion", "Lavail/anvil/environment/GlobalEnvironmentSettingsV1;", "avail"})
public interface GlobalEnvironmentSettings
extends JSONFriendly {
    @NotNull
    public static final Companion Companion = avail.anvil.environment.GlobalEnvironmentSettings$Companion.$$INSTANCE;
    @NotNull
    public static final String CONFIG_FILE_NAME = "environment-settings.json";

    public int getSerializationVersion();

    @Nullable
    public String getFavorite();

    public void setFavorite(@Nullable String var1);

    public float getCodePaneFontSize();

    public void setCodePaneFontSize(float var1);

    @NotNull
    public String getFont();

    public void setFont(@NotNull String var1);

    @NotNull
    public List<Integer> getEditorGuideLines();

    @NotNull
    public Set<KnownAvailProject> getKnownProjects();

    @NotNull
    default public Map<String, KeyboardShortcutOverride> getKeyboardShortcutOverrides() {
        return this.getShortcutSettings().getKeyboardShortcutOverrides();
    }

    @NotNull
    public ShortcutSettings getShortcutSettings();

    @NotNull
    public String getPalette();

    public void setPalette(@NotNull String var1);

    @NotNull
    default public StylingSelection getStylingSelection() {
        return Companion.getGlobalStylingGroup().selection(this.getPalette());
    }

    @NotNull
    default public List<KnownAvailProject> getKnownProjectsByAlphaAscending() {
        Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)this.getKnownProjects());
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KnownAvailProject it = (KnownAvailProject)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (KnownAvailProject)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    @NotNull
    default public List<KnownAvailProject> getKnownProjectsByAlphaDescending() {
        Iterable $this$sortedByDescending$iv = CollectionsKt.toList((Iterable)this.getKnownProjects());
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KnownAvailProject it = (KnownAvailProject)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (KnownAvailProject)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    @NotNull
    default public List<KnownAvailProject> getKnownProjectsByLastOpenedAscending() {
        Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)this.getKnownProjects());
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KnownAvailProject it = (KnownAvailProject)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getLastOpened());
                it = (KnownAvailProject)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getLastOpened()));
            }
        });
    }

    @NotNull
    default public List<KnownAvailProject> getKnownProjectsByLastOpenedDescending() {
        Iterable $this$sortedByDescending$iv = CollectionsKt.toList((Iterable)this.getKnownProjects());
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KnownAvailProject it = (KnownAvailProject)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getLastOpened());
                it = (KnownAvailProject)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getLastOpened()));
            }
        });
    }

    default public void add(@NotNull AvailProject project, @NotNull String path) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable $this$firstOrNull$iv = this.getKnownProjects();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KnownAvailProject it = (KnownAvailProject)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)project.getId())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        KnownAvailProject knownAvailProject = v0;
        if (knownAvailProject != null) {
            KnownAvailProject it = knownAvailProject;
            boolean bl = false;
            it.setName(project.getName());
            it.setProjectConfigFile(path);
            it.setLastOpened(System.currentTimeMillis());
        } else {
            this.getKnownProjects().add(new KnownAvailProject(project.getName(), project.getId(), path, System.currentTimeMillis()));
        }
        this.saveToDisk();
    }

    @Nullable
    default public KnownAvailProject getFavoriteKnownProject() {
        KnownAvailProject knownAvailProject;
        String string2 = this.getFavorite();
        if (string2 != null) {
            Object v1;
            block3: {
                String fav = string2;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = this.getKnownProjects();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KnownAvailProject it = (KnownAvailProject)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)fav)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            knownAvailProject = v1;
        } else {
            knownAvailProject = null;
        }
        return knownAvailProject;
    }

    default public void removeProject(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.getKnownProjects().removeIf(arg_0 -> GlobalEnvironmentSettings.removeProject$lambda$8((Function1)new Function1<KnownAvailProject, Boolean>(id){
            final /* synthetic */ String $id;
            {
                this.$id = $id;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KnownAvailProject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getId(), (Object)this.$id);
            }
        }, arg_0))) {
            this.saveToDisk();
        }
    }

    @NotNull
    default public String getFileContent() {
        return UtilityKt.jsonPrettyPrintWriter((Function1)((Function1)new Function1<JSONWriter, Unit>(this){
            final /* synthetic */ GlobalEnvironmentSettings this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JSONWriter $this$jsonPrettyPrintWriter) {
                Intrinsics.checkNotNullParameter((Object)$this$jsonPrettyPrintWriter, (String)"$this$jsonPrettyPrintWriter");
                this.this$0.writeTo($this$jsonPrettyPrintWriter);
            }
        })).toString();
    }

    default public void saveToDisk() {
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(Paths.get(LocationsKt.getEnvironmentConfigFile(), new String[0]), Paths.get(LocationsKt.getEnvironmentConfigFile() + ".bak", new String[0]), copyOptionArray);
        FilesKt.writeText$default((File)new File(LocationsKt.getEnvironmentConfigFile()), (String)this.getFileContent(), null, (int)2, null);
    }

    default public void resetToDefaultShortcuts() {
        this.getShortcutSettings().getKeyboardShortcutOverrides().clear();
        this.getShortcutSettings().save();
    }

    private static boolean removeProject$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lavail/anvil/environment/GlobalEnvironmentSettings$Companion;", "", "()V", "CONFIG_FILE_NAME", "", "CURRENT_PROJECT_VERSION", "", "configFilePath", "getConfigFilePath", "()Ljava/lang/String;", "emptyConfig", "Lavail/anvil/environment/GlobalEnvironmentSettings;", "getEmptyConfig", "()Lavail/anvil/environment/GlobalEnvironmentSettings;", "globalStylingGroup", "Lorg/availlang/artifact/environment/project/StylingGroup;", "getGlobalStylingGroup", "()Lorg/availlang/artifact/environment/project/StylingGroup;", "globalTemplates", "Lorg/availlang/artifact/environment/project/TemplateGroup;", "getGlobalTemplates", "()Lorg/availlang/artifact/environment/project/TemplateGroup;", "getGlobalSettings", "avail"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final int CURRENT_PROJECT_VERSION = 1;
        @NotNull
        public static final String CONFIG_FILE_NAME = "environment-settings.json";

        private Companion() {
        }

        @NotNull
        public final String getConfigFilePath() {
            return AvailEnvironment.INSTANCE.getAvailHome() + File.separator + "environment-settings.json";
        }

        @NotNull
        public final GlobalEnvironmentSettings getEmptyConfig() {
            return new GlobalEnvironmentSettingsV1();
        }

        @NotNull
        public final TemplateGroup getGlobalTemplates() {
            return new TemplateGroup(UtilityKt.jsonObject$default((String)FilesKt.readText$default((File)new File(LocationsKt.getGlobalTemplatesFile()), null, (int)1, null), null, (int)2, null));
        }

        @NotNull
        public final StylingGroup getGlobalStylingGroup() {
            return new StylingGroup(UtilityKt.jsonObject$default((String)FilesKt.readText$default((File)new File(LocationsKt.getGlobalStylesFile()), null, (int)1, null), null, (int)2, null));
        }

        @NotNull
        public final GlobalEnvironmentSettings getGlobalSettings() {
            String contents;
            File file2 = new File(LocationsKt.getEnvironmentConfigFile());
            if (!file2.exists()) {
                GlobalEnvironmentSettings config = this.getEmptyConfig();
                config.saveToDisk();
                return config;
            }
            try {
                contents = FilesKt.readText$default((File)file2, null, (int)1, null);
                contents = UtilityKt.jsonObject$default((String)contents, null, (int)2, null);
            }
            catch (Throwable e) {
                System.err.println("Malformed Global Avail Configuration File: " + this.getConfigFilePath() + "\n. Delete file and restart avail");
                e.printStackTrace();
                throw e;
            }
            String obj = contents;
            int version = JSONObject.getNumber$default((JSONObject)obj, (String)"serializationVersion", null, (int)2, null).getInt();
            if (version != 1) {
                throw new IllegalStateException("Invalid Global Avail Configuration File: Version " + version + " is not in the valid range of known global config file versions, [1, 1].");
            }
            return GlobalEnvironmentSettingsV1.Companion.from((JSONObject)obj);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static Map<String, KeyboardShortcutOverride> getKeyboardShortcutOverrides(@NotNull GlobalEnvironmentSettings $this) {
            return $this.getKeyboardShortcutOverrides();
        }

        @Deprecated
        @NotNull
        public static StylingSelection getStylingSelection(@NotNull GlobalEnvironmentSettings $this) {
            return $this.getStylingSelection();
        }

        @Deprecated
        @NotNull
        public static List<KnownAvailProject> getKnownProjectsByAlphaAscending(@NotNull GlobalEnvironmentSettings $this) {
            return $this.getKnownProjectsByAlphaAscending();
        }

        @Deprecated
        @NotNull
        public static List<KnownAvailProject> getKnownProjectsByAlphaDescending(@NotNull GlobalEnvironmentSettings $this) {
            return $this.getKnownProjectsByAlphaDescending();
        }

        @Deprecated
        @NotNull
        public static List<KnownAvailProject> getKnownProjectsByLastOpenedAscending(@NotNull GlobalEnvironmentSettings $this) {
            return $this.getKnownProjectsByLastOpenedAscending();
        }

        @Deprecated
        @NotNull
        public static List<KnownAvailProject> getKnownProjectsByLastOpenedDescending(@NotNull GlobalEnvironmentSettings $this) {
            return $this.getKnownProjectsByLastOpenedDescending();
        }

        @Deprecated
        public static void add(@NotNull GlobalEnvironmentSettings $this, @NotNull AvailProject project, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            $this.add(project, path);
        }

        @Deprecated
        @Nullable
        public static KnownAvailProject getFavoriteKnownProject(@NotNull GlobalEnvironmentSettings $this) {
            return $this.getFavoriteKnownProject();
        }

        @Deprecated
        public static void removeProject(@NotNull GlobalEnvironmentSettings $this, @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            $this.removeProject(id);
        }

        @Deprecated
        @NotNull
        public static String getFileContent(@NotNull GlobalEnvironmentSettings $this) {
            return $this.getFileContent();
        }

        public static /* synthetic */ void getFileContent$annotations() {
        }

        @Deprecated
        public static void saveToDisk(@NotNull GlobalEnvironmentSettings $this) {
            $this.saveToDisk();
        }

        @Deprecated
        public static void resetToDefaultShortcuts(@NotNull GlobalEnvironmentSettings $this) {
            $this.resetToDefaultShortcuts();
        }

        @Deprecated
        @NotNull
        public static String getJsonFormattedString(@NotNull GlobalEnvironmentSettings $this) {
            return $this.getJsonFormattedString();
        }

        @Deprecated
        @NotNull
        public static String getJsonPrettyPrintedFormattedString(@NotNull GlobalEnvironmentSettings $this) {
            return $this.getJsonPrettyPrintedFormattedString();
        }
    }
}

