/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.settings;

import avail.anvil.environment.GlobalEnvironmentSettings;
import avail.anvil.settings.KeyboardShortcutOverride;
import avail.anvil.settings.SettingsView;
import avail.anvil.settings.ShortcutRow;
import avail.anvil.settings.ShortcutSettings;
import avail.anvil.settings.ShortcutsPanel;
import avail.anvil.shortcuts.KeyboardShortcut;
import avail.anvil.shortcuts.KeyboardShortcutCategory;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u0000J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0010*\u00020\u0011H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lavail/anvil/settings/ShortcutsPanel;", "Ljavax/swing/JPanel;", "category", "Lavail/anvil/shortcuts/KeyboardShortcutCategory;", "settingsView", "Lavail/anvil/settings/SettingsView;", "(Lavail/anvil/shortcuts/KeyboardShortcutCategory;Lavail/anvil/settings/SettingsView;)V", "getCategory$avail", "()Lavail/anvil/shortcuts/KeyboardShortcutCategory;", "globalSettings", "Lavail/anvil/environment/GlobalEnvironmentSettings;", "getGlobalSettings", "()Lavail/anvil/environment/GlobalEnvironmentSettings;", "shortcutsPanel", "redrawShortcuts", "exportSettings", "", "Ljavax/swing/JFileChooser;", "importSettings", "avail"})
public final class ShortcutsPanel
extends JPanel {
    @NotNull
    private final KeyboardShortcutCategory category;
    @NotNull
    private final SettingsView settingsView;
    @NotNull
    private final JPanel shortcutsPanel;

    /*
     * WARNING - void declaration
     */
    public ShortcutsPanel(@NotNull KeyboardShortcutCategory category, @NotNull SettingsView settingsView) {
        void $this$_init__u24lambda_u2415;
        JComponent jComponent;
        JButton $this$sortedBy$iv2;
        void $this$shortcutsPanel_u24lambda_u240;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        Intrinsics.checkNotNullParameter((Object)settingsView, (String)"settingsView");
        this.category = category;
        this.settingsView = settingsView;
        JPanel jPanel2 = jPanel = new JPanel();
        ShortcutsPanel shortcutsPanel = this;
        boolean bl2 = false;
        $this$shortcutsPanel_u24lambda_u240.setLayout(new BoxLayout((Container)$this$shortcutsPanel_u24lambda_u240, 1));
        shortcutsPanel.shortcutsPanel = jPanel;
        this.setLayout(new BoxLayout(this, 1));
        Set<KeyboardShortcutCategory> overlaps = this.category.getOverlapCategories();
        if (!((Collection)overlaps).isEmpty()) {
            void $this$lambda_u248_u24lambda_u247;
            JLabel jLabel;
            void $this$_init__u24lambda_u248;
            JPanel $this$sortedBy$iv2;
            Iterable bl2 = CollectionsKt.toList((Iterable)overlaps);
            boolean $i$f$sortedBy22 = false;
            String overlapCategories2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)((Object)$this$sortedBy$iv2), (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    KeyboardShortcutCategory it = (KeyboardShortcutCategory)((Object)a);
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getDisplay());
                    it = (KeyboardShortcutCategory)((Object)b);
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplay())));
                }
            }), (CharSequence)", ", null, null, (int)0, null, (Function1)overlapCategories.2.INSTANCE, (int)30, null);
            JPanel $i$f$sortedBy22 = $this$sortedBy$iv2 = new JPanel();
            shortcutsPanel = this;
            boolean bl3 = false;
            $this$_init__u24lambda_u248.setLayout(new FlowLayout(0));
            $this$_init__u24lambda_u248.setMinimumSize(new Dimension(720, 30));
            $this$_init__u24lambda_u248.setPreferredSize(new Dimension(750, 30));
            $this$_init__u24lambda_u248.setMaximumSize(new Dimension(750, 30));
            JLabel jLabel2 = jLabel = new JLabel("In-Scope with " + overlapCategories2);
            void var10_18 = $this$_init__u24lambda_u248;
            boolean bl4 = false;
            $this$lambda_u248_u24lambda_u247.setFont($this$lambda_u248_u24lambda_u247.getFont().deriveFont($this$lambda_u248_u24lambda_u247.getFont().getStyle() | 1));
            var10_18.add(jLabel);
            shortcutsPanel.add($this$sortedBy$iv2);
        }
        this.add(new JScrollPane(this.shortcutsPanel));
        JButton $this$_init__u24lambda_u2410 = $this$sortedBy$iv2 = new JButton("Reset to Defaults");
        boolean bl5 = false;
        $this$_init__u24lambda_u2410.setOpaque(true);
        int currentHeight = $this$_init__u24lambda_u2410.getHeight();
        int currentWidth = $this$_init__u24lambda_u2410.getWidth();
        $this$_init__u24lambda_u2410.setMinimumSize(new Dimension(currentWidth + 150, currentHeight + 40));
        $this$_init__u24lambda_u2410.setPreferredSize(new Dimension(currentWidth + 150, currentHeight + 40));
        $this$_init__u24lambda_u2410.setMaximumSize(new Dimension(currentWidth + 150, currentHeight + 40));
        $this$_init__u24lambda_u2410.setToolTipText("Resets all shortcuts across all categories to default key mappings");
        $this$_init__u24lambda_u2410.addActionListener(arg_0 -> ShortcutsPanel.lambda$10$lambda$9(this, arg_0));
        JButton reset = $this$sortedBy$iv2;
        JButton $this$_init__u24lambda_u2412 = $this$_init__u24lambda_u2410 = new JButton("Import");
        boolean bl6 = false;
        $this$_init__u24lambda_u2412.setOpaque(true);
        int currentHeight2 = $this$_init__u24lambda_u2412.getHeight();
        int currentWidth2 = $this$_init__u24lambda_u2412.getWidth();
        $this$_init__u24lambda_u2412.setMinimumSize(new Dimension(currentWidth2 + 150, currentHeight2 + 40));
        $this$_init__u24lambda_u2412.setPreferredSize(new Dimension(currentWidth2 + 150, currentHeight2 + 40));
        $this$_init__u24lambda_u2412.setMaximumSize(new Dimension(currentWidth2 + 150, currentHeight2 + 40));
        $this$_init__u24lambda_u2412.setToolTipText("Imports shortcuts from a settings file");
        $this$_init__u24lambda_u2412.addActionListener(arg_0 -> ShortcutsPanel.lambda$12$lambda$11(this, arg_0));
        JButton importSettings2 = $this$_init__u24lambda_u2410;
        JButton $this$_init__u24lambda_u2414 = jComponent = new JButton("Export");
        boolean bl7 = false;
        $this$_init__u24lambda_u2414.setOpaque(true);
        int currentHeight3 = $this$_init__u24lambda_u2414.getHeight();
        int currentWidth3 = $this$_init__u24lambda_u2414.getWidth();
        $this$_init__u24lambda_u2414.setMinimumSize(new Dimension(currentWidth3 + 150, currentHeight3 + 40));
        $this$_init__u24lambda_u2414.setPreferredSize(new Dimension(currentWidth3 + 150, currentHeight3 + 40));
        $this$_init__u24lambda_u2414.setMaximumSize(new Dimension(currentWidth3 + 150, currentHeight3 + 40));
        $this$_init__u24lambda_u2414.setToolTipText("Export shortcuts to a settings file");
        $this$_init__u24lambda_u2414.addActionListener(arg_0 -> ShortcutsPanel.lambda$14$lambda$13(this, arg_0));
        JButton exportSettings2 = jComponent;
        $this$_init__u24lambda_u2414 = jComponent = new JPanel();
        shortcutsPanel = this;
        boolean bl8 = false;
        $this$_init__u24lambda_u2415.setLayout(new FlowLayout(2));
        $this$_init__u24lambda_u2415.setMinimumSize(new Dimension(600, 50));
        $this$_init__u24lambda_u2415.setPreferredSize(new Dimension(700, 50));
        $this$_init__u24lambda_u2415.setMaximumSize(new Dimension(700, 50));
        $this$_init__u24lambda_u2415.setBackground(new Color(60, 63, 65));
        $this$_init__u24lambda_u2415.add(importSettings2);
        $this$_init__u24lambda_u2415.add(exportSettings2);
        $this$_init__u24lambda_u2415.add(reset);
        shortcutsPanel.add(jComponent);
    }

    @NotNull
    public final KeyboardShortcutCategory getCategory$avail() {
        return this.category;
    }

    @NotNull
    public final GlobalEnvironmentSettings getGlobalSettings() {
        return this.settingsView.getGlobalSettings$avail();
    }

    @NotNull
    public final ShortcutsPanel redrawShortcuts() {
        SwingUtilities.invokeLater(() -> ShortcutsPanel.redrawShortcuts$lambda$2(this));
        return this;
    }

    private final void importSettings(JFileChooser $this$importSettings) {
        $this$importSettings.setDialogTitle("Select Settings File to Import From");
        $this$importSettings.setFileSelectionMode(0);
        String[] stringArray = new String[]{"json"};
        $this$importSettings.setFileFilter(new FileNameExtensionFilter("*.json", stringArray));
        $this$importSettings.addChoosableFileFilter(new FileFilter(){

            @NotNull
            public String getDescription() {
                return "Settings File (*.json)";
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(@NotNull File f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                if (!f.isFile()) return false;
                if (!f.canWrite()) return false;
                String string2 = f.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"f.absolutePath");
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!StringsKt.endsWith$default((String)string3, (String)".json", (boolean)false, (int)2, null)) return false;
                return true;
            }
        });
        int result2 = $this$importSettings.showDialog(this, "Select Settings File");
        if (result2 == 0) {
            File file2 = $this$importSettings.getSelectedFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"selectedFile");
            ShortcutSettings shortcuts = ShortcutSettings.Companion.readFromFile(file2);
            if (shortcuts != null) {
                Map<KeyboardShortcutOverride, Set<KeyboardShortcut>> m = this.getGlobalSettings().getShortcutSettings().attemptShortcutImport(shortcuts);
                if (!m.isEmpty()) {
                    String conflicts2 = CollectionsKt.joinToString$default((Iterable)m.entrySet(), (CharSequence)"\n\t", null, null, (int)0, null, (Function1)importSettings.conflicts.1.INSTANCE, (int)30, null);
                    SwingUtilities.invokeLater(() -> ShortcutsPanel.importSettings$lambda$3(this, conflicts2));
                } else {
                    SwingUtilities.invokeLater(() -> ShortcutsPanel.importSettings$lambda$4(this));
                }
                this.redrawShortcuts();
            } else {
                String path = $this$importSettings.getSelectedFile().getPath();
                SwingUtilities.invokeLater(() -> ShortcutsPanel.importSettings$lambda$5(this, path));
            }
        }
    }

    private final void exportSettings(JFileChooser $this$exportSettings) {
        $this$exportSettings.setDialogTitle("Select Settings File to Export To");
        $this$exportSettings.setFileSelectionMode(0);
        String[] stringArray = new String[]{"json"};
        $this$exportSettings.setFileFilter(new FileNameExtensionFilter("*.json", stringArray));
        $this$exportSettings.addChoosableFileFilter(new FileFilter(){

            @NotNull
            public String getDescription() {
                return "Settings File (*.json)";
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(@NotNull File f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                if (!f.isFile()) return false;
                if (!f.canWrite()) return false;
                String string2 = f.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"f.absolutePath");
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!StringsKt.endsWith$default((String)string3, (String)".json", (boolean)false, (int)2, null)) return false;
                return true;
            }
        });
        int result2 = $this$exportSettings.showSaveDialog(this);
        if (result2 == 0) {
            ShortcutSettings shortcuts = this.getGlobalSettings().getShortcutSettings();
            String string2 = $this$exportSettings.getSelectedFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"selectedFile.name");
            File target = StringsKt.endsWith$default((String)string2, (String)".json", (boolean)false, (int)2, null) ? $this$exportSettings.getSelectedFile() : new File($this$exportSettings.getSelectedFile().getAbsolutePath() + ".json");
            Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
            shortcuts.saveToDisk(target);
        }
    }

    private static final void redrawShortcuts$lambda$2(ShortcutsPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.shortcutsPanel.removeAll();
        Iterable $this$forEach$iv = this$0.category.getShortcutsByDescription();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyboardShortcut it = (KeyboardShortcut)element$iv;
            boolean bl = false;
            this$0.shortcutsPanel.add(new ShortcutRow(it, this$0.settingsView, this$0));
        }
        this$0.shortcutsPanel.revalidate();
        this$0.shortcutsPanel.repaint();
    }

    private static final void importSettings$lambda$3(ShortcutsPanel this$0, String $conflicts) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$conflicts, (String)"$conflicts");
        JOptionPane.showMessageDialog(this$0, "Partial Success, some key mapping conflicts detected:\n " + $conflicts, "Some Shortcuts Loaded", -1);
    }

    private static final void importSettings$lambda$4(ShortcutsPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JOptionPane.showMessageDialog(this$0, "Success!", "Shortcuts Loaded", -1);
    }

    private static final void importSettings$lambda$5(ShortcutsPanel this$0, String $path) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JOptionPane.showMessageDialog(this$0, "Could not load shortcut settings from " + $path + ".", "Settings Load Failure", 0);
    }

    private static final void lambda$10$lambda$9(ShortcutsPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        KeyboardShortcutCategory.Companion.resetAllToDefaults(this$0.getGlobalSettings());
        this$0.redrawShortcuts();
    }

    private static final void lambda$12$lambda$11(ShortcutsPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.importSettings(new JFileChooser());
    }

    private static final void lambda$14$lambda$13(ShortcutsPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.exportSettings(new JFileChooser());
    }
}

