/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.versions;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.environment.AvailEnvironment;
import org.availlang.json.JSONReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\bH\u0002J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bJH\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\u00132\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016H\u0002J>\u0010\u0019\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\u00132\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016J>\u0010\u001a\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\u00132\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00100\u0016J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lavail/anvil/versions/MavenCentralAPI;", "", "()V", "searchAvailLibUrl", "Ljava/net/URL;", "searchAvailSdkUrl", "artifactDownloadUrl", "artifactId", "", "version", "download", "", "fileURL", "target", "downloadAvailStandardLib", "search", "", "url", "success", "Lkotlin/Function1;", "Lorg/availlang/json/JSONReader;", "failure", "Lkotlin/Function3;", "", "", "searchAvailSdk", "searchAvailStdLib", "searchUrl", "artifact", "avail"})
public final class MavenCentralAPI {
    @NotNull
    public static final MavenCentralAPI INSTANCE = new MavenCentralAPI();
    @NotNull
    private static final URL searchAvailLibUrl = INSTANCE.searchUrl("avail-stdlib");
    @NotNull
    private static final URL searchAvailSdkUrl = INSTANCE.searchUrl("avail");

    private MavenCentralAPI() {
    }

    @NotNull
    public final URL searchUrl(@NotNull String artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return new URL("https://search.maven.org/solrsearch/select?q=g:org.availlang%20AND%20a:" + artifact + "%20AND%20p:jar&rows=1&wt=json");
    }

    private final void search(URL url, Function1<? super JSONReader, Unit> success2, Function3<? super Integer, ? super String, ? super Throwable, Unit> failure) {
        try {
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection con = (HttpURLConnection)uRLConnection;
            con.setRequestMethod("GET");
            int rspCode = con.getResponseCode();
            if (rspCode != 200) {
                failure.invoke((Object)rspCode, (Object)con.getResponseMessage(), null);
                return;
            }
            BufferedReader responseReader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            success2.invoke((Object)new JSONReader((Reader)responseReader));
        }
        catch (Throwable e) {
            failure.invoke((Object)0, null, (Object)e);
        }
    }

    public final void searchAvailStdLib(@NotNull Function1<? super JSONReader, Unit> success2, @NotNull Function3<? super Integer, ? super String, ? super Throwable, Unit> failure) {
        Intrinsics.checkNotNullParameter(success2, (String)"success");
        Intrinsics.checkNotNullParameter(failure, (String)"failure");
        this.search(searchAvailLibUrl, success2, failure);
    }

    public final void searchAvailSdk(@NotNull Function1<? super JSONReader, Unit> success2, @NotNull Function3<? super Integer, ? super String, ? super Throwable, Unit> failure) {
        Intrinsics.checkNotNullParameter(success2, (String)"success");
        Intrinsics.checkNotNullParameter(failure, (String)"failure");
        this.search(searchAvailSdkUrl, success2, failure);
    }

    private final URL artifactDownloadUrl(String artifactId, String version) {
        return new URL("https://search.maven.org/remotecontent?filepath=org/availlang/" + artifactId + "/" + version + "/" + artifactId + "-" + version + ".jar");
    }

    private final long download(URL fileURL, String target) {
        return new FileOutputStream(target).getChannel().transferFrom(Channels.newChannel(fileURL.openStream()), 0L, Long.MAX_VALUE);
    }

    public final long downloadAvailStandardLib(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.download(this.artifactDownloadUrl("avail-stdlib", version), AvailEnvironment.INSTANCE.getAvailHomeLibs() + "/org/availlang/avail-stdlib-" + version + ".jar");
    }
}

