/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.types;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.numbers.DoubleDescriptor;
import avail.descriptor.numbers.FloatDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.pojos.PojoDescriptor;
import avail.descriptor.pojos.RawPojoDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.RepeatedElementTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.ArrayPojoTypeDescriptor;
import avail.descriptor.types.BottomPojoTypeDescriptor;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FusedPojoTypeDescriptor;
import avail.descriptor.types.InstanceTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PojoTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.SelfPojoTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.descriptor.types.TypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.descriptor.types.UnfusedPojoTypeDescriptor;
import avail.exceptions.MarshalingException;
import avail.utility.Mutable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.cache.LRUCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 :2\u00020\u0001:\u00049:;<B3\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\u0010\u0007\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH&J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH&J \u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\f\u001a\u00020\r2\f\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H&J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH&J\u0018\u0010$\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001bH\u0016J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u001bH&J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u001bH&J\u0018\u0010(\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u001bH&J\u0018\u0010*\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001bH\u0016J\u0018\u0010+\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u001bH&J\u0018\u0010,\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u001bH&J\u0018\u0010-\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u001bH&J\u0010\u0010.\u001a\u00020/2\u0006\u0010\f\u001a\u00020\rH&J8\u00100\u001a\u0002012\u0006\u0010\f\u001a\u00020\r2\n\u00102\u001a\u000603j\u0002`42\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u000207062\u0006\u00108\u001a\u00020\u0013H&\u00a8\u0006="}, d2={"Lavail/descriptor/types/PojoTypeDescriptor;", "Lavail/descriptor/types/TypeDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "objectSlotsEnumClass", "Ljava/lang/Class;", "Lavail/descriptor/representation/ObjectSlotsEnum;", "integerSlotsEnumClass", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Lavail/descriptor/representation/Mutability;Ljava/lang/Class;Ljava/lang/Class;)V", "o_Equals", "", "self", "Lavail/descriptor/representation/AvailObject;", "another", "Lavail/descriptor/representation/A_BasicObject;", "o_EqualsPojoType", "aPojoType", "o_Hash", "", "o_IsAbstract", "o_IsPojoArrayType", "o_IsPojoFusedType", "o_IsPojoSelfType", "o_IsPojoType", "o_IsSubtypeOf", "aType", "Lavail/descriptor/types/A_Type;", "o_IsSupertypeOfPojoBottomType", "o_IsSupertypeOfPojoType", "o_JavaAncestors", "o_JavaClass", "o_MarshalToJava", "", "classHint", "o_PojoSelfType", "o_TypeIntersection", "o_TypeIntersectionOfPojoFusedType", "aFusedPojoType", "o_TypeIntersectionOfPojoType", "o_TypeIntersectionOfPojoUnfusedType", "anUnfusedPojoType", "o_TypeUnion", "o_TypeUnionOfPojoFusedType", "o_TypeUnionOfPojoType", "o_TypeUnionOfPojoUnfusedType", "o_TypeVariables", "Lavail/descriptor/maps/A_Map;", "printObjectOnAvoidingIndent", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "Canon", "Companion", "LRUCacheKey", "TypeVariableMap", "avail"})
public abstract class PojoTypeDescriptor
extends TypeDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final A_Atom selfTypeAtom = AtomDescriptor.Companion.createSpecialAtom("pojo self");
    @NotNull
    private static final A_Type selfType = InstanceTypeDescriptor.Companion.instanceType(selfTypeAtom).makeShared();
    @NotNull
    private static final A_Type byteRange = IntegerRangeTypeDescriptor.Companion.inclusive(-128L, 127L).makeShared();
    @NotNull
    private static final A_Type shortRange = IntegerRangeTypeDescriptor.Companion.inclusive(-32768L, 32767L).makeShared();
    @NotNull
    private static final A_Type intRange = IntegerRangeTypeDescriptor.Companion.getInt32();
    @NotNull
    private static final A_Type longRange = IntegerRangeTypeDescriptor.Companion.getInt64();
    @NotNull
    private static final A_Type charRange = IntegerRangeTypeDescriptor.Companion.inclusive(0L, 65535L).makeShared();
    @NotNull
    private static final LRUCache<LRUCacheKey, AvailObject> cache = new LRUCache(1000, 10, (Function1)Companion.cache.1.INSTANCE, null, 8, null);

    protected PojoTypeDescriptor(@NotNull Mutability mutability, @Nullable Class<? extends ObjectSlotsEnum> objectSlotsEnumClass, @Nullable Class<? extends IntegerSlotsEnum> integerSlotsEnumClass) {
        Intrinsics.checkNotNullParameter((Object)((Object)mutability), (String)"mutability");
        super(mutability, TypeTag.POJO_TYPE_TAG, TypeTag.POJO_TAG, objectSlotsEnumClass, integerSlotsEnumClass);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return another.traversed().sameAddressAs(self) ? true : self.isPojoType() == another.isPojoType() && self.isPojoFusedType() == another.isPojoFusedType() && self.isPojoArrayType() == another.isPojoArrayType() && self.hash() == another.hash() && another.equalsPojoType(self);
    }

    @Override
    public abstract boolean o_EqualsPojoType(@NotNull AvailObject var1, @NotNull AvailObject var2);

    @Override
    public abstract int o_Hash(@NotNull AvailObject var1);

    @Override
    public abstract boolean o_IsAbstract(@NotNull AvailObject var1);

    @Override
    public abstract boolean o_IsPojoArrayType(@NotNull AvailObject var1);

    @Override
    public abstract boolean o_IsPojoFusedType(@NotNull AvailObject var1);

    @Override
    public boolean o_IsPojoSelfType(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return false;
    }

    @Override
    public boolean o_IsPojoType(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return true;
    }

    @Override
    public boolean o_IsSubtypeOf(@NotNull AvailObject self, @NotNull A_Type aType) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aType, (String)"aType");
        return A_Type.Companion.isSupertypeOfPojoType(aType, self);
    }

    @Override
    public boolean o_IsSupertypeOfPojoBottomType(@NotNull AvailObject self, @NotNull A_Type aPojoType) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aPojoType, (String)"aPojoType");
        return true;
    }

    @Override
    public boolean o_IsSupertypeOfPojoType(@NotNull AvailObject self, @NotNull A_Type aPojoType) {
        A_Set otherJavaClasses;
        A_Set intersection;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aPojoType, (String)"aPojoType");
        if (aPojoType.isPojoSelfType()) {
            return A_Type.Companion.isSupertypeOfPojoType(self.pojoSelfType(), aPojoType);
        }
        A_Map ancestors = self.javaAncestors();
        A_Map otherAncestors = aPojoType.javaAncestors();
        A_Set javaClasses = A_Map.Companion.getKeysAsSet(ancestors);
        if (!javaClasses.equals(intersection = A_Set.Companion.setIntersectionCanDestroy(javaClasses, otherJavaClasses = A_Map.Companion.getKeysAsSet(otherAncestors), false))) {
            return false;
        }
        block0: for (AvailObject javaClass : intersection) {
            A_Tuple params = A_Map.Companion.mapAt(ancestors, javaClass);
            A_Tuple otherParams = A_Map.Companion.mapAt(otherAncestors, javaClass);
            int i2 = 1;
            int limit = A_Tuple.Companion.getTupleSize(params);
            if (i2 > limit) continue;
            while (true) {
                A_Type x = A_Tuple.Companion.tupleAt(params, i2);
                A_Type y = A_Tuple.Companion.tupleAt(otherParams, i2);
                if (!A_Type.Companion.isSubtypeOf(y, x)) {
                    return false;
                }
                if (i2 == limit) continue block0;
                ++i2;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public abstract AvailObject o_JavaAncestors(@NotNull AvailObject var1);

    @Override
    @NotNull
    public abstract AvailObject o_JavaClass(@NotNull AvailObject var1);

    @Override
    @Nullable
    public abstract Object o_MarshalToJava(@NotNull AvailObject var1, @Nullable Class<?> var2);

    @Override
    @NotNull
    public abstract A_Type o_PojoSelfType(@NotNull AvailObject var1);

    @Override
    @NotNull
    public A_Type o_TypeIntersection(@NotNull AvailObject self, @NotNull A_Type another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        if (A_Type.Companion.isSubtypeOf(self, another)) {
            return self;
        }
        return A_Type.Companion.isSubtypeOf(another, self) ? another : A_Type.Companion.typeIntersectionOfPojoType(another, self);
    }

    @Override
    @NotNull
    public abstract A_Type o_TypeIntersectionOfPojoType(@NotNull AvailObject var1, @NotNull A_Type var2);

    @Override
    @NotNull
    public abstract A_Type o_TypeIntersectionOfPojoFusedType(@NotNull AvailObject var1, @NotNull A_Type var2);

    @Override
    @NotNull
    public abstract A_Type o_TypeIntersectionOfPojoUnfusedType(@NotNull AvailObject var1, @NotNull A_Type var2);

    @Override
    @NotNull
    public A_Type o_TypeUnion(@NotNull AvailObject self, @NotNull A_Type another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        if (A_Type.Companion.isSubtypeOf(self, another)) {
            return another;
        }
        return A_Type.Companion.isSubtypeOf(another, self) ? (A_Type)self : A_Type.Companion.typeUnionOfPojoType(another, self);
    }

    @Override
    @NotNull
    public abstract A_Type o_TypeUnionOfPojoType(@NotNull AvailObject var1, @NotNull A_Type var2);

    @Override
    @NotNull
    public abstract A_Type o_TypeUnionOfPojoFusedType(@NotNull AvailObject var1, @NotNull A_Type var2);

    @Override
    @NotNull
    public abstract A_Type o_TypeUnionOfPojoUnfusedType(@NotNull AvailObject var1, @NotNull A_Type var2);

    @Override
    @NotNull
    public abstract A_Map o_TypeVariables(@NotNull AvailObject var1);

    @Override
    public abstract void printObjectOnAvoidingIndent(@NotNull AvailObject var1, @NotNull StringBuilder var2, @NotNull IdentityHashMap<A_BasicObject, Void> var3, int var4);

    @JvmStatic
    @NotNull
    protected static final A_BasicObject computeIntersection(@NotNull A_BasicObject self, @NotNull A_BasicObject aPojoType) {
        return Companion.computeIntersection(self, aPojoType);
    }

    @JvmStatic
    @NotNull
    protected static final A_Map computeUnion(@NotNull A_BasicObject self, @NotNull A_BasicObject aPojoType) {
        return Companion.computeUnion(self, aPojoType);
    }

    @JvmStatic
    @NotNull
    protected static final Set<AvailObject> childlessAmong(@NotNull A_Set ancestry) {
        return Companion.childlessAmong(ancestry);
    }

    @JvmStatic
    @NotNull
    protected static final AvailObject mostSpecificOf(@NotNull A_Set ancestry) {
        return Companion.mostSpecificOf(ancestry);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u0003`\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u00a8\u0006\b"}, d2={"Lavail/descriptor/types/PojoTypeDescriptor$Canon;", "Ljava/util/LinkedHashMap;", "Ljava/lang/Class;", "Lavail/descriptor/representation/AvailObject;", "Lkotlin/collections/LinkedHashMap;", "()V", "canonize", "javaClass", "avail"})
    private static final class Canon
    extends LinkedHashMap<Class<?>, AvailObject> {
        public Canon() {
            super(5);
            this.put(Object.class, RawPojoDescriptor.Companion.rawObjectClass());
        }

        @NotNull
        public final AvailObject canonize(@Nullable Class<?> javaClass) {
            AvailObject rawPojo = (AvailObject)((Map)this).get(javaClass);
            if (rawPojo == null) {
                Class<?> clazz = javaClass;
                Intrinsics.checkNotNull(clazz);
                rawPojo = RawPojoDescriptor.Companion.equalityPojo(clazz);
                this.put(javaClass, rawPojo);
            }
            return rawPojo;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0004B\u0011\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lavail/descriptor/types/PojoTypeDescriptor$TypeVariableMap;", "Ljava/util/LinkedHashMap;", "", "", "Lkotlin/collections/LinkedHashMap;", "javaClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "avail"})
    private static final class TypeVariableMap
    extends LinkedHashMap<String, Integer> {
        /*
         * WARNING - void declaration
         */
        public TypeVariableMap(@NotNull Class<?> javaClass) {
            Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
            super(2);
            TypeVariable<Class<?>>[] vars = javaClass.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(vars, (String)"vars");
            TypeVariable<Class<?>>[] $this$forEachIndexed$iv = vars;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (TypeVariable<Class<?>> item$iv : $this$forEachIndexed$iv) {
                void param;
                int n = index$iv++;
                TypeVariable<Class<?>> typeVariable = item$iv;
                int i2 = n;
                boolean bl = false;
                this.put(param.getName(), i2);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lavail/descriptor/types/PojoTypeDescriptor$LRUCacheKey;", "", "javaClass", "Ljava/lang/Class;", "typeArgs", "Lavail/descriptor/tuples/A_Tuple;", "(Ljava/lang/Class;Lavail/descriptor/tuples/A_Tuple;)V", "getJavaClass", "()Ljava/lang/Class;", "getTypeArgs", "()Lavail/descriptor/tuples/A_Tuple;", "equals", "", "other", "hashCode", "", "avail"})
    public static final class LRUCacheKey {
        @NotNull
        private final Class<?> javaClass;
        @NotNull
        private final A_Tuple typeArgs;

        public LRUCacheKey(@NotNull Class<?> javaClass, @NotNull A_Tuple typeArgs) {
            Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
            Intrinsics.checkNotNullParameter((Object)typeArgs, (String)"typeArgs");
            this.javaClass = javaClass;
            this.typeArgs = typeArgs;
        }

        @NotNull
        public final Class<?> getJavaClass() {
            return this.javaClass;
        }

        @NotNull
        public final A_Tuple getTypeArgs() {
            return this.typeArgs;
        }

        public boolean equals(@Nullable Object other) {
            if (other instanceof LRUCacheKey) {
                return Intrinsics.areEqual(this.javaClass, ((LRUCacheKey)other).javaClass) && this.typeArgs.equals(((LRUCacheKey)other).typeArgs);
            }
            return false;
        }

        public int hashCode() {
            return this.javaClass.hashCode() * this.typeArgs.hash() ^ 0x1FA07381;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\t\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0005J2\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#H\u0005J,\u0010&\u001a\u00020\u001d2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0002J(\u0010)\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010-\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#H\u0005J*\u0010.\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\b002\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\u0007J\u000e\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\u001fJ\u0006\u0010\n\u001a\u00020\u0004J\u0006\u0010\u000b\u001a\u00020\u0004J\u0012\u00105\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u00106\u001a\u00020\u0004J\u001d\u00107\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b082\u0006\u00109\u001a\u00020\u001d\u00a2\u0006\u0002\u0010:J\u0006\u0010;\u001a\u00020\u0004J\u0006\u0010<\u001a\u00020\u0004J\u0010\u0010=\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0005J\u0016\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u0004J\u0006\u0010A\u001a\u00020\u0004J\u0006\u0010B\u001a\u00020\u000eJ\u0012\u0010C\u001a\u00020\b2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bJ\u001a\u0010D\u001a\u00020\b2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010E\u001a\u00020\u00042\u0006\u00106\u001a\u00020(2\u0006\u0010F\u001a\u00020\u001fJ\u0012\u0010G\u001a\u00020\b2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bJ\u0006\u0010\u000f\u001a\u00020\u0004J\u0018\u0010H\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010\u00012\u0006\u00106\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lavail/descriptor/types/PojoTypeDescriptor$Companion;", "", "()V", "byteRange", "Lavail/descriptor/types/A_Type;", "cache", "Lorg/availlang/cache/LRUCache;", "Lavail/descriptor/types/PojoTypeDescriptor$LRUCacheKey;", "Lavail/descriptor/representation/AvailObject;", "charRange", "intRange", "longRange", "selfType", "selfTypeAtom", "Lavail/descriptor/atoms/A_Atom;", "shortRange", "canonicalPojoType", "probablePojoType", "allowMetas", "", "childlessAmong", "", "ancestry", "Lavail/descriptor/sets/A_Set;", "computeAncestry", "", "target", "Ljava/lang/Class;", "typeArgs", "Lavail/descriptor/tuples/A_Tuple;", "Lavail/utility/Mutable;", "Lavail/descriptor/maps/A_Map;", "canon", "Lavail/descriptor/types/PojoTypeDescriptor$Canon;", "computeIntersection", "Lavail/descriptor/representation/A_BasicObject;", "self", "aPojoType", "computeSupertypeParameters", "supertype", "Ljava/lang/reflect/Type;", "computeTypeArgumentsOf", "Ljava/lang/reflect/ParameterizedType;", "vars", "Lavail/descriptor/types/PojoTypeDescriptor$TypeVariableMap;", "computeUnion", "computeUnparameterizedAncestry", "ancestors", "", "computeValue", "key", "fusedTypeFromAncestorMap", "ancestorMap", "marshalDefiningType", "type", "marshalTypes", "", "types", "(Lavail/descriptor/tuples/A_Tuple;)[Ljava/lang/Class;", "mostGeneralPojoArrayType", "mostGeneralPojoType", "mostSpecificOf", "pojoArrayType", "elementType", "sizeRange", "pojoSelfType", "pojoSelfTypeAtom", "pojoTypeForClass", "pojoTypeForClassWithTypeArguments", "resolvePojoType", "typeVars", "selfTypeForClass", "unmarshal", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final A_Type mostGeneralPojoType() {
            return UnfusedPojoTypeDescriptor.Companion.getMostGeneralType();
        }

        @NotNull
        public final A_Type mostGeneralPojoArrayType() {
            return ArrayPojoTypeDescriptor.Companion.getMostGeneralType();
        }

        @NotNull
        public final A_Atom pojoSelfTypeAtom() {
            return selfTypeAtom;
        }

        @NotNull
        public final A_Type pojoSelfType() {
            return selfType;
        }

        @NotNull
        public final A_Type byteRange() {
            return byteRange;
        }

        @NotNull
        public final A_Type shortRange() {
            return shortRange;
        }

        @NotNull
        public final A_Type intRange() {
            return intRange;
        }

        @NotNull
        public final A_Type longRange() {
            return longRange;
        }

        @NotNull
        public final A_Type charRange() {
            return charRange;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AvailObject computeValue(@NotNull LRUCacheKey key) {
            void $this$computeValue_u24lambda_u240;
            Mutable<A_Map> ancestors;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Canon canon = new Canon();
            Mutable<A_Map> this_$iv = ancestors = new Mutable<A_Map>(MapDescriptor.Companion.getEmptyMap());
            boolean $i$f$update = false;
            A_Map a_Map = this_$iv.getValue();
            Mutable<A_Map> mutable = this_$iv;
            boolean bl = false;
            Object object = canon.get((Object)Object.class);
            Intrinsics.checkNotNull((Object)object);
            mutable.setValue(A_Map.Companion.mapAtPuttingCanDestroy((A_Map)$this$computeValue_u24lambda_u240, (A_BasicObject)object, TupleDescriptor.Companion.getEmptyTuple(), true));
            this.computeAncestry(key.getJavaClass(), key.getTypeArgs(), ancestors, canon);
            Object object2 = canon.get((Object)key.getJavaClass());
            Intrinsics.checkNotNull((Object)object2);
            return UnfusedPojoTypeDescriptor.Companion.createUnfusedPojoType((AvailObject)object2, ancestors.getValue());
        }

        @JvmStatic
        @NotNull
        protected final A_BasicObject computeIntersection(@NotNull A_BasicObject self, @NotNull A_BasicObject aPojoType) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)aPojoType, (String)"aPojoType");
            A_Map ancestors = self.javaAncestors();
            A_Map otherAncestors = aPojoType.javaAncestors();
            A_Set javaClasses = A_Map.Companion.getKeysAsSet(ancestors);
            A_Set otherJavaClasses = A_Map.Companion.getKeysAsSet(otherAncestors);
            A_Set union = A_Set.Companion.setUnionCanDestroy(javaClasses, otherJavaClasses, false);
            A_Map unionAncestors = MapDescriptor.Companion.getEmptyMap();
            for (AvailObject javaClass : union) {
                boolean bl;
                AvailObject availObject = A_Map.Companion.mapAtOrNull(ancestors, javaClass);
                A_Tuple params = availObject != null ? (A_Tuple)availObject : (A_Tuple)A_Map.Companion.mapAt(otherAncestors, javaClass);
                AvailObject availObject2 = A_Map.Companion.mapAtOrNull(otherAncestors, javaClass);
                A_Tuple otherParams = availObject2 != null ? (A_Tuple)availObject2 : (A_Tuple)A_Map.Companion.mapAt(ancestors, javaClass);
                int limit = A_Tuple.Companion.getTupleSize(params);
                boolean bl2 = bl = limit == A_Tuple.Companion.getTupleSize(otherParams);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                List intersectionParams = new ArrayList();
                int i2 = 1;
                if (i2 <= limit) {
                    while (true) {
                        A_Type y;
                        A_Type x;
                        A_Type intersection;
                        if (A_Type.Companion.isSubtypeOf(intersection = A_Type.Companion.typeIntersection(x = (A_Type)A_Tuple.Companion.tupleAt(params, i2), y = (A_Type)A_Tuple.Companion.tupleAt(otherParams, i2)), BottomPojoTypeDescriptor.Companion.pojoBottom())) {
                            return BottomPojoTypeDescriptor.Companion.pojoBottom();
                        }
                        intersectionParams.add(intersection);
                        if (i2 == limit) break;
                        ++i2;
                    }
                }
                unionAncestors = A_Map.Companion.mapAtPuttingCanDestroy(unionAncestors, javaClass, ObjectTupleDescriptor.Companion.tupleFromList(intersectionParams), true);
            }
            return unionAncestors;
        }

        @JvmStatic
        @NotNull
        protected final A_Map computeUnion(@NotNull A_BasicObject self, @NotNull A_BasicObject aPojoType) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)aPojoType, (String)"aPojoType");
            A_Map ancestors = self.javaAncestors();
            A_Map otherAncestors = aPojoType.javaAncestors();
            A_Set javaClasses = A_Map.Companion.getKeysAsSet(ancestors);
            A_Set otherJavaClasses = A_Map.Companion.getKeysAsSet(otherAncestors);
            A_Set intersection = A_Set.Companion.setIntersectionCanDestroy(javaClasses, otherJavaClasses, false);
            A_Map intersectionAncestors = MapDescriptor.Companion.getEmptyMap();
            for (AvailObject javaClass : intersection) {
                boolean bl;
                A_Tuple params = A_Map.Companion.mapAt(ancestors, javaClass);
                A_Tuple otherParams = A_Map.Companion.mapAt(otherAncestors, javaClass);
                int limit = A_Tuple.Companion.getTupleSize(params);
                boolean bl2 = bl = limit == A_Tuple.Companion.getTupleSize(otherParams);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                List unionParams = new ArrayList();
                int i2 = 1;
                if (i2 <= limit) {
                    while (true) {
                        A_Type x = A_Tuple.Companion.tupleAt(params, i2);
                        A_Type y = A_Tuple.Companion.tupleAt(otherParams, i2);
                        A_Type union = A_Type.Companion.typeUnion(x, y);
                        unionParams.add(union);
                        if (i2 == limit) break;
                        ++i2;
                    }
                }
                intersectionAncestors = A_Map.Companion.mapAtPuttingCanDestroy(intersectionAncestors, javaClass.makeImmutable(), ObjectTupleDescriptor.Companion.tupleFromList(unionParams), true);
            }
            return intersectionAncestors;
        }

        @JvmStatic
        @NotNull
        protected final Set<AvailObject> childlessAmong(@NotNull A_Set ancestry) {
            Intrinsics.checkNotNullParameter((Object)ancestry, (String)"ancestry");
            Set childless = new LinkedHashSet();
            for (AvailObject ancestor : ancestry) {
                childless.add(ancestor);
            }
            for (AvailObject ancestor : ancestry) {
                Class possibleAncestor = (Class)ancestor.javaObjectNotNull();
                for (AvailObject child : ancestry) {
                    Class possibleChild = (Class)child.javaObjectNotNull();
                    if (Intrinsics.areEqual((Object)possibleAncestor, (Object)possibleChild) || !possibleAncestor.isAssignableFrom(possibleChild)) continue;
                    childless.remove(ancestor);
                }
            }
            return childless;
        }

        @JvmStatic
        @NotNull
        protected final AvailObject mostSpecificOf(@NotNull A_Set ancestry) {
            Intrinsics.checkNotNullParameter((Object)ancestry, (String)"ancestry");
            AvailObject answer = RawPojoDescriptor.Companion.rawObjectClass();
            Class mostSpecific = Object.class;
            for (AvailObject rawType : ancestry) {
                Class javaClass = (Class)rawType.javaObjectNotNull();
                if (!mostSpecific.isAssignableFrom(javaClass)) continue;
                mostSpecific = javaClass;
                answer = rawType;
            }
            int modifiers = mostSpecific.getModifiers();
            if (Modifier.isInterface(modifiers)) {
                for (AvailObject rawType : ancestry) {
                    Class javaClass = (Class)rawType.javaObjectNotNull();
                    if (javaClass.isAssignableFrom(mostSpecific)) continue;
                    return NilDescriptor.Companion.getNil();
                }
            }
            return answer;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Class<?>[] marshalTypes(@NotNull A_Tuple types) throws MarshalingException {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)types, (String)"types");
            Iterable $this$map$iv = types;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object $this$cast$iv;
                void it;
                AvailObject availObject = (AvailObject)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it.marshalToJava(null));
                boolean $i$f$cast = false;
                collection2.add((Class)$this$cast$iv);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Class[0]);
        }

        @NotNull
        public final Class<?> marshalDefiningType(@NotNull A_Type type) {
            Object marshalledType;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Object $this$cast$iv = marshalledType = type.marshalToJava(null);
            boolean $i$f$cast = false;
            Class aClass = (Class)$this$cast$iv;
            if (aClass.isPrimitive()) {
                Class clazz = aClass;
                return Intrinsics.areEqual((Object)clazz, Boolean.TYPE) ? Boolean.class : (Intrinsics.areEqual((Object)clazz, Byte.TYPE) ? Byte.class : (Intrinsics.areEqual((Object)clazz, Short.TYPE) ? Short.class : (Intrinsics.areEqual((Object)clazz, Integer.TYPE) ? Integer.class : (Intrinsics.areEqual((Object)clazz, Long.TYPE) ? Long.class : (Intrinsics.areEqual((Object)clazz, Float.TYPE) ? Float.class : (Intrinsics.areEqual((Object)clazz, Double.TYPE) ? Double.class : (Intrinsics.areEqual((Object)clazz, Character.TYPE) ? Character.class : aClass)))))));
            }
            return aClass;
        }

        @NotNull
        public final AvailObject unmarshal(@Nullable Object self, @NotNull A_Type type) {
            A_BasicObject availObject;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            if (self == null) {
                return PojoDescriptor.Companion.nullPojo();
            }
            Class<?> clazz = self.getClass();
            A_BasicObject a_BasicObject = Intrinsics.areEqual(clazz, AvailObject.class) ? (A_BasicObject)((AvailObject)self) : (Intrinsics.areEqual(clazz, Boolean.class) ? (A_BasicObject)AtomDescriptor.Companion.objectFromBoolean((Boolean)self) : (Intrinsics.areEqual(clazz, Byte.class) ? (A_BasicObject)IntegerDescriptor.Companion.fromInt(((Byte)self).byteValue()) : (Intrinsics.areEqual(clazz, Short.class) ? (A_BasicObject)IntegerDescriptor.Companion.fromInt(((Short)self).shortValue()) : (Intrinsics.areEqual(clazz, Integer.class) ? (A_BasicObject)IntegerDescriptor.Companion.fromInt((Integer)self) : (Intrinsics.areEqual(clazz, Long.class) ? (A_BasicObject)IntegerDescriptor.Companion.fromLong((Long)self) : (Intrinsics.areEqual(clazz, Float.class) ? (A_BasicObject)FloatDescriptor.Companion.fromFloat(((Float)self).floatValue()) : (Intrinsics.areEqual(clazz, Double.class) ? (A_BasicObject)DoubleDescriptor.Companion.fromDouble((Double)self) : (Intrinsics.areEqual(clazz, Character.class) ? (A_BasicObject)IntegerDescriptor.Companion.fromInt(((Character)self).charValue()) : (Intrinsics.areEqual(clazz, String.class) ? (A_BasicObject)StringDescriptor.Companion.stringFrom((String)self) : (availObject = Intrinsics.areEqual(clazz, BigInteger.class) ? (A_BasicObject)IntegerDescriptor.Companion.fromBigInteger((BigInteger)self) : (A_BasicObject)PojoDescriptor.Companion.newPojo(RawPojoDescriptor.Companion.equalityPojo(self), type)))))))))));
            if (!availObject.isInstanceOf(type)) {
                throw new MarshalingException();
            }
            Intrinsics.checkNotNull((Object)availObject, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
            return (AvailObject)availObject;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final A_Type resolvePojoType(@NotNull Type type, @NotNull A_Map typeVars) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)typeVars, (String)"typeVars");
            if (type instanceof Class) {
                if (Intrinsics.areEqual((Object)type, Object.class)) {
                    return PrimitiveTypeDescriptor.Types.ANY.getO();
                }
                if (((Class)type).isPrimitive()) {
                    A_Type a_Type;
                    Type type2 = type;
                    if (Intrinsics.areEqual((Object)type2, Void.TYPE)) {
                        a_Type = PrimitiveTypeDescriptor.Types.TOP.getO();
                    } else if (Intrinsics.areEqual((Object)type2, Boolean.TYPE)) {
                        a_Type = EnumerationTypeDescriptor.Companion.getBooleanType();
                    } else if (Intrinsics.areEqual((Object)type2, Byte.TYPE)) {
                        a_Type = this.byteRange();
                    } else if (Intrinsics.areEqual((Object)type2, Short.TYPE)) {
                        a_Type = this.shortRange();
                    } else if (Intrinsics.areEqual((Object)type2, Integer.TYPE)) {
                        a_Type = this.intRange();
                    } else if (Intrinsics.areEqual((Object)type2, Long.TYPE)) {
                        a_Type = this.longRange();
                    } else if (Intrinsics.areEqual((Object)type2, Float.TYPE)) {
                        a_Type = PrimitiveTypeDescriptor.Types.FLOAT.getO();
                    } else if (Intrinsics.areEqual((Object)type2, Double.TYPE)) {
                        a_Type = PrimitiveTypeDescriptor.Types.DOUBLE.getO();
                    } else if (Intrinsics.areEqual((Object)type2, Character.TYPE)) {
                        a_Type = this.charRange();
                    } else {
                        if (_Assertions.ENABLED) {
                            boolean $i$a$-assert-PojoTypeDescriptor$Companion$resolvePojoType$22 = false;
                            String $i$a$-assert-PojoTypeDescriptor$Companion$resolvePojoType$22 = "There are only nine primitive types!";
                            throw new AssertionError((Object)$i$a$-assert-PojoTypeDescriptor$Companion$resolvePojoType$22);
                        }
                        throw new RuntimeException();
                    }
                    return a_Type;
                }
                Type type3 = type;
                if (Intrinsics.areEqual((Object)type3, Void.class)) {
                    return PrimitiveTypeDescriptor.Types.TOP.getO();
                }
                if (Intrinsics.areEqual((Object)type3, Boolean.class)) {
                    return EnumerationTypeDescriptor.Companion.getBooleanType();
                }
                if (Intrinsics.areEqual((Object)type3, Byte.class)) {
                    return this.byteRange();
                }
                if (Intrinsics.areEqual((Object)type3, Short.class)) {
                    return this.shortRange();
                }
                if (Intrinsics.areEqual((Object)type3, Integer.class)) {
                    return this.intRange();
                }
                if (Intrinsics.areEqual((Object)type3, Long.class)) {
                    return this.longRange();
                }
                if (Intrinsics.areEqual((Object)type3, Float.class)) {
                    return PrimitiveTypeDescriptor.Types.FLOAT.getO();
                }
                if (Intrinsics.areEqual((Object)type3, Double.class)) {
                    return PrimitiveTypeDescriptor.Types.DOUBLE.getO();
                }
                if (Intrinsics.areEqual((Object)type3, Character.class)) {
                    return this.charRange();
                }
                if (Intrinsics.areEqual((Object)type3, String.class)) {
                    return TupleTypeDescriptor.Companion.getStringType();
                }
                return Intrinsics.areEqual((Object)type, BigInteger.class) ? IntegerRangeTypeDescriptor.Companion.getIntegers() : (A_Type)this.pojoTypeForClass((Class)type);
            }
            if (type instanceof TypeVariable) {
                void $this$fold$iv;
                Class<Object> clazz;
                Object decl = ((TypeVariable)type).getGenericDeclaration();
                if (decl instanceof Class) {
                    clazz = (Class)decl;
                } else if (decl instanceof Constructor) {
                    clazz = ((Constructor)decl).getDeclaringClass();
                } else if (decl instanceof Method) {
                    clazz = ((Method)decl).getDeclaringClass();
                } else {
                    if (_Assertions.ENABLED) {
                        boolean $i$a$-assert-PojoTypeDescriptor$Companion$resolvePojoType$javaClass$22 = false;
                        String $i$a$-assert-PojoTypeDescriptor$Companion$resolvePojoType$javaClass$22 = "There should only be three contexts that can define a type variable!";
                        throw new AssertionError((Object)$i$a$-assert-PojoTypeDescriptor$Companion$resolvePojoType$javaClass$22);
                    }
                    throw new RuntimeException();
                }
                Class javaClass = clazz;
                A_String name = StringDescriptor.Companion.stringFrom(javaClass.getName() + "." + ((TypeVariable)type).getName());
                Object[] $i$a$-assert-PojoTypeDescriptor$Companion$resolvePojoType$22 = A_Map.Companion.mapAtOrNull(typeVars, name);
                if ($i$a$-assert-PojoTypeDescriptor$Companion$resolvePojoType$22 != null) {
                    Object[] it = $i$a$-assert-PojoTypeDescriptor$Companion$resolvePojoType$22;
                    boolean bl = false;
                    return (A_Type)it;
                }
                Type[] typeArray = ((TypeVariable)type).getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"type.bounds");
                $i$a$-assert-PojoTypeDescriptor$Companion$resolvePojoType$22 = typeArray;
                A_Type initial$iv = BottomTypeDescriptor.Companion.getBottom();
                boolean $i$f$fold = false;
                A_Type accumulator$iv = initial$iv;
                for (void element$iv : $this$fold$iv) {
                    void bound;
                    Type type4 = (Type)element$iv;
                    A_Type union = accumulator$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)bound, (String)"bound");
                    accumulator$iv = A_Type.Companion.typeIntersection(union, Companion.resolvePojoType((Type)bound, typeVars));
                }
                return accumulator$iv;
            }
            if (type instanceof ParameterizedType) {
                Type[] unresolved = ((ParameterizedType)type).getActualTypeArguments();
                List resolved = new ArrayList();
                Intrinsics.checkNotNullExpressionValue((Object)unresolved, (String)"unresolved");
                for (Type anUnresolved : unresolved) {
                    Intrinsics.checkNotNullExpressionValue((Object)anUnresolved, (String)"anUnresolved");
                    resolved.add(this.resolvePojoType(anUnresolved, typeVars));
                }
                Type type5 = ((ParameterizedType)type).getRawType();
                Intrinsics.checkNotNull((Object)type5, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                return this.pojoTypeForClassWithTypeArguments((Class)type5, ObjectTupleDescriptor.Companion.tupleFromList(resolved));
            }
            if (_Assertions.ENABLED) {
                boolean bl = false;
                String string2 = "Unsupported generic declaration";
                throw new AssertionError((Object)string2);
            }
            throw new RuntimeException();
        }

        @NotNull
        public final A_Type canonicalPojoType(@NotNull A_Type probablePojoType, boolean allowMetas) {
            A_BasicObject pojoClass;
            Intrinsics.checkNotNullParameter((Object)probablePojoType, (String)"probablePojoType");
            if (probablePojoType.isPojoType() && !probablePojoType.equalsPojoBottomType() && (pojoClass = probablePojoType.javaClass()).getNotNil()) {
                Class javaClass = (Class)pojoClass.javaObjectNotNull();
                TypeVariable<Class<T>>[] typeVariableArray = javaClass.getTypeParameters();
                Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"javaClass.typeParameters");
                if (((Object[])typeVariableArray).length == 0) {
                    A_Type resolved = this.resolvePojoType(javaClass, MapDescriptor.Companion.getEmptyMap());
                    return !allowMetas && resolved.equals(PrimitiveTypeDescriptor.Types.ANY.getO()) ? (A_Type)PrimitiveTypeDescriptor.Types.NONTYPE.getO() : resolved;
                }
            }
            return probablePojoType;
        }

        private final A_Tuple computeTypeArgumentsOf(ParameterizedType target, TypeVariableMap vars, A_Tuple typeArgs, Canon canon) {
            Type[] args = target.getActualTypeArguments();
            List propagation = new ArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)args, (String)"args");
            for (Type arg : args) {
                Type type = arg;
                if (type instanceof Class) {
                    A_Type a_Type;
                    if (canon.containsKey(arg)) {
                        Intrinsics.checkNotNullExpressionValue((Object)arg, (String)"arg");
                        a_Type = this.selfTypeForClass((Class)arg);
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)arg, (String)"arg");
                        a_Type = this.pojoTypeForClass((Class)arg);
                    }
                    A_Type typeArg = a_Type;
                    propagation.add(typeArg);
                    continue;
                }
                if (type instanceof TypeVariable) {
                    Object object = vars.get((Object)((TypeVariable)arg).getName());
                    Intrinsics.checkNotNull((Object)object);
                    int index2 = ((Number)object).intValue();
                    propagation.add(A_Tuple.Companion.tupleAt(typeArgs, index2 + 1));
                    continue;
                }
                if (type instanceof ParameterizedType) {
                    Intrinsics.checkNotNullExpressionValue((Object)arg, (String)"arg");
                    A_Tuple localArgs = this.computeTypeArgumentsOf((ParameterizedType)arg, vars, typeArgs, canon);
                    Type type2 = ((ParameterizedType)arg).getRawType();
                    Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                    propagation.add(this.pojoTypeForClassWithTypeArguments((Class)type2, localArgs));
                    continue;
                }
                if (_Assertions.ENABLED) {
                    boolean bl = false;
                    String string2 = "Unsupported generic declaration";
                    throw new AssertionError((Object)string2);
                }
                throw new RuntimeException();
            }
            return ObjectTupleDescriptor.Companion.tupleFromList(propagation);
        }

        private final A_Tuple computeSupertypeParameters(Class<?> target, Type supertype, A_Tuple typeArgs, Canon canon) {
            A_Tuple a_Tuple;
            Type type = supertype;
            if (type instanceof Class) {
                a_Tuple = TupleDescriptor.Companion.getEmptyTuple();
            } else if (type instanceof ParameterizedType) {
                a_Tuple = this.computeTypeArgumentsOf((ParameterizedType)supertype, new TypeVariableMap(target), typeArgs, canon);
            } else {
                if (_Assertions.ENABLED) {
                    boolean bl = false;
                    String string2 = "Unsupported generic declaration";
                    throw new AssertionError((Object)string2);
                }
                throw new RuntimeException();
            }
            return a_Tuple;
        }

        /*
         * WARNING - void declaration
         */
        private final void computeAncestry(Class<?> target, A_Tuple typeArgs, Mutable<A_Map> ancestry, Canon canon) {
            void $this$computeAncestry_u24lambda_u249;
            AvailObject javaClass = canon.canonize(target);
            Mutable<A_Map> this_$iv = ancestry;
            boolean $i$f$update = false;
            A_Map a_Map = this_$iv.getValue();
            Mutable<A_Map> mutable = this_$iv;
            boolean bl = false;
            mutable.setValue(A_Map.Companion.mapAtPuttingCanDestroy((A_Map)$this$computeAncestry_u24lambda_u249, javaClass, typeArgs, true));
            Class<?> superclass = target.getSuperclass();
            if (superclass != null && !canon.containsKey((Object)superclass)) {
                Type type = target.getGenericSuperclass();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"target.genericSuperclass");
                A_Tuple supertypeParams = this.computeSupertypeParameters(target, type, typeArgs, canon);
                this.computeAncestry(superclass, supertypeParams, ancestry, canon);
            }
            Class<?>[] superinterfaces = target.getInterfaces();
            Type[] genericSuperinterfaces = target.getGenericInterfaces();
            int n = superinterfaces.length;
            for (int i2 = 0; i2 < n; ++i2) {
                if (canon.containsKey((Object)superinterfaces[i2])) continue;
                Type type = genericSuperinterfaces[i2];
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"genericSuperinterfaces[i]");
                A_Tuple supertypeParams = this.computeSupertypeParameters(target, type, typeArgs, canon);
                Class<?> clazz = superinterfaces[i2];
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"superinterfaces[i]");
                this.computeAncestry(clazz, supertypeParams, ancestry, canon);
            }
        }

        @NotNull
        public final AvailObject pojoTypeForClassWithTypeArguments(@NotNull Class<?> target, @NotNull A_Tuple typeArgs) {
            Intrinsics.checkNotNullParameter(target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)typeArgs, (String)"typeArgs");
            return (AvailObject)cache.get((Object)new LRUCacheKey(target, typeArgs));
        }

        @NotNull
        public final AvailObject pojoTypeForClass(@NotNull Class<?> target) {
            Intrinsics.checkNotNullParameter(target, (String)"target");
            if (target.isArray()) {
                Class<?> clazz = target.getComponentType();
                Intrinsics.checkNotNull(clazz);
                return ArrayPojoTypeDescriptor.Companion.arrayPojoType(this.resolvePojoType(clazz, MapDescriptor.Companion.getEmptyMap()), IntegerRangeTypeDescriptor.Companion.getNonnegativeInt32());
            }
            return this.pojoTypeForClassWithTypeArguments(target, RepeatedElementTupleDescriptor.Companion.createRepeatedElementTuple(target.getTypeParameters().length, PrimitiveTypeDescriptor.Types.ANY.getO()));
        }

        @NotNull
        public final AvailObject pojoArrayType(@NotNull A_Type elementType, @NotNull A_Type sizeRange) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)sizeRange, (String)"sizeRange");
            boolean bl = A_Type.Companion.isSubtypeOf(sizeRange, IntegerRangeTypeDescriptor.Companion.getWholeNumbers());
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return ArrayPojoTypeDescriptor.Companion.arrayPojoType(elementType, sizeRange);
        }

        @NotNull
        public final AvailObject fusedTypeFromAncestorMap(@NotNull A_Map ancestorMap) {
            Intrinsics.checkNotNullParameter((Object)ancestorMap, (String)"ancestorMap");
            boolean bl = ancestorMap.isMap();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return FusedPojoTypeDescriptor.Companion.createFusedPojoType(ancestorMap);
        }

        private final void computeUnparameterizedAncestry(Class<?> target, Set<AvailObject> ancestors, Canon canon) {
            Class<?> superclass;
            ancestors.add(canon.canonize(target));
            Class<?> clazz = superclass = target.getSuperclass();
            if (clazz != null) {
                Class<?> it = clazz;
                boolean bl = false;
                Companion.computeUnparameterizedAncestry(it, ancestors, canon);
            }
            Class<?>[] classArray = target.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"target.interfaces");
            for (Class<?> superinterface : classArray) {
                Intrinsics.checkNotNullExpressionValue(superinterface, (String)"superinterface");
                this.computeUnparameterizedAncestry(superinterface, ancestors, canon);
            }
        }

        @NotNull
        public final AvailObject selfTypeForClass(@NotNull Class<?> target) {
            Intrinsics.checkNotNullParameter(target, (String)"target");
            Canon canon = new Canon();
            Set ancestors = new LinkedHashSet();
            Object object = canon.get((Object)Object.class);
            Intrinsics.checkNotNull((Object)object);
            ancestors.add(object);
            this.computeUnparameterizedAncestry(target, ancestors, canon);
            Object object2 = canon.get((Object)target);
            Intrinsics.checkNotNull((Object)object2);
            return SelfPojoTypeDescriptor.Companion.newSelfPojoType((AvailObject)object2, SetDescriptor.Companion.setFromCollection(ancestors));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

