/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.execution;

import avail.compiler.CompilationContext;
import avail.compiler.scanning.LexingState;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.character.CharacterDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.methods.A_Method;
import avail.descriptor.module.A_Module;
import avail.descriptor.module.ModuleDescriptor;
import avail.descriptor.parsing.A_Lexer;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.interpreter.execution.AvailLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bJ\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\rH\u0002J\u0006\u0010!\u001a\u00020\u001dJJ\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001b2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001d0'2\u001e\u0010(\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020*0)\u0012\u0004\u0012\u00020\u001d0'J>\u0010+\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001b2$\u0010&\u001a \u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020*0)\u0012\u0004\u0012\u00020\u001d0,H\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000e0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lavail/interpreter/execution/LexicalScanner;", "", "moduleNameProducer", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "allVisibleLexers", "", "Lavail/descriptor/parsing/A_Lexer;", "getAllVisibleLexers", "()Ljava/util/List;", "canonicalLexerTuples", "", "Lavail/descriptor/sets/A_Set;", "Lavail/descriptor/tuples/A_Tuple;", "frozen", "", "getFrozen", "()Z", "setFrozen", "(Z)V", "latin1ApplicableLexers", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "getModuleNameProducer", "()Lkotlin/jvm/functions/Function0;", "nonLatin1Lexers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "addLexer", "", "lexer", "canonicalTupleOfLexers", "applicable", "freezeFromChanges", "getLexersForCodePointThen", "lexingState", "Lavail/compiler/scanning/LexingState;", "codePoint", "continuation", "Lkotlin/Function1;", "onFailure", "", "", "selectLexersPassingFilterThen", "Lkotlin/Function2;", "avail"})
public final class LexicalScanner {
    @NotNull
    private final Function0<String> moduleNameProducer;
    @NotNull
    private final List<A_Lexer> allVisibleLexers;
    private volatile boolean frozen;
    @NotNull
    private final AtomicReferenceArray<A_Tuple> latin1ApplicableLexers;
    @NotNull
    private final ConcurrentHashMap<Integer, A_Tuple> nonLatin1Lexers;
    @NotNull
    private final Map<A_Set, A_Tuple> canonicalLexerTuples;

    public LexicalScanner(@NotNull Function0<String> moduleNameProducer) {
        Intrinsics.checkNotNullParameter(moduleNameProducer, (String)"moduleNameProducer");
        this.moduleNameProducer = moduleNameProducer;
        this.allVisibleLexers = new ArrayList();
        this.latin1ApplicableLexers = new AtomicReferenceArray(256);
        this.nonLatin1Lexers = new ConcurrentHashMap();
        this.canonicalLexerTuples = new LinkedHashMap();
    }

    @NotNull
    public final Function0<String> getModuleNameProducer() {
        return this.moduleNameProducer;
    }

    @NotNull
    public final List<A_Lexer> getAllVisibleLexers() {
        return this.allVisibleLexers;
    }

    public final boolean getFrozen() {
        return this.frozen;
    }

    public final void setFrozen(boolean bl) {
        this.frozen = bl;
    }

    public final void freezeFromChanges() {
        boolean bl;
        boolean bl2 = bl = !this.frozen;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.frozen = true;
    }

    public final synchronized void addLexer(@NotNull A_Lexer lexer) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        boolean bl2 = bl = !this.frozen;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Method.Companion.setLexer(A_Lexer.Companion.getLexerMethod(lexer), lexer);
        A_Module module = A_Lexer.Companion.getDefinitionModule(lexer);
        if (module.getNotNil() && A_Module.Companion.getModuleState(module) == ModuleDescriptor.State.Loading) {
            A_Module.Companion.addLexer(module, lexer);
        }
        this.allVisibleLexers.add(lexer);
        if (!this.canonicalLexerTuples.isEmpty()) {
            for (int i2 = 0; i2 < 256; ++i2) {
                this.latin1ApplicableLexers.set(i2, null);
            }
            this.nonLatin1Lexers.clear();
            this.canonicalLexerTuples.clear();
        }
    }

    public final void getLexersForCodePointThen(@NotNull LexingState lexingState, int codePoint, @NotNull Function1<? super A_Tuple, Unit> continuation, @NotNull Function1<? super Map<A_Lexer, ? extends Throwable>, Unit> onFailure) {
        A_Tuple tuple2;
        Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        if ((codePoint & 0xFFFFFF00) == 0) {
            A_Tuple a_Tuple = this.latin1ApplicableLexers.get(codePoint);
            if (a_Tuple != null) {
                A_Tuple it = a_Tuple;
                boolean bl = false;
                continuation.invoke((Object)it);
                return;
            }
            this.selectLexersPassingFilterThen(lexingState, codePoint, (Function2<? super A_Set, ? super Map<A_Lexer, ? extends Throwable>, Unit>)((Function2)new Function2<A_Set, Map<A_Lexer, ? extends Throwable>, Unit>(onFailure, this, codePoint, continuation){
                final /* synthetic */ Function1<Map<A_Lexer, ? extends Throwable>, Unit> $onFailure;
                final /* synthetic */ LexicalScanner this$0;
                final /* synthetic */ int $codePoint;
                final /* synthetic */ Function1<A_Tuple, Unit> $continuation;
                {
                    this.$onFailure = $onFailure;
                    this.this$0 = $receiver;
                    this.$codePoint = $codePoint;
                    this.$continuation = $continuation;
                    super(2);
                }

                public final void invoke(@NotNull A_Set applicable, @NotNull Map<A_Lexer, ? extends Throwable> failures) {
                    Intrinsics.checkNotNullParameter((Object)applicable, (String)"applicable");
                    Intrinsics.checkNotNullParameter(failures, (String)"failures");
                    if (!failures.isEmpty()) {
                        this.$onFailure.invoke(failures);
                    } else {
                        A_Tuple lexers = LexicalScanner.access$canonicalTupleOfLexers(this.this$0, applicable);
                        LexicalScanner.access$getLatin1ApplicableLexers$p(this.this$0).set(this.$codePoint, lexers);
                        this.$continuation.invoke((Object)lexers);
                    }
                }
            }));
            return;
        }
        A_Tuple a_Tuple = tuple2 = this.nonLatin1Lexers.get(codePoint);
        if (a_Tuple != null) {
            continuation.invoke((Object)a_Tuple);
            return;
        }
        this.selectLexersPassingFilterThen(lexingState, codePoint, (Function2<? super A_Set, ? super Map<A_Lexer, ? extends Throwable>, Unit>)((Function2)new Function2<A_Set, Map<A_Lexer, ? extends Throwable>, Unit>(onFailure, this, codePoint, continuation){
            final /* synthetic */ Function1<Map<A_Lexer, ? extends Throwable>, Unit> $onFailure;
            final /* synthetic */ LexicalScanner this$0;
            final /* synthetic */ int $codePoint;
            final /* synthetic */ Function1<A_Tuple, Unit> $continuation;
            {
                this.$onFailure = $onFailure;
                this.this$0 = $receiver;
                this.$codePoint = $codePoint;
                this.$continuation = $continuation;
                super(2);
            }

            public final void invoke(@NotNull A_Set applicable, @NotNull Map<A_Lexer, ? extends Throwable> failures) {
                Intrinsics.checkNotNullParameter((Object)applicable, (String)"applicable");
                Intrinsics.checkNotNullParameter(failures, (String)"failures");
                if (!failures.isEmpty()) {
                    this.$onFailure.invoke(failures);
                    return;
                }
                A_Tuple lexers = LexicalScanner.access$canonicalTupleOfLexers(this.this$0, applicable);
                ((Map)LexicalScanner.access$getNonLatin1Lexers$p(this.this$0)).put(this.$codePoint, lexers);
                this.$continuation.invoke((Object)lexers);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final A_Tuple canonicalTupleOfLexers(A_Set applicable) {
        A_Tuple a_Tuple;
        Map<A_Set, A_Tuple> map = this.canonicalLexerTuples;
        synchronized (map) {
            boolean bl = false;
            A_Tuple a_Tuple2 = this.canonicalLexerTuples.get(applicable);
            if (a_Tuple2 == null) {
                LexicalScanner $this$canonicalTupleOfLexers_u24lambda_u242_u24lambda_u241 = this;
                boolean bl2 = false;
                AvailObject tuple2 = A_Set.Companion.getAsTuple(applicable).makeShared();
                $this$canonicalTupleOfLexers_u24lambda_u242_u24lambda_u241.canonicalLexerTuples.put(applicable.makeShared(), tuple2);
                a_Tuple2 = tuple2;
            }
            a_Tuple = a_Tuple2;
        }
        return a_Tuple;
    }

    /*
     * WARNING - void declaration
     */
    private final void selectLexersPassingFilterThen(LexingState lexingState, int codePoint, Function2<? super A_Set, ? super Map<A_Lexer, ? extends Throwable>, Unit> continuation) {
        void $this$mapTo$iv$iv;
        List applicableLexers = new ArrayList();
        List undecidedLexers = new ArrayList();
        int n = codePoint;
        boolean bl = 0 <= n ? n < 256 : false;
        if (bl) {
            Iterable $this$forEach$iv = this.allVisibleLexers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                A_Lexer it = (A_Lexer)element$iv;
                boolean bl2 = false;
                Boolean bl3 = A_Lexer.Companion.lexerApplicability(it, codePoint);
                if (bl3 == null) {
                    undecidedLexers.add(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)bl3, (Object)true)) {
                    applicableLexers.add(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)bl3, (Object)false)) continue;
            }
        } else {
            undecidedLexers.addAll((Collection)this.allVisibleLexers);
        }
        Ref.IntRef countdown = new Ref.IntRef();
        countdown.element = undecidedLexers.size();
        if (countdown.element == 0) {
            continuation.invoke((Object)SetDescriptor.Companion.setFromCollection(applicableLexers), (Object)MapsKt.emptyMap());
            return;
        }
        List argsList = CollectionsKt.listOf((Object)CharacterDescriptor.Companion.fromCodePoint(codePoint));
        CompilationContext compilationContext = lexingState.getCompilationContext();
        AvailLoader loader = compilationContext.getLoader();
        ReentrantLock joinLock = new ReentrantLock();
        Map failureMap = new LinkedHashMap();
        Iterable $this$map$iv = undecidedLexers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void lexer;
            A_Lexer a_Lexer = (A_Lexer)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl4 = false;
            A_Fiber fiber2 = FiberDescriptor.Companion.newLoaderFiber(EnumerationTypeDescriptor.Companion.getBooleanType(), loader, (Function0<? extends A_String>)((Function0)new Function0<A_String>((A_Lexer)lexer, loader, codePoint, this){
                final /* synthetic */ A_Lexer $lexer;
                final /* synthetic */ AvailLoader $loader;
                final /* synthetic */ int $codePoint;
                final /* synthetic */ LexicalScanner this$0;
                {
                    this.$lexer = $lexer;
                    this.$loader = $loader;
                    this.$codePoint = $codePoint;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final A_String invoke() {
                    Object[] objectArray = new Object[]{A_Atom.Companion.getAtomName(A_Bundle.Companion.getMessage(A_Method.Companion.chooseBundle(A_Lexer.Companion.getLexerMethod(this.$lexer), this.$loader.getModule()))), this.$codePoint, this.this$0.getModuleNameProducer().invoke()};
                    return StringDescriptor.Companion.formatString("Lexer filter %s for U+%04x in %s", objectArray);
                }
            }));
            lexingState.setFiberContinuationsTrackingWork(fiber2, (Function1<? super AvailObject, Unit>)((Function1)new Function1<AvailObject, Unit>(codePoint, (A_Lexer)lexer, joinLock, continuation, (List<A_Lexer>)applicableLexers, (Map<A_Lexer, Throwable>)failureMap, countdown){
                final /* synthetic */ int $codePoint;
                final /* synthetic */ A_Lexer $lexer;
                final /* synthetic */ ReentrantLock $joinLock;
                final /* synthetic */ Function2<A_Set, Map<A_Lexer, ? extends Throwable>, Unit> $continuation;
                final /* synthetic */ List<A_Lexer> $applicableLexers;
                final /* synthetic */ Map<A_Lexer, Throwable> $failureMap;
                final /* synthetic */ Ref.IntRef $countdown;
                {
                    this.$codePoint = $codePoint;
                    this.$lexer = $lexer;
                    this.$joinLock = $joinLock;
                    this.$continuation = $continuation;
                    this.$applicableLexers = $applicableLexers;
                    this.$failureMap = $failureMap;
                    this.$countdown = $countdown;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull AvailObject boolObject) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)boolObject, (String)"boolObject");
                    boolean boolValue = A_Atom.Companion.getExtractBoolean(boolObject);
                    boolean bl2 = 0 <= this.$codePoint ? this.$codePoint < 256 : false;
                    if (bl2) {
                        A_Lexer.Companion.setLexerApplicability(this.$lexer, this.$codePoint, boolValue);
                    }
                    Lock lock = this.$joinLock;
                    List<A_Lexer> list2 = this.$applicableLexers;
                    A_Lexer a_Lexer = this.$lexer;
                    Ref.IntRef intRef = this.$countdown;
                    lock.lock();
                    try {
                        boolean bl3 = false;
                        if (boolValue) {
                            list2.add(a_Lexer);
                        }
                        int n = intRef.element;
                        intRef.element = n + -1;
                        int n2 = n = intRef.element >= 0 ? 1 : 0;
                        if (_Assertions.ENABLED && n == 0) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        bl = intRef.element == 0;
                    }
                    finally {
                        lock.unlock();
                    }
                    boolean countdownHitZero = bl;
                    if (countdownHitZero) {
                        this.$continuation.invoke((Object)SetDescriptor.Companion.setFromCollection((Collection<? extends A_BasicObject>)this.$applicableLexers), this.$failureMap);
                    }
                }
            }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(joinLock, continuation, (List<A_Lexer>)applicableLexers, (Map<A_Lexer, Throwable>)failureMap, (A_Lexer)lexer, countdown){
                final /* synthetic */ ReentrantLock $joinLock;
                final /* synthetic */ Function2<A_Set, Map<A_Lexer, ? extends Throwable>, Unit> $continuation;
                final /* synthetic */ List<A_Lexer> $applicableLexers;
                final /* synthetic */ Map<A_Lexer, Throwable> $failureMap;
                final /* synthetic */ A_Lexer $lexer;
                final /* synthetic */ Ref.IntRef $countdown;
                {
                    this.$joinLock = $joinLock;
                    this.$continuation = $continuation;
                    this.$applicableLexers = $applicableLexers;
                    this.$failureMap = $failureMap;
                    this.$lexer = $lexer;
                    this.$countdown = $countdown;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull Throwable throwable) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    Lock lock = this.$joinLock;
                    Map<A_Lexer, Throwable> map = this.$failureMap;
                    A_Lexer a_Lexer = this.$lexer;
                    Ref.IntRef intRef = this.$countdown;
                    lock.lock();
                    try {
                        boolean bl2 = false;
                        map.put(a_Lexer, throwable);
                        int n = intRef.element;
                        intRef.element = n + -1;
                        int n2 = n = intRef.element >= 0 ? 1 : 0;
                        if (_Assertions.ENABLED && n == 0) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        bl = intRef.element == 0;
                    }
                    finally {
                        lock.unlock();
                    }
                    boolean countdownHitZero = bl;
                    if (countdownHitZero) {
                        this.$continuation.invoke((Object)SetDescriptor.Companion.setFromCollection((Collection<? extends A_BasicObject>)this.$applicableLexers), this.$failureMap);
                    }
                }
            }));
            collection2.add(fiber2);
        }
        List fibers2 = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = fibers2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void fiber3;
            int n2;
            Object item$iv$iv;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (A_Fiber)item$iv;
            int i2 = n2;
            boolean bl5 = false;
            loader.getRuntime().runOutermostFunction((A_Fiber)fiber3, A_Lexer.Companion.getLexerFilterFunction((A_Lexer)undecidedLexers.get(i2)), argsList);
        }
    }

    public static final /* synthetic */ A_Tuple access$canonicalTupleOfLexers(LexicalScanner $this, A_Set applicable) {
        return $this.canonicalTupleOfLexers(applicable);
    }

    public static final /* synthetic */ AtomicReferenceArray access$getLatin1ApplicableLexers$p(LexicalScanner $this) {
        return $this.latin1ApplicableLexers;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getNonLatin1Lexers$p(LexicalScanner $this) {
        return $this.nonLatin1Lexers;
    }
}

