/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelOne;

import avail.descriptor.functions.CompiledCodeDescriptor;
import avail.descriptor.module.A_Module;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.BlockPhraseDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.NybbleTupleDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.levelOne.L1InstructionWriter;
import avail.interpreter.levelOne.L1Operation;
import avail.interpreter.levelOne.L1StackTracker;
import avail.io.NybbleArray;
import avail.io.NybbleOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020*J\u001f\u0010\t\u001a\u0002032\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b05\"\u00020\u000b\u00a2\u0006\u0002\u00106J\u000e\u00107\u001a\u0002032\u0006\u00104\u001a\u000208J\u0006\u00109\u001a\u00020\u0010J\u000e\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u000bJ\u000e\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u000bJ\b\u0010>\u001a\u00020\u0010H\u0002J\"\u0010?\u001a\u0002032\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020B2\n\u0010C\u001a\u00020D\"\u00020\u0005J\u0010\u0010E\u001a\u0002032\u0006\u0010F\u001a\u00020\u0005H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R(\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00050)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lavail/interpreter/levelOne/L1InstructionWriter;", "", "module", "Lavail/descriptor/module/A_Module;", "startingLineNumber", "", "phrase", "Lavail/descriptor/phrases/A_Phrase;", "(Lavail/descriptor/module/A_Module;ILavail/descriptor/phrases/A_Phrase;)V", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "constantTypes", "currentLineNumber", "lineNumberEncodedDeltas", "literals", "Lavail/descriptor/representation/AvailObject;", "getLiterals$avail", "()Ljava/util/List;", "localTypes", "getModule$avail", "()Lavail/descriptor/module/A_Module;", "outerTypes", "getPhrase$avail", "()Lavail/descriptor/phrases/A_Phrase;", "newValue", "Lavail/interpreter/Primitive;", "primitive", "getPrimitive", "()Lavail/interpreter/Primitive;", "setPrimitive", "(Lavail/interpreter/Primitive;)V", "returnType", "getReturnType", "()Lavail/descriptor/types/A_Type;", "setReturnType", "(Lavail/descriptor/types/A_Type;)V", "returnTypeIfPrimitiveFails", "getReturnTypeIfPrimitiveFails", "setReturnTypeIfPrimitiveFails", "reverseLiterals", "", "Lavail/descriptor/representation/A_BasicObject;", "stackTracker", "Lavail/interpreter/levelOne/L1StackTracker;", "getStartingLineNumber$avail", "()I", "stream", "Lavail/io/NybbleOutputStream;", "addLiteral", "literal", "", "argTypes", "", "([Lavail/descriptor/types/A_Type;)V", "argumentTypesTuple", "Lavail/descriptor/tuples/A_Tuple;", "compiledCode", "createLocal", "localType", "createOuter", "outerType", "nybbles", "write", "lineNumber", "operation", "Lavail/interpreter/levelOne/L1Operation;", "operands", "", "writeOperand", "operand", "avail"})
public final class L1InstructionWriter {
    @NotNull
    private final A_Module module;
    private final int startingLineNumber;
    @NotNull
    private final A_Phrase phrase;
    @NotNull
    private final NybbleOutputStream stream;
    @NotNull
    private final List<AvailObject> literals;
    @NotNull
    private final Map<A_BasicObject, Integer> reverseLiterals;
    @NotNull
    private List<A_Type> argumentTypes;
    @Nullable
    private A_Type returnType;
    @Nullable
    private A_Type returnTypeIfPrimitiveFails;
    @NotNull
    private final List<A_Type> localTypes;
    @NotNull
    private final List<A_Type> constantTypes;
    @NotNull
    private final List<A_Type> outerTypes;
    @Nullable
    private Primitive primitive;
    private int currentLineNumber;
    @NotNull
    private final List<Integer> lineNumberEncodedDeltas;
    @NotNull
    private final L1StackTracker stackTracker;

    public L1InstructionWriter(@NotNull A_Module module, int startingLineNumber, @NotNull A_Phrase phrase) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)phrase, (String)"phrase");
        this.module = module;
        this.startingLineNumber = startingLineNumber;
        this.phrase = phrase;
        this.stream = new NybbleOutputStream(0, 1, null);
        this.literals = new ArrayList();
        this.reverseLiterals = new LinkedHashMap();
        this.argumentTypes = new ArrayList();
        this.localTypes = new ArrayList();
        this.constantTypes = new ArrayList();
        this.outerTypes = new ArrayList();
        this.currentLineNumber = this.startingLineNumber;
        this.lineNumberEncodedDeltas = new ArrayList();
        this.stackTracker = new L1StackTracker(this){
            final /* synthetic */ L1InstructionWriter this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public AvailObject literalAt$avail(int literalIndex2) {
                return this.this$0.getLiterals$avail().get(literalIndex2 - 1);
            }
        };
    }

    @NotNull
    public final A_Module getModule$avail() {
        return this.module;
    }

    public final int getStartingLineNumber$avail() {
        return this.startingLineNumber;
    }

    @NotNull
    public final A_Phrase getPhrase$avail() {
        return this.phrase;
    }

    @NotNull
    public final List<AvailObject> getLiterals$avail() {
        return this.literals;
    }

    @Nullable
    public final A_Type getReturnType() {
        return this.returnType;
    }

    public final void setReturnType(@Nullable A_Type a_Type) {
        this.returnType = a_Type;
    }

    @Nullable
    public final A_Type getReturnTypeIfPrimitiveFails() {
        return this.returnTypeIfPrimitiveFails;
    }

    public final void setReturnTypeIfPrimitiveFails(@Nullable A_Type a_Type) {
        this.returnTypeIfPrimitiveFails = a_Type;
    }

    @Nullable
    public final Primitive getPrimitive() {
        return this.primitive;
    }

    public final void setPrimitive(@Nullable Primitive newValue) {
        boolean bl;
        boolean bl2 = bl = this.primitive == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Don't set the primitive twice";
            throw new AssertionError((Object)string2);
        }
        this.primitive = newValue;
    }

    public final int addLiteral(@NotNull A_BasicObject literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        Integer index2 = this.reverseLiterals.get(literal);
        if (index2 == null) {
            this.literals.add((AvailObject)literal);
            index2 = this.literals.size();
            this.reverseLiterals.put(literal, index2);
        }
        return index2;
    }

    public final void argumentTypes(A_Type ... argTypes2) {
        Intrinsics.checkNotNullParameter((Object)argTypes2, (String)"argTypes");
        boolean bl = this.argumentTypes.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl2 = bl = !ArraysKt.contains((Object[])argTypes2, (Object)BottomTypeDescriptor.Companion.getBottom());
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        boolean bl3 = bl = this.localTypes.size() == 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string4 = "Must declare argument types before allocating locals";
            throw new AssertionError((Object)string4);
        }
        Collections.addAll((Collection)this.argumentTypes, Arrays.copyOf(argTypes2, argTypes2.length));
    }

    public final void argumentTypesTuple(@NotNull A_Tuple argTypes2) {
        Intrinsics.checkNotNullParameter((Object)argTypes2, (String)"argTypes");
        boolean bl = this.argumentTypes.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl2 = bl = !CollectionsKt.contains((Iterable)argTypes2, (Object)BottomTypeDescriptor.Companion.getBottom());
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        boolean bl3 = bl = this.localTypes.size() == 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string4 = "Must declare argument types before allocating locals";
            throw new AssertionError((Object)string4);
        }
        CollectionsKt.addAll((Collection)this.argumentTypes, (Iterable)argTypes2);
    }

    public final int createLocal(@NotNull A_Type localType) {
        Intrinsics.checkNotNullParameter((Object)localType, (String)"localType");
        boolean bl = localType.isInstanceOf(InstanceMetaDescriptor.Companion.topMeta());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.localTypes.add(localType);
        return this.localTypes.size() + this.argumentTypes.size();
    }

    public final int createOuter(@NotNull A_Type outerType) {
        Intrinsics.checkNotNullParameter((Object)outerType, (String)"outerType");
        this.outerTypes.add(outerType);
        return this.outerTypes.size();
    }

    private final void writeOperand(int operand) {
        if (operand < 10) {
            this.stream.write(operand);
        } else if (operand < 58) {
            this.stream.write(operand + 150 >>> 4);
            this.stream.write(operand + 150 & 0xF);
        } else if (operand < 314) {
            this.stream.write(13);
            this.stream.write(operand - 58 >>> 4);
            this.stream.write(operand - 58 & 0xF);
        } else if (operand < 65536) {
            this.stream.write(14);
            this.stream.write(operand >>> 12);
            this.stream.write(operand >>> 8 & 0xF);
            this.stream.write(operand >>> 4 & 0xF);
            this.stream.write(operand & 0xF);
        } else {
            this.stream.write(15);
            this.stream.write(operand >>> 28);
            this.stream.write(operand >>> 24 & 0xF);
            this.stream.write(operand >>> 20 & 0xF);
            this.stream.write(operand >>> 16 & 0xF);
            this.stream.write(operand >>> 12 & 0xF);
            this.stream.write(operand >>> 8 & 0xF);
            this.stream.write(operand >>> 4 & 0xF);
            this.stream.write(operand & 0xF);
        }
    }

    public final void write(int lineNumber, @NotNull L1Operation operation, int ... operands) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter((Object)operands, (String)"operands");
        int newLineNumber = lineNumber == 0 ? this.currentLineNumber : lineNumber;
        int delta = newLineNumber - this.currentLineNumber;
        int encodedDelta = delta > 0 ? delta << 1 : -delta << 1 | 1;
        this.lineNumberEncodedDeltas.add(encodedDelta);
        this.currentLineNumber = newLineNumber;
        this.stackTracker.track(operation, Arrays.copyOf(operands, operands.length));
        byte opcode = (byte)operation.ordinal();
        if (opcode <= 15) {
            this.stream.write(opcode);
        } else {
            this.stream.write(L1Operation.L1_doExtension.ordinal());
            this.stream.write(opcode - 16);
        }
        int[] $this$forEach$iv = operands;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            int element$iv;
            int p0 = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            this.writeOperand(p0);
        }
    }

    private final AvailObject nybbles() {
        int size = this.stream.getSize();
        NybbleArray nybbleArray = this.stream.toNybbleArray();
        AvailObject nybbles2 = NybbleTupleDescriptor.Companion.generateNybbleTupleFrom(size, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(nybbleArray){
            final /* synthetic */ NybbleArray $nybbleArray;
            {
                this.$nybbleArray = $nybbleArray;
                super(1);
            }

            @NotNull
            public final Integer invoke(int it) {
                boolean bl;
                byte nybble = this.$nybbleArray.get(it - 1);
                boolean bl2 = bl = nybble < 16;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                return nybble;
            }
        }));
        nybbles2.makeImmutable();
        return nybbles2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AvailObject compiledCode() {
        boolean bl;
        Primitive p = this.primitive;
        boolean bl2 = bl = p == null || p.hasFlag(Primitive.Flag.CannotFail) || this.localTypes.size() > 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-L1InstructionWriter$compiledCode$22 = false;
            String $i$a$-assert-L1InstructionWriter$compiledCode$22 = "Fallible primitive needs a primitive failure variable";
            throw new AssertionError((Object)$i$a$-assert-L1InstructionWriter$compiledCode$22);
        }
        List names = new ArrayList();
        if (this.phrase.getNotNil()) {
            void $this$mapTo$iv$iv;
            Object[] $i$a$-assert-L1InstructionWriter$compiledCode$22 = new Iterable[]{A_Phrase.Companion.getArgumentsTuple(this.phrase), BlockPhraseDescriptor.Companion.locals(this.phrase), BlockPhraseDescriptor.Companion.constants(this.phrase)};
            Iterable $this$map$iv = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])$i$a$-assert-L1InstructionWriter$compiledCode$22));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                A_Phrase a_Phrase = (A_Phrase)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(A_String.Companion.asNativeString(A_Phrase.Companion.getToken((A_Phrase)it).string()));
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            A_Type it;
            int n;
            Collection collection3;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            int counter = 0;
            counter = 1;
            Iterable $i$f$map = this.argumentTypes;
            List list2 = names;
            boolean $i$f$map2 = false;
            void destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                A_Type bl3 = (A_Type)item$iv$iv;
                collection3 = destination$iv$iv2;
                boolean bl4 = false;
                n = counter;
                counter = n + 1;
                collection3.add("arg" + n);
            }
            list2.addAll((List)destination$iv$iv2);
            $this$map$iv2 = this.localTypes;
            list2 = names;
            $i$f$map2 = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (A_Type)item$iv$iv;
                collection3 = destination$iv$iv2;
                boolean bl5 = false;
                n = counter;
                counter = n + 1;
                collection3.add("local" + n);
            }
            list2.addAll((List)destination$iv$iv2);
            $this$map$iv2 = this.constantTypes;
            list2 = names;
            $i$f$map2 = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (A_Type)item$iv$iv;
                collection3 = destination$iv$iv2;
                boolean bl6 = false;
                n = counter;
                counter = n + 1;
                collection3.add("constant" + n);
            }
            list2.addAll((List)destination$iv$iv2);
            int outerCounter = 0;
            outerCounter = 1;
            Iterable $i$f$map22 = this.outerTypes;
            list2 = names;
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                A_Type bl6 = (A_Type)item$iv$iv;
                collection3 = destination$iv$iv3;
                boolean bl7 = false;
                int n2 = outerCounter;
                outerCounter = n2 + 1;
                collection3.add("outer" + n2);
            }
            list2.addAll((List)destination$iv$iv3);
        }
        String packedDeclarationNames2 = CollectionsKt.joinToString$default((Iterable)names, (CharSequence)",", null, null, (int)0, null, (Function1)compiledCode.packedDeclarationNames.1.INSTANCE, (int)30, null);
        A_Tuple a_Tuple = this.nybbles();
        int n = this.stackTracker.getMaxDepth$avail();
        A_Tuple a_Tuple2 = ObjectTupleDescriptor.Companion.tupleFromList(this.argumentTypes);
        A_Type a_Type = this.returnType;
        Intrinsics.checkNotNull((Object)a_Type);
        A_Type a_Type2 = FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, a_Tuple2, a_Type, null, 4, null);
        A_Type a_Type3 = this.returnTypeIfPrimitiveFails;
        Intrinsics.checkNotNull((Object)a_Type3);
        return CompiledCodeDescriptor.Companion.newCompiledCode(a_Tuple, n, a_Type2, this.primitive, a_Type3, ObjectTupleDescriptor.Companion.tupleFromList(this.literals), ObjectTupleDescriptor.Companion.tupleFromList(this.localTypes), ObjectTupleDescriptor.Companion.tupleFromList(this.constantTypes), ObjectTupleDescriptor.Companion.tupleFromList(this.outerTypes), this.module, this.startingLineNumber, TupleDescriptor.Companion.tupleFromIntegerList(this.lineNumberEncodedDeltas), -1, this.phrase, StringDescriptor.Companion.stringFrom(packedDeclarationNames2));
    }
}

