/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.functions.A_Function;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.types.A_Type;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2FloatImmediateOperand;
import avail.interpreter.levelTwo.operand.L2IntImmediateOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteFloatOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.L2WriteOperand;
import avail.interpreter.levelTwo.operation.L2_MOVE_CONSTANT;
import avail.interpreter.levelTwo.register.L2BoxedRegister;
import avail.interpreter.levelTwo.register.L2FloatRegister;
import avail.interpreter.levelTwo.register.L2IntRegister;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2Generator;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.values.L2SemanticValue;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 2*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\u000e\b\u0002\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00030\u00062\u00020\u0007:\u00012BC\b\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\u000b\u0012\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J>\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u000e0\u001dH\u0016J0\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010+\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\tH\u0016J \u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lavail/interpreter/levelTwo/operation/L2_MOVE_CONSTANT;", "C", "Lavail/interpreter/levelTwo/operand/L2Operand;", "R", "Lavail/interpreter/levelTwo/register/L2Register;", "WR", "Lavail/interpreter/levelTwo/operand/L2WriteOperand;", "Lavail/interpreter/levelTwo/L2Operation;", "variantName", "", "pushConstant", "Lkotlin/Function3;", "Lavail/optimizer/jvm/JVMTranslator;", "Lorg/objectweb/asm/MethodVisitor;", "", "theNamedOperandTypes", "", "Lavail/interpreter/levelTwo/L2NamedOperandType;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function3;[Lavail/interpreter/levelTwo/L2NamedOperandType;)V", "appendToWithWarnings", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "extractFunctionOuter", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "functionRegister", "outerIndex", "", "outerType", "Lavail/descriptor/types/A_Type;", "generator", "Lavail/optimizer/L2Generator;", "extractTupleElement", "tupleReg", "index", "instructionWasAdded", "manifest", "Lavail/optimizer/L2ValueManifest;", "toString", "translateToJVM", "translator", "method", "Companion", "avail"})
public final class L2_MOVE_CONSTANT<C extends L2Operand, R extends L2Register, WR extends L2WriteOperand<R>>
extends L2Operation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String variantName;
    @NotNull
    private final Function3<JVMTranslator, MethodVisitor, C, Unit> pushConstant;
    @JvmField
    @NotNull
    public static final L2_MOVE_CONSTANT<L2ConstantOperand, L2BoxedRegister, L2WriteBoxedOperand> boxed;
    @JvmField
    @NotNull
    public static final L2_MOVE_CONSTANT<L2IntImmediateOperand, L2IntRegister, L2WriteIntOperand> unboxedInt;
    @NotNull
    private static final L2_MOVE_CONSTANT<L2FloatImmediateOperand, L2FloatRegister, L2WriteFloatOperand> unboxedFloat;

    private L2_MOVE_CONSTANT(String variantName, Function3<? super JVMTranslator, ? super MethodVisitor, ? super C, Unit> pushConstant, L2NamedOperandType ... theNamedOperandTypes) {
        super(Arrays.copyOf(theNamedOperandTypes, theNamedOperandTypes.length));
        this.variantName = variantName;
        this.pushConstant = pushConstant;
    }

    @Override
    public void instructionWasAdded(@NotNull L2Instruction instruction2, @NotNull L2ValueManifest manifest2) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)manifest2, (String)"manifest");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Object source = instruction2.operand(0);
        L2WriteOperand destination = (L2WriteOperand)instruction2.operand(1);
        ((L2Operand)source).instructionWasAdded(manifest2);
        L2SemanticValue semanticValue = destination.pickSemanticValue();
        if (manifest2.hasSemanticValue(semanticValue)) {
            destination.instructionWasAddedForMove(semanticValue, manifest2);
        } else {
            destination.instructionWasAdded(manifest2);
        }
    }

    @Override
    @NotNull
    public L2ReadBoxedOperand extractFunctionOuter(@NotNull L2Instruction instruction2, @NotNull L2ReadBoxedOperand functionRegister, int outerIndex, @NotNull A_Type outerType, @NotNull L2Generator generator) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)functionRegister, (String)"functionRegister");
        Intrinsics.checkNotNullParameter((Object)outerType, (String)"outerType");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        boolean bl2 = bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation()) && Intrinsics.areEqual((Object)this, boxed);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Function constantFunction = Companion.constantOf(instruction2);
        return generator.boxedConstant(constantFunction.outerVarAt(outerIndex));
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, (String)"desiredTypes");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Object constant = instruction2.operand(0);
        L2WriteOperand destination = (L2WriteOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder);
        builder.append(' ');
        destination.appendWithWarningsTo(builder, 0, warningStyleChange);
        builder.append(" \u2190 ");
        builder.append(constant);
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + "(" + this.variantName + ")";
    }

    @Override
    @NotNull
    public L2ReadBoxedOperand extractTupleElement(@NotNull L2ReadBoxedOperand tupleReg, int index2, @NotNull L2Generator generator) {
        Intrinsics.checkNotNullParameter((Object)tupleReg, (String)"tupleReg");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        L2Instruction instruction2 = tupleReg.definition().getInstruction();
        L2ConstantOperand source = (L2ConstantOperand)instruction2.operand(0);
        AvailObject tupleElement = A_Tuple.Companion.tupleAt(source.getConstant(), index2);
        return generator.boxedConstant(tupleElement);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Object constantOperand = instruction2.operand(0);
        L2WriteOperand destinationWriter = (L2WriteOperand)instruction2.operand(1);
        this.pushConstant.invoke((Object)translator, (Object)method, constantOperand);
        translator.store(method, (L2Register)destinationWriter.register());
    }

    static {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.CONSTANT.named("constant"), L2OperandType.WRITE_BOXED.named("destination boxed")};
        boxed = new L2_MOVE_CONSTANT("boxed", Companion.boxed.1.INSTANCE, l2NamedOperandTypeArray);
        l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.INT_IMMEDIATE.named("constant int"), L2OperandType.WRITE_INT.named("destination int")};
        unboxedInt = new L2_MOVE_CONSTANT("int", Companion.unboxedInt.1.INSTANCE, l2NamedOperandTypeArray);
        l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.FLOAT_IMMEDIATE.named("constant float"), L2OperandType.WRITE_FLOAT.named("destination float")};
        unboxedFloat = new L2_MOVE_CONSTANT("float", Companion.unboxedFloat.1.INSTANCE, l2NamedOperandTypeArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\"\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lavail/interpreter/levelTwo/operation/L2_MOVE_CONSTANT$Companion;", "", "()V", "boxed", "Lavail/interpreter/levelTwo/operation/L2_MOVE_CONSTANT;", "Lavail/interpreter/levelTwo/operand/L2ConstantOperand;", "Lavail/interpreter/levelTwo/register/L2BoxedRegister;", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "unboxedFloat", "Lavail/interpreter/levelTwo/operand/L2FloatImmediateOperand;", "Lavail/interpreter/levelTwo/register/L2FloatRegister;", "Lavail/interpreter/levelTwo/operand/L2WriteFloatOperand;", "getUnboxedFloat", "()Lavail/interpreter/levelTwo/operation/L2_MOVE_CONSTANT;", "unboxedInt", "Lavail/interpreter/levelTwo/operand/L2IntImmediateOperand;", "Lavail/interpreter/levelTwo/register/L2IntRegister;", "Lavail/interpreter/levelTwo/operand/L2WriteIntOperand;", "constantOf", "Lavail/descriptor/representation/AvailObject;", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final L2_MOVE_CONSTANT<L2FloatImmediateOperand, L2FloatRegister, L2WriteFloatOperand> getUnboxedFloat() {
            return unboxedFloat;
        }

        @NotNull
        public final AvailObject constantOf(@NotNull L2Instruction instruction2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
            boolean bl2 = bl = instruction2.getOperation() == boxed;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            L2ConstantOperand constant = (L2ConstantOperand)instruction2.operand(0);
            return constant.getConstant();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

