/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwoSimple;

import avail.AvailRuntime;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.A_Function;
import avail.descriptor.methods.A_Method;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.variables.VariableDescriptor;
import avail.exceptions.MethodDefinitionException;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Chunk;
import avail.interpreter.levelTwo.L2JVMChunk;
import avail.interpreter.levelTwoSimple.L2Simple_AbstractReifiableInstruction;
import avail.optimizer.StackReifier;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJA\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0004\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010\u001f\u001a\u00020 H\u0004\u00a2\u0006\u0002\u0010!J%\u0010\"\u001a\u0004\u0018\u00010\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010#R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lavail/interpreter/levelTwoSimple/L2Simple_AbstractInvokerInstruction;", "Lavail/interpreter/levelTwoSimple/L2Simple_AbstractReifiableInstruction;", "stackp", "", "pc", "nextOffset", "liveIndices", "", "expectedType", "Lavail/descriptor/types/A_Type;", "mustCheck", "", "(III[Ljava/lang/Integer;Lavail/descriptor/types/A_Type;Z)V", "getExpectedType", "()Lavail/descriptor/types/A_Type;", "getMustCheck", "()Z", "handleFailedLookup", "Lavail/optimizer/StackReifier;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "args", "", "Lavail/descriptor/representation/AvailObject;", "e", "Lavail/exceptions/MethodDefinitionException;", "registers", "bundle", "Lavail/descriptor/bundles/A_Bundle;", "(Lavail/interpreter/execution/Interpreter;Ljava/util/List;Lavail/exceptions/MethodDefinitionException;[Lavail/descriptor/representation/AvailObject;Lavail/descriptor/bundles/A_Bundle;)Lavail/optimizer/StackReifier;", "invocationHelper", "function", "Lavail/descriptor/functions/A_Function;", "(Lavail/interpreter/execution/Interpreter;[Lavail/descriptor/representation/AvailObject;Lavail/descriptor/functions/A_Function;)Lavail/optimizer/StackReifier;", "reenter", "([Lavail/descriptor/representation/AvailObject;Lavail/interpreter/execution/Interpreter;)Lavail/optimizer/StackReifier;", "avail"})
public abstract class L2Simple_AbstractInvokerInstruction
extends L2Simple_AbstractReifiableInstruction {
    @NotNull
    private final A_Type expectedType;
    private final boolean mustCheck;

    public L2Simple_AbstractInvokerInstruction(int stackp, int pc, int nextOffset, @NotNull Integer[] liveIndices2, @NotNull A_Type expectedType, boolean mustCheck) {
        Intrinsics.checkNotNullParameter((Object)liveIndices2, (String)"liveIndices");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        super(stackp, pc, nextOffset, liveIndices2);
        this.expectedType = expectedType;
        this.mustCheck = mustCheck;
    }

    @NotNull
    public final A_Type getExpectedType() {
        return this.expectedType;
    }

    public final boolean getMustCheck() {
        return this.mustCheck;
    }

    @Nullable
    protected final StackReifier invocationHelper(@NotNull Interpreter interpreter, @NotNull AvailObject[] registers, @NotNull A_Function function) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)registers, (String)"registers");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        L2Chunk l2Chunk = interpreter.chunk;
        Intrinsics.checkNotNull((Object)l2Chunk);
        L2Chunk thisChunk = l2Chunk;
        StackReifier reifier = interpreter.invokeFunction(function);
        interpreter.chunk = thisChunk;
        interpreter.function = registers[0];
        if (reifier == null) {
            interpreter.returnNow = false;
            AvailObject availObject = interpreter.latestResultOrNull();
            Intrinsics.checkNotNull((Object)availObject);
            AvailObject result2 = availObject;
            if (!this.mustCheck || result2.isInstanceOf(this.expectedType)) {
                registers[this.getStackp()] = result2;
                return null;
            }
            List<AvailObject> args = interpreter.argsBuffer;
            args.clear();
            args.add((AvailObject)function);
            A_Type a_Type = this.expectedType;
            Intrinsics.checkNotNull((Object)a_Type, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
            args.add((AvailObject)a_Type);
            AvailObject wrappedReturnValue = VariableDescriptor.Companion.newVariableWithContentType$default(VariableDescriptor.Companion, PrimitiveTypeDescriptor.Types.ANY.getO(), null, 2, null);
            if (result2.getNotNil()) {
                wrappedReturnValue.setValueNoCheck(result2);
            }
            args.add(wrappedReturnValue);
            reifier = interpreter.invokeFunction(interpreter.runtime.get(AvailRuntime.HookType.RESULT_DISAGREED_WITH_EXPECTED_TYPE));
        }
        boolean bl2 = bl = reifier != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        StackReifier stackReifier = reifier;
        Intrinsics.checkNotNull((Object)stackReifier);
        if (stackReifier.actuallyReify()) {
            reifier.pushAction((Function1<? super Interpreter, Unit>)((Function1)new Function1<Interpreter, Unit>(registers, this, thisChunk){
                final /* synthetic */ AvailObject[] $registers;
                final /* synthetic */ L2Simple_AbstractInvokerInstruction this$0;
                final /* synthetic */ L2Chunk $thisChunk;
                {
                    this.$registers = $registers;
                    this.this$0 = $receiver;
                    this.$thisChunk = $thisChunk;
                    super(1);
                }

                public final void invoke(@NotNull Interpreter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int n = this.this$0.getStackp();
                    A_Type a_Type = this.this$0.getExpectedType();
                    Intrinsics.checkNotNull((Object)a_Type, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                    this.$registers[n] = (AvailObject)a_Type;
                    L2Simple_AbstractReifiableInstruction l2Simple_AbstractReifiableInstruction = this.this$0;
                    AvailObject availObject = it.getReifiedContinuation();
                    Intrinsics.checkNotNull((Object)availObject);
                    A_Continuation continuation = L2Simple_AbstractReifiableInstruction.createContinuation$default(l2Simple_AbstractReifiableInstruction, availObject, this.$registers, this.$thisChunk, 0, 8, null);
                    it.setReifiedContinuation(continuation);
                }
            }));
        }
        return reifier;
    }

    @Override
    @Nullable
    public StackReifier reenter(@NotNull AvailObject[] registers, @NotNull Interpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)registers, (String)"registers");
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        if (!interpreter.checkValidity(L2JVMChunk.ChunkEntryPoint.TO_RETURN_INTO.getOffsetInDefaultChunk())) {
            return null;
        }
        AvailObject result2 = interpreter.getLatestResult();
        AvailObject availObject = interpreter.getReifiedContinuation();
        Intrinsics.checkNotNull((Object)availObject);
        AvailObject con = availObject;
        L2Chunk thisChunk = A_Continuation.Companion.levelTwoChunk(con);
        if (!this.mustCheck || result2.isInstanceOf(this.expectedType)) {
            boolean bl2 = A_Continuation.Companion.frameAt(con, this.getStackp()).equals(this.expectedType);
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            int n = registers.length;
            for (int i2 = 1; i2 < n; ++i2) {
                registers[i2] = A_Continuation.Companion.frameAt(con, i2);
            }
            registers[this.getStackp()] = result2;
            interpreter.popContinuation();
            return null;
        }
        List<AvailObject> args = interpreter.argsBuffer;
        args.clear();
        args.add(registers[0]);
        A_Type a_Type = this.expectedType;
        Intrinsics.checkNotNull((Object)a_Type, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
        args.add((AvailObject)a_Type);
        AvailObject wrappedReturnValue = VariableDescriptor.Companion.newVariableWithContentType$default(VariableDescriptor.Companion, PrimitiveTypeDescriptor.Types.ANY.getO(), null, 2, null);
        if (result2.getNotNil()) {
            wrappedReturnValue.setValueNoCheck(result2);
        }
        args.add(wrappedReturnValue);
        StackReifier reifier = interpreter.invokeFunction(interpreter.runtime.get(AvailRuntime.HookType.RESULT_DISAGREED_WITH_EXPECTED_TYPE));
        boolean bl3 = bl = reifier != null;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        StackReifier stackReifier = reifier;
        Intrinsics.checkNotNull((Object)stackReifier);
        if (stackReifier.actuallyReify()) {
            reifier.pushAction((Function1<? super Interpreter, Unit>)((Function1)new Function1<Interpreter, Unit>(registers, this, thisChunk){
                final /* synthetic */ AvailObject[] $registers;
                final /* synthetic */ L2Simple_AbstractInvokerInstruction this$0;
                final /* synthetic */ L2Chunk $thisChunk;
                {
                    this.$registers = $registers;
                    this.this$0 = $receiver;
                    this.$thisChunk = $thisChunk;
                    super(1);
                }

                public final void invoke(@NotNull Interpreter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$registers[this.this$0.getStackp()] = (AvailObject)this.this$0.getExpectedType();
                    L2Simple_AbstractReifiableInstruction l2Simple_AbstractReifiableInstruction = this.this$0;
                    AvailObject availObject = it.getReifiedContinuation();
                    Intrinsics.checkNotNull((Object)availObject);
                    A_Continuation continuation = L2Simple_AbstractReifiableInstruction.createContinuation$default(l2Simple_AbstractReifiableInstruction, availObject, this.$registers, this.$thisChunk, 0, 8, null);
                    it.setReifiedContinuation(continuation);
                }
            }));
        }
        return reifier;
    }

    @NotNull
    protected final StackReifier handleFailedLookup(@NotNull Interpreter interpreter, @NotNull List<AvailObject> args, @NotNull MethodDefinitionException e, @NotNull AvailObject[] registers, @NotNull A_Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)registers, (String)"registers");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        L2Chunk l2Chunk = interpreter.chunk;
        Intrinsics.checkNotNull((Object)l2Chunk);
        L2Chunk thisChunk = l2Chunk;
        A_Tuple argumentsTuple = ObjectTupleDescriptor.Companion.tupleFromList(args);
        args.clear();
        A_Number a_Number = e.getErrorCode().numericCode();
        Intrinsics.checkNotNull((Object)a_Number, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
        args.add((AvailObject)a_Number);
        A_Method a_Method = A_Bundle.Companion.getBundleMethod(bundle);
        Intrinsics.checkNotNull((Object)a_Method, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
        args.add((AvailObject)a_Method);
        Intrinsics.checkNotNull((Object)argumentsTuple, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
        args.add((AvailObject)argumentsTuple);
        StackReifier stackReifier = interpreter.invokeFunction(interpreter.runtime.invalidMessageSendFunction());
        Intrinsics.checkNotNull((Object)stackReifier);
        StackReifier reifier = stackReifier;
        if (reifier.actuallyReify()) {
            reifier.pushAction((Function1<? super Interpreter, Unit>)((Function1)new Function1<Interpreter, Unit>(registers, this, thisChunk){
                final /* synthetic */ AvailObject[] $registers;
                final /* synthetic */ L2Simple_AbstractInvokerInstruction this$0;
                final /* synthetic */ L2Chunk $thisChunk;
                {
                    this.$registers = $registers;
                    this.this$0 = $receiver;
                    this.$thisChunk = $thisChunk;
                    super(1);
                }

                public final void invoke(@NotNull Interpreter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int n = this.this$0.getStackp();
                    A_Type a_Type = this.this$0.getExpectedType();
                    Intrinsics.checkNotNull((Object)a_Type, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                    this.$registers[n] = (AvailObject)a_Type;
                    L2Simple_AbstractReifiableInstruction l2Simple_AbstractReifiableInstruction = this.this$0;
                    AvailObject availObject = it.getReifiedContinuation();
                    Intrinsics.checkNotNull((Object)availObject);
                    A_Continuation continuation = L2Simple_AbstractReifiableInstruction.createContinuation$default(l2Simple_AbstractReifiableInstruction, availObject, this.$registers, this.$thisChunk, 0, 8, null);
                    it.setReifiedContinuation(continuation);
                }
            }));
        }
        return reifier;
    }
}

