/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.maps.A_Map;
import avail.descriptor.module.A_Module;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.DeclarationPhraseDescriptor;
import avail.descriptor.phrases.LiteralPhraseDescriptor;
import avail.descriptor.phrases.VariableUsePhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tokens.LiteralTokenDescriptor;
import avail.descriptor.tokens.TokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_BootstrapVariableUseMacro;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_BootstrapVariableUseMacro
extends Primitive {
    @NotNull
    public static final P_BootstrapVariableUseMacro INSTANCE = new P_BootstrapVariableUseMacro();

    private P_BootstrapVariableUseMacro() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject variableNameLiteral = interpreter.argument(0);
        AvailLoader availLoader = interpreter.availLoaderOrNull();
        if (availLoader == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        AvailLoader loader = availLoader;
        boolean bl2 = variableNameLiteral.isInstanceOf(PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.getMostGeneralType());
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Token literalToken = A_Phrase.Companion.getToken(variableNameLiteral);
        boolean bl3 = bl = literalToken.tokenType() == TokenDescriptor.TokenType.LITERAL;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        AvailObject actualToken = literalToken.literal();
        boolean bl4 = actualToken.isInstanceOf(PrimitiveTypeDescriptor.Types.TOKEN.getO());
        if (_Assertions.ENABLED && !bl4) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        A_String variableNameString = actualToken.string();
        if (actualToken.tokenType() != TokenDescriptor.TokenType.KEYWORD) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.SILENT, "variable " + variableNameString + " to be alphanumeric", new Object[0]);
        }
        A_Map fiberGlobals = A_Fiber.Companion.getFiberGlobals(interpreter.fiber());
        AvailObject clientData = A_Map.Companion.mapAt(fiberGlobals, AtomDescriptor.SpecialAtom.CLIENT_DATA_GLOBAL_KEY.getAtom());
        AvailObject scopeMap = A_Map.Companion.mapAt(clientData, AtomDescriptor.SpecialAtom.COMPILER_SCOPE_MAP_KEY.getAtom());
        AvailObject availObject = A_Map.Companion.mapAtOrNull(scopeMap, variableNameString);
        if (availObject != null) {
            AvailObject localDeclaration = availObject;
            boolean bl5 = false;
            if (localDeclaration.declarationKind() == DeclarationPhraseDescriptor.DeclarationKind.LOCAL_CONSTANT && A_Phrase.Companion.phraseKindIsUnder(A_Phrase.Companion.getInitializationExpression(localDeclaration), PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
                AvailObject definitionLiteral = A_Phrase.Companion.getInitializationExpression(localDeclaration);
                A_Token definitionToken = A_Phrase.Companion.getToken(definitionLiteral);
                AvailObject newLiteralToken = LiteralTokenDescriptor.Companion.literalToken$default(LiteralTokenDescriptor.Companion, actualToken.string(), actualToken.start(), actualToken.lineNumber(), definitionToken.literal(), NilDescriptor.Companion.getNil(), null, 32, null);
                A_Phrase newLiteral = LiteralPhraseDescriptor.Companion.literalNodeFromToken(newLiteralToken);
                return interpreter.primitiveSuccess(newLiteral.makeImmutable());
            }
            A_Phrase variableUse = VariableUsePhraseDescriptor.Companion.newUse(actualToken, localDeclaration);
            return interpreter.primitiveSuccess(variableUse.makeImmutable());
        }
        A_Module module = loader.getModule();
        AvailObject availObject2 = A_Map.Companion.mapAtOrNull(A_Module.Companion.getVariableBindings(module), variableNameString);
        if (availObject2 != null) {
            AvailObject variableObject = availObject2;
            boolean bl6 = false;
            A_Phrase moduleVarDecl = DeclarationPhraseDescriptor.Companion.newModuleVariable(actualToken, variableObject, NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil());
            A_Phrase variableUse = VariableUsePhraseDescriptor.Companion.newUse(actualToken, moduleVarDecl);
            return interpreter.primitiveSuccess(variableUse.makeImmutable());
        }
        availObject2 = A_Map.Companion.mapAtOrNull(A_Module.Companion.getConstantBindings(module), variableNameString);
        if (availObject2 != null) {
            AvailObject variableObject = availObject2;
            boolean bl7 = false;
            A_Phrase moduleConstDecl = DeclarationPhraseDescriptor.Companion.newModuleConstant(actualToken, variableObject, NilDescriptor.Companion.getNil());
            A_Phrase variableUse = VariableUsePhraseDescriptor.Companion.newUse(actualToken, moduleConstDecl);
            return interpreter.primitiveSuccess(variableUse.makeImmutable());
        }
        throw new AvailRejectedParseException(A_Map.Companion.getMapSize(scopeMap) == 0 ? CompilerDiagnostics.ParseNotificationLevel.SILENT : CompilerDiagnostics.ParseNotificationLevel.WEAK, (Function0<? extends A_String>)((Function0)new Function0<A_String>(scopeMap, variableNameString){
            final /* synthetic */ AvailObject $scopeMap;
            final /* synthetic */ A_String $variableNameString;
            {
                this.$scopeMap = $scopeMap;
                this.$variableNameString = $variableNameString;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final A_String invoke() {
                void $this$invoke_u24lambda_u241;
                void $this$mapTo$iv$iv;
                StringBuilder stringBuilder;
                AvailObject availObject = this.$scopeMap;
                A_String a_String = this.$variableNameString;
                StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                StringDescriptor.Companion companion = StringDescriptor.Companion;
                boolean bl = false;
                Iterable $this$map$iv = A_Map.Companion.getKeysAsSet(availObject);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AvailObject availObject2 = (AvailObject)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    collection2.add(A_String.Companion.asNativeString((A_String)it));
                }
                List scope = (List)destination$iv$iv;
                $this$invoke_u24lambda_u241.append("potential variable ");
                $this$invoke_u24lambda_u241.append(a_String);
                $this$invoke_u24lambda_u241.append(" to be in scope (local scope is");
                if (scope.isEmpty()) {
                    $this$invoke_u24lambda_u241.append(" empty)");
                } else {
                    $this$invoke_u24lambda_u241.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)scope), null, (CharSequence)": ", (CharSequence)")", (int)0, null, null, (int)57, null));
                }
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                return companion.stringFrom(string2);
            }
        }));
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.create(PrimitiveTypeDescriptor.Types.TOKEN.getO())), PhraseTypeDescriptor.PhraseKind.VARIABLE_USE_PHRASE.getMostGeneralType(), null, 4, null);
    }
}

