/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.continuations;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.ContinuationDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.ContinuationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2JVMChunk;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/continuations/P_CreateContinuation;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_CreateContinuation
extends Primitive {
    @NotNull
    public static final P_CreateContinuation INSTANCE = new P_CreateContinuation();

    private P_CreateContinuation() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(5, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(5);
        AvailObject function = interpreter.argument(0);
        AvailObject pc = interpreter.argument(1);
        AvailObject stack = interpreter.argument(2);
        AvailObject stackp = interpreter.argument(3);
        AvailObject callerHolder = interpreter.argument(4);
        A_RawFunction rawFunction2 = function.code();
        Primitive primitive2 = rawFunction2.codePrimitive();
        if (primitive2 != null && primitive2.hasFlag(Primitive.Flag.CannotFail)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_CREATE_CONTINUATION_FOR_INFALLIBLE_PRIMITIVE_FUNCTION);
        }
        if (A_Tuple.Companion.getTupleSize(stack) != A_RawFunction.Companion.getNumSlots(rawFunction2)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_CONTINUATION_STACK_SIZE);
        }
        AvailObject cont = ContinuationDescriptor.Companion.createContinuationWithFrame(function, callerHolder.value(), NilDescriptor.Companion.getNil(), A_Number.Companion.getExtractInt(pc), A_Number.Companion.getExtractInt(stackp), L2JVMChunk.Companion.getUnoptimizedChunk(), L2JVMChunk.ChunkEntryPoint.TO_RETURN_INTO.getOffsetInDefaultChunk(), TupleDescriptor.Companion.toList(stack), 0);
        return interpreter.primitiveSuccess(cont);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(FunctionTypeDescriptor.Companion.mostGeneralFunctionType(), IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), TupleTypeDescriptor.Companion.getMostGeneralTupleType(), IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), VariableTypeDescriptor.Companion.variableTypeFor(ContinuationTypeDescriptor.Companion.getMostGeneralContinuationType())), ContinuationTypeDescriptor.Companion.getMostGeneralContinuationType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_CREATE_CONTINUATION_FOR_INFALLIBLE_PRIMITIVE_FUNCTION, AvailErrorCode.E_INCORRECT_CONTINUATION_STACK_SIZE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

