/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.files;

import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.IOSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/files/P_FileCanWrite;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_FileCanWrite
extends Primitive {
    @NotNull
    public static final P_FileCanWrite INSTANCE = new P_FileCanWrite();

    private P_FileCanWrite() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        boolean bl;
        Path path;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject filename = interpreter.argument(0);
        try {
            Path path2 = IOSystem.Companion.getFileSystem().getPath(A_String.Companion.asNativeString(filename), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"{\n\t\t\t\tIOSystem.fileSyste\u2026me.asNativeString())\n\t\t\t}");
            path = path2;
        }
        catch (InvalidPathException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INVALID_PATH);
        }
        Path path3 = path;
        try {
            bl = Files.isWritable(path3);
        }
        catch (SecurityException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        boolean writable = bl;
        return interpreter.primitiveSuccess(AtomDescriptor.Companion.objectFromBoolean(writable));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getStringType()), EnumerationTypeDescriptor.Companion.getBooleanType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_PATH, AvailErrorCode.E_PERMISSION_DENIED};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

