/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.integers;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operation.L2_BIT_LOGIC_OP;
import avail.optimizer.L1Translator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016JH\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/primitive/integers/P_BitwiseAnd;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_BitwiseAnd
extends Primitive {
    @NotNull
    public static final P_BitwiseAnd INSTANCE = new P_BitwiseAnd();

    private P_BitwiseAnd() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject a = interpreter.argument(0);
        AvailObject b = interpreter.argument(1);
        return interpreter.primitiveSuccess(A_Number.Companion.bitwiseAnd(a, b, true));
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        long l;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        boolean bl2 = bl = argumentTypes.size() == 2;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Type aRange = argumentTypes.get(0);
        A_Type bRange = argumentTypes.get(1);
        if (A_Number.Companion.greaterOrEqual(A_Type.Companion.getLowerBound(aRange), IntegerDescriptor.Companion.getZero()) && A_Number.Companion.isLong(A_Type.Companion.getUpperBound(aRange))) {
            l = A_Number.Companion.greaterOrEqual(A_Type.Companion.getLowerBound(bRange), IntegerDescriptor.Companion.getZero()) && A_Number.Companion.isLong(A_Type.Companion.getUpperBound(bRange)) ? Math.min(A_Number.Companion.getExtractLong(A_Type.Companion.getUpperBound(aRange)), A_Number.Companion.getExtractLong(A_Type.Companion.getUpperBound(bRange))) : A_Number.Companion.getExtractLong(A_Type.Companion.getUpperBound(aRange));
        } else if (A_Number.Companion.greaterOrEqual(A_Type.Companion.getLowerBound(bRange), IntegerDescriptor.Companion.getZero()) && A_Number.Companion.isLong(A_Type.Companion.getUpperBound(bRange))) {
            l = A_Number.Companion.getExtractLong(A_Type.Companion.getUpperBound(bRange));
        } else {
            return super.returnTypeGuaranteedByVM(rawFunction2, argumentTypes);
        }
        long upper = l;
        long highOneBit = Long.highestOneBit(upper);
        if (highOneBit == 0L) {
            return IntegerRangeTypeDescriptor.Companion.singleInt(0);
        }
        long maxValue = highOneBit - 1L | highOneBit;
        return IntegerRangeTypeDescriptor.Companion.integerRangeType(IntegerDescriptor.Companion.getZero(), true, IntegerDescriptor.Companion.fromLong(maxValue), true);
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        return L2_BIT_LOGIC_OP.Companion.getBitwiseAnd().generateBinaryIntOperation(arguments, argumentTypes, callSiteHelper, (Function1<? super List<? extends A_Type>, ? extends A_Type>)((Function1)new Function1<List<? extends A_Type>, A_Type>(rawFunction2){
            final /* synthetic */ A_RawFunction $rawFunction;
            {
                this.$rawFunction = $rawFunction;
                super(1);
            }

            @NotNull
            public final A_Type invoke(@NotNull List<? extends A_Type> restrictedArgTypes) {
                Intrinsics.checkNotNullParameter(restrictedArgTypes, (String)"restrictedArgTypes");
                return P_BitwiseAnd.INSTANCE.returnTypeGuaranteedByVM(this.$rawFunction, restrictedArgTypes);
            }
        }), (Function1<? super L1Translator, Unit>)((Function1)new Function1<L1Translator, Unit>(rawFunction2, arguments, argumentTypes, translator, callSiteHelper){
            final /* synthetic */ A_RawFunction $rawFunction;
            final /* synthetic */ List<L2ReadBoxedOperand> $arguments;
            final /* synthetic */ List<A_Type> $argumentTypes;
            final /* synthetic */ L1Translator $translator;
            final /* synthetic */ L1Translator.CallSiteHelper $callSiteHelper;
            {
                this.$rawFunction = $rawFunction;
                this.$arguments = $arguments;
                this.$argumentTypes = $argumentTypes;
                this.$translator = $translator;
                this.$callSiteHelper = $callSiteHelper;
                super(1);
            }

            public final void invoke(@NotNull L1Translator $this$generateBinaryIntOperation) {
                Intrinsics.checkNotNullParameter((Object)$this$generateBinaryIntOperation, (String)"$this$generateBinaryIntOperation");
                P_BitwiseAnd.INSTANCE.tryToGenerateGeneralPrimitiveInvocation(this.$rawFunction, this.$arguments, this.$argumentTypes, this.$translator, this.$callSiteHelper);
            }
        }));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(IntegerRangeTypeDescriptor.Companion.getIntegers(), IntegerRangeTypeDescriptor.Companion.getIntegers()), IntegerRangeTypeDescriptor.Companion.getIntegers(), null, 4, null);
    }
}

