/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.maps;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.maps.A_Map;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.MapTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014J\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lavail/interpreter/primitive/maps/P_MapAtKey;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "avail"})
public final class P_MapAtKey
extends Primitive {
    @NotNull
    public static final P_MapAtKey INSTANCE = new P_MapAtKey();

    private P_MapAtKey() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject map = interpreter.argument(0);
        AvailObject key = interpreter.argument(1);
        AvailObject availObject = A_Map.Companion.mapAtOrNull(map, key);
        if (availObject != null) {
            AvailObject it = availObject;
            boolean bl = false;
            return interpreter.primitiveSuccess(it);
        }
        return interpreter.primitiveFailure(AvailErrorCode.E_KEY_NOT_FOUND);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(MapTypeDescriptor.Companion.mostGeneralMapType(), PrimitiveTypeDescriptor.Types.ANY.getO()), PrimitiveTypeDescriptor.Types.ANY.getO(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type mapType = argumentTypes.get(0);
        A_Type keyType = argumentTypes.get(1);
        if (mapType.isEnumeration() && keyType.isEnumeration()) {
            A_Set values = null;
            values = SetDescriptor.Companion.getEmptySet();
            A_Set keyTypeInstances = A_Type.Companion.getInstances(keyType);
            for (AvailObject mapInstance : A_Type.Companion.getInstances(mapType)) {
                for (AvailObject keyInstance : keyTypeInstances) {
                    AvailObject value;
                    if (A_Map.Companion.mapAtOrNull(mapInstance, keyInstance) == null) continue;
                    boolean bl = false;
                    values = A_Set.Companion.setWithElementCanDestroy(values, value, true);
                }
            }
            return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(values);
        }
        return A_Type.Companion.getValueType(mapType);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_KEY_NOT_FOUND};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

