/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer;

import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2ReadOperand;
import avail.interpreter.levelTwo.operand.L2WriteOperand;
import avail.interpreter.levelTwo.operation.L2_PHI_PSEUDO_OPERATION;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2ControlFlowGraph;
import avail.utility.Graph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0014J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lavail/optimizer/L2RegisterColorer;", "", "controlFlowGraph", "Lavail/optimizer/L2ControlFlowGraph;", "(Lavail/optimizer/L2ControlFlowGraph;)V", "allRegisters", "", "Lavail/interpreter/levelTwo/register/L2Register;", "blocksToTrace", "Ljava/util/Deque;", "Lavail/optimizer/L2BasicBlock;", "interferences", "Lavail/utility/Graph;", "Lavail/optimizer/L2RegisterColorer$RegisterGroup;", "reachedBlocks", "", "registerBeingTraced", "registerGroups", "", "coalesceNoninterferingMoves", "", "computeColors", "computeInterferenceGraph", "processLiveInAtStatement", "block", "statementIndex", "", "toString", "", "RegisterGroup", "avail"})
public final class L2RegisterColorer {
    @NotNull
    private final List<L2Register> allRegisters;
    @Nullable
    private L2Register registerBeingTraced;
    @NotNull
    private final Map<L2Register, RegisterGroup> registerGroups;
    @NotNull
    private final Set<L2BasicBlock> reachedBlocks;
    @NotNull
    private final Deque<L2BasicBlock> blocksToTrace;
    @NotNull
    private final Graph<RegisterGroup> interferences;

    public L2RegisterColorer(@NotNull L2ControlFlowGraph controlFlowGraph) {
        Intrinsics.checkNotNullParameter((Object)controlFlowGraph, (String)"controlFlowGraph");
        this.allRegisters = controlFlowGraph.allRegisters();
        this.registerGroups = new LinkedHashMap();
        this.reachedBlocks = new LinkedHashSet();
        this.blocksToTrace = new ArrayDeque();
        this.interferences = new Graph();
        Iterable $this$forEach$iv = this.allRegisters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            L2Register it = (L2Register)element$iv;
            boolean bl = false;
            RegisterGroup singleton2 = new RegisterGroup();
            singleton2.getRegisters().add(it);
            this.registerGroups.put(it, singleton2);
            this.interferences.addVertex(singleton2);
        }
    }

    public final void computeInterferenceGraph() {
        Iterator<L2Register> iterator2 = this.allRegisters.iterator();
        while (iterator2.hasNext()) {
            L2Register reg;
            this.registerBeingTraced = reg = iterator2.next();
            for (L2ReadOperand<?> read2 : reg.uses()) {
                L2Instruction instruction2 = read2.getInstruction();
                if (instruction2.getOperation().isPhi()) {
                    L2Operation $this$cast$iv = instruction2.getOperation();
                    boolean $i$f$cast = false;
                    L2_PHI_PSEUDO_OPERATION phiOperation = (L2_PHI_PSEUDO_OPERATION)$this$cast$iv;
                    for (L2BasicBlock predBlock : phiOperation.predecessorBlocksForUseOf(instruction2, reg)) {
                        if (!this.reachedBlocks.add(predBlock)) continue;
                        this.blocksToTrace.add(predBlock);
                    }
                } else {
                    this.processLiveInAtStatement(instruction2.basicBlock(), instruction2.basicBlock().instructions().indexOf(instruction2));
                }
                while (!this.blocksToTrace.isEmpty()) {
                    L2BasicBlock blockToTrace = this.blocksToTrace.removeLast();
                    Intrinsics.checkNotNullExpressionValue((Object)blockToTrace, (String)"blockToTrace");
                    this.processLiveInAtStatement(blockToTrace, blockToTrace.instructions().size());
                }
            }
            this.reachedBlocks.clear();
        }
        this.registerBeingTraced = null;
    }

    private final void processLiveInAtStatement(L2BasicBlock block, int statementIndex) {
        boolean bl;
        boolean bl2 = bl = this.registerBeingTraced != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        List<L2Instruction> instructions2 = block.instructions();
        for (int index2 = statementIndex - 1; -1 < index2; --index2) {
            L2Instruction instruction2 = instructions2.get(index2);
            boolean definesCurrentRegister = false;
            for (L2Register written : instruction2.getDestinationRegisters()) {
                RegisterGroup group2;
                RegisterGroup group1;
                if (written == this.registerBeingTraced) {
                    definesCurrentRegister = true;
                    continue;
                }
                RegisterGroup registerGroup = this.registerGroups.get(this.registerBeingTraced);
                Intrinsics.checkNotNull((Object)registerGroup);
                if (registerGroup.getRegisters().contains(written)) continue;
                L2Register l2Register = this.registerBeingTraced;
                Intrinsics.checkNotNull((Object)l2Register);
                if (l2Register.getRegisterKind() != written.getRegisterKind() || instruction2.getOperation().isMove() && instruction2.getSourceRegisters().get(0) == this.registerBeingTraced) continue;
                Intrinsics.checkNotNull((Object)this.registerGroups.get(this.registerBeingTraced));
                Intrinsics.checkNotNull((Object)this.registerGroups.get(written));
                this.interferences.includeEdge(group1, group2);
                this.interferences.includeEdge(group2, group1);
            }
            if (!definesCurrentRegister) continue;
            return;
        }
        Iterable $this$forEach$iv = block.predecessorEdges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            L2PcOperand sourceEdge = (L2PcOperand)element$iv;
            boolean bl3 = false;
            L2BasicBlock sourceBlock = sourceEdge.sourceBlock();
            if (!this.reachedBlocks.add(sourceBlock)) continue;
            this.blocksToTrace.add(sourceBlock);
        }
    }

    public final void coalesceNoninterferingMoves() {
        for (L2Register reg : this.allRegisters) {
            for (L2WriteOperand<?> write2 : reg.definitions()) {
                RegisterGroup group2;
                RegisterGroup group1;
                L2Instruction instruction2 = write2.getInstruction();
                if (!instruction2.getOperation().isMove() || (group1 = this.registerGroups.get(reg)) == (group2 = this.registerGroups.get(instruction2.getSourceRegisters().get(0)))) continue;
                RegisterGroup registerGroup = group1;
                Intrinsics.checkNotNull((Object)registerGroup);
                RegisterGroup registerGroup2 = group2;
                Intrinsics.checkNotNull((Object)registerGroup2);
                if (this.interferences.includesEdge(registerGroup, registerGroup2)) continue;
                RegisterGroup smallSet = null;
                RegisterGroup largeSet = null;
                if (group1.getRegisters().size() < group2.getRegisters().size()) {
                    smallSet = group1;
                    largeSet = group2;
                } else {
                    smallSet = group2;
                    largeSet = group1;
                }
                for (RegisterGroup neighborOfSmall : this.interferences.successorsOf(smallSet)) {
                    boolean bl;
                    boolean bl2 = bl = neighborOfSmall != largeSet;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    this.interferences.includeEdge(largeSet, neighborOfSmall);
                    this.interferences.includeEdge(neighborOfSmall, largeSet);
                }
                this.interferences.exciseVertex(smallSet);
                Iterator<Object> iterator2 = smallSet.getRegisters().iterator();
                while (iterator2.hasNext()) {
                    L2Register r;
                    L2Register l2Register = r = (L2Register)iterator2.next();
                    Intrinsics.checkNotNull((Object)l2Register);
                    this.registerGroups.put(l2Register, largeSet);
                }
                largeSet.getRegisters().addAll((Collection<L2Register>)smallSet.getRegisters());
            }
        }
    }

    public final void computeColors() {
        Deque stack = new ArrayDeque(this.allRegisters.size());
        Graph<RegisterGroup> graphCopy = new Graph<RegisterGroup>(this.interferences);
        while (!graphCopy.isEmpty()) {
            int fewestCount = Integer.MAX_VALUE;
            List withFewest = new ArrayList();
            for (RegisterGroup reg : graphCopy.getVertices()) {
                int neighborCount = graphCopy.successorsOf(reg).size();
                if (neighborCount < fewestCount) {
                    fewestCount = neighborCount;
                    withFewest.clear();
                }
                if (fewestCount != neighborCount) continue;
                withFewest.add(reg);
            }
            stack.addAll(withFewest);
            for (RegisterGroup registerGroup : withFewest) {
                graphCopy.exciseVertex(registerGroup);
            }
        }
        BitSet neighbors = new BitSet();
        while (!stack.isEmpty()) {
            Object e = stack.removeLast();
            Intrinsics.checkNotNull(e);
            RegisterGroup group = (RegisterGroup)e;
            neighbors.clear();
            for (RegisterGroup registerGroup : this.interferences.successorsOf(group)) {
                int index2 = registerGroup.getFinalIndex();
                if (index2 == -1) continue;
                neighbors.set(index2);
            }
            int color = neighbors.nextClearBit(0);
            group.setFinalIndex(color);
        }
        for (L2Register register : this.registerGroups.keySet()) {
            boolean bl;
            boolean bl2 = bl = register.finalIndex() != -1;
            if (!_Assertions.ENABLED || bl) continue;
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u242.append("Colorer:\n\tGroups:");
        Collection groups = CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)this.registerGroups.values()));
        Iterable $this$forEach$iv = groups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegisterGroup it = (RegisterGroup)element$iv;
            boolean bl2 = false;
            $this$toString_u24lambda_u242.append("\n\t\t");
            $this$toString_u24lambda_u242.append(it);
        }
        $this$toString_u24lambda_u242.append("\n\tInterferences:");
        for (RegisterGroup group : this.interferences.getVertices()) {
            Set<RegisterGroup> neighbors = this.interferences.successorsOf(group);
            if (!(!((Collection)neighbors).isEmpty())) continue;
            $this$toString_u24lambda_u242.append("\n\t\t");
            $this$toString_u24lambda_u242.append(group);
            $this$toString_u24lambda_u242.append(" \u2260 ");
            $this$toString_u24lambda_u242.append(neighbors);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lavail/optimizer/L2RegisterColorer$RegisterGroup;", "", "()V", "value", "", "finalIndex", "getFinalIndex", "()I", "setFinalIndex", "(I)V", "registers", "", "Lavail/interpreter/levelTwo/register/L2Register;", "getRegisters", "()Ljava/util/Set;", "toString", "", "avail"})
    public static final class RegisterGroup {
        @NotNull
        private final Set<L2Register> registers = new LinkedHashSet();
        private int finalIndex = -1;

        @NotNull
        public final Set<L2Register> getRegisters() {
            return this.registers;
        }

        public final int getFinalIndex() {
            return this.finalIndex;
        }

        public final void setFinalIndex(int value) {
            this.finalIndex = value;
            Iterable $this$forEach$iv = this.registers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2Register it = (L2Register)element$iv;
                boolean bl = false;
                L2Register l2Register = it;
                Intrinsics.checkNotNull((Object)l2Register);
                l2Register.setFinalIndex(value);
            }
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u241.append("RegisterGroup: ");
            $this$toString_u24lambda_u241.append(CollectionsKt.joinToString$default((Iterable)this.registers, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null));
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }
    }
}

