/*
 * Decompiled with CFR 0.152.
 */
package avail.performance;

import avail.performance.PerInterpreterStatistic;
import avail.performance.ReportingUnit;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import avail.utility.Strings;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0086\u0001\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001+B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tJ\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170\u00160\bR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*\u00a8\u0006,"}, d2={"Lavail/performance/StatisticReport;", "", "title", "", "unit", "Lavail/performance/ReportingUnit;", "(Ljava/lang/String;ILjava/lang/String;Lavail/performance/ReportingUnit;)V", "statistics", "", "Lavail/performance/Statistic;", "getStatistics$avail", "()Ljava/util/List;", "getTitle", "()Ljava/lang/String;", "getUnit", "()Lavail/performance/ReportingUnit;", "clear", "", "registerStatistic", "", "statistic", "sortedPairs", "Lkotlin/Pair;", "Lavail/performance/PerInterpreterStatistic;", "RUNNING_PARSING_INSTRUCTIONS", "TYPE_CHECKING_FOR_PARSER", "EXPANDING_PARSING_INSTRUCTIONS", "L2_OPTIMIZATION_TIME", "L1_NAIVE_TRANSLATION_TIME", "L2_TRANSLATION_VALUES", "FINAL_JVM_TRANSLATION_TIME", "REIFICATIONS", "PRIMITIVES", "DYNAMIC_LOOKUP", "PRIMITIVE_RETURNER_TYPE_CHECKS", "NON_PRIMITIVE_RETURNER_TYPE_CHECKS", "NON_PRIMITIVE_RETURNEE_TYPE_CHECKS", "TOP_LEVEL_STATEMENTS", "WORKBENCH_TRANSCRIPT", "SERIALIZE_TRACE", "SERIALIZE_WRITE", "DESERIALIZE", "ALLOCATIONS_BY_DESCRIPTOR_CLASS", "Companion", "avail"})
public final class StatisticReport
extends Enum<StatisticReport> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String title;
    @NotNull
    private final ReportingUnit unit;
    @NotNull
    private final List<Statistic> statistics;
    public static final /* enum */ StatisticReport RUNNING_PARSING_INSTRUCTIONS;
    public static final /* enum */ StatisticReport TYPE_CHECKING_FOR_PARSER;
    public static final /* enum */ StatisticReport EXPANDING_PARSING_INSTRUCTIONS;
    public static final /* enum */ StatisticReport L2_OPTIMIZATION_TIME;
    public static final /* enum */ StatisticReport L1_NAIVE_TRANSLATION_TIME;
    public static final /* enum */ StatisticReport L2_TRANSLATION_VALUES;
    public static final /* enum */ StatisticReport FINAL_JVM_TRANSLATION_TIME;
    public static final /* enum */ StatisticReport REIFICATIONS;
    public static final /* enum */ StatisticReport PRIMITIVES;
    public static final /* enum */ StatisticReport DYNAMIC_LOOKUP;
    public static final /* enum */ StatisticReport PRIMITIVE_RETURNER_TYPE_CHECKS;
    public static final /* enum */ StatisticReport NON_PRIMITIVE_RETURNER_TYPE_CHECKS;
    public static final /* enum */ StatisticReport NON_PRIMITIVE_RETURNEE_TYPE_CHECKS;
    public static final /* enum */ StatisticReport TOP_LEVEL_STATEMENTS;
    public static final /* enum */ StatisticReport WORKBENCH_TRANSCRIPT;
    public static final /* enum */ StatisticReport SERIALIZE_TRACE;
    public static final /* enum */ StatisticReport SERIALIZE_WRITE;
    public static final /* enum */ StatisticReport DESERIALIZE;
    public static final /* enum */ StatisticReport ALLOCATIONS_BY_DESCRIPTOR_CLASS;
    private static final /* synthetic */ StatisticReport[] $VALUES;

    private StatisticReport(String title, ReportingUnit unit) {
        this.title = title;
        this.unit = unit;
        this.statistics = new ArrayList();
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final ReportingUnit getUnit() {
        return this.unit;
    }

    @NotNull
    public final List<Statistic> getStatistics$avail() {
        return this.statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean registerStatistic(@NotNull Statistic statistic) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)statistic, (String)"statistic");
        List<Statistic> list2 = this.statistics;
        synchronized (list2) {
            boolean bl2 = false;
            bl = this.statistics.add(statistic);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        List<Statistic> list2 = this.statistics;
        synchronized (list2) {
            boolean bl = false;
            Iterable $this$forEach$iv = this.statistics;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Statistic it = (Statistic)element$iv;
                boolean bl2 = false;
                it.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<String, PerInterpreterStatistic>> sortedPairs() {
        List<Statistic> list2 = this.statistics;
        synchronized (list2) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.statistics;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Statistic statistic = (Statistic)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(TuplesKt.to((Object)it.name(), (Object)it.aggregate()));
            }
            List namedSnapshots = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            namedSnapshots.removeIf(arg_0 -> StatisticReport.sortedPairs$lambda$6$lambda$4(sortedPairs.1.1.INSTANCE, arg_0));
            Collator collator = Collator.getInstance();
            CollectionsKt.sortWith((List)namedSnapshots, (arg_0, arg_1) -> StatisticReport.sortedPairs$lambda$6$lambda$5((Function2)new Function2<Pair<? extends String, ? extends PerInterpreterStatistic>, Pair<? extends String, ? extends PerInterpreterStatistic>, Integer>(collator){
                final /* synthetic */ Collator $collator;
                {
                    this.$collator = $collator;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Integer invoke(Pair<String, PerInterpreterStatistic> pair, Pair<String, PerInterpreterStatistic> pair2) {
                    int n;
                    void $this$ifZero$iv;
                    String name1 = (String)pair.component1();
                    PerInterpreterStatistic aggregate1 = (PerInterpreterStatistic)pair.component2();
                    String name2 = (String)pair2.component1();
                    PerInterpreterStatistic aggregate2 = (PerInterpreterStatistic)pair2.component2();
                    int n2 = aggregate1.compareTo(aggregate2);
                    Collator collator = this.$collator;
                    boolean $i$f$ifZero = false;
                    if ($this$ifZero$iv != false) {
                        n = $this$ifZero$iv;
                    } else {
                        boolean bl = false;
                        n = collator.compare(name1, name2);
                    }
                    return n;
                }
            }, arg_0, arg_1));
            List list3 = namedSnapshots;
            return list3;
        }
    }

    public static StatisticReport[] values() {
        return (StatisticReport[])$VALUES.clone();
    }

    public static StatisticReport valueOf(String value) {
        return Enum.valueOf(StatisticReport.class, value);
    }

    private static final boolean sortedPairs$lambda$6$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int sortedPairs$lambda$6$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    static {
        RUNNING_PARSING_INSTRUCTIONS = new StatisticReport("Running Parsing Operations", ReportingUnit.NANOSECONDS);
        TYPE_CHECKING_FOR_PARSER = new StatisticReport("Parser Type Check", ReportingUnit.NANOSECONDS);
        EXPANDING_PARSING_INSTRUCTIONS = new StatisticReport("Expanding Parsing Operations", ReportingUnit.NANOSECONDS);
        L2_OPTIMIZATION_TIME = new StatisticReport("L2 Translation time", ReportingUnit.NANOSECONDS);
        L1_NAIVE_TRANSLATION_TIME = new StatisticReport("L1 -> L2 Naive translation by nybblecode", ReportingUnit.NANOSECONDS);
        L2_TRANSLATION_VALUES = new StatisticReport("L2 Translation values", ReportingUnit.DIMENSIONLESS_INTEGRAL);
        FINAL_JVM_TRANSLATION_TIME = new StatisticReport("Final JVM Translation time", ReportingUnit.NANOSECONDS);
        REIFICATIONS = new StatisticReport("Java stack reifications", ReportingUnit.NANOSECONDS);
        PRIMITIVES = new StatisticReport("Primitives", ReportingUnit.NANOSECONDS);
        DYNAMIC_LOOKUP = new StatisticReport("Dynamic Lookup", ReportingUnit.NANOSECONDS);
        PRIMITIVE_RETURNER_TYPE_CHECKS = new StatisticReport("Primitive Return Type Checks", ReportingUnit.NANOSECONDS);
        NON_PRIMITIVE_RETURNER_TYPE_CHECKS = new StatisticReport("Non-primitive Returner Type Checks", ReportingUnit.NANOSECONDS);
        NON_PRIMITIVE_RETURNEE_TYPE_CHECKS = new StatisticReport("Non-primitive Returnee Type Checks", ReportingUnit.NANOSECONDS);
        TOP_LEVEL_STATEMENTS = new StatisticReport("Top Level Statements By Module (CPU time)", ReportingUnit.NANOSECONDS);
        WORKBENCH_TRANSCRIPT = new StatisticReport("Workbench transcript", ReportingUnit.NANOSECONDS);
        SERIALIZE_TRACE = new StatisticReport("Serialization tracing", ReportingUnit.NANOSECONDS);
        SERIALIZE_WRITE = new StatisticReport("Serialization writing", ReportingUnit.NANOSECONDS);
        DESERIALIZE = new StatisticReport("Deserialization", ReportingUnit.NANOSECONDS);
        ALLOCATIONS_BY_DESCRIPTOR_CLASS = new StatisticReport("Allocations by initial descriptor", ReportingUnit.BYTES);
        $VALUES = statisticReportArray = new StatisticReport[]{StatisticReport.RUNNING_PARSING_INSTRUCTIONS, StatisticReport.TYPE_CHECKING_FOR_PARSER, StatisticReport.EXPANDING_PARSING_INSTRUCTIONS, StatisticReport.L2_OPTIMIZATION_TIME, StatisticReport.L1_NAIVE_TRANSLATION_TIME, StatisticReport.L2_TRANSLATION_VALUES, StatisticReport.FINAL_JVM_TRANSLATION_TIME, StatisticReport.REIFICATIONS, StatisticReport.PRIMITIVES, StatisticReport.DYNAMIC_LOOKUP, StatisticReport.PRIMITIVE_RETURNER_TYPE_CHECKS, StatisticReport.NON_PRIMITIVE_RETURNER_TYPE_CHECKS, StatisticReport.NON_PRIMITIVE_RETURNEE_TYPE_CHECKS, StatisticReport.TOP_LEVEL_STATEMENTS, StatisticReport.WORKBENCH_TRANSCRIPT, StatisticReport.SERIALIZE_TRACE, StatisticReport.SERIALIZE_WRITE, StatisticReport.DESERIALIZE, StatisticReport.ALLOCATIONS_BY_DESCRIPTOR_CLASS};
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lavail/performance/StatisticReport$Companion;", "", "()V", "produceReports", "", "reports", "Ljava/util/EnumSet;", "Lavail/performance/StatisticReport;", "reportFor", "str", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final StatisticReport reportFor(@NotNull String str) {
            StatisticReport statisticReport;
            block1: {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                StatisticReport[] $this$firstOrNull$iv = StatisticReport.values();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int j = 0; j < n; ++j) {
                    StatisticReport element$iv;
                    StatisticReport it = element$iv = $this$firstOrNull$iv[j];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getTitle(), (Object)str)) continue;
                    statisticReport = element$iv;
                    break block1;
                }
                statisticReport = null;
            }
            return statisticReport;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String produceReports(@NotNull EnumSet<StatisticReport> reports) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(reports, (String)"reports");
            StringBuilder $this$produceReports_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = reports;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void report2;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                StatisticReport statisticReport = (StatisticReport)((Object)item$iv);
                int index2 = n;
                boolean bl2 = false;
                String reportText2 = Strings.buildUnicodeBox$default(Strings.INSTANCE, report2.getTitle(), 0, (Function1)new Function1<StringBuilder, Unit>((StatisticReport)report2){
                    final /* synthetic */ StatisticReport $report;
                    {
                        this.$report = $report;
                        super(1);
                    }

                    public final void invoke(@NotNull StringBuilder $this$buildUnicodeBox) {
                        Intrinsics.checkNotNullParameter((Object)$this$buildUnicodeBox, (String)"$this$buildUnicodeBox");
                        List<Pair<String, PerInterpreterStatistic>> pairs = this.$report.sortedPairs();
                        if (!((Collection)pairs).isEmpty()) {
                            PerInterpreterStatistic total = new PerInterpreterStatistic(null, 0L, 0.0, 0.0, 0.0, 0.0, 63, null);
                            Iterable $this$forEach$iv = pairs;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                Pair pair = (Pair)element$iv;
                                boolean bl = false;
                                PerInterpreterStatistic stat = (PerInterpreterStatistic)pair.component2();
                                stat.addTo$avail(total);
                            }
                            pairs.add(0, (Pair<String, PerInterpreterStatistic>)TuplesKt.to((Object)"TOTAL", (Object)total));
                            $this$forEach$iv = pairs;
                            StatisticReport statisticReport = this.$report;
                            boolean $i$f$forEach2 = false;
                            for (T element$iv : $this$forEach$iv) {
                                Pair pair = (Pair)element$iv;
                                boolean bl = false;
                                String name = (String)pair.component1();
                                PerInterpreterStatistic stat = (PerInterpreterStatistic)pair.component2();
                                stat.describeOn($this$buildUnicodeBox, statisticReport.getUnit());
                                $this$buildUnicodeBox.append(" " + name + "\n");
                            }
                        }
                    }
                }, 2, null);
                $this$produceReports_u24lambda_u242.append(reportText2);
                if (index2 == reports.size() - 1) continue;
                $this$produceReports_u24lambda_u242.append("\n");
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

