/*
 * Decompiled with CFR 0.152.
 */
package avail.serialization;

import avail.descriptor.character.CharacterDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ByteStringDescriptor;
import avail.descriptor.tuples.ByteTupleDescriptor;
import avail.descriptor.tuples.IntTupleDescriptor;
import avail.descriptor.tuples.NybbleTupleDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.tuples.TwoByteStringDescriptor;
import avail.serialization.AbstractDeserializer;
import avail.serialization.DeserializerDescriber;
import avail.serialization.Serializer;
import avail.serialization.SerializerOperand;
import avail.utility.Strings;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0080\u0001\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH \u00a2\u0006\u0002\b\u0010J\u001d\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0010\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H \u00a2\u0006\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&\u00a8\u0006("}, d2={"Lavail/serialization/SerializerOperandEncoding;", "", "(Ljava/lang/String;I)V", "describe", "", "describer", "Lavail/serialization/DeserializerDescriber;", "describe$avail", "named", "Lavail/serialization/SerializerOperand;", "roleName", "", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "trace", "obj", "serializer", "Lavail/serialization/Serializer;", "trace$avail", "write", "write$avail", "BYTE", "COMPRESSED_SHORT", "UNCOMPRESSED_SHORT", "SIGNED_INT", "UNSIGNED_INT", "OBJECT_REFERENCE", "BIG_INTEGER_DATA", "TUPLE_OF_OBJECTS", "BYTE_CHARACTER_TUPLE", "COMPRESSED_SHORT_CHARACTER_TUPLE", "COMPRESSED_ARBITRARY_CHARACTER_TUPLE", "COMPRESSED_INT_TUPLE", "UNCOMPRESSED_BYTE_TUPLE", "UNCOMPRESSED_NYBBLE_TUPLE", "GENERAL_MAP", "Companion", "avail"})
public abstract class SerializerOperandEncoding
extends Enum<SerializerOperandEncoding> {
    @NotNull
    public static final Companion Companion;
    public static final /* enum */ SerializerOperandEncoding BYTE;
    public static final /* enum */ SerializerOperandEncoding COMPRESSED_SHORT;
    public static final /* enum */ SerializerOperandEncoding UNCOMPRESSED_SHORT;
    public static final /* enum */ SerializerOperandEncoding SIGNED_INT;
    public static final /* enum */ SerializerOperandEncoding UNSIGNED_INT;
    public static final /* enum */ SerializerOperandEncoding OBJECT_REFERENCE;
    public static final /* enum */ SerializerOperandEncoding BIG_INTEGER_DATA;
    public static final /* enum */ SerializerOperandEncoding TUPLE_OF_OBJECTS;
    public static final /* enum */ SerializerOperandEncoding BYTE_CHARACTER_TUPLE;
    public static final /* enum */ SerializerOperandEncoding COMPRESSED_SHORT_CHARACTER_TUPLE;
    public static final /* enum */ SerializerOperandEncoding COMPRESSED_ARBITRARY_CHARACTER_TUPLE;
    public static final /* enum */ SerializerOperandEncoding COMPRESSED_INT_TUPLE;
    public static final /* enum */ SerializerOperandEncoding UNCOMPRESSED_BYTE_TUPLE;
    public static final /* enum */ SerializerOperandEncoding UNCOMPRESSED_NYBBLE_TUPLE;
    public static final /* enum */ SerializerOperandEncoding GENERAL_MAP;
    private static final /* synthetic */ SerializerOperandEncoding[] $VALUES;

    private SerializerOperandEncoding() {
    }

    public void trace$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
    }

    public abstract void write$avail(@NotNull AvailObject var1, @NotNull Serializer var2);

    @NotNull
    public abstract AvailObject read$avail(@NotNull AbstractDeserializer var1);

    public void describe$avail(@NotNull DeserializerDescriber describer) {
        Intrinsics.checkNotNullParameter((Object)describer, (String)"describer");
        AvailObject value = this.read$avail(describer);
        describer.append$avail(Strings.INSTANCE.increaseIndentation(value.toString(), 1));
    }

    @NotNull
    public final SerializerOperand named(@NotNull String roleName) {
        Intrinsics.checkNotNullParameter((Object)roleName, (String)"roleName");
        return new SerializerOperand(this, roleName);
    }

    public static SerializerOperandEncoding[] values() {
        return (SerializerOperandEncoding[])$VALUES.clone();
    }

    public static SerializerOperandEncoding valueOf(String value) {
        return Enum.valueOf(SerializerOperandEncoding.class, value);
    }

    public /* synthetic */ SerializerOperandEncoding(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        BYTE = new BYTE("BYTE", 0);
        COMPRESSED_SHORT = new COMPRESSED_SHORT("COMPRESSED_SHORT", 1);
        UNCOMPRESSED_SHORT = new UNCOMPRESSED_SHORT("UNCOMPRESSED_SHORT", 2);
        SIGNED_INT = new SIGNED_INT("SIGNED_INT", 3);
        UNSIGNED_INT = new UNSIGNED_INT("UNSIGNED_INT", 4);
        OBJECT_REFERENCE = new OBJECT_REFERENCE("OBJECT_REFERENCE", 5);
        BIG_INTEGER_DATA = new BIG_INTEGER_DATA("BIG_INTEGER_DATA", 6);
        TUPLE_OF_OBJECTS = new TUPLE_OF_OBJECTS("TUPLE_OF_OBJECTS", 7);
        BYTE_CHARACTER_TUPLE = new BYTE_CHARACTER_TUPLE("BYTE_CHARACTER_TUPLE", 8);
        COMPRESSED_SHORT_CHARACTER_TUPLE = new COMPRESSED_SHORT_CHARACTER_TUPLE("COMPRESSED_SHORT_CHARACTER_TUPLE", 9);
        COMPRESSED_ARBITRARY_CHARACTER_TUPLE = new COMPRESSED_ARBITRARY_CHARACTER_TUPLE("COMPRESSED_ARBITRARY_CHARACTER_TUPLE", 10);
        COMPRESSED_INT_TUPLE = new COMPRESSED_INT_TUPLE("COMPRESSED_INT_TUPLE", 11);
        UNCOMPRESSED_BYTE_TUPLE = new UNCOMPRESSED_BYTE_TUPLE("UNCOMPRESSED_BYTE_TUPLE", 12);
        UNCOMPRESSED_NYBBLE_TUPLE = new UNCOMPRESSED_NYBBLE_TUPLE("UNCOMPRESSED_NYBBLE_TUPLE", 13);
        GENERAL_MAP = new GENERAL_MAP("GENERAL_MAP", 14);
        $VALUES = serializerOperandEncodingArray = new SerializerOperandEncoding[]{SerializerOperandEncoding.BYTE, SerializerOperandEncoding.COMPRESSED_SHORT, SerializerOperandEncoding.UNCOMPRESSED_SHORT, SerializerOperandEncoding.SIGNED_INT, SerializerOperandEncoding.UNSIGNED_INT, SerializerOperandEncoding.OBJECT_REFERENCE, SerializerOperandEncoding.BIG_INTEGER_DATA, SerializerOperandEncoding.TUPLE_OF_OBJECTS, SerializerOperandEncoding.BYTE_CHARACTER_TUPLE, SerializerOperandEncoding.COMPRESSED_SHORT_CHARACTER_TUPLE, SerializerOperandEncoding.COMPRESSED_ARBITRARY_CHARACTER_TUPLE, SerializerOperandEncoding.COMPRESSED_INT_TUPLE, SerializerOperandEncoding.UNCOMPRESSED_BYTE_TUPLE, SerializerOperandEncoding.UNCOMPRESSED_NYBBLE_TUPLE, SerializerOperandEncoding.GENERAL_MAP};
        Companion = new Companion(null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J%\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lavail/serialization/SerializerOperandEncoding$Companion;", "", "()V", "readCompressedPositiveInt", "", "deserializer", "Lavail/serialization/AbstractDeserializer;", "readCompressedULong", "Lkotlin/ULong;", "readCompressedULong-I7RO_PI", "(Lavail/serialization/AbstractDeserializer;)J", "writeCompressedPositiveInt", "", "value", "serializer", "Lavail/serialization/Serializer;", "writeCompressedPositiveInt$avail", "writeCompressedULong", "writeCompressedULong-4PLdz1A", "(JLavail/serialization/Serializer;)V", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public final void writeCompressedPositiveInt$avail(int value, @NotNull Serializer serializer) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            boolean bl2 = bl = value >= 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.writeCompressedULong-4PLdz1A(ULong.constructor-impl((long)value), serializer);
        }

        private final void writeCompressedULong-4PLdz1A(long value, Serializer serializer) {
            if (Long.compareUnsigned(value, 127L) <= 0) {
                serializer.writeByte$avail((int)value);
            } else if (Long.compareUnsigned(value, 16383L) <= 0) {
                serializer.writeByte$avail(((int)value >> 8) + 128);
                serializer.writeByte$avail((int)value & 0xFF);
            } else if (Long.compareUnsigned(value, 0x3DFFFFL) <= 0) {
                serializer.writeByte$avail(((int)value >> 16) + 192);
                serializer.writeShort$avail((int)value & 0xFFFF);
            } else if (Long.compareUnsigned(value, 0xFFFFFFFFL) <= 0) {
                serializer.writeByte$avail(254);
                serializer.writeInt$avail((int)value);
            } else {
                serializer.writeByte$avail(255);
                serializer.writeInt$avail((int)ULong.constructor-impl((long)(value >>> 32)));
                serializer.writeInt$avail((int)value);
            }
        }

        public final long readCompressedULong-I7RO_PI(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            int firstByte = deserializer2.readByte();
            if (firstByte <= 127) {
                return ULong.constructor-impl((long)firstByte);
            }
            if (firstByte <= 191) {
                return ULong.constructor-impl((long)(ULong.constructor-impl((long)(firstByte - 128 << 8)) + ULong.constructor-impl((long)deserializer2.readByte())));
            }
            if (firstByte <= 253) {
                return ULong.constructor-impl((long)(ULong.constructor-impl((long)(firstByte - 192 << 16)) + ULong.constructor-impl((long)deserializer2.readShort())));
            }
            if (firstByte == 254) {
                return ULong.constructor-impl((long)(ULong.constructor-impl((long)deserializer2.readInt()) & 0xFFFFFFFFL));
            }
            return ULong.constructor-impl((long)(ULong.constructor-impl((long)(ULong.constructor-impl((long)deserializer2.readInt()) << 32)) + ULong.constructor-impl((long)(ULong.constructor-impl((long)deserializer2.readInt()) & 0xFFFFFFFFL))));
        }

        public final int readCompressedPositiveInt(@NotNull AbstractDeserializer deserializer2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            long value = this.readCompressedULong-I7RO_PI(deserializer2);
            boolean bl2 = bl = Long.compareUnsigned(value, Integer.MAX_VALUE) <= 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return (int)value;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/serialization/SerializerOperandEncoding$BYTE;", "Lavail/serialization/SerializerOperandEncoding;", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "write", "", "obj", "serializer", "Lavail/serialization/Serializer;", "write$avail", "avail"})
    static final class BYTE
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        BYTE() {
            void var1_1;
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            serializer.writeByte$avail(A_Number.Companion.getExtractUnsignedByte(obj));
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            return IntegerDescriptor.Companion.fromInt(deserializer2.readByte());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/serialization/SerializerOperandEncoding$COMPRESSED_SHORT;", "Lavail/serialization/SerializerOperandEncoding;", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "write", "", "obj", "serializer", "Lavail/serialization/Serializer;", "write$avail", "avail"})
    static final class COMPRESSED_SHORT
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        COMPRESSED_SHORT() {
            void var1_1;
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            int shortValue = A_Number.Companion.getExtractInt(obj);
            boolean bl2 = bl = (shortValue & 0xFFFF) == shortValue;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (shortValue < 128) {
                serializer.writeByte$avail(shortValue);
            } else if (shortValue < 32512) {
                serializer.writeByte$avail((shortValue >> 8) + 128);
                serializer.writeByte$avail(shortValue & 0xFF);
            } else {
                serializer.writeByte$avail(255);
                serializer.writeShort$avail(shortValue);
            }
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            int firstByte = deserializer2.readByte();
            int intValue = (0 <= firstByte ? firstByte < 128 : false) ? firstByte : ((128 <= firstByte ? firstByte < 255 : false) ? (firstByte - 128 << 8) + deserializer2.readByte() : deserializer2.readShort());
            return IntegerDescriptor.Companion.fromInt(intValue);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/serialization/SerializerOperandEncoding$UNCOMPRESSED_SHORT;", "Lavail/serialization/SerializerOperandEncoding;", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "write", "", "obj", "serializer", "Lavail/serialization/Serializer;", "write$avail", "avail"})
    static final class UNCOMPRESSED_SHORT
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        UNCOMPRESSED_SHORT() {
            void var1_1;
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            serializer.writeShort$avail(A_Number.Companion.getExtractUnsignedShort(obj));
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            return IntegerDescriptor.Companion.fromInt(deserializer2.readShort());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/serialization/SerializerOperandEncoding$SIGNED_INT;", "Lavail/serialization/SerializerOperandEncoding;", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "write", "", "obj", "serializer", "Lavail/serialization/Serializer;", "write$avail", "avail"})
    static final class SIGNED_INT
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        SIGNED_INT() {
            void var1_1;
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            int intValue = A_Number.Companion.getExtractInt(obj);
            serializer.writeInt$avail(intValue);
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            return IntegerDescriptor.Companion.fromInt(deserializer2.readInt());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/serialization/SerializerOperandEncoding$UNSIGNED_INT;", "Lavail/serialization/SerializerOperandEncoding;", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "write", "", "obj", "serializer", "Lavail/serialization/Serializer;", "write$avail", "avail"})
    static final class UNSIGNED_INT
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        UNSIGNED_INT() {
            void var1_1;
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            long longValue = A_Number.Companion.getExtractLong(obj);
            boolean bl2 = bl = (longValue & 0xFFFFFFFFL) == longValue;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            serializer.writeInt$avail((int)longValue);
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            int intValue = deserializer2.readInt();
            long longValue = (long)intValue & 0xFFFFFFFFL;
            return IntegerDescriptor.Companion.fromLong(longValue);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u001d\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010J\u001d\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lavail/serialization/SerializerOperandEncoding$OBJECT_REFERENCE;", "Lavail/serialization/SerializerOperandEncoding;", "describe", "", "describer", "Lavail/serialization/DeserializerDescriber;", "describe$avail", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "trace", "obj", "serializer", "Lavail/serialization/Serializer;", "trace$avail", "write", "write$avail", "avail"})
    static final class OBJECT_REFERENCE
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        OBJECT_REFERENCE() {
            void var1_1;
        }

        @Override
        public void trace$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            serializer.traceOne$avail(obj);
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            Companion.writeCompressedPositiveInt$avail(serializer.compressedObjectIndex$avail(obj), serializer);
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            return deserializer2.fromCompressedObjectIndex$avail(Companion.readCompressedPositiveInt(deserializer2));
        }

        @Override
        public void describe$avail(@NotNull DeserializerDescriber describer) {
            Intrinsics.checkNotNullParameter((Object)describer, (String)"describer");
            int index2 = Companion.readCompressedPositiveInt(describer);
            describer.printCompressedIndex(index2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/serialization/SerializerOperandEncoding$BIG_INTEGER_DATA;", "Lavail/serialization/SerializerOperandEncoding;", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "write", "", "obj", "serializer", "Lavail/serialization/Serializer;", "write$avail", "avail"})
    static final class BIG_INTEGER_DATA
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        BIG_INTEGER_DATA() {
            void var1_1;
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            int slotsCount = IntegerDescriptor.Companion.intCount(obj);
            Companion.writeCompressedPositiveInt$avail(slotsCount, serializer);
            for (int i2 = slotsCount; 0 < i2; --i2) {
                serializer.writeInt$avail(A_Number.Companion.rawSignedIntegerAt(obj, i2));
            }
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            int slotsCount = Companion.readCompressedPositiveInt(deserializer2);
            AvailObject newInteger = IntegerDescriptor.Companion.createUninitializedInteger(slotsCount);
            for (int i2 = slotsCount; 0 < i2; --i2) {
                A_Number.Companion.rawSignedIntegerAtPut(newInteger, i2, deserializer2.readInt());
            }
            newInteger.makeImmutable();
            return newInteger;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u001d\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010J\u001d\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lavail/serialization/SerializerOperandEncoding$TUPLE_OF_OBJECTS;", "Lavail/serialization/SerializerOperandEncoding;", "describe", "", "describer", "Lavail/serialization/DeserializerDescriber;", "describe$avail", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "trace", "obj", "serializer", "Lavail/serialization/Serializer;", "trace$avail", "write", "write$avail", "avail"})
    static final class TUPLE_OF_OBJECTS
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        TUPLE_OF_OBJECTS() {
            void var1_1;
        }

        @Override
        public void trace$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            for (AvailObject element : obj) {
                serializer.traceOne$avail(element);
            }
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            int tupleSize = A_Tuple.Companion.getTupleSize(obj);
            Companion.writeCompressedPositiveInt$avail(tupleSize, serializer);
            for (AvailObject element : obj) {
                Companion.writeCompressedPositiveInt$avail(serializer.compressedObjectIndex$avail(element), serializer);
            }
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            int tupleSize = Companion.readCompressedPositiveInt(deserializer2);
            if (tupleSize == 0) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            AvailObject newTuple2 = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(tupleSize, (Function1<? super Integer, ? extends A_BasicObject>)((Function1)new Function1<Integer, A_BasicObject>(deserializer2){
                final /* synthetic */ AbstractDeserializer $deserializer;
                {
                    this.$deserializer = $deserializer;
                    super(1);
                }

                @NotNull
                public final A_BasicObject invoke(int it) {
                    return this.$deserializer.fromCompressedObjectIndex$avail(SerializerOperandEncoding.Companion.readCompressedPositiveInt(this.$deserializer));
                }
            }));
            newTuple2.makeImmutable();
            return newTuple2;
        }

        @Override
        public void describe$avail(@NotNull DeserializerDescriber describer) {
            Intrinsics.checkNotNullParameter((Object)describer, (String)"describer");
            int tupleSize = Companion.readCompressedPositiveInt(describer);
            describer.append$avail("<");
            int i2 = 1;
            if (i2 <= tupleSize) {
                while (true) {
                    if (i2 > 1) {
                        describer.append$avail(", ");
                    }
                    int objectIndex = Companion.readCompressedPositiveInt(describer);
                    describer.printCompressedIndex(objectIndex);
                    if (i2 == tupleSize) break;
                    ++i2;
                }
            }
            describer.append$avail(">");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/serialization/SerializerOperandEncoding$BYTE_CHARACTER_TUPLE;", "Lavail/serialization/SerializerOperandEncoding;", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "write", "", "obj", "serializer", "Lavail/serialization/Serializer;", "write$avail", "avail"})
    static final class BYTE_CHARACTER_TUPLE
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        BYTE_CHARACTER_TUPLE() {
            void var1_1;
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            int tupleSize = A_Tuple.Companion.getTupleSize(obj);
            Companion.writeCompressedPositiveInt$avail(tupleSize, serializer);
            int i2 = 1;
            if (i2 <= tupleSize) {
                while (true) {
                    serializer.writeByte$avail(A_Tuple.Companion.tupleCodePointAt(obj, i2));
                    if (i2 == tupleSize) break;
                    ++i2;
                }
            }
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            int tupleSize = Companion.readCompressedPositiveInt(deserializer2);
            if (tupleSize == 0) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            return ByteStringDescriptor.Companion.generateByteString(tupleSize, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(deserializer2){
                final /* synthetic */ AbstractDeserializer $deserializer;
                {
                    this.$deserializer = $deserializer;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int it) {
                    return this.$deserializer.readByte();
                }
            }));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/serialization/SerializerOperandEncoding$COMPRESSED_SHORT_CHARACTER_TUPLE;", "Lavail/serialization/SerializerOperandEncoding;", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "write", "", "obj", "serializer", "Lavail/serialization/Serializer;", "write$avail", "avail"})
    static final class COMPRESSED_SHORT_CHARACTER_TUPLE
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        COMPRESSED_SHORT_CHARACTER_TUPLE() {
            void var1_1;
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            int tupleSize = A_Tuple.Companion.getTupleSize(obj);
            Companion.writeCompressedPositiveInt$avail(tupleSize, serializer);
            int i2 = 1;
            if (i2 <= tupleSize) {
                while (true) {
                    Companion.writeCompressedPositiveInt$avail(A_Tuple.Companion.tupleCodePointAt(obj, i2), serializer);
                    if (i2 == tupleSize) break;
                    ++i2;
                }
            }
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            int tupleSize = Companion.readCompressedPositiveInt(deserializer2);
            if (tupleSize == 0) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            return TwoByteStringDescriptor.Companion.generateTwoByteString(tupleSize, (Function1<? super Integer, UShort>)((Function1)new Function1<Integer, UShort>(deserializer2){
                final /* synthetic */ AbstractDeserializer $deserializer;
                {
                    this.$deserializer = $deserializer;
                    super(1);
                }

                public final short invoke-BwKQO78(int it) {
                    boolean bl;
                    int codePoint = SerializerOperandEncoding.Companion.readCompressedPositiveInt(this.$deserializer);
                    boolean bl2 = bl = (codePoint & 0xFFFF) == codePoint;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    return UShort.constructor-impl((short)((short)codePoint));
                }
            }));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/serialization/SerializerOperandEncoding$COMPRESSED_ARBITRARY_CHARACTER_TUPLE;", "Lavail/serialization/SerializerOperandEncoding;", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "write", "", "obj", "serializer", "Lavail/serialization/Serializer;", "write$avail", "avail"})
    static final class COMPRESSED_ARBITRARY_CHARACTER_TUPLE
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        COMPRESSED_ARBITRARY_CHARACTER_TUPLE() {
            void var1_1;
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            int tupleSize = A_Tuple.Companion.getTupleSize(obj);
            long shiftedTupleSize = ULong.constructor-impl((long)(ULong.constructor-impl((long)tupleSize) << 2));
            if (obj.isByteString()) {
                Companion.writeCompressedULong-4PLdz1A(shiftedTupleSize, serializer);
                Iterable $this$forEach$iv = (Iterable)new IntRange(1, tupleSize);
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int i2 = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl = false;
                    serializer.writeByte$avail(A_Tuple.Companion.tupleCodePointAt(obj, i2));
                }
                return;
            }
            if (obj.isTwoByteString()) {
                Companion.writeCompressedULong-4PLdz1A(ULong.constructor-impl((long)(shiftedTupleSize + 1L)), serializer);
            } else {
                Companion.writeCompressedULong-4PLdz1A(ULong.constructor-impl((long)(shiftedTupleSize + 3L)), serializer);
            }
            Iterable $this$forEach$iv = (Iterable)new IntRange(1, tupleSize);
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                int element$iv;
                int i3 = element$iv = ((IntIterator)iterator3).nextInt();
                boolean bl = false;
                Companion.writeCompressedPositiveInt$avail(A_Tuple.Companion.tupleCodePointAt(obj, i3), serializer);
            }
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            long shiftedTupleSize = Companion.readCompressedULong-I7RO_PI(deserializer2);
            int tupleSize = (int)ULong.constructor-impl((long)(shiftedTupleSize >>> 2));
            if (tupleSize == 0) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            return switch ((int)ULong.constructor-impl((long)(shiftedTupleSize & 3L))) {
                case 0 -> ByteStringDescriptor.Companion.generateByteString(tupleSize, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(deserializer2){
                    final /* synthetic */ AbstractDeserializer $deserializer;
                    {
                        this.$deserializer = $deserializer;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return this.$deserializer.readByte();
                    }
                }));
                case 1 -> TwoByteStringDescriptor.Companion.generateTwoByteString(tupleSize, (Function1<? super Integer, UShort>)((Function1)new Function1<Integer, UShort>(deserializer2){
                    final /* synthetic */ AbstractDeserializer $deserializer;
                    {
                        this.$deserializer = $deserializer;
                        super(1);
                    }

                    public final short invoke-BwKQO78(int it) {
                        return UShort.constructor-impl((short)((short)SerializerOperandEncoding.Companion.readCompressedPositiveInt(this.$deserializer)));
                    }
                }));
                default -> ObjectTupleDescriptor.Companion.generateObjectTupleFrom(tupleSize, (Function1<? super Integer, ? extends A_BasicObject>)((Function1)new Function1<Integer, A_BasicObject>(deserializer2){
                    final /* synthetic */ AbstractDeserializer $deserializer;
                    {
                        this.$deserializer = $deserializer;
                        super(1);
                    }

                    @NotNull
                    public final A_BasicObject invoke(int it) {
                        return CharacterDescriptor.Companion.fromCodePoint(SerializerOperandEncoding.Companion.readCompressedPositiveInt(this.$deserializer));
                    }
                }));
            };
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/serialization/SerializerOperandEncoding$COMPRESSED_INT_TUPLE;", "Lavail/serialization/SerializerOperandEncoding;", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "write", "", "obj", "serializer", "Lavail/serialization/Serializer;", "write$avail", "avail"})
    static final class COMPRESSED_INT_TUPLE
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        COMPRESSED_INT_TUPLE() {
            void var1_1;
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            int tupleSize = A_Tuple.Companion.getTupleSize(obj);
            Companion.writeCompressedPositiveInt$avail(tupleSize, serializer);
            for (AvailObject element : obj) {
                Companion.writeCompressedPositiveInt$avail(A_Number.Companion.getExtractInt(element), serializer);
            }
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            int tupleSize = Companion.readCompressedPositiveInt(deserializer2);
            if (tupleSize == 0) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            return IntTupleDescriptor.Companion.generateIntTupleFrom(tupleSize, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(deserializer2){
                final /* synthetic */ AbstractDeserializer $deserializer;
                {
                    this.$deserializer = $deserializer;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int it) {
                    return SerializerOperandEncoding.Companion.readCompressedPositiveInt(this.$deserializer);
                }
            })).makeImmutable();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/serialization/SerializerOperandEncoding$UNCOMPRESSED_BYTE_TUPLE;", "Lavail/serialization/SerializerOperandEncoding;", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "write", "", "obj", "serializer", "Lavail/serialization/Serializer;", "write$avail", "avail"})
    static final class UNCOMPRESSED_BYTE_TUPLE
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        UNCOMPRESSED_BYTE_TUPLE() {
            void var1_1;
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            int tupleSize = A_Tuple.Companion.getTupleSize(obj);
            Companion.writeCompressedPositiveInt$avail(tupleSize, serializer);
            int i2 = 1;
            if (i2 <= tupleSize) {
                while (true) {
                    serializer.writeByte$avail(A_Tuple.Companion.tupleIntAt(obj, i2));
                    if (i2 == tupleSize) break;
                    ++i2;
                }
            }
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            int tupleSize = Companion.readCompressedPositiveInt(deserializer2);
            if (tupleSize == 0) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            return ByteTupleDescriptor.Companion.generateByteTupleFrom(tupleSize, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(deserializer2){
                final /* synthetic */ AbstractDeserializer $deserializer;
                {
                    this.$deserializer = $deserializer;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int it) {
                    return this.$deserializer.readByte();
                }
            }));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u001d\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lavail/serialization/SerializerOperandEncoding$UNCOMPRESSED_NYBBLE_TUPLE;", "Lavail/serialization/SerializerOperandEncoding;", "describe", "", "describer", "Lavail/serialization/DeserializerDescriber;", "describe$avail", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "write", "obj", "serializer", "Lavail/serialization/Serializer;", "write$avail", "avail"})
    static final class UNCOMPRESSED_NYBBLE_TUPLE
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        UNCOMPRESSED_NYBBLE_TUPLE() {
            void var1_1;
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            int tupleSize = A_Tuple.Companion.getTupleSize(obj);
            Companion.writeCompressedPositiveInt$avail(tupleSize, serializer);
            for (int i2 = 1; i2 < tupleSize; i2 += 2) {
                int first = A_Tuple.Companion.tupleIntAt(obj, i2);
                int second = A_Tuple.Companion.tupleIntAt(obj, i2 + 1);
                int pair = (first << 4) + second;
                serializer.writeByte$avail(pair);
            }
            if ((tupleSize & 1) == 1) {
                serializer.writeByte$avail(A_Tuple.Companion.tupleIntAt(obj, tupleSize) << 4);
            }
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            int tupleSize = Companion.readCompressedPositiveInt(deserializer2);
            if (tupleSize == 0) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            Ref.IntRef twoNybbles = new Ref.IntRef();
            return NybbleTupleDescriptor.Companion.generateNybbleTupleFrom(tupleSize, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(twoNybbles, deserializer2){
                final /* synthetic */ Ref.IntRef $twoNybbles;
                final /* synthetic */ AbstractDeserializer $deserializer;
                {
                    this.$twoNybbles = $twoNybbles;
                    this.$deserializer = $deserializer;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int index2) {
                    if ((index2 & 1) != 0) {
                        this.$twoNybbles.element = this.$deserializer.readByte();
                        return this.$twoNybbles.element >> 4 & 0xF;
                    }
                    return this.$twoNybbles.element & 0xF;
                }
            }));
        }

        @Override
        public void describe$avail(@NotNull DeserializerDescriber describer) {
            Intrinsics.checkNotNullParameter((Object)describer, (String)"describer");
            int tupleSize = Companion.readCompressedPositiveInt(describer);
            describer.append$avail("Nybbles:[");
            int byteIndex = 1;
            int n = tupleSize >>> 1;
            if (byteIndex <= n) {
                while (true) {
                    int n2 = describer.readByte();
                    describer.append$avail("0123456789ABCDEF".charAt(n2 >>> 4));
                    describer.append$avail("0123456789ABCDEF".charAt(n2 & 0xF));
                    if (byteIndex == n) break;
                    ++byteIndex;
                }
            }
            if ((tupleSize & 1) == 1) {
                int n3 = describer.readByte();
                describer.append$avail("0123456789ABCDEF".charAt(n3 >>> 4));
            }
            describer.append$avail("]");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u001d\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010J\u001d\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lavail/serialization/SerializerOperandEncoding$GENERAL_MAP;", "Lavail/serialization/SerializerOperandEncoding;", "describe", "", "describer", "Lavail/serialization/DeserializerDescriber;", "describe$avail", "read", "Lavail/descriptor/representation/AvailObject;", "deserializer", "Lavail/serialization/AbstractDeserializer;", "read$avail", "trace", "obj", "serializer", "Lavail/serialization/Serializer;", "trace$avail", "write", "write$avail", "avail"})
    static final class GENERAL_MAP
    extends SerializerOperandEncoding {
        /*
         * WARNING - void declaration
         */
        GENERAL_MAP() {
            void var1_1;
        }

        @Override
        public void trace$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            A_Map.Companion.forEach(obj, (Function2<? super AvailObject, ? super AvailObject, Unit>)((Function2)new Function2<AvailObject, AvailObject, Unit>(serializer){
                final /* synthetic */ Serializer $serializer;
                {
                    this.$serializer = $serializer;
                    super(2);
                }

                public final void invoke(@NotNull AvailObject key, @NotNull AvailObject value) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    this.$serializer.traceOne$avail(key);
                    this.$serializer.traceOne$avail(value);
                }
            }));
        }

        @Override
        public void write$avail(@NotNull AvailObject obj, @NotNull Serializer serializer) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            Companion.writeCompressedPositiveInt$avail(A_Map.Companion.getMapSize(obj), serializer);
            A_Map.Companion.forEach(obj, (Function2<? super AvailObject, ? super AvailObject, Unit>)((Function2)new Function2<AvailObject, AvailObject, Unit>(serializer){
                final /* synthetic */ Serializer $serializer;
                {
                    this.$serializer = $serializer;
                    super(2);
                }

                public final void invoke(@NotNull AvailObject key, @NotNull AvailObject value) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    SerializerOperandEncoding.Companion.writeCompressedPositiveInt$avail(this.$serializer.compressedObjectIndex$avail(key), this.$serializer);
                    SerializerOperandEncoding.Companion.writeCompressedPositiveInt$avail(this.$serializer.compressedObjectIndex$avail(value), this.$serializer);
                }
            }));
        }

        @Override
        @NotNull
        public AvailObject read$avail(@NotNull AbstractDeserializer deserializer2) {
            Intrinsics.checkNotNullParameter((Object)deserializer2, (String)"deserializer");
            int mapSize = Companion.readCompressedPositiveInt(deserializer2);
            if (mapSize == 0) {
                A_Map a_Map = MapDescriptor.Companion.getEmptyMap();
                Intrinsics.checkNotNull((Object)a_Map, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                return (AvailObject)a_Map;
            }
            A_Map map = MapDescriptor.Companion.getEmptyMap();
            int index2 = 1;
            if (index2 <= mapSize) {
                while (true) {
                    map = A_Map.Companion.mapAtPuttingCanDestroy(map, deserializer2.fromCompressedObjectIndex$avail(Companion.readCompressedPositiveInt(deserializer2)), deserializer2.fromCompressedObjectIndex$avail(Companion.readCompressedPositiveInt(deserializer2)), true);
                    if (index2 == mapSize) break;
                    ++index2;
                }
            }
            A_Map a_Map = map;
            Intrinsics.checkNotNull((Object)a_Map, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
            return (AvailObject)a_Map;
        }

        @Override
        public void describe$avail(@NotNull DeserializerDescriber describer) {
            Intrinsics.checkNotNullParameter((Object)describer, (String)"describer");
            int mapSize = Companion.readCompressedPositiveInt(describer);
            describer.append$avail("{");
            int i2 = 1;
            if (i2 <= mapSize) {
                while (true) {
                    if (i2 > 1) {
                        describer.append$avail(", ");
                    }
                    int keyIndex = Companion.readCompressedPositiveInt(describer);
                    int valueIndex = Companion.readCompressedPositiveInt(describer);
                    describer.printCompressedIndex(keyIndex);
                    describer.append$avail(" \u2192 ");
                    describer.printCompressedIndex(valueIndex);
                    if (i2 == mapSize) break;
                    ++i2;
                }
            }
            describer.append$avail("}");
        }
    }
}

