/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil;

import avail.anvil.AvailWorkbench;
import avail.anvil.streams.StreamStyle;
import avail.utility.DirectoryWatcherExtensionsKt;
import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryWatcher;
import io.methvin.watcher.hashing.FileHasher;
import java.io.File;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.artifact.environment.project.AvailProjectRoot;
import org.jetbrains.annotations.NotNull;
import org.slf4j.helpers.NOPLogger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lavail/anvil/ProjectWatcher;", "", "workbench", "Lavail/anvil/AvailWorkbench;", "(Lavail/anvil/AvailWorkbench;)V", "configurationWatcher", "Lio/methvin/watcher/DirectoryWatcher;", "getConfigurationWatcher$annotations", "()V", "getWorkbench", "()Lavail/anvil/AvailWorkbench;", "avail"})
public final class ProjectWatcher {
    @NotNull
    private final AvailWorkbench workbench;
    @NotNull
    private final DirectoryWatcher configurationWatcher;

    public ProjectWatcher(@NotNull AvailWorkbench workbench) {
        Intrinsics.checkNotNullParameter(workbench, "workbench");
        this.workbench = workbench;
        DirectoryWatcher directoryWatcher = DirectoryWatcher.builder().logger(NOPLogger.NOP_LOGGER).fileHasher(FileHasher.LAST_MODIFIED_TIME).path(new File(this.workbench.getProjectConfigDirectory()).toPath()).listener(arg_0 -> ProjectWatcher.configurationWatcher$lambda$0(this, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue(directoryWatcher, "builder()\n\t\t.logger(NOPL\u2026\t\t\t\t)\n\t\t\t}\n\t\t}\n\t\t.build()");
        this.configurationWatcher = DirectoryWatcherExtensionsKt.launch(directoryWatcher, "configuration watcher: " + this.workbench.getProjectConfigDirectory());
    }

    @NotNull
    public final AvailWorkbench getWorkbench() {
        return this.workbench;
    }

    private static /* synthetic */ void getConfigurationWatcher$annotations() {
    }

    private static final void configurationWatcher$lambda$0(ProjectWatcher this$0, DirectoryChangeEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            DirectoryChangeEvent.EventType eventType = event.eventType();
            Intrinsics.checkNotNull((Object)eventType);
            switch (WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()]) {
                case 1: {
                    this$0.workbench.errorStream().println("configuration file deleted: " + event.path());
                    break;
                }
                case 2: 
                case 3: {
                    String parent = event.path().toFile().getParent();
                    boolean isRoot = !Intrinsics.areEqual(this$0.workbench.getProjectConfigDirectory(), parent);
                    if (event.path().endsWith("templates.json")) {
                        if (isRoot) {
                            AvailProject availProject = this$0.workbench.getAvailProject$avail();
                            Intrinsics.checkNotNullExpressionValue(parent, "parent");
                            AvailProjectRoot availProjectRoot = availProject.rootFromConfigDirPath(parent);
                            if (availProjectRoot != null) {
                                availProjectRoot.refreshTemplates(parent);
                            }
                        } else {
                            this$0.workbench.getAvailProject$avail().refreshTemplates(this$0.workbench.getProjectConfigDirectory());
                        }
                        this$0.workbench.refreshTemplates$avail();
                        this$0.workbench.writeText("configuration file refreshed: " + event.path() + "\n", StreamStyle.INFO);
                    } else if (event.path().endsWith("styles.json")) {
                        if (isRoot) {
                            AvailProject availProject = this$0.workbench.getAvailProject$avail();
                            Intrinsics.checkNotNullExpressionValue(parent, "parent");
                            AvailProjectRoot availProjectRoot = availProject.rootFromConfigDirPath(parent);
                            if (availProjectRoot != null) {
                                availProjectRoot.refreshStyles(parent);
                            }
                        } else {
                            this$0.workbench.getAvailProject$avail().refreshStyles(this$0.workbench.getProjectConfigDirectory());
                        }
                        this$0.workbench.getRefreshStylesheetAction().runAction();
                        this$0.workbench.writeText("configuration file refreshed: " + event.path() + "\n", StreamStyle.INFO);
                    } else if (event.path().endsWith("settings-local.json")) {
                        if (isRoot) {
                            AvailProject availProject = this$0.workbench.getAvailProject$avail();
                            Intrinsics.checkNotNullExpressionValue(parent, "parent");
                            AvailProjectRoot availProjectRoot = availProject.rootFromConfigDirPath(parent);
                            if (availProjectRoot != null) {
                                availProjectRoot.refreshLocalSettings(parent);
                            }
                        } else {
                            this$0.workbench.getAvailProject$avail().refreshLocalSettings(this$0.workbench.getProjectConfigDirectory());
                        }
                        this$0.workbench.getRefreshStylesheetAction().runAction();
                        this$0.workbench.writeText("configuration file refreshed: " + event.path() + "\n", StreamStyle.INFO);
                    }
                    this$0.workbench.getRefreshStylesheetAction().runAction();
                    this$0.workbench.refreshTemplates$avail();
                    this$0.workbench.writeText("configuration file refreshed: " + event.path() + "\n", StreamStyle.INFO);
                }
            }
        }
        catch (Throwable e) {
            this$0.workbench.errorStream().println("Failed to process configuration file update: " + event + ".eventType():\n" + event.path() + ":\n" + ExceptionsKt.stackTraceToString(e));
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DirectoryChangeEvent.EventType.values().length];
            try {
                nArray[DirectoryChangeEvent.EventType.DELETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DirectoryChangeEvent.EventType.CREATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DirectoryChangeEvent.EventType.MODIFY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DirectoryChangeEvent.EventType.OVERFLOW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

