/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.nodes;

import avail.anvil.AvailWorkbench;
import avail.anvil.nodes.AbstractWorkbenchTreeNode;
import avail.anvil.nodes.LocalSettingsNode;
import avail.anvil.nodes.ModuleHeaderTemplateNode;
import avail.anvil.nodes.StylesNode;
import avail.anvil.nodes.TemplatesNode;
import java.io.File;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.artifact.environment.AvailEnvironment;
import org.availlang.artifact.environment.project.AvailProjectRoot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\nH\u0016J\u0015\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\u001cR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lavail/anvil/nodes/RootConfigDirNode;", "Lavail/anvil/nodes/AbstractWorkbenchTreeNode;", "workbench", "Lavail/anvil/AvailWorkbench;", "root", "Lorg/availlang/artifact/environment/project/AvailProjectRoot;", "visible", "", "(Lavail/anvil/AvailWorkbench;Lorg/availlang/artifact/environment/project/AvailProjectRoot;Z)V", "path", "", "getPath", "()Ljava/lang/String;", "getRoot", "()Lorg/availlang/artifact/environment/project/AvailProjectRoot;", "sortMajor", "", "getSortMajor", "()I", "getVisible", "()Z", "htmlStyle", "selected", "htmlStyle$avail", "iconResourceName", "iconResourceName$avail", "modulePathString", "text", "text$avail", "avail"})
public final class RootConfigDirNode
extends AbstractWorkbenchTreeNode {
    @NotNull
    private final AvailProjectRoot root;
    private final boolean visible;

    /*
     * WARNING - void declaration
     */
    public RootConfigDirNode(@NotNull AvailWorkbench workbench, @NotNull AvailProjectRoot root, boolean visible) {
        File[] fileArray;
        Intrinsics.checkNotNullParameter(workbench, "workbench");
        Intrinsics.checkNotNullParameter(root, "root");
        super(workbench);
        this.root = root;
        this.visible = visible;
        String configDir = this.getPath();
        File[] $this$_init__u24lambda_u240 = fileArray = new File(configDir);
        boolean bl = false;
        if (!$this$_init__u24lambda_u240.exists()) {
            $this$_init__u24lambda_u240.mkdirs();
        }
        File[] dir = fileArray;
        if (!dir.isDirectory()) {
            System.err.println(configDir + " is expected to be a directory");
        } else {
            fileArray = dir.listFiles(RootConfigDirNode::_init_$lambda$1);
            if (fileArray != null) {
                void $this$forEach$iv;
                File[] $this$_init__u24lambda_u243 = bl = fileArray;
                boolean bl2 = false;
                File[] $this$sortBy$iv = $this$_init__u24lambda_u243;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.length > 1) {
                    ArraysKt.sortWith($this$sortBy$iv, new Comparator(){

                        public final int compare(T a, T b) {
                            File it = (File)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getName());
                            it = (File)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                        }
                    });
                }
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv;
                    void it = element$iv = $this$forEach$iv[j];
                    boolean bl3 = false;
                    if (Intrinsics.areEqual(it.getName(), "styles.json")) {
                        String string2 = it.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue(string2, "it.absolutePath");
                        this.add(new StylesNode(workbench, string2));
                        continue;
                    }
                    if (Intrinsics.areEqual(it.getName(), "templates.json")) {
                        String string3 = it.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue(string3, "it.absolutePath");
                        this.add(new TemplatesNode(workbench, string3));
                        continue;
                    }
                    if (Intrinsics.areEqual(it.getName(), "settings-local.json")) {
                        String string4 = it.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue(string4, "it.absolutePath");
                        this.add(new LocalSettingsNode(workbench, string4));
                        continue;
                    }
                    String string5 = it.getName();
                    Intrinsics.checkNotNullExpressionValue(string5, "it.name");
                    if (!StringsKt.endsWith$default(string5, ".mhd", false, 2, null)) continue;
                    String string6 = it.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue(string6, "it.absolutePath");
                    this.add(new ModuleHeaderTemplateNode(workbench, string6));
                }
            }
        }
    }

    @NotNull
    public final AvailProjectRoot getRoot() {
        return this.root;
    }

    public final boolean getVisible() {
        return this.visible;
    }

    @Override
    @NotNull
    public String modulePathString() {
        return this.root.getName();
    }

    @Override
    @NotNull
    public String iconResourceName$avail() {
        return "root-config-color";
    }

    @Override
    @NotNull
    public String text$avail(boolean selected) {
        return this.root.getName();
    }

    @Override
    @NotNull
    public String htmlStyle$avail(boolean selected) {
        return AbstractWorkbenchTreeNode.Companion.fontStyle$default(AbstractWorkbenchTreeNode.Companion, true, false, !this.visible, 2, null) + AbstractWorkbenchTreeNode.Companion.colorStyle$default(AbstractWorkbenchTreeNode.Companion, selected, this.visible, false, false, 8, null);
    }

    @NotNull
    public final String getPath() {
        return AvailEnvironment.INSTANCE.projectRootConfigPath(this.getWorkbench$avail().getProjectName(), this.root.getName(), this.getWorkbench$avail().getProjectHomeDirectory());
    }

    @Override
    public int getSortMajor() {
        return 50;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean _init_$lambda$1(File f) {
        if (f.isDirectory()) return false;
        String string2 = f.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "f.name");
        if (StringsKt.endsWith$default(string2, ".backup", false, 2, null)) return false;
        return true;
    }
}

