/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.projects;

import java.io.File;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.json.JSONFriendly;
import org.availlang.json.JSONObject;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 /2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001/B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0011\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0000H\u0096\u0002J\t\u0010\"\u001a\u00020\u0004H\u00c6\u0003J\t\u0010#\u001a\u00020\u0004H\u00c6\u0003J\t\u0010$\u001a\u00020\u0004H\u00c6\u0003J\t\u0010%\u001a\u00020\bH\u00c6\u0003J1\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010'\u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020 H\u0016J\b\u0010*\u001a\u00020\u0004H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016R\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\f\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0006\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\f\"\u0004\b\u001c\u0010\u001a\u00a8\u00060"}, d2={"Lavail/anvil/projects/KnownAvailProject;", "Lorg/availlang/json/JSONFriendly;", "", "name", "", "id", "projectConfigFile", "lastOpened", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;J)V", "configFilePath", "getConfigFilePath", "()Ljava/lang/String;", "exists", "", "getExists", "()Z", "getId", "getLastOpened", "()J", "setLastOpened", "(J)V", "lastOpenedTimestamp", "getLastOpenedTimestamp", "getName", "setName", "(Ljava/lang/String;)V", "getProjectConfigFile", "setProjectConfigFile", "availProject", "Lorg/availlang/artifact/environment/project/AvailProject;", "compareTo", "", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "hashCode", "toString", "writeTo", "", "writer", "Lorg/availlang/json/JSONWriter;", "Companion", "avail"})
public final class KnownAvailProject
implements JSONFriendly,
Comparable<KnownAvailProject> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    @NotNull
    private final String id;
    @NotNull
    private String projectConfigFile;
    private long lastOpened;

    public KnownAvailProject(@NotNull String name, @NotNull String id, @NotNull String projectConfigFile, long lastOpened) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(projectConfigFile, "projectConfigFile");
        this.name = name;
        this.id = id;
        this.projectConfigFile = projectConfigFile;
        this.lastOpened = lastOpened;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.name = string2;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getProjectConfigFile() {
        return this.projectConfigFile;
    }

    public final void setProjectConfigFile(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.projectConfigFile = string2;
    }

    public final long getLastOpened() {
        return this.lastOpened;
    }

    public final void setLastOpened(long l) {
        this.lastOpened = l;
    }

    @NotNull
    public final String getConfigFilePath() {
        String string2 = new File(this.projectConfigFile).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string2, "File(projectConfigFile).absolutePath");
        return string2;
    }

    public final boolean getExists() {
        return new File(this.projectConfigFile).exists();
    }

    @NotNull
    public final String getLastOpenedTimestamp() {
        ZoneId zoneId = ZonedDateTime.now().getZone();
        Instant instant = Instant.ofEpochMilli(this.lastOpened);
        ZonedDateTime zdt = ZonedDateTime.of(instant.atZone(zoneId).toLocalDate(), instant.atZone(zoneId).toLocalTime(), zoneId);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm");
        String string2 = zdt.format(formatter);
        Intrinsics.checkNotNullExpressionValue(string2, "zdt.format(formatter)");
        return string2;
    }

    @Nullable
    public final AvailProject availProject() {
        AvailProject availProject;
        File configFile = new File(this.projectConfigFile);
        if (!configFile.exists() || !configFile.isFile()) {
            return null;
        }
        try {
            String string2 = configFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue(string2, "configFile.absolutePath");
            availProject = AvailProject.Companion.from(string2);
        }
        catch (Throwable e) {
            e.printStackTrace();
            availProject = null;
        }
        return availProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(@NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeObject = false;
        this_$iv.startObject();
        try {
            JSONWriter this_$iv2;
            JSONWriter $this$writeTo_u24lambda_u244 = this_$iv;
            boolean bl = false;
            JSONWriter jSONWriter = $this$writeTo_u24lambda_u244;
            String key$iv = "id";
            boolean $i$f$at = false;
            this_$iv2.write(key$iv);
            void $this$writeTo_u24lambda_u244_u24lambda_u240 = this_$iv2;
            boolean bl2 = false;
            $this$writeTo_u24lambda_u244_u24lambda_u240.write(this.id);
            this_$iv2 = $this$writeTo_u24lambda_u244;
            key$iv = "name";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u244_u24lambda_u241 = this_$iv2;
            boolean bl3 = false;
            $this$writeTo_u24lambda_u244_u24lambda_u241.write(this.name);
            this_$iv2 = $this$writeTo_u24lambda_u244;
            key$iv = "projectConfigFile";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u244_u24lambda_u242 = this_$iv2;
            boolean bl4 = false;
            $this$writeTo_u24lambda_u244_u24lambda_u242.write(this.projectConfigFile);
            this_$iv2 = $this$writeTo_u24lambda_u244;
            key$iv = "lastOpened";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u244_u24lambda_u243 = this_$iv2;
            boolean bl5 = false;
            $this$writeTo_u24lambda_u244_u24lambda_u243.write(this.lastOpened);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endObject();
        }
    }

    @Override
    public int compareTo(@NotNull KnownAvailProject other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.lastOpened > other.lastOpened ? 1 : (this.lastOpened < other.lastOpened ? -1 : 0);
    }

    @NotNull
    public String toString() {
        return this.name + ": " + this.projectConfigFile;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KnownAvailProject)) {
            return false;
        }
        return Intrinsics.areEqual(this.id, ((KnownAvailProject)other).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.id;
    }

    @NotNull
    public final String component3() {
        return this.projectConfigFile;
    }

    public final long component4() {
        return this.lastOpened;
    }

    @NotNull
    public final KnownAvailProject copy(@NotNull String name, @NotNull String id, @NotNull String projectConfigFile, long lastOpened) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(projectConfigFile, "projectConfigFile");
        return new KnownAvailProject(name, id, projectConfigFile, lastOpened);
    }

    public static /* synthetic */ KnownAvailProject copy$default(KnownAvailProject knownAvailProject, String string2, String string3, String string4, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = knownAvailProject.name;
        }
        if ((n & 2) != 0) {
            string3 = knownAvailProject.id;
        }
        if ((n & 4) != 0) {
            string4 = knownAvailProject.projectConfigFile;
        }
        if ((n & 8) != 0) {
            l = knownAvailProject.lastOpened;
        }
        return knownAvailProject.copy(string2, string3, string4, l);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lavail/anvil/projects/KnownAvailProject$Companion;", "", "()V", "from", "Lavail/anvil/projects/KnownAvailProject;", "obj", "Lorg/availlang/json/JSONObject;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KnownAvailProject from(@NotNull JSONObject obj) {
            KnownAvailProject knownAvailProject;
            Intrinsics.checkNotNullParameter(obj, "obj");
            if (!(obj.containsKey("projectConfigFile") && obj.containsKey("name") && obj.containsKey("id") && obj.containsKey("lastOpened"))) {
                return null;
            }
            try {
                knownAvailProject = new KnownAvailProject(JSONObject.getString$default(obj, "name", null, 2, null), JSONObject.getString$default(obj, "id", null, 2, null), JSONObject.getString$default(obj, "projectConfigFile", null, 2, null), JSONObject.getNumber$default(obj, "lastOpened", null, 2, null).getLong());
            }
            catch (Throwable e) {
                e.printStackTrace();
                knownAvailProject = null;
            }
            return knownAvailProject;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

