/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lavail/anvil/text/TextLineNumber;", "Ljavax/swing/JPanel;", "Ljavax/swing/event/CaretListener;", "Ljavax/swing/event/DocumentListener;", "Ljava/beans/PropertyChangeListener;", "component", "Ljavax/swing/text/JTextComponent;", "(Ljavax/swing/text/JTextComponent;)V", "currentLineForeground", "Ljava/awt/Color;", "lastDigits", "", "lastHeight", "lastLines", "Lkotlin/ranges/IntRange;", "caretUpdate", "", "e", "Ljavax/swing/event/CaretEvent;", "changedUpdate", "Ljavax/swing/event/DocumentEvent;", "computeSelectionLines", "documentChanged", "insertUpdate", "paintComponent", "g", "Ljava/awt/Graphics;", "propertyChange", "evt", "Ljava/beans/PropertyChangeEvent;", "removeUpdate", "setPreferredWidth", "avail"})
public final class TextLineNumber
extends JPanel
implements CaretListener,
DocumentListener,
PropertyChangeListener {
    @NotNull
    private final JTextComponent component;
    @Nullable
    private Color currentLineForeground;
    private int lastDigits;
    private int lastHeight;
    @NotNull
    private IntRange lastLines;

    public TextLineNumber(@NotNull JTextComponent component) {
        Intrinsics.checkNotNullParameter(component, "component");
        this.component = component;
        this.currentLineForeground = Color.RED;
        this.lastLines = new IntRange(-1, -1);
        this.setFont(this.component.getFont());
        this.setBorder(new CompoundBorder(new MatteBorder(0, 0, 0, 2, Color.GRAY), new EmptyBorder(0, 5, 0, 5)));
        this.component.getDocument().addDocumentListener(this);
        this.component.addCaretListener(this);
        this.component.addPropertyChangeListener("font", this);
        this.lastDigits = 0;
        this.setPreferredWidth();
    }

    private final void setPreferredWidth() {
        Element root = this.component.getDocument().getDefaultRootElement();
        int lines = root.getElementCount();
        int digits = String.valueOf(lines).length();
        if (this.lastDigits != digits) {
            this.lastDigits = digits;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width;
            this.setPreferredSize(new Dimension(preferredWidth, 2146483647));
            this.setSize(this.getPreferredSize());
        }
    }

    @Override
    public void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter(g, "g");
        super.paintComponent(g);
        int leftInset = this.getInsets().left;
        Element root = this.component.getDocument().getDefaultRootElement();
        Rectangle clip = g.getClipBounds();
        int firstLine = root.getElementIndex(this.component.viewToModel2D(new Point(0, (int)clip.getMinY())));
        int lastLine = root.getElementIndex(this.component.viewToModel2D(new Point(0, (int)clip.getMaxY())));
        IntRange selectedLines = this.computeSelectionLines();
        int line = firstLine;
        if (line <= lastLine) {
            while (true) {
                try {
                    Color color;
                    int n = line;
                    int n2 = selectedLines.getFirst();
                    boolean bl = n <= selectedLines.getLast() ? n2 <= n : false;
                    if (bl) {
                        color = this.currentLineForeground;
                        if (color == null) {
                            color = this.getForeground();
                        }
                    } else {
                        color = this.getForeground();
                    }
                    g.setColor(color);
                    Element element = root.getElement(line);
                    int topY = (int)this.component.modelToView2D(element.getStartOffset()).getY();
                    int offsetY = g.getFontMetrics().getAscent();
                    g.drawString(String.valueOf(line + 1), leftInset, topY + offsetY);
                }
                catch (Exception e) {
                    break;
                }
                if (line == lastLine) break;
                ++line;
            }
        }
    }

    @Override
    public void caretUpdate(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        IntRange currentLines = this.computeSelectionLines();
        if (!Intrinsics.areEqual(this.lastLines, currentLines)) {
            this.lastLines = currentLines;
            this.getParent().repaint();
        }
    }

    private final IntRange computeSelectionLines() {
        Element root = this.component.getDocument().getDefaultRootElement();
        int dot = this.component.getCaret().getDot();
        int mark = this.component.getCaret().getMark();
        int startLine = root.getElementIndex(Math.min(dot, mark));
        int endLine = root.getElementIndex(Math.max(dot, mark));
        return new IntRange(startLine, endLine);
    }

    @Override
    public void changedUpdate(@NotNull DocumentEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.documentChanged();
    }

    @Override
    public void insertUpdate(@NotNull DocumentEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.documentChanged();
    }

    @Override
    public void removeUpdate(@NotNull DocumentEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.documentChanged();
    }

    private final void documentChanged() {
        SwingUtilities.invokeLater(() -> TextLineNumber.documentChanged$lambda$0(this));
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        Intrinsics.checkNotNullParameter(evt, "evt");
        Object value = evt.getNewValue();
        if (value instanceof Font) {
            this.setFont((Font)value);
            this.lastDigits = 0;
            this.setPreferredWidth();
        }
    }

    private static final void documentChanged$lambda$0(TextLineNumber this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            int endPos = this$0.component.getDocument().getLength();
            Rectangle2D rect = this$0.component.modelToView2D(endPos);
            if ((int)rect.getY() != this$0.lastHeight) {
                this$0.setPreferredWidth();
                this$0.getParent().repaint();
                this$0.lastHeight = (int)rect.getY();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

