/*
 * Decompiled with CFR 0.152.
 */
package avail.builder;

import avail.annotations.ThreadSafe;
import avail.builder.ModuleRoot;
import avail.builder.ModuleRoots;
import avail.error.ErrorCode;
import avail.files.FileManager;
import avail.persistence.cache.Repositories;
import avail.resolver.ModuleRootResolver;
import avail.resolver.ModuleRootResolverRegistry;
import avail.resolver.ResolverReference;
import avail.utility.CollectionExtensionsKt;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ0\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\n0\bJ\u0006\u0010\u001c\u001a\u00020\nJ\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eH\u0096\u0002J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u0006J@\u0010 \u001a\u00020\n28\u0010!\u001a4\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\t\u0012\u001e\u0012\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u00010&0$0\t\u0012\u0004\u0012\u00020\n0\"J*\u0010'\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\n0\bH\u0002J\u000e\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0006J\u000e\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\n2\u0006\u0010+\u001a\u00020,R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R,\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0013j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0002`\u00148\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lavail/builder/ModuleRoots;", "", "Lavail/builder/ModuleRoot;", "fileManager", "Lavail/files/FileManager;", "modulePath", "", "withFailures", "Lkotlin/Function1;", "", "", "(Lavail/files/FileManager;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getFileManager", "()Lavail/files/FileManager;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getModulePath", "()Ljava/lang/String;", "rootMap", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "roots", "", "getRoots", "()Ljava/util/Set;", "addRoot", "rootName", "location", "clearRoots", "iterator", "", "moduleRootFor", "moduleRootTreesThen", "withResults", "Lkotlin/Function2;", "Lavail/resolver/ResolverReference;", "Lkotlin/Triple;", "Lavail/error/ErrorCode;", "", "parseAvailModulePathThen", "removeRoot", "name", "writeOn", "writer", "Lorg/availlang/json/JSONWriter;", "writePathsOn", "avail"})
@ThreadSafe
public final class ModuleRoots
implements Iterable<ModuleRoot>,
KMappedMarker {
    @NotNull
    private final FileManager fileManager;
    @NotNull
    private final ReentrantLock lock;
    @GuardedBy(value="lock")
    @NotNull
    private final LinkedHashMap<String, ModuleRoot> rootMap;

    public ModuleRoots(@NotNull FileManager fileManager, @NotNull String modulePath2, @NotNull Function1<? super List<String>, Unit> withFailures) {
        Intrinsics.checkNotNullParameter(fileManager, "fileManager");
        Intrinsics.checkNotNullParameter(modulePath2, "modulePath");
        Intrinsics.checkNotNullParameter(withFailures, "withFailures");
        this.fileManager = fileManager;
        this.lock = new ReentrantLock();
        this.rootMap = new LinkedHashMap();
        this.parseAvailModulePathThen(modulePath2, withFailures);
    }

    @NotNull
    public final FileManager getFileManager() {
        return this.fileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getModulePath() {
        String string2;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Collection<ModuleRoot> collection2 = this.rootMap.values();
            Intrinsics.checkNotNullExpressionValue(collection2, "rootMap.values");
            string2 = CollectionsKt.joinToString$default(collection2, ";", null, null, 0, null, modulePath.1.1.INSTANCE, 30, null);
        }
        finally {
            lock.unlock();
        }
        return string2;
    }

    private final void parseAvailModulePathThen(String modulePath2, Function1<? super List<String>, Unit> withFailures) {
        List list2;
        this.clearRoots();
        if (((CharSequence)modulePath2).length() == 0) {
            list2 = CollectionsKt.emptyList();
        } else {
            String[] stringArray = new String[]{";"};
            list2 = StringsKt.split$default((CharSequence)modulePath2, stringArray, false, 0, 6, null);
        }
        List components = list2;
        List<String> failures = Collections.synchronizedList(new ArrayList());
        CollectionExtensionsKt.parallelDoThen(components, (Function2)new Function2<String, Function0<? extends Unit>, Unit>(this, failures){
            final /* synthetic */ ModuleRoots this$0;
            final /* synthetic */ List<String> $failures;
            {
                this.this$0 = $receiver;
                this.$failures = $failures;
                super(2);
            }

            public final void invoke(@NotNull String component, @NotNull Function0<Unit> after) {
                Intrinsics.checkNotNullParameter(component, "component");
                Intrinsics.checkNotNullParameter(after, "after");
                String[] stringArray = new String[]{"="};
                List binding = StringsKt.split$default((CharSequence)component, stringArray, false, 0, 6, null);
                if (!(binding.size() == 2)) {
                    boolean $i$a$-require-ModuleRoots$parseAvailModulePathThen$1$22 = false;
                    String $i$a$-require-ModuleRoots$parseAvailModulePathThen$1$22 = "Bad module root location setting: " + component;
                    throw new IllegalArgumentException($i$a$-require-ModuleRoots$parseAvailModulePathThen$1$22.toString());
                }
                String rootName = (String)binding.get(0);
                String location = (String)binding.get(1);
                this.this$0.addRoot(rootName, location, (Function1<? super List<String>, Unit>)new Function1<List<? extends String>, Unit>(this.$failures, after){
                    final /* synthetic */ List<String> $failures;
                    final /* synthetic */ Function0<Unit> $after;
                    {
                        this.$failures = $failures;
                        this.$after = $after;
                        super(1);
                    }

                    public final void invoke(@NotNull List<String> newFailures) {
                        Intrinsics.checkNotNullParameter(newFailures, "newFailures");
                        this.$failures.addAll((Collection<String>)newFailures);
                        this.$after.invoke();
                    }
                });
            }
        }, new Function0<Unit>(withFailures, failures){
            final /* synthetic */ Function1<List<String>, Unit> $withFailures;
            final /* synthetic */ List<String> $failures;
            {
                this.$withFailures = $withFailures;
                this.$failures = $failures;
                super(0);
            }

            public final void invoke() {
                List<String> list2 = this.$failures;
                Intrinsics.checkNotNullExpressionValue(list2, "failures");
                this.$withFailures.invoke(CollectionsKt.toList((Iterable)list2));
            }
        });
    }

    public final void addRoot(@NotNull String rootName, @NotNull String location, @NotNull Function1<? super List<String>, Unit> withFailures) {
        Intrinsics.checkNotNullParameter(rootName, "rootName");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(withFailures, "withFailures");
        if (((CharSequence)location).length() == 0) {
            List<CallSite> list2 = Collections.singletonList("Module root \"" + rootName + "\" is missing a source URI");
            Intrinsics.checkNotNullExpressionValue(list2, "singletonList(\n\t\t\t\t\"Modu\u2026is missing a source URI\")");
            withFailures.invoke(list2);
            return;
        }
        URI rootUri = new URI(StringsKt.replace$default(location, "\\", "/", false, 4, null));
        ModuleRootResolver resolver = ModuleRootResolverRegistry.INSTANCE.createResolver(rootName, rootUri, this.fileManager);
        resolver.resolve((Function1<? super ResolverReference, Unit>)new Function1<ResolverReference, Unit>(this, withFailures, rootName, resolver){
            final /* synthetic */ ModuleRoots this$0;
            final /* synthetic */ Function1<List<String>, Unit> $withFailures;
            final /* synthetic */ String $rootName;
            final /* synthetic */ ModuleRootResolver $resolver;
            {
                this.this$0 = $receiver;
                this.$withFailures = $withFailures;
                this.$rootName = $rootName;
                this.$resolver = $resolver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull ResolverReference it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Lock lock = ModuleRoots.access$getLock$p(this.this$0);
                ModuleRoots moduleRoots = this.this$0;
                String string2 = this.$rootName;
                ModuleRootResolver moduleRootResolver = this.$resolver;
                lock.lock();
                try {
                    boolean bl = false;
                    ((Map)ModuleRoots.access$getRootMap$p(moduleRoots)).put(string2, moduleRootResolver.getModuleRoot());
                    Repositories.INSTANCE.addRepository(moduleRootResolver.getModuleRoot());
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                this.$withFailures.invoke(CollectionsKt.emptyList());
            }
        }, (Function2<? super ErrorCode, ? super Throwable, Unit>)new Function2<ErrorCode, Throwable, Unit>(rootName, rootUri, withFailures){
            final /* synthetic */ String $rootName;
            final /* synthetic */ URI $rootUri;
            final /* synthetic */ Function1<List<String>, Unit> $withFailures;
            {
                this.$rootName = $rootName;
                this.$rootUri = $rootUri;
                this.$withFailures = $withFailures;
                super(2);
            }

            public final void invoke(@NotNull ErrorCode code, @Nullable Throwable ex) {
                Intrinsics.checkNotNullParameter(code, "code");
                String message = code + ": Could not resolve module root " + this.$rootName + " (" + this.$rootUri + ")";
                System.err.println(message);
                Throwable throwable = ex;
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                List<CallSite> list2 = Collections.singletonList(message);
                Intrinsics.checkNotNullExpressionValue(list2, "singletonList(message)");
                this.$withFailures.invoke(list2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRoot(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Lock lock = this.lock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            ModuleRoot moduleRoot = (ModuleRoot)this.rootMap.remove(name);
            if (moduleRoot != null) {
                ModuleRoot it = moduleRoot;
                boolean bl2 = false;
                Repositories.INSTANCE.deleteRepository(name);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearRoots() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.rootMap.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<ModuleRoot> getRoots() {
        Set<ModuleRoot> set2;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Collection<ModuleRoot> collection2 = this.rootMap.values();
            Intrinsics.checkNotNullExpressionValue(collection2, "rootMap.values");
            set2 = CollectionsKt.toSet((Iterable)collection2);
        }
        finally {
            lock.unlock();
        }
        return set2;
    }

    @Override
    @NotNull
    public Iterator<ModuleRoot> iterator() {
        return this.getRoots().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ModuleRoot moduleRootFor(@NotNull String rootName) {
        ModuleRoot moduleRoot;
        Intrinsics.checkNotNullParameter(rootName, "rootName");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            moduleRoot = this.rootMap.get(rootName);
        }
        finally {
            lock.unlock();
        }
        return moduleRoot;
    }

    public final void moduleRootTreesThen(@NotNull Function2<? super List<ResolverReference>, ? super List<? extends Triple<String, ? extends ErrorCode, ? extends Throwable>>, Unit> withResults) {
        Intrinsics.checkNotNullParameter(withResults, "withResults");
        Set<ModuleRoot> rootsToAcquire = this.getRoots();
        List<ResolverReference> references = Collections.synchronizedList(new ArrayList());
        List<Triple<String, ErrorCode, Throwable>> failures = Collections.synchronizedList(new ArrayList());
        CollectionExtensionsKt.parallelDoThen((Collection)rootsToAcquire, (Function2)new Function2<ModuleRoot, Function0<? extends Unit>, Unit>(references, failures){
            final /* synthetic */ List<ResolverReference> $references;
            final /* synthetic */ List<Triple<String, ErrorCode, Throwable>> $failures;
            {
                this.$references = $references;
                this.$failures = $failures;
                super(2);
            }

            public final void invoke(@NotNull ModuleRoot root, @NotNull Function0<Unit> after) {
                Intrinsics.checkNotNullParameter(root, "root");
                Intrinsics.checkNotNullParameter(after, "after");
                root.getResolver().provideModuleRootTree((Function1<? super ResolverReference, Unit>)new Function1<ResolverReference, Unit>(this.$references, after){
                    final /* synthetic */ List<ResolverReference> $references;
                    final /* synthetic */ Function0<Unit> $after;
                    {
                        this.$references = $references;
                        this.$after = $after;
                        super(1);
                    }

                    public final void invoke(@NotNull ResolverReference ref) {
                        Intrinsics.checkNotNullParameter(ref, "ref");
                        this.$references.add(ref);
                        this.$after.invoke();
                    }
                }, (Function2<? super ErrorCode, ? super Throwable, Unit>)new Function2<ErrorCode, Throwable, Unit>(this.$failures, root, after){
                    final /* synthetic */ List<Triple<String, ErrorCode, Throwable>> $failures;
                    final /* synthetic */ ModuleRoot $root;
                    final /* synthetic */ Function0<Unit> $after;
                    {
                        this.$failures = $failures;
                        this.$root = $root;
                        this.$after = $after;
                        super(2);
                    }

                    public final void invoke(@NotNull ErrorCode code, @Nullable Throwable ex) {
                        Intrinsics.checkNotNullParameter(code, "code");
                        this.$failures.add(new Triple<String, ErrorCode, Throwable>(this.$root.getName(), code, ex));
                        this.$after.invoke();
                    }
                });
            }
        }, new Function0<Unit>(withResults, references, failures){
            final /* synthetic */ Function2<List<ResolverReference>, List<? extends Triple<String, ? extends ErrorCode, ? extends Throwable>>, Unit> $withResults;
            final /* synthetic */ List<ResolverReference> $references;
            final /* synthetic */ List<Triple<String, ErrorCode, Throwable>> $failures;
            {
                this.$withResults = $withResults;
                this.$references = $references;
                this.$failures = $failures;
                super(0);
            }

            public final void invoke() {
                List<ResolverReference> list2 = this.$references;
                Intrinsics.checkNotNullExpressionValue(list2, "references");
                List<Triple<String, ErrorCode, Throwable>> list3 = this.$failures;
                Intrinsics.checkNotNullExpressionValue(list3, "failures");
                this.$withResults.invoke(list2, list3);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeOn(@NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeArray = false;
        this_$iv.startArray();
        try {
            JSONWriter $this$writeOn_u24lambda_u247 = this_$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = this.getRoots();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModuleRoot root = (ModuleRoot)element$iv;
                boolean bl2 = false;
                $this$writeOn_u24lambda_u247.write(root.getName());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void writePathsOn(@NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeArray = false;
        this_$iv.startArray();
        try {
            JSONWriter $this$writePathsOn_u24lambda_u2410 = this_$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = this.getRoots();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void this_$iv2;
                ModuleRoot root = (ModuleRoot)element$iv;
                boolean bl2 = false;
                JSONWriter jSONWriter = $this$writePathsOn_u24lambda_u2410;
                String key$iv = root.getName();
                boolean $i$f$at = false;
                this_$iv2.write(key$iv);
                void $this$writePathsOn_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = this_$iv2;
                boolean bl3 = false;
                root.writePathsOn(writer);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endArray();
        }
    }

    public static final /* synthetic */ ReentrantLock access$getLock$p(ModuleRoots $this) {
        return $this.lock;
    }

    public static final /* synthetic */ LinkedHashMap access$getRootMap$p(ModuleRoots $this) {
        return $this.rootMap;
    }
}

