/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.types;

import avail.annotations.ThreadSafe;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.AbstractNumberDescriptor;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PojoTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.serialization.SerializerOperation;
import avail.utility.structures.EnumMap;
import java.math.BigInteger;
import java.util.IdentityHashMap;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 @2\u00020\u0001:\u0002@AB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!H\u0016J\u0018\u0010\"\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010'\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u0013H\u0016J\u0018\u0010)\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0018\u0010*\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u0018\u0010+\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0018\u0010/\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u0018\u00100\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u00101\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u00102\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u00103\u001a\u0002042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00105\u001a\u000206H\u0016J8\u00107\u001a\u0002042\u0006\u0010\r\u001a\u00020\u000e2\n\u00108\u001a\u000609j\u0002`:2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020=0<2\u0006\u0010>\u001a\u00020\u0015H\u0016J\b\u0010?\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lavail/descriptor/types/IntegerRangeTypeDescriptor;", "Lavail/descriptor/types/TypeDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "lowerInclusive", "", "upperInclusive", "(Lavail/descriptor/representation/Mutability;ZZ)V", "immutable", "Lavail/descriptor/representation/AbstractDescriptor;", "mutable", "o_ComputeInstanceTag", "Lavail/descriptor/types/TypeTag;", "self", "Lavail/descriptor/representation/AvailObject;", "o_Equals", "another", "Lavail/descriptor/representation/A_BasicObject;", "o_EqualsIntegerRangeType", "Lavail/descriptor/types/A_Type;", "o_Hash", "", "o_IsIntegerRangeType", "o_IsSubtypeOf", "aType", "o_IsSupertypeOfIntegerRangeType", "anIntegerRangeType", "o_LowerBound", "Lavail/descriptor/numbers/A_Number;", "o_LowerInclusive", "o_MarshalToJava", "", "classHint", "Ljava/lang/Class;", "o_RangeIncludesLong", "aLong", "", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_TrimType", "typeToRemove", "o_TypeIntersection", "o_TypeIntersectionOfIntegerRangeType", "o_TypeIntersectionOfPrimitiveTypeEnum", "primitiveTypeEnum", "Lavail/descriptor/types/PrimitiveTypeDescriptor$Types;", "o_TypeUnion", "o_TypeUnionOfIntegerRangeType", "o_TypeUnionOfPrimitiveTypeEnum", "o_UpperBound", "o_UpperInclusive", "o_WriteTo", "", "writer", "Lorg/availlang/json/JSONWriter;", "printObjectOnAvoidingIndent", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "shared", "Companion", "ObjectSlots", "avail"})
public final class IntegerRangeTypeDescriptor
extends TypeDescriptor {
    @NotNull
    public static final Companion Companion;
    private final boolean lowerInclusive;
    private final boolean upperInclusive;
    @NotNull
    private static final EnumMap<Mutability, IntegerRangeTypeDescriptor[]> descriptors;
    private static final int smallRangeLimit = 20;
    @NotNull
    private static final A_Type[][] smallRanges;
    @NotNull
    private static final A_Type bytes;
    @NotNull
    private static final A_Type characterCodePoints;
    @NotNull
    private static final A_Type extendedIntegers;
    @NotNull
    private static final A_Type integers;
    @NotNull
    private static final A_Type naturalNumbers;
    @NotNull
    private static final A_Type nybbles;
    @NotNull
    private static final A_Type unsignedShorts;
    @NotNull
    private static final A_Type wholeNumbers;
    @NotNull
    private static final A_Type int32;
    @NotNull
    private static final A_Type nonnegativeInt32;
    @NotNull
    private static final A_Type int64;
    @NotNull
    private static final A_Type extendedIntegersMeta;
    @NotNull
    private static final A_Type zeroOrOne;

    private IntegerRangeTypeDescriptor(Mutability mutability, boolean lowerInclusive, boolean upperInclusive) {
        super(mutability, TypeTag.EXTENDED_INTEGER_TYPE_TAG, TypeTag.UNKNOWN_TAG, ObjectSlots.class, null);
        this.lowerInclusive = lowerInclusive;
        this.upperInclusive = upperInclusive;
    }

    @Override
    public void printObjectOnAvoidingIndent(@NotNull AvailObject self, @NotNull StringBuilder builder, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(recursionMap, "recursionMap");
        builder.append(this.lowerInclusive ? (char)'[' : '(');
        self.get(ObjectSlots.LOWER_BOUND).printOnAvoidingIndent(builder, recursionMap, indent + 1);
        builder.append("..");
        self.get(ObjectSlots.UPPER_BOUND).printOnAvoidingIndent(builder, recursionMap, indent + 1);
        builder.append(this.upperInclusive ? (char)']' : ')');
    }

    @Override
    @NotNull
    public TypeTag o_ComputeInstanceTag(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        AvailObject lower = self.get(ObjectSlots.LOWER_BOUND);
        AvailObject upper = self.get(ObjectSlots.UPPER_BOUND);
        return !lower.isFinite() && this.lowerInclusive ? TypeTag.EXTENDED_INTEGER_TAG : (!upper.isFinite() && this.upperInclusive ? TypeTag.EXTENDED_INTEGER_TAG : (A_Number.Companion.greaterThan(lower, IntegerDescriptor.Companion.getZero()) ? TypeTag.NATURAL_NUMBER_TAG : (A_Number.Companion.equalsInt(lower, 0) ? TypeTag.WHOLE_NUMBER_TAG : TypeTag.INTEGER_TAG)));
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return another.equalsIntegerRangeType(self);
    }

    @Override
    public boolean o_EqualsIntegerRangeType(@NotNull AvailObject self, @NotNull A_Type another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return self.get(ObjectSlots.LOWER_BOUND).equals(A_Type.Companion.getLowerBound(another)) && self.get(ObjectSlots.UPPER_BOUND).equals(A_Type.Companion.getUpperBound(another)) && this.lowerInclusive == A_Type.Companion.getLowerInclusive(another) && this.upperInclusive == A_Type.Companion.getUpperInclusive(another);
    }

    @Override
    public int o_Hash(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return IntegerRangeTypeDescriptor.Companion.computeHash(self.get(ObjectSlots.LOWER_BOUND).hash(), self.get(ObjectSlots.UPPER_BOUND).hash(), this.lowerInclusive, this.upperInclusive);
    }

    @Override
    public boolean o_IsIntegerRangeType(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return true;
    }

    @Override
    public boolean o_IsSubtypeOf(@NotNull AvailObject self, @NotNull A_Type aType) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aType, "aType");
        return A_Type.Companion.isSupertypeOfIntegerRangeType(aType, self);
    }

    @Override
    public boolean o_IsSupertypeOfIntegerRangeType(@NotNull AvailObject self, @NotNull A_Type anIntegerRangeType) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anIntegerRangeType, "anIntegerRangeType");
        A_Number subMinObject = A_Type.Companion.getLowerBound(anIntegerRangeType);
        AvailObject superMinObject = self.get(ObjectSlots.LOWER_BOUND);
        if (A_Number.Companion.lessThan(subMinObject, superMinObject)) {
            return false;
        }
        if (subMinObject.equals(superMinObject) && A_Type.Companion.getLowerInclusive(anIntegerRangeType) && !this.lowerInclusive) {
            return false;
        }
        A_Number subMaxObject = A_Type.Companion.getUpperBound(anIntegerRangeType);
        A_Number superMaxObject = self.get(ObjectSlots.UPPER_BOUND);
        return A_Number.Companion.lessThan(superMaxObject, subMaxObject) ? false : !superMaxObject.equals(subMaxObject) || !A_Type.Companion.getUpperInclusive(anIntegerRangeType) || this.upperInclusive;
    }

    @Override
    @NotNull
    public A_Number o_LowerBound(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.get(ObjectSlots.LOWER_BOUND);
    }

    @Override
    public boolean o_LowerInclusive(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return this.lowerInclusive;
    }

    @Override
    @Nullable
    public Object o_MarshalToJava(@NotNull AvailObject self, @Nullable Class<?> classHint) {
        Intrinsics.checkNotNullParameter(self, "self");
        return A_Type.Companion.isSubtypeOf(self, PojoTypeDescriptor.Companion.byteRange()) ? Byte.TYPE : (A_Type.Companion.isSubtypeOf(self, PojoTypeDescriptor.Companion.charRange()) ? Character.TYPE : (A_Type.Companion.isSubtypeOf(self, PojoTypeDescriptor.Companion.shortRange()) ? Short.TYPE : (A_Type.Companion.isSubtypeOf(self, PojoTypeDescriptor.Companion.intRange()) ? Integer.TYPE : (A_Type.Companion.isSubtypeOf(self, PojoTypeDescriptor.Companion.longRange()) ? Long.TYPE : (A_Type.Companion.isSubtypeOf(self, integers) ? BigInteger.class : super.o_MarshalToJava(self, classHint))))));
    }

    @Override
    public boolean o_RangeIncludesLong(@NotNull AvailObject self, long aLong) {
        Intrinsics.checkNotNullParameter(self, "self");
        A_Number lower = self.get(ObjectSlots.LOWER_BOUND);
        A_Number asInteger = null;
        if (A_Number.Companion.isLong(lower) && aLong < A_Number.Companion.getExtractLong(lower)) {
            return false;
        }
        if (!lower.isFinite() && A_Number.Companion.isPositive(lower)) {
            return false;
        }
        asInteger = IntegerDescriptor.Companion.fromLong(aLong);
        if (A_Number.Companion.lessThan(asInteger, lower)) {
            return false;
        }
        A_Number upper = self.get(ObjectSlots.UPPER_BOUND);
        return A_Number.Companion.isLong(upper) ? aLong <= A_Number.Companion.getExtractLong(upper) : (!upper.isFinite() ? A_Number.Companion.isPositive(upper) : !A_Number.Companion.lessThan(upper, asInteger));
    }

    @Override
    @ThreadSafe
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return SerializerOperation.INTEGER_RANGE_TYPE;
    }

    @Override
    @NotNull
    public A_Type o_TrimType(@NotNull AvailObject self, @NotNull A_Type typeToRemove) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(typeToRemove, "typeToRemove");
        return A_Type.Companion.isSubtypeOf(self, typeToRemove) ? BottomTypeDescriptor.Companion.getBottom() : (!typeToRemove.isIntegerRangeType() ? (A_Type)self : (typeToRemove.isEnumeration() && !A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(typeToRemove), 1) ? (A_Type)self : (!this.lowerInclusive && A_Type.Companion.getLowerBound(typeToRemove).equals(InfinityDescriptor.Companion.getNegativeInfinity()) || A_Type.Companion.getLowerBound(self).isInstanceOf(typeToRemove) ? A_Type.Companion.typeIntersection(Companion.integerRangeType(A_Type.Companion.getUpperBound(typeToRemove), A_Number.Companion.equalsInfinity(A_Type.Companion.getUpperBound(typeToRemove), AbstractNumberDescriptor.Sign.POSITIVE), InfinityDescriptor.Companion.getPositiveInfinity(), true), self) : (!this.upperInclusive && A_Type.Companion.getUpperBound(typeToRemove).equals(InfinityDescriptor.Companion.getPositiveInfinity()) || A_Type.Companion.getUpperBound(self).isInstanceOf(typeToRemove) ? A_Type.Companion.typeIntersection(Companion.integerRangeType(InfinityDescriptor.Companion.getNegativeInfinity(), true, A_Type.Companion.getLowerBound(typeToRemove), A_Number.Companion.equalsInfinity(A_Type.Companion.getLowerBound(typeToRemove), AbstractNumberDescriptor.Sign.NEGATIVE)), self) : (A_Type)self))));
    }

    @Override
    @NotNull
    public A_Type o_TypeIntersection(@NotNull AvailObject self, @NotNull A_Type another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return A_Type.Companion.isSubtypeOf(self, another) ? (A_Type)self : (A_Type.Companion.isSubtypeOf(another, self) ? another : A_Type.Companion.typeIntersectionOfIntegerRangeType(another, self));
    }

    @Override
    @NotNull
    public A_Type o_TypeIntersectionOfIntegerRangeType(@NotNull AvailObject self, @NotNull A_Type anIntegerRangeType) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anIntegerRangeType, "anIntegerRangeType");
        A_Number minObject = self.get(ObjectSlots.LOWER_BOUND);
        boolean isMinInc = this.lowerInclusive;
        if (A_Type.Companion.getLowerBound(anIntegerRangeType).equals(minObject)) {
            isMinInc = isMinInc && A_Type.Companion.getLowerInclusive(anIntegerRangeType);
        } else if (A_Number.Companion.lessThan(minObject, A_Type.Companion.getLowerBound(anIntegerRangeType))) {
            minObject = A_Type.Companion.getLowerBound(anIntegerRangeType);
            isMinInc = A_Type.Companion.getLowerInclusive(anIntegerRangeType);
        }
        A_Number maxObject = self.get(ObjectSlots.UPPER_BOUND);
        boolean isMaxInc = this.upperInclusive;
        if (A_Type.Companion.getUpperBound(anIntegerRangeType).equals(maxObject)) {
            isMaxInc = isMaxInc && A_Type.Companion.getUpperInclusive(anIntegerRangeType);
        } else if (A_Number.Companion.lessThan(A_Type.Companion.getUpperBound(anIntegerRangeType), maxObject)) {
            maxObject = A_Type.Companion.getUpperBound(anIntegerRangeType);
            isMaxInc = A_Type.Companion.getUpperInclusive(anIntegerRangeType);
        }
        return Companion.integerRangeType(minObject.makeImmutable(), isMinInc, maxObject.makeImmutable(), isMaxInc);
    }

    @Override
    @NotNull
    public A_Type o_TypeIntersectionOfPrimitiveTypeEnum(@NotNull AvailObject self, @NotNull PrimitiveTypeDescriptor.Types primitiveTypeEnum) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter((Object)primitiveTypeEnum, "primitiveTypeEnum");
        return PrimitiveTypeDescriptor.Types.NUMBER.getSuperTests()[primitiveTypeEnum.ordinal()] ? (A_Type)self : BottomTypeDescriptor.Companion.getBottom();
    }

    @Override
    @NotNull
    public A_Type o_TypeUnion(@NotNull AvailObject self, @NotNull A_Type another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return A_Type.Companion.isSubtypeOf(self, another) ? another : (A_Type.Companion.isSubtypeOf(another, self) ? (A_Type)self : A_Type.Companion.typeUnionOfIntegerRangeType(another, self));
    }

    @Override
    @NotNull
    public A_Type o_TypeUnionOfIntegerRangeType(@NotNull AvailObject self, @NotNull A_Type anIntegerRangeType) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anIntegerRangeType, "anIntegerRangeType");
        A_Number minObject = self.get(ObjectSlots.LOWER_BOUND);
        boolean isMinInc = this.lowerInclusive;
        if (A_Type.Companion.getLowerBound(anIntegerRangeType).equals(minObject)) {
            isMinInc = isMinInc || A_Type.Companion.getLowerInclusive(anIntegerRangeType);
        } else if (A_Number.Companion.lessThan(A_Type.Companion.getLowerBound(anIntegerRangeType), minObject)) {
            minObject = A_Type.Companion.getLowerBound(anIntegerRangeType);
            isMinInc = A_Type.Companion.getLowerInclusive(anIntegerRangeType);
        }
        A_Number maxObject = self.get(ObjectSlots.UPPER_BOUND);
        boolean isMaxInc = this.upperInclusive;
        if (A_Type.Companion.getUpperBound(anIntegerRangeType).equals(maxObject)) {
            isMaxInc = isMaxInc || A_Type.Companion.getUpperInclusive(anIntegerRangeType);
        } else if (A_Number.Companion.lessThan(maxObject, A_Type.Companion.getUpperBound(anIntegerRangeType))) {
            maxObject = A_Type.Companion.getUpperBound(anIntegerRangeType);
            isMaxInc = A_Type.Companion.getUpperInclusive(anIntegerRangeType);
        }
        return Companion.integerRangeType(minObject, isMinInc, maxObject, isMaxInc);
    }

    @Override
    @NotNull
    public A_Type o_TypeUnionOfPrimitiveTypeEnum(@NotNull AvailObject self, @NotNull PrimitiveTypeDescriptor.Types primitiveTypeEnum) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter((Object)primitiveTypeEnum, "primitiveTypeEnum");
        A_Type a_Type = PrimitiveTypeDescriptor.Types.NUMBER.getUnionTypes()[primitiveTypeEnum.ordinal()];
        Intrinsics.checkNotNull(a_Type);
        return a_Type;
    }

    @Override
    @NotNull
    public A_Number o_UpperBound(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.get(ObjectSlots.UPPER_BOUND);
    }

    @Override
    public boolean o_UpperInclusive(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return this.upperInclusive;
    }

    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(writer, "writer");
        writer.startObject();
        writer.write("kind");
        writer.write("integer type");
        writer.write("lower bound");
        self.get(ObjectSlots.LOWER_BOUND).writeTo(writer);
        writer.write("upper bound");
        self.get(ObjectSlots.UPPER_BOUND).writeTo(writer);
        writer.endObject();
    }

    @Override
    @NotNull
    public AbstractDescriptor mutable() {
        return IntegerRangeTypeDescriptor.Companion.lookupDescriptor(Mutability.MUTABLE, this.lowerInclusive, this.upperInclusive);
    }

    @Override
    @NotNull
    public AbstractDescriptor immutable() {
        return IntegerRangeTypeDescriptor.Companion.lookupDescriptor(Mutability.IMMUTABLE, this.lowerInclusive, this.upperInclusive);
    }

    @Override
    @NotNull
    public AbstractDescriptor shared() {
        return IntegerRangeTypeDescriptor.Companion.lookupDescriptor(Mutability.SHARED, this.lowerInclusive, this.upperInclusive);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_6;
        int n;
        Companion = new Companion(null);
        EnumMap.Companion this_$iv = EnumMap.Companion;
        boolean $i$f$enumMap = false;
        Enum[] keys$iv = (Enum[])Mutability.class.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(keys$iv, "keys");
        EnumMap map$iv = new EnumMap(keys$iv);
        Enum[] $this$forEach$iv$iv = keys$iv;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            Enum element$iv$iv;
            Enum key$iv = element$iv$iv = $this$forEach$iv$iv[n];
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(key$iv, "key");
            Mutability mutability = (Mutability)key$iv;
            boolean bl2 = false;
            IntegerRangeTypeDescriptor[] integerRangeTypeDescriptorArray = new IntegerRangeTypeDescriptor[4];
            for (int j = 0; j < 4; ++j) {
                int n3 = j;
                integerRangeTypeDescriptorArray[n3] = new IntegerRangeTypeDescriptor(mutability, (n3 & 1) != 0, (n3 & 2) != 0);
            }
            IntegerRangeTypeDescriptor[] value$iv = integerRangeTypeDescriptorArray;
            boolean bl3 = false;
            map$iv.set(key$iv, value$iv);
        }
        descriptors = var3_6;
        A_Type[][] a_TypeArrayArray = new A_Type[20][];
        for (int j = 0; j < 20; ++j) {
            int n4 = j;
            int n5 = 0;
            int n6 = n4 + 1;
            A_Type[] a_TypeArray = new A_Type[n6];
            int n7 = n4;
            A_Type[][] a_TypeArrayArray2 = a_TypeArrayArray;
            while (n5 < n6) {
                void $this$smallRanges_u24lambda_u241;
                n = n5++;
                AbstractDescriptor $this$iv = IntegerRangeTypeDescriptor.Companion.lookupDescriptor(Mutability.MUTABLE, true, true);
                int indexedSlotCount$iv = 0;
                boolean $i$f$createShared = false;
                AvailObject $this$createShared_u24lambda_u245$iv = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, $this$iv);
                boolean bl = false;
                AvailObject bl2 = $this$createShared_u24lambda_u245$iv;
                int n8 = n;
                A_Type[] a_TypeArray2 = a_TypeArray;
                boolean bl4 = false;
                $this$smallRanges_u24lambda_u241.setSlot(ObjectSlots.UPPER_BOUND, IntegerDescriptor.Companion.fromInt(n4));
                $this$smallRanges_u24lambda_u241.setSlot(ObjectSlots.LOWER_BOUND, IntegerDescriptor.Companion.fromInt(n));
                Unit unit = Unit.INSTANCE;
                a_TypeArray2[n8] = $this$createShared_u24lambda_u245$iv.makeShared();
            }
            a_TypeArrayArray2[n7] = a_TypeArray;
        }
        smallRanges = a_TypeArrayArray;
        bytes = Companion.inclusive(0L, 255L).makeShared();
        characterCodePoints = Companion.inclusive(0L, 0x10FFFFL).makeShared();
        extendedIntegers = Companion.inclusive(InfinityDescriptor.Companion.getNegativeInfinity(), InfinityDescriptor.Companion.getPositiveInfinity()).makeShared();
        integers = Companion.integerRangeType(InfinityDescriptor.Companion.getNegativeInfinity(), false, InfinityDescriptor.Companion.getPositiveInfinity(), false).makeShared();
        naturalNumbers = Companion.integerRangeType(IntegerDescriptor.Companion.getOne(), true, InfinityDescriptor.Companion.getPositiveInfinity(), false).makeShared();
        nybbles = Companion.inclusive(0L, 15L).makeShared();
        unsignedShorts = Companion.inclusive(0L, 65535L).makeShared();
        wholeNumbers = Companion.integerRangeType(IntegerDescriptor.Companion.getZero(), true, InfinityDescriptor.Companion.getPositiveInfinity(), false).makeShared();
        int32 = Companion.inclusive(Integer.MIN_VALUE, Integer.MAX_VALUE).makeShared();
        nonnegativeInt32 = Companion.inclusive(0L, Integer.MAX_VALUE).makeShared();
        int64 = Companion.inclusive(Long.MIN_VALUE, Long.MAX_VALUE).makeShared();
        extendedIntegersMeta = InstanceMetaDescriptor.Companion.instanceMeta(extendedIntegers).makeShared();
        zeroOrOne = smallRanges[1][0];
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/types/IntegerRangeTypeDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "LOWER_BOUND", "UPPER_BOUND", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots LOWER_BOUND = new ObjectSlots();
        public static final /* enum */ ObjectSlots UPPER_BOUND = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.LOWER_BOUND, ObjectSlots.UPPER_BOUND};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J\u0016\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200J\u0016\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u0002022\u0006\u00101\u001a\u000202J&\u00103\u001a\u00020\u00042\u0006\u0010/\u001a\u0002002\u0006\u0010+\u001a\u00020,2\u0006\u00101\u001a\u0002002\u0006\u0010-\u001a\u00020,J \u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J\u000e\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u001fJ\u000e\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u000200R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u0011\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0006R\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0006R\u0011\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0006R\u0011\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0006R\u0011\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0006R\u0011\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0006R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u0011\u0010\"\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0006R\u0011\u0010$\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0006R\u0011\u0010&\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0006\u00a8\u0006:"}, d2={"Lavail/descriptor/types/IntegerRangeTypeDescriptor$Companion;", "", "()V", "bytes", "Lavail/descriptor/types/A_Type;", "getBytes", "()Lavail/descriptor/types/A_Type;", "characterCodePoints", "getCharacterCodePoints", "descriptors", "Lavail/utility/structures/EnumMap;", "Lavail/descriptor/representation/Mutability;", "", "Lavail/descriptor/types/IntegerRangeTypeDescriptor;", "extendedIntegers", "getExtendedIntegers", "extendedIntegersMeta", "getExtendedIntegersMeta", "int32", "getInt32", "int64", "getInt64", "integers", "getIntegers", "naturalNumbers", "getNaturalNumbers", "nonnegativeInt32", "getNonnegativeInt32", "nybbles", "getNybbles", "smallRangeLimit", "", "smallRanges", "[[Lavail/descriptor/types/A_Type;", "unsignedShorts", "getUnsignedShorts", "wholeNumbers", "getWholeNumbers", "zeroOrOne", "getZeroOrOne", "computeHash", "lowerBoundHash", "upperBoundHash", "lowerInclusive", "", "upperInclusive", "inclusive", "lowerBound", "Lavail/descriptor/numbers/A_Number;", "upperBound", "", "integerRangeType", "lookupDescriptor", "mutability", "singleInt", "anInt", "singleInteger", "integerObject", "avail"})
    public static final class Companion {
        private Companion() {
        }

        private final int computeHash(int lowerBoundHash, int upperBoundHash, boolean lowerInclusive, boolean upperInclusive) {
            int flagsHash = lowerInclusive && upperInclusive ? 352519262 : (lowerInclusive ? 1966763031 : (upperInclusive ? 498259793 : 288375421));
            return AvailObject.Companion.combine3(lowerBoundHash, upperBoundHash, flagsHash);
        }

        @NotNull
        public final A_Type singleInteger(@NotNull A_Number integerObject) {
            Intrinsics.checkNotNullParameter(integerObject, "integerObject");
            integerObject.makeImmutable();
            return this.integerRangeType(integerObject, true, integerObject, true);
        }

        @NotNull
        public final A_Type singleInt(int anInt) {
            A_Number integerObject = IntegerDescriptor.Companion.fromInt(anInt).makeImmutable();
            return this.integerRangeType(integerObject, true, integerObject, true);
        }

        @NotNull
        public final A_Type integerRangeType(@NotNull A_Number lowerBound, boolean lowerInclusive, @NotNull A_Number upperBound, boolean upperInclusive) {
            AvailObject availObject;
            Intrinsics.checkNotNullParameter(lowerBound, "lowerBound");
            Intrinsics.checkNotNullParameter(upperBound, "upperBound");
            if (lowerBound.sameAddressAs(upperBound) && lowerBound.descriptor().isMutable()) {
                AvailObject.Companion.error("Don't plug in a mutable object as two distinct construction parameters", new Object[0]);
                throw new KotlinNothingValueException();
            }
            A_Number low = null;
            low = lowerBound;
            boolean lowInc = lowerInclusive;
            if (!lowInc && low.isFinite()) {
                low = A_Number.Companion.noFailPlusCanDestroy(low, IntegerDescriptor.Companion.getOne(), false);
                lowInc = true;
            }
            A_Number high = null;
            high = upperBound;
            boolean highInc = upperInclusive;
            if (!highInc && high.isFinite()) {
                high = A_Number.Companion.noFailMinusCanDestroy(high, IntegerDescriptor.Companion.getOne(), false);
                highInc = true;
            }
            if (A_Number.Companion.lessThan(high, low)) {
                return BottomTypeDescriptor.Companion.getBottom();
            }
            if (!(!high.equals(low) || highInc && lowInc)) {
                return BottomTypeDescriptor.Companion.getBottom();
            }
            if (A_Number.Companion.isInt(low) && A_Number.Companion.isInt(high)) {
                boolean bl;
                boolean bl2 = bl = lowInc && highInc;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                int lowInt = A_Number.Companion.getExtractInt(low);
                int highInt = A_Number.Companion.getExtractInt(high);
                boolean bl3 = 0 <= lowInt ? lowInt < 20 : false;
                if (bl3) {
                    boolean bl4 = 0 <= highInt ? highInt < 20 : false;
                    if (bl4) {
                        return smallRanges[highInt][lowInt];
                    }
                }
            }
            AbstractDescriptor $this$iv = this.lookupDescriptor(Mutability.MUTABLE, lowInc, highInc);
            int indexedSlotCount$iv = 0;
            boolean $i$f$create = false;
            AvailObject $this$integerRangeType_u24lambda_u240 = availObject = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, $this$iv);
            boolean bl = false;
            $this$integerRangeType_u24lambda_u240.setSlot(ObjectSlots.LOWER_BOUND, low);
            $this$integerRangeType_u24lambda_u240.setSlot(ObjectSlots.UPPER_BOUND, high);
            return availObject;
        }

        @NotNull
        public final A_Type inclusive(@NotNull A_Number lowerBound, @NotNull A_Number upperBound) {
            Intrinsics.checkNotNullParameter(lowerBound, "lowerBound");
            Intrinsics.checkNotNullParameter(upperBound, "upperBound");
            return this.integerRangeType(lowerBound, true, upperBound, true);
        }

        @NotNull
        public final A_Type inclusive(long lowerBound, long upperBound) {
            return this.integerRangeType(IntegerDescriptor.Companion.fromLong(lowerBound), true, IntegerDescriptor.Companion.fromLong(upperBound), true);
        }

        private final IntegerRangeTypeDescriptor lookupDescriptor(Mutability mutability, boolean lowerInclusive, boolean upperInclusive) {
            int subscript = (lowerInclusive ? 1 : 0) | (upperInclusive ? 2 : 0);
            Object v = descriptors.get((Object)mutability);
            Intrinsics.checkNotNull(v);
            return ((IntegerRangeTypeDescriptor[])v)[subscript];
        }

        @NotNull
        public final A_Type getBytes() {
            return bytes;
        }

        @NotNull
        public final A_Type getCharacterCodePoints() {
            return characterCodePoints;
        }

        @NotNull
        public final A_Type getExtendedIntegers() {
            return extendedIntegers;
        }

        @NotNull
        public final A_Type getIntegers() {
            return integers;
        }

        @NotNull
        public final A_Type getNaturalNumbers() {
            return naturalNumbers;
        }

        @NotNull
        public final A_Type getNybbles() {
            return nybbles;
        }

        @NotNull
        public final A_Type getUnsignedShorts() {
            return unsignedShorts;
        }

        @NotNull
        public final A_Type getWholeNumbers() {
            return wholeNumbers;
        }

        @NotNull
        public final A_Type getInt32() {
            return int32;
        }

        @NotNull
        public final A_Type getNonnegativeInt32() {
            return nonnegativeInt32;
        }

        @NotNull
        public final A_Type getInt64() {
            return int64;
        }

        @NotNull
        public final A_Type getExtendedIntegersMeta() {
            return extendedIntegersMeta;
        }

        @NotNull
        public final A_Type getZeroOrOne() {
            return zeroOrOne;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

