/*
 * Decompiled with CFR 0.152.
 */
package avail.files;

import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.StringDescriptor;
import avail.error.ErrorCode;
import avail.files.AbstractAvailTextFile;
import avail.files.AbstractFileWrapper;
import avail.files.AvailFile;
import avail.files.EditRange;
import avail.files.FileAction;
import avail.files.FileErrorCode;
import avail.files.TracedAction;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016J \u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lavail/files/AvailModuleFile;", "Lavail/files/AbstractAvailTextFile;", "fileWrapper", "Lavail/files/AbstractFileWrapper;", "charset", "Ljava/nio/charset/Charset;", "(Lavail/files/AbstractFileWrapper;Ljava/nio/charset/Charset;)V", "raw", "", "([BLavail/files/AbstractFileWrapper;Ljava/nio/charset/Charset;)V", "<set-?>", "Lavail/descriptor/tuples/A_String;", "content", "getContent", "()Lavail/descriptor/tuples/A_String;", "rawContent", "getRawContent", "()[B", "editRange", "Lavail/files/TracedAction;", "data", "start", "", "end", "timestamp", "", "originator", "Ljava/util/UUID;", "getSavableContent", "replaceFile", "avail"})
public final class AvailModuleFile
extends AbstractAvailTextFile {
    private A_String content;

    @NotNull
    public final A_String getContent() {
        A_String a_String = this.content;
        if (a_String != null) {
            return a_String;
        }
        Intrinsics.throwUninitializedPropertyAccessException("content");
        return null;
    }

    @Override
    @NotNull
    public byte[] getRawContent() {
        String string2 = A_String.Companion.asNativeString(this.getContent());
        Charset charset = StandardCharsets.UTF_16BE;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_16BE");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @Override
    @NotNull
    public byte[] getSavableContent() {
        String string2 = A_String.Companion.asNativeString(this.getContent());
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    public AvailModuleFile(final @NotNull AbstractFileWrapper fileWrapper, final @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(fileWrapper, "fileWrapper");
        Intrinsics.checkNotNullParameter(charset, "charset");
        super(charset, fileWrapper);
        fileWrapper.getReference().readFileBytes(true, (Function2<? super byte[], ? super UUID, Unit>)new Function2<byte[], UUID, Unit>(){

            @Override
            public final void invoke(@NotNull byte[] bytes2, @Nullable UUID uUID) {
                Intrinsics.checkNotNullParameter(bytes2, "bytes");
                CharsetDecoder decoder = charset.newDecoder();
                decoder.onMalformedInput(CodingErrorAction.REPLACE);
                decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
                try {
                    String string2 = decoder.decode(ByteBuffer.wrap(bytes2)).toString();
                    Intrinsics.checkNotNullExpressionValue(string2, "decoder.decode(ByteBuffer.wrap(bytes)).toString()");
                    content = StringDescriptor.Companion.stringWithSurrogatesFrom(string2);
                }
                catch (CharacterCodingException e) {
                    System.err.println("Attempted to decode bytes from supposed module file " + fileWrapper.getReference().getUri());
                    e.printStackTrace();
                    fileWrapper.notifyOpenFailure(FileErrorCode.DECODER_FAILURE, e);
                    return;
                }
                catch (Throwable e) {
                    System.err.println("Attempted to decode bytes from supposed module file " + fileWrapper.getReference().getUri());
                    e.printStackTrace();
                    fileWrapper.notifyOpenFailure(FileErrorCode.UNSPECIFIED, e);
                    return;
                }
                fileWrapper.notifyReady();
            }
        }, (Function2<? super ErrorCode, ? super Throwable, Unit>)new Function2<ErrorCode, Throwable, Unit>(){

            @Override
            public final void invoke(@NotNull ErrorCode code, @Nullable Throwable ex) {
                Intrinsics.checkNotNullParameter(code, "code");
                System.err.println("Received ErrorCode: " + code + " while attempting read file: " + fileWrapper.getReference().getUri() + " with exception:\n");
                Throwable throwable = ex;
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                fileWrapper.notifyOpenFailure(code, ex);
            }
        });
    }

    public /* synthetic */ AvailModuleFile(AbstractFileWrapper abstractFileWrapper, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        this(abstractFileWrapper, charset);
    }

    public AvailModuleFile(@NotNull byte[] raw, @NotNull AbstractFileWrapper fileWrapper, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(raw, "raw");
        Intrinsics.checkNotNullParameter(fileWrapper, "fileWrapper");
        Intrinsics.checkNotNullParameter(charset, "charset");
        super(charset, fileWrapper);
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        try {
            String string2 = decoder.decode(ByteBuffer.wrap(raw)).toString();
            Intrinsics.checkNotNullExpressionValue(string2, "decoder.decode(ByteBuffer.wrap(raw)).toString()");
            this.content = StringDescriptor.Companion.stringWithSurrogatesFrom(string2);
        }
        catch (CharacterCodingException e) {
            System.err.println("Attempted to decode bytes from supposed module file " + fileWrapper.getReference().getUri());
            e.printStackTrace();
            fileWrapper.notifyOpenFailure(FileErrorCode.DECODER_FAILURE, e);
            return;
        }
        catch (Throwable e) {
            System.err.println("Attempted to decode bytes from supposed module file " + fileWrapper.getReference().getUri());
            e.printStackTrace();
            fileWrapper.notifyOpenFailure(FileErrorCode.UNSPECIFIED, e);
            return;
        }
        fileWrapper.notifyReady();
    }

    public /* synthetic */ AvailModuleFile(byte[] byArray, AbstractFileWrapper abstractFileWrapper, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        this(byArray, abstractFileWrapper, charset);
    }

    @Override
    @NotNull
    public TracedAction replaceFile(@NotNull byte[] data2, long timestamp, @NotNull UUID originator) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(originator, "originator");
        return AvailFile.editRange$default(this, data2, 0, A_Tuple.Companion.getTupleSize(this.getContent()), 0L, originator, 8, null);
    }

    @Override
    @NotNull
    public TracedAction editRange(@NotNull byte[] data2, int start, int end, long timestamp, @NotNull UUID originator) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(originator, "originator");
        A_String text = StringDescriptor.Companion.stringWithSurrogatesFrom(new String(data2, Charsets.UTF_16BE));
        A_String removed = A_String.Companion.copyStringFromToCanDestroy(this.getContent(), start + 1, end, false);
        A_String first = A_String.Companion.copyStringFromToCanDestroy(this.getContent(), 1, start, false);
        A_String third = A_String.Companion.copyStringFromToCanDestroy(this.getContent(), end + 1, A_Tuple.Companion.getTupleSize(this.getContent()), false);
        this.content = (A_String)A_Tuple.Companion.concatenate(A_Tuple.Companion.concatenate((A_Tuple)first, (A_Tuple)text, false), (A_Tuple)third, false);
        this.markDirty();
        FileAction fileAction = new EditRange(data2, start, end);
        byte[] byArray = A_String.Companion.asNativeString(removed).getBytes(Charsets.UTF_16BE);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        return new TracedAction(timestamp, originator, fileAction, new EditRange(byArray, start, start + A_Tuple.Companion.getTupleSize(text)));
    }
}

