/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo;

import avail.AvailRuntime;
import avail.AvailRuntimeSupport;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.pojos.RawPojoDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2AbstractInstruction;
import avail.interpreter.levelTwo.L2Chunk;
import avail.interpreter.levelTwo.L2JVMChunk;
import avail.optimizer.ExecutableChunk;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 62\u00020\u0001:\u0003678B!\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0005J\b\u0010/\u001a\u000200H&J\u000e\u00101\u001a\u00020-2\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000200J\b\u00105\u001a\u000200H\u0016R\u0017\u0010\t\u001a\u00020\n\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR \u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R%\u0010&\u001a\u0010\u0012\f\u0012\n (*\u0004\u0018\u00010\u00000\u00000'\u00a2\u0006\u000e\n\u0000\u0012\u0004\b)\u0010\f\u001a\u0004\b*\u0010+\u00a8\u00069"}, d2={"Lavail/interpreter/levelTwo/L2Chunk;", "", "code", "Lavail/descriptor/functions/A_RawFunction;", "offsetAfterInitialTryPrimitive", "", "contingentValues", "Lavail/descriptor/sets/A_Set;", "(Lavail/descriptor/functions/A_RawFunction;ILavail/descriptor/sets/A_Set;)V", "chunkPojo", "Lavail/descriptor/representation/AvailObject;", "getChunkPojo$annotations", "()V", "getChunkPojo", "()Lavail/descriptor/representation/AvailObject;", "getCode", "()Lavail/descriptor/functions/A_RawFunction;", "executableChunk", "Lavail/optimizer/ExecutableChunk;", "getExecutableChunk", "()Lavail/optimizer/ExecutableChunk;", "generation", "Lavail/interpreter/levelTwo/L2Chunk$Generation;", "getGeneration", "()Lavail/interpreter/levelTwo/L2Chunk$Generation;", "setGeneration", "(Lavail/interpreter/levelTwo/L2Chunk$Generation;)V", "instructions", "", "Lavail/interpreter/levelTwo/L2AbstractInstruction;", "getInstructions", "()Ljava/util/List;", "<set-?>", "", "isValid", "()Z", "getOffsetAfterInitialTryPrimitive", "()I", "weakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "getWeakReference$annotations", "getWeakReference", "()Ljava/lang/ref/WeakReference;", "beforeRunChunk", "", "offset", "dumpChunk", "", "invalidate", "reason", "Lavail/interpreter/levelTwo/L2Chunk$InvalidationReason;", "name", "toString", "Companion", "Generation", "InvalidationReason", "avail"})
public abstract class L2Chunk {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final A_RawFunction code;
    private final int offsetAfterInitialTryPrimitive;
    @NotNull
    private A_Set contingentValues;
    @NotNull
    private final WeakReference<L2Chunk> weakReference;
    @Nullable
    private volatile Generation generation;
    private boolean isValid;
    @NotNull
    private final AvailObject chunkPojo;
    public static final long decrementForPolledActiveCode = 1000L;
    @NotNull
    private static final ReentrantLock invalidationLock = new ReentrantLock();

    protected L2Chunk(@Nullable A_RawFunction code, int offsetAfterInitialTryPrimitive, @NotNull A_Set contingentValues) {
        Intrinsics.checkNotNullParameter(contingentValues, "contingentValues");
        this.code = code;
        this.offsetAfterInitialTryPrimitive = offsetAfterInitialTryPrimitive;
        this.contingentValues = contingentValues;
        this.weakReference = new WeakReference<L2Chunk>(this);
        this.generation = Generation.Companion.getNewest();
        this.isValid = true;
        this.chunkPojo = RawPojoDescriptor.Companion.identityPojo(this).makeShared();
    }

    @Nullable
    public final A_RawFunction getCode() {
        return this.code;
    }

    public final int getOffsetAfterInitialTryPrimitive() {
        return this.offsetAfterInitialTryPrimitive;
    }

    @NotNull
    public abstract ExecutableChunk getExecutableChunk();

    @NotNull
    public abstract List<L2AbstractInstruction> getInstructions();

    @NotNull
    public final WeakReference<L2Chunk> getWeakReference() {
        return this.weakReference;
    }

    public static /* synthetic */ void getWeakReference$annotations() {
    }

    @Nullable
    public final Generation getGeneration() {
        return this.generation;
    }

    public final void setGeneration(@Nullable Generation generation) {
        this.generation = generation;
    }

    @ReferencedInGeneratedCode
    public final boolean isValid() {
        return this.isValid;
    }

    @NotNull
    public final AvailObject getChunkPojo() {
        return this.chunkPojo;
    }

    public static /* synthetic */ void getChunkPojo$annotations() {
    }

    @NotNull
    public final String name() {
        return Companion.name(this.code);
    }

    @NotNull
    public String toString() {
        if (Intrinsics.areEqual(this, L2JVMChunk.Companion.getUnoptimizedChunk())) {
            return "Default chunk";
        }
        StringBuilder builder = new StringBuilder();
        if (!this.isValid) {
            builder.append("[INVALID] ");
        }
        String string2 = "Chunk #%08x";
        Object[] objectArray = new Object[]{System.identityHashCode(this)};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
        builder.append(string3);
        A_RawFunction a_RawFunction = this.code;
        if (a_RawFunction != null) {
            A_RawFunction $this$toString_u24lambda_u240 = a_RawFunction;
            boolean bl = false;
            builder.append(" for " + A_RawFunction.Companion.getMethodName($this$toString_u24lambda_u240));
        }
        String string4 = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "builder.toString()");
        return string4;
    }

    public final void beforeRunChunk(int offset) {
        if (Interpreter.Companion.getDebugL2()) {
            Logger logger = Interpreter.Companion.getLoggerDebugL2();
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue(level, "INFO");
            Object[] objectArray = new Object[]{this.name(), offset};
            Interpreter.Companion.log(logger, level, "Running chunk {0} at offset {1}.", objectArray);
        }
    }

    public final void invalidate(@NotNull InvalidationReason reason) {
        Intrinsics.checkNotNullParameter((Object)reason, "reason");
        long before = AvailRuntimeSupport.INSTANCE.captureNanos();
        boolean bl = invalidationLock.isHeldByCurrentThread();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailRuntime.Companion.currentRuntime().assertInSafePoint();
        boolean bl2 = bl = this != L2JVMChunk.Companion.getUnoptimizedChunk();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        this.isValid = false;
        A_Set contingents = this.contingentValues.makeImmutable();
        this.contingentValues = SetDescriptor.Companion.getEmptySet();
        for (AvailObject value : contingents) {
            value.removeDependentChunk(this);
        }
        A_RawFunction a_RawFunction = this.code;
        if (a_RawFunction != null) {
            A_RawFunction.Companion.setStartingChunkAndReoptimizationCountdown(a_RawFunction, L2JVMChunk.Companion.getUnoptimizedChunk(), reason.getCountdownToNextOptimization());
        }
        Generation.Companion.removeInvalidatedChunk(this);
        long after = AvailRuntimeSupport.INSTANCE.captureNanos();
        reason.getStatistic().record(after - before, 0);
    }

    @NotNull
    public abstract String dumpChunk();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016RJ\u0010\u0003\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u0005 \u0007*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u0005\u0018\u00010\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lavail/interpreter/levelTwo/L2Chunk$Generation;", "", "()V", "chunks", "", "Ljava/lang/ref/WeakReference;", "Lavail/interpreter/levelTwo/L2Chunk;", "kotlin.jvm.PlatformType", "", "toString", "", "Companion", "avail"})
    public static final class Generation {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final Set<WeakReference<L2Chunk>> chunks = Collections.synchronizedSet(new HashSet());
        @GuardedBy(value="generationsLock")
        @NotNull
        private static final Deque<Generation> generations = new ArrayDeque();
        @NotNull
        private static final ReentrantReadWriteLock generationsLock = new ReentrantReadWriteLock();
        @NotNull
        private static volatile Generation newest = new Generation();
        private static final int maximumNewestGenerationSize = 1000;
        private static final int maximumTotalChunkCount = 10000;

        @NotNull
        public String toString() {
            return super.toString() + " (size=" + this.chunks.size() + ")";
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/levelTwo/L2Chunk$Generation$Companion;", "", "()V", "generations", "Ljava/util/Deque;", "Lavail/interpreter/levelTwo/L2Chunk$Generation;", "generationsLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "maximumNewestGenerationSize", "", "maximumTotalChunkCount", "newest", "getNewest", "()Lavail/interpreter/levelTwo/L2Chunk$Generation;", "setNewest", "(Lavail/interpreter/levelTwo/L2Chunk$Generation;)V", "addNewChunk", "", "newChunk", "Lavail/interpreter/levelTwo/L2Chunk;", "removeInvalidatedChunk", "chunk", "usedChunk", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Generation getNewest() {
                return newest;
            }

            public final void setNewest(@NotNull Generation generation) {
                Intrinsics.checkNotNullParameter(generation, "<set-?>");
                newest = generation;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void addNewChunk(@NotNull L2Chunk newChunk) {
                Intrinsics.checkNotNullParameter(newChunk, "newChunk");
                newChunk.setGeneration(this.getNewest());
                this.getNewest().chunks.add(newChunk.getWeakReference());
                if (this.getNewest().chunks.size() > 1000) {
                    ReentrantReadWriteLock $this$safeWrite$iv = generationsLock;
                    boolean $i$f$safeWrite = false;
                    ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                    Intrinsics.checkNotNullExpressionValue(writeLock, "this.writeLock()");
                    Lock lock = writeLock;
                    lock.lock();
                    try {
                        void $this$filterTo$iv$iv;
                        boolean bl = false;
                        Generation lastGenerationToKeep = Companion.getNewest();
                        generations.addFirst(Companion.getNewest());
                        Companion.setNewest(new Generation());
                        int liveCount = 0;
                        for (Generation gen : generations) {
                            Intrinsics.checkNotNullExpressionValue(gen, "gen");
                            int genSize = gen.chunks.size();
                            if ((liveCount += genSize) >= 10000) break;
                            lastGenerationToKeep = gen;
                        }
                        List chunksToInvalidate = new ArrayList();
                        while (generations.getLast() != lastGenerationToKeep) {
                            Object e = generations.removeLast();
                            Intrinsics.checkNotNullExpressionValue(e, "generations.removeLast()");
                            Set set2 = ((Generation)e).chunks;
                            Intrinsics.checkNotNullExpressionValue(set2, "generations.removeLast().chunks");
                            chunksToInvalidate.addAll(set2);
                        }
                        Iterable $this$filter$iv = generations;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Generation it = (Generation)element$iv$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNullExpressionValue(it, "it");
                            Set set3 = it.chunks;
                            Intrinsics.checkNotNullExpressionValue(set3, "it.chunks");
                            boolean bl3 = !((Collection)set3).isEmpty();
                            if (!bl3) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List toKeep = (List)destination$iv$iv;
                        generations.clear();
                        generations.addAll(toKeep);
                        if (!((Collection)chunksToInvalidate).isEmpty()) {
                            AvailRuntime.Companion.currentRuntime().whenSafePointDo(90, new Function0<Unit>((List<WeakReference<L2Chunk>>)chunksToInvalidate){
                                final /* synthetic */ List<WeakReference<L2Chunk>> $chunksToInvalidate;
                                {
                                    this.$chunksToInvalidate = $chunksToInvalidate;
                                    super(0);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public final void invoke() {
                                    Lock lock = L2Chunk.Companion.getInvalidationLock();
                                    List<WeakReference<L2Chunk>> list2 = this.$chunksToInvalidate;
                                    lock.lock();
                                    try {
                                        boolean bl = false;
                                        Iterable $this$forEach$iv = list2;
                                        boolean $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            WeakReference it = (WeakReference)element$iv;
                                            boolean bl2 = false;
                                            L2Chunk l2Chunk = (L2Chunk)it.get();
                                            if (l2Chunk == null) continue;
                                            l2Chunk.invalidate(InvalidationReason.EVICTION);
                                        }
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    finally {
                                        lock.unlock();
                                    }
                                }
                            });
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void usedChunk(@NotNull L2Chunk chunk) {
                Intrinsics.checkNotNullParameter(chunk, "chunk");
                Generation theNewest = this.getNewest();
                Generation oldGen = chunk.getGeneration();
                if (oldGen == theNewest) {
                    return;
                }
                Generation generation = oldGen;
                if (generation != null) {
                    Generation $this$usedChunk_u24lambda_u242 = generation;
                    boolean bl = false;
                    $this$usedChunk_u24lambda_u242.chunks.remove(chunk.getWeakReference());
                }
                theNewest.chunks.add(chunk.getWeakReference());
                chunk.setGeneration(theNewest);
                if (theNewest.chunks.size() > 1000) {
                    ReentrantReadWriteLock $this$safeWrite$iv = generationsLock;
                    boolean $i$f$safeWrite = false;
                    ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                    Intrinsics.checkNotNullExpressionValue(writeLock, "this.writeLock()");
                    Lock lock = writeLock;
                    lock.lock();
                    try {
                        boolean bl = false;
                        if (Intrinsics.areEqual(theNewest, Companion.getNewest())) {
                            generations.add(Companion.getNewest());
                            Companion.setNewest(new Generation());
                            if (generations.size() > 10000) {
                                generations.removeIf(arg_0 -> Companion.usedChunk$lambda$4$lambda$3(usedChunk.2.1.INSTANCE, arg_0));
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }

            public final void removeInvalidatedChunk(@NotNull L2Chunk chunk) {
                block0: {
                    Intrinsics.checkNotNullParameter(chunk, "chunk");
                    Generation generation = chunk.getGeneration();
                    if (generation == null) break block0;
                    Generation it = generation;
                    boolean bl = false;
                    it.chunks.remove(chunk.getWeakReference());
                    chunk.setGeneration(null);
                }
            }

            private static final boolean usedChunk$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lavail/interpreter/levelTwo/L2Chunk$InvalidationReason;", "", "countdownToNextOptimization", "", "(Ljava/lang/String;IJ)V", "getCountdownToNextOptimization", "()J", "statistic", "Lavail/performance/Statistic;", "getStatistic", "()Lavail/performance/Statistic;", "DEPENDENCY_CHANGED", "EVICTION", "CODE_COVERAGE", "avail"})
    public static final class InvalidationReason
    extends Enum<InvalidationReason> {
        private final long countdownToNextOptimization;
        @NotNull
        private final Statistic statistic;
        public static final /* enum */ InvalidationReason DEPENDENCY_CHANGED = new InvalidationReason(200L);
        public static final /* enum */ InvalidationReason EVICTION = new InvalidationReason(20000L);
        public static final /* enum */ InvalidationReason CODE_COVERAGE = new InvalidationReason(200L);
        private static final /* synthetic */ InvalidationReason[] $VALUES;

        private InvalidationReason(long countdownToNextOptimization) {
            this.countdownToNextOptimization = countdownToNextOptimization;
            this.statistic = new Statistic(StatisticReport.L2_OPTIMIZATION_TIME, "(invalidation from " + this.name() + ")");
        }

        public final long getCountdownToNextOptimization() {
            return this.countdownToNextOptimization;
        }

        @NotNull
        public final Statistic getStatistic() {
            return this.statistic;
        }

        public static InvalidationReason[] values() {
            return (InvalidationReason[])$VALUES.clone();
        }

        public static InvalidationReason valueOf(String value) {
            return Enum.valueOf(InvalidationReason.class, value);
        }

        static {
            $VALUES = invalidationReasonArray = new InvalidationReason[]{InvalidationReason.DEPENDENCY_CHANGED, InvalidationReason.EVICTION, InvalidationReason.CODE_COVERAGE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lavail/interpreter/levelTwo/L2Chunk$Companion;", "", "()V", "decrementForPolledActiveCode", "", "invalidationLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getInvalidationLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "name", "", "code", "Lavail/descriptor/functions/A_RawFunction;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String name(@Nullable A_RawFunction code) {
            Object object = code;
            if (object == null || (object = A_RawFunction.Companion.getMethodName((A_RawFunction)object)) == null || (object = A_String.Companion.asNativeString((A_String)object)) == null) {
                object = "\u00abdefault\u00bb";
            }
            return object;
        }

        @NotNull
        public final ReentrantLock getInvalidationLock() {
            return invalidationLock;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

