/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.character.A_Character;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ByteStringDescriptor;
import avail.descriptor.tuples.ByteTupleDescriptor;
import avail.descriptor.tuples.IntTupleDescriptor;
import avail.descriptor.tuples.LongTupleDescriptor;
import avail.descriptor.tuples.NybbleTupleDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.tuples.TwoByteStringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2Generator;
import avail.optimizer.jvm.JVMTranslator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u001e"}, d2={"Lavail/interpreter/levelTwo/operation/L2_CREATE_TUPLE;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "extractTupleElement", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "tupleReg", "index", "", "generator", "Lavail/optimizer/L2Generator;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "tupleSourceRegistersOf", "", "avail"})
public final class L2_CREATE_TUPLE
extends L2Operation {
    @NotNull
    public static final L2_CREATE_TUPLE INSTANCE = new L2_CREATE_TUPLE();

    private L2_CREATE_TUPLE() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_BOXED_VECTOR.named("elements"), L2OperandType.WRITE_BOXED.named("tuple")};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, "desiredTypes");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, "warningStyleChange");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedVectorOperand values2 = (L2ReadBoxedVectorOperand)instruction2.operand(0);
        L2WriteBoxedOperand tuple2 = (L2WriteBoxedOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder);
        builder.append(' ');
        builder.append(tuple2.registerString());
        builder.append(" \u2190 ");
        builder.append(values2.getElements());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Object $this$translateToJVM_u24lambda_u244_u24lambda_u243;
        void read2;
        List<L2ReadBoxedOperand> elements;
        L2WriteBoxedOperand tuple2;
        block23: {
            boolean bl;
            block24: {
                boolean bl2;
                Iterable $this$any$iv;
                block27: {
                    int size;
                    block28: {
                        A_Type unionType;
                        block29: {
                            block26: {
                                void $this$fold$iv;
                                boolean bl3;
                                Intrinsics.checkNotNullParameter(translator, "translator");
                                Intrinsics.checkNotNullParameter(method, "method");
                                Intrinsics.checkNotNullParameter(instruction2, "instruction");
                                L2ReadBoxedVectorOperand values2 = (L2ReadBoxedVectorOperand)instruction2.operand(0);
                                tuple2 = (L2WriteBoxedOperand)instruction2.operand(1);
                                elements = values2.getElements();
                                size = elements.size();
                                boolean bl4 = bl3 = size > 0;
                                if (_Assertions.ENABLED && !bl3) {
                                    boolean $i$a$-assert-L2_CREATE_TUPLE$translateToJVM$22 = false;
                                    String $i$a$-assert-L2_CREATE_TUPLE$translateToJVM$22 = "Empty tuple should have been replaced via generateReplacement()";
                                    throw new AssertionError((Object)$i$a$-assert-L2_CREATE_TUPLE$translateToJVM$22);
                                }
                                Iterable $i$a$-assert-L2_CREATE_TUPLE$translateToJVM$22 = elements;
                                A_Type initial$iv = BottomTypeDescriptor.Companion.getBottom();
                                boolean $i$f$fold = false;
                                A_Type accumulator$iv = initial$iv;
                                for (Object element$iv : $this$fold$iv) {
                                    L2ReadBoxedOperand l2ReadBoxedOperand = (L2ReadBoxedOperand)element$iv;
                                    A_Type t = accumulator$iv;
                                    boolean bl5 = false;
                                    accumulator$iv = A_Type.Companion.typeUnion(t, read2.type());
                                }
                                unionType = accumulator$iv;
                                if (!A_Type.Companion.isSubtypeOf(unionType, PrimitiveTypeDescriptor.Types.CHARACTER.getO())) break block26;
                                translator.intConstant(method, size);
                                $this$any$iv = elements;
                                boolean $i$f$any = false;
                                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block27;
                                bl = false;
                                break block24;
                            }
                            if (!A_Type.Companion.isSubtypeOf(unionType, IntegerRangeTypeDescriptor.Companion.getInt64())) break block28;
                            translator.intConstant(method, size);
                            if (!A_Type.Companion.isSubtypeOf(unionType, IntegerRangeTypeDescriptor.Companion.getNybbles())) break block29;
                            NybbleTupleDescriptor.Companion.getCreateUninitializedNybbleTupleMethod().generateCall(method);
                            break block23;
                        }
                        if (A_Type.Companion.isSubtypeOf(unionType, IntegerRangeTypeDescriptor.Companion.getBytes())) {
                            ByteTupleDescriptor.Companion.getCreateUninitializedByteTupleMethod().generateCall(method);
                            break block23;
                        } else if (A_Type.Companion.isSubtypeOf(unionType, IntegerRangeTypeDescriptor.Companion.getInt32())) {
                            IntTupleDescriptor.Companion.getCreateUninitializedIntTupleMethod().generateCall(method);
                            break block23;
                        } else {
                            LongTupleDescriptor.Companion.getCreateUninitializedLongTupleMethod().generateCall(method);
                        }
                        break block23;
                    }
                    if (size <= 5) {
                        Iterable $this$forEach$iv = elements;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            L2ReadBoxedOperand it = (L2ReadBoxedOperand)element$iv;
                            boolean bl6 = false;
                            translator.load(method, (L2Register)it.register());
                        }
                    }
                    switch (size) {
                        case 1: {
                            ObjectTupleDescriptor.Companion.getTuple1Method().generateCall(method);
                            break;
                        }
                        case 2: {
                            ObjectTupleDescriptor.Companion.getTuple2Method().generateCall(method);
                            break;
                        }
                        case 3: {
                            ObjectTupleDescriptor.Companion.getTuple3Method().generateCall(method);
                            break;
                        }
                        case 4: {
                            ObjectTupleDescriptor.Companion.getTuple4Method().generateCall(method);
                            break;
                        }
                        case 5: {
                            ObjectTupleDescriptor.Companion.getTuple5Method().generateCall(method);
                            break;
                        }
                        default: {
                            translator.objectArray(method, elements, A_BasicObject.class);
                            ObjectTupleDescriptor.Companion.getTupleFromArrayMethod().generateCall(method);
                        }
                    }
                    method.visitTypeInsn(192, Type.getInternalName(AvailObject.class));
                    translator.store(method, (L2Register)tuple2.register());
                    return;
                }
                Iterator $i$f$fold = $this$any$iv.iterator();
                do {
                    block31: {
                        boolean bl7;
                        block25: {
                            Iterator iterator2;
                            block33: {
                                block30: {
                                    Iterable $this$any$iv2;
                                    block32: {
                                        Object element$iv;
                                        if (!$i$f$fold.hasNext()) break block30;
                                        element$iv = $i$f$fold.next();
                                        L2ReadBoxedOperand read3 = (L2ReadBoxedOperand)element$iv;
                                        boolean bl8 = false;
                                        $this$translateToJVM_u24lambda_u244_u24lambda_u243 = read3.type();
                                        boolean bl9 = false;
                                        if (!$this$translateToJVM_u24lambda_u244_u24lambda_u243.isEnumeration()) break block31;
                                        $this$any$iv2 = A_Type.Companion.getInstances((A_Type)$this$translateToJVM_u24lambda_u244_u24lambda_u243);
                                        boolean $i$f$any = false;
                                        if (!($this$any$iv2 instanceof Collection) || !((Collection)$this$any$iv2).isEmpty()) break block32;
                                        bl7 = false;
                                        break block25;
                                    }
                                    iterator2 = $this$any$iv2.iterator();
                                    break block33;
                                }
                                bl = false;
                                break block24;
                            }
                            while (iterator2.hasNext()) {
                                Object element$iv = iterator2.next();
                                AvailObject c = (AvailObject)element$iv;
                                boolean bl10 = false;
                                if (!(A_Character.Companion.getCodePoint(c) > 255)) continue;
                                bl7 = true;
                                break block25;
                            }
                            bl7 = false;
                        }
                        if (bl7) {
                            bl2 = true;
                            continue;
                        }
                    }
                    bl2 = false;
                } while (!bl2);
                bl = true;
            }
            if (bl) {
                TwoByteStringDescriptor.Companion.getCreateUninitializedTwoByteStringMethod().generateCall(method);
            } else {
                ByteStringDescriptor.Companion.getCreateUninitializedByteStringMethod().generateCall(method);
            }
        }
        Iterable $this$forEachIndexed$iv = elements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        Iterator iterator3 = $this$forEachIndexed$iv.iterator();
        while (true) {
            int n;
            if (!iterator3.hasNext()) {
                translator.store(method, (L2Register)tuple2.register());
                return;
            }
            Object item$iv = iterator3.next();
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            $this$translateToJVM_u24lambda_u244_u24lambda_u243 = (L2ReadBoxedOperand)item$iv;
            int zeroIndex = n;
            boolean bl = false;
            translator.intConstant(method, zeroIndex + 1);
            translator.load(method, (L2Register)read2.register());
            TupleDescriptor.Companion.getTupleAtPuttingMethod().generateCall(method);
        }
    }

    @Override
    @NotNull
    public L2ReadBoxedOperand extractTupleElement(@NotNull L2ReadBoxedOperand tupleReg, int index2, @NotNull L2Generator generator) {
        Intrinsics.checkNotNullParameter(tupleReg, "tupleReg");
        Intrinsics.checkNotNullParameter(generator, "generator");
        L2Instruction instruction2 = tupleReg.definition().getInstruction();
        L2ReadBoxedVectorOperand values2 = (L2ReadBoxedVectorOperand)instruction2.operand(0);
        return (L2ReadBoxedOperand)values2.getElements().get(index2 - 1);
    }

    @NotNull
    public final List<L2ReadBoxedOperand> tupleSourceRegistersOf(@NotNull L2Instruction instruction2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        boolean bl2 = bl = instruction2.getOperation() == this;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedVectorOperand vector = (L2ReadBoxedVectorOperand)instruction2.operand(0);
        return vector.getElements();
    }
}

