/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwoSimple;

import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.ContinuationDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Chunk;
import avail.interpreter.levelTwo.L2JVMChunk;
import avail.interpreter.levelTwoSimple.L2Simple_AbstractReifiableInstruction;
import avail.optimizer.StackReifier;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ%\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ%\u0010\u0010\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lavail/interpreter/levelTwoSimple/L2Simple_CheckForInterrupt;", "Lavail/interpreter/levelTwoSimple/L2Simple_AbstractReifiableInstruction;", "stackp", "", "pc", "nextOffset", "liveIndices", "", "(III[Ljava/lang/Integer;)V", "reenter", "Lavail/optimizer/StackReifier;", "registers", "Lavail/descriptor/representation/AvailObject;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "([Lavail/descriptor/representation/AvailObject;Lavail/interpreter/execution/Interpreter;)Lavail/optimizer/StackReifier;", "step", "Companion", "avail"})
public final class L2Simple_CheckForInterrupt
extends L2Simple_AbstractReifiableInstruction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Statistic interruptStatistic = new Statistic(StatisticReport.REIFICATIONS, "L2Simple interrupt");

    public L2Simple_CheckForInterrupt(int stackp, int pc, int nextOffset, @NotNull Integer[] liveIndices2) {
        Intrinsics.checkNotNullParameter(liveIndices2, "liveIndices");
        super(stackp, pc, nextOffset, liveIndices2);
    }

    @Override
    @Nullable
    public StackReifier reenter(@NotNull AvailObject[] registers, @NotNull Interpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter(registers, "registers");
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        if (!interpreter.checkValidity(L2JVMChunk.ChunkEntryPoint.TO_RESUME.getOffsetInDefaultChunk())) {
            return null;
        }
        boolean bl2 = bl = !interpreter.returnNow && !interpreter.getExitNow();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject availObject = interpreter.getReifiedContinuation();
        Intrinsics.checkNotNull(availObject);
        AvailObject con = availObject;
        int n = registers.length;
        for (int i2 = 1; i2 < n; ++i2) {
            registers[i2] = A_Continuation.Companion.frameAt(con, i2);
        }
        interpreter.popContinuation();
        return null;
    }

    @Override
    @Nullable
    public StackReifier step(@NotNull AvailObject[] registers, @NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(registers, "registers");
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        if (!interpreter.isInterruptRequested()) {
            return null;
        }
        AvailObject function = registers[0];
        L2Chunk l2Chunk = interpreter.chunk;
        Intrinsics.checkNotNull(l2Chunk);
        L2Chunk thisChunk = l2Chunk;
        return new StackReifier(true, interruptStatistic, new Function0<Unit>(interpreter, function, this, thisChunk, registers){
            final /* synthetic */ Interpreter $interpreter;
            final /* synthetic */ AvailObject $function;
            final /* synthetic */ L2Simple_CheckForInterrupt this$0;
            final /* synthetic */ L2Chunk $thisChunk;
            final /* synthetic */ AvailObject[] $registers;
            {
                this.$interpreter = $interpreter;
                this.$function = $function;
                this.this$0 = $receiver;
                this.$thisChunk = $thisChunk;
                this.$registers = $registers;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEachIndexed$iv;
                boolean bl;
                boolean bl2 = bl = !this.$interpreter.returnNow;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                AvailObject availObject = this.$interpreter.getReifiedContinuation();
                Intrinsics.checkNotNull(availObject);
                AvailObject caller2 = availObject;
                AvailObject continuation = ContinuationDescriptor.Companion.createContinuationExceptFrame(this.$function, caller2, NilDescriptor.Companion.getNil(), this.this$0.getPc(), this.this$0.getStackp(), this.$thisChunk, this.this$0.getNextOffset());
                Integer[] integerArray = this.this$0.getLiveIndices();
                AvailObject[] availObjectArray = this.$registers;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (void item$iv : $this$forEachIndexed$iv) {
                    void source;
                    int n = index$iv++;
                    int n2 = ((Number)item$iv).intValue();
                    int zeroIndex = n;
                    boolean bl3 = false;
                    A_Continuation.Companion.frameAtPut(continuation, zeroIndex + 1, source == false ? NilDescriptor.Companion.getNil() : availObjectArray[source]);
                }
                this.$interpreter.setReifiedContinuation(continuation);
                this.$interpreter.function = this.$function;
                this.$interpreter.chunk = this.$thisChunk;
                this.$interpreter.offset = this.this$0.getNextOffset();
                this.$interpreter.processInterrupt(continuation);
            }
        });
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/interpreter/levelTwoSimple/L2Simple_CheckForInterrupt$Companion;", "", "()V", "interruptStatistic", "Lavail/performance/Statistic;", "getInterruptStatistic", "()Lavail/performance/Statistic;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Statistic getInterruptStatistic() {
            return interruptStatistic;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

