/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.maps.A_Map;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_BootstrapPrefixEndOfBlockBody;", "Lavail/interpreter/Primitive;", "()V", "clientDataKey", "Lavail/descriptor/atoms/A_Atom;", "scopeMapKey", "scopeStackKey", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_BootstrapPrefixEndOfBlockBody
extends Primitive {
    @NotNull
    public static final P_BootstrapPrefixEndOfBlockBody INSTANCE = new P_BootstrapPrefixEndOfBlockBody();
    @NotNull
    private static final A_Atom clientDataKey = AtomDescriptor.SpecialAtom.CLIENT_DATA_GLOBAL_KEY.getAtom();
    @NotNull
    private static final A_Atom scopeMapKey = AtomDescriptor.SpecialAtom.COMPILER_SCOPE_MAP_KEY.getAtom();
    @NotNull
    private static final A_Atom scopeStackKey = AtomDescriptor.SpecialAtom.COMPILER_SCOPE_STACK_KEY.getAtom();

    private P_BootstrapPrefixEndOfBlockBody() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(5, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(5);
        A_Fiber fiber2 = interpreter.fiber();
        A_Map fiberGlobals = A_Fiber.Companion.getFiberGlobals(fiber2);
        AvailObject availObject = A_Map.Companion.mapAtOrNull(fiberGlobals, clientDataKey);
        if (availObject == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        A_Map clientData = availObject;
        AvailObject availObject2 = A_Map.Companion.mapAtOrNull(clientData, scopeMapKey);
        if (availObject2 == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INCONSISTENT_PREFIX_FUNCTION);
        }
        AvailObject currentScopeMap = availObject2;
        AvailObject availObject3 = A_Map.Companion.mapAtOrNull(clientData, scopeStackKey);
        if (availObject3 == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INCONSISTENT_PREFIX_FUNCTION);
        }
        A_Tuple stack = availObject3;
        AvailObject poppedScopeMap = A_Tuple.Companion.tupleAt(stack, A_Tuple.Companion.getTupleSize(stack));
        stack = A_Tuple.Companion.tupleAtPuttingCanDestroy(stack, A_Tuple.Companion.getTupleSize(stack), currentScopeMap, true);
        clientData = A_Map.Companion.mapAtPuttingCanDestroy(clientData, scopeMapKey, poppedScopeMap, true);
        clientData = A_Map.Companion.mapAtPuttingCanDestroy(clientData, scopeStackKey, stack, true);
        A_Fiber.Companion.setFiberGlobals(fiber2, A_Map.Companion.mapAtPuttingCanDestroy(fiberGlobals, clientDataKey, clientData, true));
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_Type[] a_TypeArray = new A_Type[]{PrimitiveTypeDescriptor.Types.TOKEN.getO(), InstanceMetaDescriptor.Companion.anyMeta()};
        A_BasicObject a_BasicObject = PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.oneOrMoreOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray))));
        a_TypeArray = new A_Type[2];
        a_TypeArray[0] = PrimitiveTypeDescriptor.Types.TOKEN.getO();
        A_Type[] a_TypeArray2 = new A_Type[]{PrimitiveTypeDescriptor.Types.TOKEN.getO(), InstanceMetaDescriptor.Companion.anyMeta()};
        a_TypeArray[1] = TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray2));
        A_BasicObject a_BasicObject2 = PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray)));
        a_TypeArray = new A_Type[]{PrimitiveTypeDescriptor.Types.TOKEN.getO(), TupleTypeDescriptor.Companion.zeroOrOneOf(InstanceMetaDescriptor.Companion.topMeta())};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(a_BasicObject, a_BasicObject2, PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray))), PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrMoreOf(PhraseTypeDescriptor.PhraseKind.STATEMENT_PHRASE.getMostGeneralType())), PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.create(PrimitiveTypeDescriptor.Types.ANY.getO())))), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER, AvailErrorCode.E_INCONSISTENT_PREFIX_FUNCTION};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

