/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.DeclarationPhraseDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tokens.TokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_BootstrapPrefixPrimitiveDeclaration;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_BootstrapPrefixPrimitiveDeclaration
extends Primitive {
    @NotNull
    public static final P_BootstrapPrefixPrimitiveDeclaration INSTANCE = new P_BootstrapPrefixPrimitiveDeclaration();

    private P_BootstrapPrefixPrimitiveDeclaration() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Object object;
        Object blockArgumentsList;
        boolean bl;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject optionalBlockArgumentsList = interpreter.argument(0);
        AvailObject optionalPrimPhrase = interpreter.argument(1);
        if (interpreter.availLoaderOrNull() == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        boolean bl2 = bl = A_Phrase.Companion.getExpressionsSize(optionalPrimPhrase) == 1;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Phrase primPhrase = A_Phrase.Companion.getLastExpression(optionalPrimPhrase);
        A_Phrase primNamePhrase = A_Phrase.Companion.expressionAt(primPhrase, 1);
        if (!A_Phrase.Companion.phraseKindIsUnder(primNamePhrase, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "primitive specification to be a literal keyword token", new Object[0]);
        }
        A_String primName = A_Phrase.Companion.getToken(primNamePhrase).string();
        Primitive primitive2 = Primitive.PrimitiveHolder.Companion.primitiveByName(A_String.Companion.asNativeString(primName));
        if (primitive2 == null) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "a supported primitive name, not " + primName, new Object[0]);
        }
        Primitive prim = primitive2;
        List blockArgumentPhrases = new ArrayList();
        if (A_Phrase.Companion.getExpressionsSize(optionalBlockArgumentsList) == 1) {
            boolean bl3;
            blockArgumentsList = A_Phrase.Companion.getLastExpression(optionalBlockArgumentsList);
            boolean bl4 = bl3 = A_Phrase.Companion.getExpressionsSize((A_Phrase)blockArgumentsList) >= 1;
            if (_Assertions.ENABLED && !bl3) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            Iterable $this$forEach$iv = A_Phrase.Companion.getExpressionsTuple((A_Phrase)blockArgumentsList);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                A_Phrase declaration2;
                boolean bl5;
                AvailObject pair = (AvailObject)element$iv;
                boolean bl6 = false;
                boolean bl7 = bl5 = A_Phrase.Companion.getExpressionsSize(pair) == 2;
                if (_Assertions.ENABLED && !bl5) {
                    object = "Assertion failed";
                    throw new AssertionError(object);
                }
                A_Phrase namePhrase = A_Phrase.Companion.expressionAt(pair, 1);
                A_String name = A_Phrase.Companion.getToken(namePhrase).literal().string();
                boolean bl8 = name.isString();
                if (_Assertions.ENABLED && !bl8) {
                    String string4 = "Assertion failed";
                    throw new AssertionError((Object)string4);
                }
                Intrinsics.checkNotNull(FiberDescriptor.Companion.lookupBindingOrNull(name));
                blockArgumentPhrases.add(declaration2);
            }
        }
        if ((blockArgumentsList = Primitive.Companion.validatePrimitiveAcceptsArguments(prim, blockArgumentPhrases)) != null) {
            Object it = blockArgumentsList;
            boolean bl9 = false;
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, (String)it, new Object[0]);
        }
        A_Phrase optionalFailure = A_Phrase.Companion.expressionAt(primPhrase, 2);
        if (A_Phrase.Companion.getExpressionsSize(optionalFailure) == 1) {
            boolean it;
            if (prim.hasFlag(Primitive.Flag.CannotFail)) {
                throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "no primitive failure variable declaration for this infallible primitive", new Object[0]);
            }
            A_Phrase failurePair = A_Phrase.Companion.expressionAt(optionalFailure, 1);
            boolean bl10 = it = A_Phrase.Companion.getExpressionsSize(failurePair) == 2;
            if (_Assertions.ENABLED && !it) {
                String bl9 = "Assertion failed";
                throw new AssertionError((Object)bl9);
            }
            A_Phrase failureNamePhrase = A_Phrase.Companion.expressionAt(failurePair, 1);
            AvailObject failureName = A_Phrase.Companion.getToken(failureNamePhrase).literal();
            if (failureName.tokenType() != TokenDescriptor.TokenType.KEYWORD) {
                throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "primitive failure variable name to be alphanumeric", new Object[0]);
            }
            A_Phrase failureTypePhrase = A_Phrase.Companion.expressionAt(failurePair, 2);
            AvailObject failureType = A_Phrase.Companion.getToken(failureTypePhrase).literal();
            if (failureType.isBottom() || failureType.isTop()) {
                throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "primitive failure variable type not to be " + failureType, new Object[0]);
            }
            AvailObject requiredFailureType = prim.getFailureVariableType();
            if (!A_Type.Companion.isSubtypeOf(requiredFailureType, failureType)) {
                throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "primitive failure variable to be a supertype of: " + requiredFailureType + ", not " + failureType, new Object[0]);
            }
            A_Phrase failureDeclaration = DeclarationPhraseDescriptor.Companion.newPrimitiveFailureVariable(failureName, failureTypePhrase, failureType);
            object = FiberDescriptor.Companion.addDeclaration(failureDeclaration);
            if (object != null) {
                Object conflictingDeclaration = object;
                boolean bl11 = false;
                throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "primitive failure variable " + failureName.string() + " to have a name that doesn't shadow an existing " + conflictingDeclaration.declarationKind().nativeKindName() + " (from line " + A_Phrase.Companion.getToken((A_Phrase)conflictingDeclaration).lineNumber() + ")", new Object[0]);
            }
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        if (!prim.hasFlag(Primitive.Flag.CannotFail)) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "a primitive failure variable declaration for this fallible primitive.  Its type should be:\n\t" + prim.getFailureVariableType(), new Object[0]);
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_Type[] a_TypeArray = new A_Type[]{PrimitiveTypeDescriptor.Types.TOKEN.getO(), InstanceMetaDescriptor.Companion.anyMeta()};
        A_BasicObject a_BasicObject = PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.oneOrMoreOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray))));
        a_TypeArray = new A_Type[2];
        a_TypeArray[0] = PrimitiveTypeDescriptor.Types.TOKEN.getO();
        A_Type[] a_TypeArray2 = new A_Type[]{PrimitiveTypeDescriptor.Types.TOKEN.getO(), InstanceMetaDescriptor.Companion.anyMeta()};
        a_TypeArray[1] = TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray2));
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(a_BasicObject, PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray)))), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }
}

