/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.fibers;

import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.module.A_Module;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FiberTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/fibers/P_Fork;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_Fork
extends Primitive {
    @NotNull
    public static final P_Fork INSTANCE = new P_Fork();

    private P_Fork() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect, Primitive.Flag.WritesToHiddenGlobalState};
        super(3, flagArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        List<AvailObject> list2 = interpreter.argsBuffer;
        AvailObject function = list2.get(0);
        AvailObject argTuple = list2.get(1);
        AvailObject priority = list2.get(2);
        int numArgs = A_Tuple.Companion.getTupleSize(argTuple);
        A_RawFunction code = function.code();
        if (A_RawFunction.Companion.numArgs(code) != numArgs) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
        }
        A_Type tupleType = A_Type.Companion.getArgsTupleType(function.kind());
        Iterable $this$map$iv = new IntRange(1, numArgs);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            AvailObject anArg = A_Tuple.Companion.tupleAt(argTuple, (int)it);
            if (!anArg.isInstanceOf(A_Type.Companion.typeAtIndex(tupleType, (int)it))) {
                return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE);
            }
            collection2.add(anArg.makeShared());
        }
        List callArgs = (List)destination$iv$iv;
        function.makeShared();
        A_Fiber current = interpreter.fiber();
        A_Fiber newFiber2 = FiberDescriptor.Companion.newFiber$default(FiberDescriptor.Companion, A_Type.Companion.getReturnType(function.kind()), interpreter.runtime, A_Fiber.Companion.getTextInterface(current), A_Number.Companion.getExtractInt(priority), null, new Function0<A_String>(code){
            final /* synthetic */ A_RawFunction $code;
            {
                this.$code = $code;
                super(0);
            }

            @NotNull
            public final A_String invoke() {
                Object[] objectArray = new Object[]{A_RawFunction.Companion.getMethodName(this.$code), A_RawFunction.Companion.getModule(this.$code).isNil() ? "no module" : A_Module.Companion.getShortModuleNameNative(A_RawFunction.Companion.getModule(this.$code)), A_RawFunction.Companion.getCodeStartingLineNumber(this.$code)};
                return StringDescriptor.Companion.formatString("Fork, %s, %s:%d", objectArray);
            }
        }, 16, null);
        A_Fiber.Companion.setAvailLoader(newFiber2, A_Fiber.Companion.getAvailLoader(current));
        A_Fiber.Companion.setHeritableFiberGlobals(newFiber2, A_Fiber.Companion.getHeritableFiberGlobals(current).makeShared());
        newFiber2.makeShared();
        interpreter.runtime.runOutermostFunction(newFiber2, function, callArgs);
        return interpreter.primitiveSuccess(newFiber2);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(FunctionTypeDescriptor.Companion.functionTypeReturning(PrimitiveTypeDescriptor.Types.TOP.getO()), TupleTypeDescriptor.Companion.getMostGeneralTupleType(), IntegerRangeTypeDescriptor.Companion.getBytes()), FiberTypeDescriptor.Companion.mostGeneralFiberType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS, AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

