/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.files;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.SetTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.files.P_FileGetPermissions;
import avail.io.IOSystem;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0014R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lavail/interpreter/primitive/files/P_FileGetPermissions;", "Lavail/interpreter/Primitive;", "()V", "permissionMap", "Ljava/util/EnumMap;", "Ljava/nio/file/attribute/PosixFilePermission;", "Lavail/descriptor/numbers/A_Number;", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "ordinalsFromPosixPermissions", "Lavail/descriptor/sets/A_Set;", "permissions", "", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_FileGetPermissions
extends Primitive {
    @NotNull
    public static final P_FileGetPermissions INSTANCE = new P_FileGetPermissions();
    @NotNull
    private static final EnumMap<PosixFilePermission, A_Number> permissionMap = new EnumMap(PosixFilePermission.class);

    private P_FileGetPermissions() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(2, flagArray);
    }

    private final A_Set ordinalsFromPosixPermissions(Set<? extends PosixFilePermission> permissions) {
        return SetDescriptor.Companion.generateSetFrom((Collection)permissions, (Function1)ordinalsFromPosixPermissions.1.INSTANCE);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Set<PosixFilePermission> set2;
        Path path;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject filename = interpreter.argument(0);
        AvailObject followSymlinks = interpreter.argument(1);
        try {
            Path path2 = IOSystem.Companion.getFileSystem().getPath(A_String.Companion.asNativeString(filename), new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "{\n\t\t\t\tIOSystem.fileSyste\u2026me.asNativeString())\n\t\t\t}");
            path = path2;
        }
        catch (InvalidPathException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INVALID_PATH);
        }
        Path path3 = path;
        LinkOption[] options = IOSystem.Companion.followSymlinks(A_Atom.Companion.getExtractBoolean(followSymlinks));
        try {
            Set<PosixFilePermission> set3 = Files.getPosixFilePermissions(path3, Arrays.copyOf(options, options.length));
            Intrinsics.checkNotNullExpressionValue(set3, "{\n\t\t\t\tFiles.getPosixFile\u2026ions(path, *options)\n\t\t\t}");
            set2 = set3;
        }
        catch (SecurityException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        catch (AccessDeniedException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        catch (IOException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_IO_ERROR);
        }
        catch (UnsupportedOperationException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_OPERATION_NOT_SUPPORTED);
        }
        Set<PosixFilePermission> permissions = set2;
        A_Set ordinals = this.ordinalsFromPosixPermissions(permissions);
        return interpreter.primitiveSuccess(ordinals);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getStringType(), EnumerationTypeDescriptor.Companion.getBooleanType()), SetTypeDescriptor.Companion.setTypeForSizesContentType(IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), IntegerRangeTypeDescriptor.Companion.inclusive(1L, 9L)), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_PATH, AvailErrorCode.E_PERMISSION_DENIED, AvailErrorCode.E_IO_ERROR, AvailErrorCode.E_OPERATION_NOT_SUPPORTED};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    public static final /* synthetic */ EnumMap access$getPermissionMap$p() {
        return permissionMap;
    }

    static {
        PosixFilePermission[] permissions = IOSystem.Companion.getPosixPermissions();
        int n = permissions.length;
        for (int i2 = 0; i2 < n; ++i2) {
            ((Map)permissionMap).put(permissions[i2], IntegerDescriptor.Companion.fromInt(i2 + 1));
        }
    }
}

