/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.files;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.IOSystem;
import avail.utility.Mutable;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/files/P_FileUnlink;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_FileUnlink
extends Primitive {
    @NotNull
    public static final P_FileUnlink INSTANCE = new P_FileUnlink();

    private P_FileUnlink() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(4, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Path path;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(4);
        AvailObject recursive = interpreter.argument(0);
        AvailObject filename = interpreter.argument(1);
        AvailObject requireExistence = interpreter.argument(2);
        AvailObject followSymlinks = interpreter.argument(3);
        try {
            Path path2 = IOSystem.Companion.getFileSystem().getPath(A_String.Companion.asNativeString(filename), new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "{\n\t\t\t\tIOSystem.fileSyste\u2026me.asNativeString())\n\t\t\t}");
            path = path2;
        }
        catch (InvalidPathException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INVALID_PATH);
        }
        Path path3 = path;
        if (!A_Atom.Companion.getExtractBoolean(recursive)) {
            try {
                if (A_Atom.Companion.getExtractBoolean(requireExistence)) {
                    Files.delete(path3);
                }
                Files.deleteIfExists(path3);
            }
            catch (SecurityException e) {
                return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
            }
            catch (AccessDeniedException e) {
                return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
            }
            catch (NoSuchFileException e) {
                return interpreter.primitiveFailure(AvailErrorCode.E_NO_FILE);
            }
            catch (DirectoryNotEmptyException e) {
                return interpreter.primitiveFailure(AvailErrorCode.E_DIRECTORY_NOT_EMPTY);
            }
            catch (IOException e) {
                return interpreter.primitiveFailure(AvailErrorCode.E_IO_ERROR);
            }
        } else {
            EnumSet<Enum> visitOptions = A_Atom.Companion.getExtractBoolean(followSymlinks) ? EnumSet.of((Enum)FileVisitOption.FOLLOW_LINKS) : EnumSet.noneOf(FileVisitOption.class);
            try {
                Mutable<Boolean> partialSuccess = new Mutable<Boolean>(false);
                Files.walkFileTree(path3, (Set<FileVisitOption>)visitOptions, Integer.MAX_VALUE, (FileVisitor<? super Path>)new FileVisitor<Path>(partialSuccess){
                    final /* synthetic */ Mutable<Boolean> $partialSuccess;
                    {
                        this.$partialSuccess = $partialSuccess;
                    }

                    @NotNull
                    public FileVisitResult preVisitDirectory(@Nullable Path dir, @Nullable BasicFileAttributes unused) {
                        return FileVisitResult.CONTINUE;
                    }

                    @NotNull
                    public FileVisitResult visitFile(@Nullable Path file2, @Nullable BasicFileAttributes unused) throws IOException {
                        boolean bl;
                        boolean bl2 = bl = file2 != null;
                        if (_Assertions.ENABLED && !bl) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        Path path = file2;
                        Intrinsics.checkNotNull(path);
                        Files.deleteIfExists(path);
                        return FileVisitResult.CONTINUE;
                    }

                    @NotNull
                    public FileVisitResult visitFileFailed(@Nullable Path file2, @Nullable IOException unused) {
                        this.$partialSuccess.setValue(true);
                        return FileVisitResult.CONTINUE;
                    }

                    @NotNull
                    public FileVisitResult postVisitDirectory(@Nullable Path dir, @Nullable IOException e) throws IOException {
                        boolean bl;
                        boolean bl2 = bl = dir != null;
                        if (_Assertions.ENABLED && !bl) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        if (e != null) {
                            this.$partialSuccess.setValue(true);
                        } else {
                            Path path = dir;
                            Intrinsics.checkNotNull(path);
                            Files.deleteIfExists(path);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                if (partialSuccess.getValue().booleanValue()) {
                    return interpreter.primitiveFailure(AvailErrorCode.E_PARTIAL_SUCCESS);
                }
            }
            catch (SecurityException e) {
                return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
            }
            catch (IOException e) {
                return interpreter.primitiveFailure(AvailErrorCode.E_IO_ERROR);
            }
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(EnumerationTypeDescriptor.Companion.getBooleanType(), TupleTypeDescriptor.Companion.getStringType(), EnumerationTypeDescriptor.Companion.getBooleanType(), EnumerationTypeDescriptor.Companion.getBooleanType()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_PATH, AvailErrorCode.E_PERMISSION_DENIED, AvailErrorCode.E_NO_FILE, AvailErrorCode.E_DIRECTORY_NOT_EMPTY, AvailErrorCode.E_IO_ERROR, AvailErrorCode.E_PARTIAL_SUCCESS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

