/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.integers;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.exceptions.ArithmeticException;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_BIT_LOGIC_OP;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_COMPARE_INT;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import avail.optimizer.values.L2SemanticPrimitiveInvocation;
import avail.optimizer.values.L2SemanticUnboxedInt;
import avail.optimizer.values.L2SemanticValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016JH\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019R\u00020\u0017H\u0016\u00a8\u0006\u001a"}, d2={"Lavail/interpreter/primitive/integers/P_BitShiftRight;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_BitShiftRight
extends Primitive {
    @NotNull
    public static final P_BitShiftRight INSTANCE = new P_BitShiftRight();

    private P_BitShiftRight() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject baseInteger = interpreter.argument(0);
        AvailObject shiftFactor = interpreter.argument(1);
        try {
            result2 = interpreter.primitiveSuccess(A_Number.Companion.bitShift(baseInteger, A_Number.Companion.minusCanDestroy(IntegerDescriptor.Companion.getZero(), shiftFactor, true), true));
        }
        catch (ArithmeticException e) {
            result2 = interpreter.primitiveFailure(e);
        }
        return result2;
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type shiftFactors = argumentTypes.get(1);
        return A_Number.Companion.greaterOrEqual(A_Type.Companion.getLowerBound(shiftFactors), IntegerDescriptor.Companion.getZero()) ? Primitive.Fallibility.CallSiteCannotFail : super.fallibilityForArgumentTypes(argumentTypes);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        A_Type a_Type;
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type baseIntegers = argumentTypes.get(0);
        A_Type shiftFactors = argumentTypes.get(1);
        A_Number leastShift = A_Type.Companion.getLowerBound(shiftFactors);
        if (A_Type.Companion.getUpperBound(shiftFactors).equals(leastShift)) {
            A_Number negatedShift = A_Number.Companion.minusCanDestroy(IntegerDescriptor.Companion.getZero(), leastShift, false);
            a_Type = IntegerRangeTypeDescriptor.Companion.integerRangeType(A_Number.Companion.bitShift(A_Type.Companion.getLowerBound(baseIntegers), negatedShift, false), A_Type.Companion.getLowerInclusive(baseIntegers), A_Number.Companion.bitShift(A_Type.Companion.getUpperBound(baseIntegers), negatedShift, false), A_Type.Companion.getUpperInclusive(baseIntegers));
        } else {
            a_Type = A_Number.Companion.greaterOrEqual(A_Type.Companion.getLowerBound(baseIntegers), IntegerDescriptor.Companion.getZero()) ? IntegerRangeTypeDescriptor.Companion.getWholeNumbers() : super.returnTypeGuaranteedByVM(rawFunction2, argumentTypes);
        }
        return a_Type;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(IntegerRangeTypeDescriptor.Companion.getIntegers(), IntegerRangeTypeDescriptor.Companion.getIntegers()), IntegerRangeTypeDescriptor.Companion.getIntegers(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_TOO_LARGE_TO_REPRESENT};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments2, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Collection<A_Type> collection2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(functionToCallReg, "functionToCallReg");
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        L2ReadBoxedOperand a = arguments2.get(0);
        L2ReadBoxedOperand b = arguments2.get(1);
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        if (A_Type.Companion.typeIntersection(aType, IntegerRangeTypeDescriptor.Companion.getInt32()).isBottom() || A_Type.Companion.typeIntersection(bType, IntegerRangeTypeDescriptor.Companion.getInt32()).isBottom()) {
            return false;
        }
        if (!A_Type.Companion.isSubtypeOf(bType, IntegerRangeTypeDescriptor.Companion.getWholeNumbers())) {
            return false;
        }
        L2Generator generator = translator.getGenerator();
        L2BasicBlock fallback = generator.createBasicBlock("fall back to boxed right-shift");
        L2BasicBlock fallbackToLargeRightShift = generator.createBasicBlock("fall back to large right-shift (to 0 or -1)");
        L2ReadIntOperand intA = generator.readInt(new L2SemanticUnboxedInt(a.semanticValue()), fallback);
        L2ReadIntOperand intB = generator.readInt(new L2SemanticUnboxedInt(b.semanticValue()), fallbackToLargeRightShift);
        L2SemanticValue[] l2SemanticValueArray = new L2SemanticValue[]{a.semanticValue(), b.semanticValue()};
        L2SemanticPrimitiveInvocation semanticTemp = L2SemanticValue.Companion.primitiveInvocation(this, CollectionsKt.listOf(l2SemanticValueArray));
        Iterable iterable = argumentTypes;
        A_RawFunction a_RawFunction = rawFunction2;
        P_BitShiftRight p_BitShiftRight = this;
        boolean $i$f$map = false;
        L2Operand[] l2OperandArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            A_Type a_Type = (A_Type)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(A_Type.Companion.typeIntersection((A_Type)it, IntegerRangeTypeDescriptor.Companion.getInt32()));
        }
        collection2 = (List)destination$iv$iv;
        A_Type returnTypeIfInts = p_BitShiftRight.returnTypeGuaranteedByVM(a_RawFunction, (List<? extends A_Type>)collection2);
        L2WriteIntOperand tempIntWriter = generator.intWrite(SetsKt.setOf(new L2SemanticUnboxedInt(semanticTemp)), TypeRestriction.Companion.restrictionForType(returnTypeIfInts, TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG));
        if (generator.currentlyReachable()) {
            L2BasicBlock smallShift = generator.createBasicBlock("shift is small");
            L2_JUMP_IF_COMPARE_INT.Companion.getGreaterOrEqual().compareAndBranch(generator, intB, generator.unboxedIntConstant(32), L2Generator.Companion.edgeTo(fallbackToLargeRightShift), L2Generator.Companion.edgeTo(smallShift));
            L2Generator.startBlock$default(generator, smallShift, false, null, 6, null);
            if (generator.currentlyReachable()) {
                l2OperandArray = new L2Operand[]{intA, intB, tempIntWriter};
                generator.addInstruction(L2_BIT_LOGIC_OP.Companion.getBitwiseSignedShiftRight(), l2OperandArray);
                callSiteHelper.useAnswer(generator.readBoxed(semanticTemp));
            }
        }
        L2Generator.startBlock$default(generator, fallbackToLargeRightShift, false, null, 6, null);
        if (generator.currentlyReachable()) {
            L2Operand[] l2OperandArray2 = new L2Operand[]{intA, generator.unboxedIntConstant(31), tempIntWriter};
            generator.addInstruction(L2_BIT_LOGIC_OP.Companion.getBitwiseSignedShiftRight(), l2OperandArray2);
            callSiteHelper.useAnswer(generator.readBoxed(semanticTemp));
        }
        L2Generator.startBlock$default(generator, fallback, false, null, 6, null);
        if (generator.currentlyReachable()) {
            translator.generateGeneralFunctionInvocation(functionToCallReg, arguments2, false, callSiteHelper);
        }
        return true;
    }
}

