/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.phrases;

import avail.descriptor.objects.ObjectTypeDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.BlockPhraseDescriptor;
import avail.descriptor.phrases.PhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.SetTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/phrases/P_CreateBlockExpression;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_CreateBlockExpression
extends Primitive {
    @NotNull
    public static final P_CreateBlockExpression INSTANCE = new P_CreateBlockExpression();

    private P_CreateBlockExpression() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline};
        super(5, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive primitive2;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(5);
        AvailObject argDecls = interpreter.argument(0);
        AvailObject primitiveName = interpreter.argument(1);
        AvailObject statements = interpreter.argument(2);
        AvailObject resultType = interpreter.argument(3);
        AvailObject exceptions = interpreter.argument(4);
        List flat = new ArrayList();
        Iterable $this$forEach$iv = statements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AvailObject it = (AvailObject)element$iv;
            boolean bl = false;
            A_Phrase.Companion.flattenStatementsInto(it, flat);
        }
        if (A_Tuple.Companion.getTupleSize(primitiveName) == 0) {
            primitive2 = null;
        } else {
            primitive2 = Primitive.PrimitiveHolder.Companion.primitiveByName(A_String.Companion.asNativeString(primitiveName));
            if (primitive2 == null) {
                return interpreter.primitiveFailure(AvailErrorCode.E_INVALID_PRIMITIVE_NAME);
            }
        }
        Primitive primitive3 = primitive2;
        if (!PhraseDescriptor.Companion.containsOnlyStatements(flat, resultType)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_BLOCK_CONTAINS_INVALID_STATEMENTS);
        }
        AvailObject block = BlockPhraseDescriptor.Companion.newBlockNode(argDecls, primitive3, statements, resultType, exceptions, 0);
        return interpreter.primitiveSuccess(block);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.zeroOrMoreOf(PhraseTypeDescriptor.PhraseKind.ARGUMENT_PHRASE.getMostGeneralType()), TupleTypeDescriptor.Companion.getStringType(), TupleTypeDescriptor.Companion.zeroOrMoreOf(PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.getMostGeneralType()), InstanceMetaDescriptor.Companion.topMeta(), SetTypeDescriptor.Companion.setTypeForSizesContentType(IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), ObjectTypeDescriptor.Companion.Exceptions.INSTANCE.getExceptionType())), PhraseTypeDescriptor.PhraseKind.BLOCK_PHRASE.getMostGeneralType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_BLOCK_CONTAINS_INVALID_STATEMENTS, AvailErrorCode.E_INVALID_PRIMITIVE_NAME};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

