/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.phrases;

import avail.AvailRuntime;
import avail.compiler.AvailAcceptedParseException;
import avail.compiler.AvailRejectedParseException;
import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.methods.A_Definition;
import avail.descriptor.methods.A_Method;
import avail.descriptor.methods.A_Sendable;
import avail.descriptor.module.A_Module;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.SendPhraseDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.utility.CollectionExtensionsKt;
import avail.utility.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0014J\u001e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\nH\u0016\u00a8\u0006\u0012"}, d2={"Lavail/interpreter/primitive/phrases/P_CreateRestrictedSendExpression;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "collectProblemReport", "Lavail/descriptor/tuples/A_String;", "problems", "", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "avail"})
public final class P_CreateRestrictedSendExpression
extends Primitive {
    @NotNull
    public static final P_CreateRestrictedSendExpression INSTANCE = new P_CreateRestrictedSendExpression();

    private P_CreateRestrictedSendExpression() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanSuspend, Primitive.Flag.Unknown};
        super(3, flagArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject messageName = interpreter.argument(0);
        AvailObject argsListPhrase = interpreter.argument(1);
        AvailObject returnType = interpreter.argument(2);
        A_Fiber originalFiber = FiberDescriptor.Companion.currentFiber();
        AvailLoader availLoader = A_Fiber.Companion.getAvailLoader(originalFiber);
        if (availLoader == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        AvailLoader loader = availLoader;
        A_Tuple argExpressions = A_Phrase.Companion.getExpressionsTuple(argsListPhrase);
        int argsCount = A_Tuple.Companion.getTupleSize(argExpressions);
        A_Bundle bundle = null;
        try {
            bundle = A_Atom.Companion.bundleOrCreate(messageName);
            MessageSplitter splitter = A_Bundle.Companion.getMessageSplitter(bundle);
            if (splitter.getNumberOfArguments() != argsCount) {
                return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
            }
            if (!splitter.checkListStructure(argsListPhrase)) {
                return interpreter.primitiveFailure(AvailErrorCode.E_INCONSISTENT_ARGUMENT_REORDERING);
            }
        }
        catch (MalformedMessageException e) {
            return interpreter.primitiveFailure(e);
        }
        AvailObject argsTupleType = A_Phrase.Companion.getPhraseExpressionType(argsListPhrase).makeShared();
        Iterable $this$map$iv = new IntRange(1, argsCount);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void index2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            A_Type argType = A_Type.Companion.typeAtIndex(argsTupleType, (int)index2);
            collection2.add(argType);
        }
        List argTypesList = (List)destination$iv$iv;
        A_Module module = loader.getModule();
        Ref.ObjectRef<A_Type> intersection = new Ref.ObjectRef<A_Type>();
        intersection.element = returnType;
        ReentrantReadWriteLock intersectionLock = new ReentrantReadWriteLock();
        boolean anyDefinitionsApplicable = false;
        for (A_Definition definition : A_Method.Companion.filterByTypes(A_Bundle.Companion.getBundleMethod(bundle), argTypesList)) {
            A_Module definitionModule = A_Sendable.Companion.definitionModule(definition);
            if (!definitionModule.isNil() && !A_Module.Companion.hasAncestor(module, definitionModule)) continue;
            intersection.element = A_Type.Companion.typeIntersection((A_Type)intersection.element, A_Type.Companion.getReturnType(A_Sendable.Companion.bodySignature(definition)));
            anyDefinitionsApplicable = true;
        }
        if (!anyDefinitionsApplicable) {
            return interpreter.primitiveFailure(AvailErrorCode.E_NO_METHOD_DEFINITION);
        }
        Iterable $this$filter$iv = A_Method.Companion.getSemanticRestrictions(A_Bundle.Companion.getBundleMethod(bundle));
        boolean $i$f$filter = false;
        Iterable index2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AvailObject it = (AvailObject)element$iv$iv;
            boolean bl = false;
            boolean bl2 = A_Module.Companion.hasAncestor(module, it.definitionModule()) && A_Type.Companion.acceptsListOfArgValues(it.function().kind(), argTypesList);
            if (!bl2) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List applicableRestrictions = (List)destination$iv$iv2;
        int restrictionsSize = applicableRestrictions.size();
        if (restrictionsSize == 0) {
            return interpreter.primitiveSuccess(ObjectTupleDescriptor.Companion.tuple(ObjectTupleDescriptor.Companion.tuple(SendPhraseDescriptor.Companion.newSendNode(TupleDescriptor.Companion.getEmptyTuple(), TupleDescriptor.Companion.getEmptyTuple(), bundle, argsListPhrase, (A_Type)intersection.element)), TupleDescriptor.Companion.getEmptyTuple()));
        }
        AvailRuntime runtime = AvailRuntime.Companion.currentRuntime();
        return interpreter.suspendThen((Function1<? super Interpreter.SuspensionHelper<A_BasicObject>, Unit>)new Function1<Interpreter.SuspensionHelper<A_BasicObject>, Unit>((List<AvailObject>)applicableRestrictions, runtime, loader, originalFiber, (List<? extends A_Type>)argTypesList, intersectionLock, intersection, bundle, argsListPhrase){
            final /* synthetic */ List<AvailObject> $applicableRestrictions;
            final /* synthetic */ AvailRuntime $runtime;
            final /* synthetic */ AvailLoader $loader;
            final /* synthetic */ A_Fiber $originalFiber;
            final /* synthetic */ List<A_Type> $argTypesList;
            final /* synthetic */ ReentrantReadWriteLock $intersectionLock;
            final /* synthetic */ Ref.ObjectRef<A_Type> $intersection;
            final /* synthetic */ A_Bundle $bundle;
            final /* synthetic */ AvailObject $argsListPhrase;
            {
                this.$applicableRestrictions = $applicableRestrictions;
                this.$runtime = $runtime;
                this.$loader = $loader;
                this.$originalFiber = $originalFiber;
                this.$argTypesList = $argTypesList;
                this.$intersectionLock = $intersectionLock;
                this.$intersection = $intersection;
                this.$bundle = $bundle;
                this.$argsListPhrase = $argsListPhrase;
                super(1);
            }

            public final void invoke(@NotNull Interpreter.SuspensionHelper<A_BasicObject> $this$suspendThen) {
                Intrinsics.checkNotNullParameter($this$suspendThen, "$this$suspendThen");
                List<A_String> problems = Collections.synchronizedList((List)new ArrayList<E>());
                Ref.IntRef fiberCount = new Ref.IntRef();
                fiberCount.element = 1;
                CollectionExtensionsKt.parallelDoThen((Collection)this.$applicableRestrictions, (Function2)new Function2<AvailObject, Function0<? extends Unit>, Unit>(fiberCount, this.$runtime, this.$loader, this.$originalFiber, this.$argTypesList, this.$applicableRestrictions, this.$intersectionLock, problems, this.$intersection){
                    final /* synthetic */ Ref.IntRef $fiberCount;
                    final /* synthetic */ AvailRuntime $runtime;
                    final /* synthetic */ AvailLoader $loader;
                    final /* synthetic */ A_Fiber $originalFiber;
                    final /* synthetic */ List<A_Type> $argTypesList;
                    final /* synthetic */ List<AvailObject> $applicableRestrictions;
                    final /* synthetic */ ReentrantReadWriteLock $intersectionLock;
                    final /* synthetic */ List<A_String> $problems;
                    final /* synthetic */ Ref.ObjectRef<A_Type> $intersection;
                    {
                        this.$fiberCount = $fiberCount;
                        this.$runtime = $runtime;
                        this.$loader = $loader;
                        this.$originalFiber = $originalFiber;
                        this.$argTypesList = $argTypesList;
                        this.$applicableRestrictions = $applicableRestrictions;
                        this.$intersectionLock = $intersectionLock;
                        this.$problems = $problems;
                        this.$intersection = $intersection;
                        super(2);
                    }

                    public final void invoke(@NotNull AvailObject restriction2, @NotNull Function0<Unit> after) {
                        Intrinsics.checkNotNullParameter(restriction2, "restriction");
                        Intrinsics.checkNotNullParameter(after, "after");
                        int n = this.$fiberCount.element;
                        this.$fiberCount.element = n + 1;
                        int finalCount = n;
                        A_Fiber forkedFiber2 = FiberDescriptor.Companion.createFiber$default(FiberDescriptor.Companion, InstanceMetaDescriptor.Companion.topMeta(), this.$runtime, this.$loader, A_Fiber.Companion.getTextInterface(this.$originalFiber), A_Fiber.Companion.getPriority(this.$originalFiber), null, new Function0<A_String>(finalCount, this.$applicableRestrictions){
                            final /* synthetic */ int $finalCount;
                            final /* synthetic */ List<AvailObject> $applicableRestrictions;
                            {
                                this.$finalCount = $finalCount;
                                this.$applicableRestrictions = $applicableRestrictions;
                                super(0);
                            }

                            @NotNull
                            public final A_String invoke() {
                                return StringDescriptor.Companion.stringFrom("Semantic restriction checker (#" + this.$finalCount + "/" + this.$applicableRestrictions.size() + ") for primitive " + P_CreateRestrictedSendExpression.INSTANCE.getSimpleName());
                            }
                        }, 32, null);
                        A_Fiber.Companion.setGeneralFlag(forkedFiber2, FiberDescriptor.GeneralFlag.CAN_REJECT_PARSE);
                        A_Fiber.Companion.setGeneralFlag(forkedFiber2, FiberDescriptor.GeneralFlag.IS_SEMANTIC_RESTRICTION);
                        A_Fiber.Companion.setHeritableFiberGlobals(forkedFiber2, A_Fiber.Companion.getHeritableFiberGlobals(this.$originalFiber));
                        A_Fiber.Companion.setSuccessAndFailure(forkedFiber2, (Function1<? super AvailObject, Unit>)new Function1<AvailObject, Unit>(this.$intersectionLock, this.$problems, after, this.$intersection){
                            final /* synthetic */ ReentrantReadWriteLock $intersectionLock;
                            final /* synthetic */ List<A_String> $problems;
                            final /* synthetic */ Function0<Unit> $after;
                            final /* synthetic */ Ref.ObjectRef<A_Type> $intersection;
                            {
                                this.$intersectionLock = $intersectionLock;
                                this.$problems = $problems;
                                this.$after = $after;
                                this.$intersection = $intersection;
                                super(1);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull AvailObject it) {
                                Intrinsics.checkNotNullParameter(it, "it");
                                if (it.isType()) {
                                    void $this$safeWrite$iv;
                                    ReentrantReadWriteLock reentrantReadWriteLock = this.$intersectionLock;
                                    Ref.ObjectRef<A_Type> objectRef = this.$intersection;
                                    boolean $i$f$safeWrite = false;
                                    ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                                    Intrinsics.checkNotNullExpressionValue(writeLock, "this.writeLock()");
                                    Lock lock = writeLock;
                                    lock.lock();
                                    try {
                                        boolean bl = false;
                                        objectRef.element = A_Type.Companion.typeIntersection((A_Type)objectRef.element, it);
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    finally {
                                        lock.unlock();
                                    }
                                } else {
                                    this.$problems.add(StringDescriptor.Companion.stringFrom("Semantic restriction failed to produce a type, and instead produced: " + it));
                                }
                                this.$after.invoke();
                            }
                        }, (Function1<? super Throwable, Unit>)new Function1<Throwable, Unit>(this.$problems, after){
                            final /* synthetic */ List<A_String> $problems;
                            final /* synthetic */ Function0<Unit> $after;
                            {
                                this.$problems = $problems;
                                this.$after = $after;
                                super(1);
                            }

                            public final void invoke(@NotNull Throwable throwable) {
                                Intrinsics.checkNotNullParameter(throwable, "throwable");
                                Throwable throwable2 = throwable;
                                if (throwable2 instanceof AvailRejectedParseException) {
                                    this.$problems.add(((AvailRejectedParseException)throwable).getRejectionString());
                                } else if (!(throwable2 instanceof AvailAcceptedParseException)) {
                                    this.$problems.add(StringDescriptor.Companion.stringFrom("evaluation of macro body not to raise an unhandled exception:\n\t" + throwable));
                                }
                                this.$after.invoke();
                            }
                        });
                        this.$runtime.runOutermostFunction(forkedFiber2, restriction2.function(), this.$argTypesList);
                    }
                }, new Function0<Unit>(problems, $this$suspendThen, this.$bundle, this.$argsListPhrase, this.$intersection){
                    final /* synthetic */ List<A_String> $problems;
                    final /* synthetic */ Interpreter.SuspensionHelper<A_BasicObject> $this_suspendThen;
                    final /* synthetic */ A_Bundle $bundle;
                    final /* synthetic */ AvailObject $argsListPhrase;
                    final /* synthetic */ Ref.ObjectRef<A_Type> $intersection;
                    {
                        this.$problems = $problems;
                        this.$this_suspendThen = $this_suspendThen;
                        this.$bundle = $bundle;
                        this.$argsListPhrase = $argsListPhrase;
                        this.$intersection = $intersection;
                        super(0);
                    }

                    public final void invoke() {
                        if (this.$problems.isEmpty()) {
                            this.$this_suspendThen.succeed(ObjectTupleDescriptor.Companion.tuple(ObjectTupleDescriptor.Companion.tuple(SendPhraseDescriptor.Companion.newSendNode(TupleDescriptor.Companion.getEmptyTuple(), TupleDescriptor.Companion.getEmptyTuple(), this.$bundle, this.$argsListPhrase, (A_Type)this.$intersection.element)), TupleDescriptor.Companion.getEmptyTuple()));
                        } else {
                            A_BasicObject a_BasicObject = TupleDescriptor.Companion.getEmptyTuple();
                            List<A_String> list2 = this.$problems;
                            Intrinsics.checkNotNullExpressionValue(list2, "problems");
                            this.$this_suspendThen.succeed(ObjectTupleDescriptor.Companion.tuple(a_BasicObject, P_CreateRestrictedSendExpression.access$collectProblemReport(P_CreateRestrictedSendExpression.INSTANCE, list2)));
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final A_String collectProblemReport(List<? extends A_String> problems) {
        A_String a_String;
        if (problems.size() == 1) {
            a_String = problems.get(0);
        } else {
            void $this$collectProblemReport_u24lambda_u242;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            StringDescriptor.Companion companion = StringDescriptor.Companion;
            boolean bl = false;
            $this$collectProblemReport_u24lambda_u242.append("send phrase creation primitive not to have encountered multiple problems in semantic restrictions:");
            for (A_String a_String2 : problems) {
                $this$collectProblemReport_u24lambda_u242.append("\n\t");
                $this$collectProblemReport_u24lambda_u242.append(Strings.INSTANCE.increaseIndentation(A_String.Companion.asNativeString(a_String2), 1));
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            a_String = companion.stringFrom(string2);
        }
        return a_String;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_Type[] a_TypeArray = new A_Type[]{TupleTypeDescriptor.Companion.zeroOrOneOf(PhraseTypeDescriptor.PhraseKind.SEND_PHRASE.getMostGeneralType()), TupleTypeDescriptor.Companion.getStringType()};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.getMostGeneralType(), InstanceMetaDescriptor.Companion.topMeta()), TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        boolean bl;
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        boolean bl2 = bl = argumentTypes.size() == 3;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Type returnTypeType = argumentTypes.get(2);
        AvailObject returnType = A_Type.Companion.getInstance(returnTypeType);
        A_Type[] a_TypeArray = new A_Type[]{TupleTypeDescriptor.Companion.zeroOrOneOf(PhraseTypeDescriptor.PhraseKind.SEND_PHRASE.create(returnType)), TupleTypeDescriptor.Companion.getStringType()};
        return TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS, AvailErrorCode.E_NO_METHOD_DEFINITION, AvailErrorCode.E_LOADING_IS_OVER};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(A_Set.Companion.setUnionCanDestroy(SetDescriptor.Companion.set(availErrorCodeArray), MessageSplitter.Companion.getPossibleErrors(), true));
    }

    public static final /* synthetic */ A_String access$collectProblemReport(P_CreateRestrictedSendExpression $this, List problems) {
        return $this.collectProblemReport(problems);
    }
}

