/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.phrases;

import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.SuperCastPhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/phrases/P_CreateSuperCastExpression;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_CreateSuperCastExpression
extends Primitive {
    @NotNull
    public static final P_CreateSuperCastExpression INSTANCE = new P_CreateSuperCastExpression();

    private P_CreateSuperCastExpression() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject expression2 = interpreter.argument(0);
        AvailObject lookupType = interpreter.argument(1);
        A_Type expressionType = A_Phrase.Companion.getPhraseExpressionType(expression2);
        return expressionType.isBottom() || expressionType.isTop() ? interpreter.primitiveFailure(AvailErrorCode.E_SUPERCAST_EXPRESSION_TYPE_MUST_NOT_BE_TOP_OR_BOTTOM) : (A_Phrase.Companion.phraseKindIsUnder(expression2, PhraseTypeDescriptor.PhraseKind.SUPER_CAST_PHRASE) ? interpreter.primitiveFailure(AvailErrorCode.E_SUPERCAST_EXPRESSION_MUST_NOT_ALSO_BE_A_SUPERCAST) : (!A_Type.Companion.isSubtypeOf(expressionType, lookupType) || expressionType.equals(lookupType) ? interpreter.primitiveFailure(AvailErrorCode.E_SUPERCAST_MUST_BE_STRICT_SUPERTYPE_OF_EXPRESSION_TYPE) : interpreter.primitiveSuccess(SuperCastPhraseDescriptor.Companion.newSuperCastNode(expression2, lookupType))));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PhraseTypeDescriptor.PhraseKind.EXPRESSION_PHRASE.create(PrimitiveTypeDescriptor.Types.ANY.getO()), InstanceMetaDescriptor.Companion.anyMeta()), PhraseTypeDescriptor.PhraseKind.SUPER_CAST_PHRASE.getMostGeneralType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_SUPERCAST_EXPRESSION_TYPE_MUST_NOT_BE_TOP_OR_BOTTOM, AvailErrorCode.E_SUPERCAST_EXPRESSION_MUST_NOT_ALSO_BE_A_SUPERCAST, AvailErrorCode.E_SUPERCAST_MUST_BE_STRICT_SUPERTYPE_OF_EXPRESSION_TYPE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

