/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.style;

import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.methods.A_Styler;
import avail.descriptor.methods.StylerDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.style.P_BootstrapBlockMacroStyler;
import avail.utility.structures.RunTree;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/style/P_BootstrapBlockMacroStyler;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_BootstrapBlockMacroStyler
extends Primitive {
    @NotNull
    public static final P_BootstrapBlockMacroStyler INSTANCE = new P_BootstrapBlockMacroStyler();

    private P_BootstrapBlockMacroStyler() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.Bootstrap, Primitive.Flag.ReadsFromHiddenGlobalState, Primitive.Flag.WritesToHiddenGlobalState};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        A_Tuple optionalSendPhrase = interpreter.argument(0);
        A_Fiber fiber2 = interpreter.fiber();
        if (!A_Fiber.Companion.getCanStyle(fiber2)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_STYLE);
        }
        AvailLoader availLoader = A_Fiber.Companion.getAvailLoader(fiber2);
        Intrinsics.checkNotNull(availLoader);
        AvailLoader loader = availLoader;
        if (A_Tuple.Companion.getTupleSize(optionalSendPhrase) == 0) {
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        AvailObject sendPhrase = A_Tuple.Companion.tupleAt(optionalSendPhrase, 1);
        A_Tuple a_Tuple = A_Phrase.Companion.getExpressionsTuple(A_Phrase.Companion.getArgumentsListNode(sendPhrase));
        AvailObject optPrim = A_Tuple.Companion.component2(a_Tuple);
        AvailObject optReturn = A_Tuple.Companion.component5(a_Tuple);
        AvailLoader.styleTokens$default(loader, (Iterable)A_Phrase.Companion.getTokens(sendPhrase), StylerDescriptor.SystemStyle.BLOCK, false, null, 12, null);
        if (A_Phrase.Companion.getExpressionsSize(optPrim) > 0) {
            A_Phrase primDecl = A_Phrase.Companion.expressionAt(optPrim, 1);
            A_Phrase primNamePhrase = A_Phrase.Companion.expressionAt(primDecl, 1);
            boolean bl = A_Phrase.Companion.phraseKindIsUnder(primNamePhrase, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            AvailLoader.styleToken$default(loader, (A_Token)A_Phrase.Companion.getToken(primNamePhrase).literal(), StylerDescriptor.SystemStyle.PRIMITIVE_NAME, false, null, 12, null);
        }
        if (A_Phrase.Companion.getExpressionsSize(optReturn) > 0) {
            AvailObject returnPhrase = A_Phrase.Companion.getToken(A_Phrase.Companion.expressionAt(optReturn, 1)).literal();
            boolean primNamePhrase = A_Phrase.Companion.phraseKindIsUnder(returnPhrase, PhraseTypeDescriptor.PhraseKind.EXPRESSION_PHRASE);
            if (_Assertions.ENABLED && !primNamePhrase) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            A_Tuple tokens2 = A_Phrase.Companion.getAllTokens(returnPhrase);
            loader.lockStyles((Function1)new Function1<RunTree<String>, Unit>(tokens2){
                final /* synthetic */ A_Tuple $tokens;
                {
                    this.$tokens = $tokens;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull RunTree<String> $this$lockStyles) {
                    Map lines;
                    void $this$groupByTo$iv$iv;
                    Intrinsics.checkNotNullParameter($this$lockStyles, "$this$lockStyles");
                    Iterable $this$groupBy$iv = this.$tokens;
                    boolean $i$f$groupBy = false;
                    Object object = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object2;
                        AvailObject it = (AvailObject)element$iv$iv;
                        boolean bl = false;
                        Integer key$iv$iv = it.lineNumber();
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object2 = answer$iv$iv$iv;
                        } else {
                            object2 = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object2;
                        list$iv$iv.add(element$iv$iv);
                    }
                    Map $this$forEach$iv = lines = destination$iv$iv;
                    boolean $i$f$forEach = false;
                    object = $this$forEach$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = (Map.Entry)object.next();
                        boolean bl = false;
                        List line = (List)entry.getValue();
                        int start = ((AvailObject)CollectionsKt.first(line)).start();
                        int pastEnd = A_Token.Companion.pastEnd((A_Token)CollectionsKt.last(line));
                        $this$lockStyles.edit(start, pastEnd, (Function1<String, String>)attempt.1.1.INSTANCE);
                    }
                }
            });
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_STYLE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return A_Styler.Companion.getStylerFunctionType();
    }
}

