/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.tuples;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u001e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u0016\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016J\b\u0010\u0012\u001a\u00020\nH\u0014J\b\u0010\u0013\u001a\u00020\nH\u0014J\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/primitive/tuples/P_ExtractSubtuple;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "checkFallibility", "Lavail/interpreter/Primitive$Fallibility;", "sizeRange", "Lavail/descriptor/types/A_Type;", "startIndexType", "endIndexType", "computeSliceType", "tupleType", "fallibilityForArgumentTypes", "argumentTypes", "", "privateBlockTypeRestriction", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "avail"})
public final class P_ExtractSubtuple
extends Primitive {
    @NotNull
    public static final P_ExtractSubtuple INSTANCE = new P_ExtractSubtuple();

    private P_ExtractSubtuple() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject tuple2 = interpreter.argument(0);
        AvailObject start = interpreter.argument(1);
        AvailObject end = interpreter.argument(2);
        if (!A_Number.Companion.isInt(start) || !A_Number.Companion.isInt(end)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS);
        }
        int startInt = A_Number.Companion.getExtractInt(start);
        int endInt = A_Number.Companion.getExtractInt(end);
        return startInt < 1 ? interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS) : (startInt > endInt + 1 ? interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS) : (endInt > A_Tuple.Companion.getTupleSize(tuple2) ? interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS) : interpreter.primitiveSuccess(A_Tuple.Companion.copyTupleFromToCanDestroy(tuple2, startInt, endInt, true))));
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type tupleType = argumentTypes.get(0);
        A_Type startIndexType = argumentTypes.get(1);
        A_Type endIndexType = argumentTypes.get(2);
        return this.checkFallibility(A_Type.Companion.getSizeRange(tupleType), startIndexType, endIndexType);
    }

    @NotNull
    public final Primitive.Fallibility checkFallibility(@NotNull A_Type sizeRange, @NotNull A_Type startIndexType, @NotNull A_Type endIndexType) {
        Intrinsics.checkNotNullParameter(sizeRange, "sizeRange");
        Intrinsics.checkNotNullParameter(startIndexType, "startIndexType");
        Intrinsics.checkNotNullParameter(endIndexType, "endIndexType");
        A_Number $this$checkFallibility_u24lambda_u240 = A_Type.Companion.getLowerBound(sizeRange);
        boolean bl = false;
        if (!A_Number.Companion.isInt($this$checkFallibility_u24lambda_u240)) {
            return Primitive.Fallibility.CallSiteMustFail;
        }
        int sizeLower = A_Number.Companion.getExtractInt($this$checkFallibility_u24lambda_u240);
        A_Number $this$checkFallibility_u24lambda_u241 = A_Type.Companion.getUpperBound(sizeRange);
        boolean bl2 = false;
        int sizeUpper = A_Number.Companion.isInt($this$checkFallibility_u24lambda_u241) ? A_Number.Companion.getExtractInt($this$checkFallibility_u24lambda_u241) : Integer.MAX_VALUE;
        A_Number $this$checkFallibility_u24lambda_u242 = A_Type.Companion.getLowerBound(startIndexType);
        boolean bl3 = false;
        if (!A_Number.Companion.isInt($this$checkFallibility_u24lambda_u242)) {
            return Primitive.Fallibility.CallSiteMustFail;
        }
        int startLower = A_Number.Companion.getExtractInt($this$checkFallibility_u24lambda_u242);
        A_Number $this$checkFallibility_u24lambda_u243 = A_Type.Companion.getLowerBound(endIndexType);
        boolean bl4 = false;
        if (!A_Number.Companion.isInt($this$checkFallibility_u24lambda_u243)) {
            return Primitive.Fallibility.CallSiteMustFail;
        }
        int endLower = A_Number.Companion.getExtractInt($this$checkFallibility_u24lambda_u243);
        A_Number $this$checkFallibility_u24lambda_u244 = A_Type.Companion.getUpperBound(startIndexType);
        boolean bl5 = false;
        if (!A_Number.Companion.isInt($this$checkFallibility_u24lambda_u244)) {
            return Primitive.Fallibility.CallSiteCanFail;
        }
        int startUpper = A_Number.Companion.getExtractInt($this$checkFallibility_u24lambda_u244);
        A_Number $this$checkFallibility_u24lambda_u245 = A_Type.Companion.getUpperBound(endIndexType);
        boolean bl6 = false;
        if (!A_Number.Companion.isInt($this$checkFallibility_u24lambda_u245)) {
            return Primitive.Fallibility.CallSiteCanFail;
        }
        int endUpper = A_Number.Companion.getExtractInt($this$checkFallibility_u24lambda_u245);
        return endUpper < startLower - 1 ? Primitive.Fallibility.CallSiteMustFail : (startLower - 1 > sizeUpper ? Primitive.Fallibility.CallSiteMustFail : (endLower < startUpper - 1 ? Primitive.Fallibility.CallSiteCanFail : (endUpper > sizeLower ? Primitive.Fallibility.CallSiteCanFail : Primitive.Fallibility.CallSiteCannotFail)));
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type tupleType = argumentTypes.get(0);
        A_Type startIndexType = argumentTypes.get(1);
        A_Type endIndexType = argumentTypes.get(2);
        return this.computeSliceType(tupleType, startIndexType, endIndexType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final A_Type computeSliceType(@NotNull A_Type tupleType, @NotNull A_Type startIndexType, @NotNull A_Type endIndexType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(tupleType, "tupleType");
        Intrinsics.checkNotNullParameter(startIndexType, "startIndexType");
        Intrinsics.checkNotNullParameter(endIndexType, "endIndexType");
        A_Type fallback = TupleTypeDescriptor.Companion.getMostGeneralTupleType();
        A_Type sizeRange = A_Type.Companion.getSizeRange(tupleType);
        A_Number $this$computeSliceType_u24lambda_u246 = A_Type.Companion.getUpperBound(sizeRange);
        boolean bl = false;
        int sizeUpper = A_Number.Companion.isInt($this$computeSliceType_u24lambda_u246) ? A_Number.Companion.getExtractInt($this$computeSliceType_u24lambda_u246) : Integer.MAX_VALUE;
        A_Number $this$computeSliceType_u24lambda_u247 = A_Type.Companion.getLowerBound(startIndexType);
        boolean bl2 = false;
        if (!A_Number.Companion.isInt($this$computeSliceType_u24lambda_u247)) {
            return fallback;
        }
        int startLower = A_Number.Companion.getExtractInt($this$computeSliceType_u24lambda_u247);
        A_Number $this$computeSliceType_u24lambda_u248 = A_Type.Companion.getUpperBound(startIndexType);
        boolean bl3 = false;
        int startUpper = !A_Number.Companion.isInt($this$computeSliceType_u24lambda_u248) ? Integer.MAX_VALUE : A_Number.Companion.getExtractInt($this$computeSliceType_u24lambda_u248);
        A_Number $this$computeSliceType_u24lambda_u249 = A_Type.Companion.getLowerBound(endIndexType);
        boolean bl4 = false;
        if (!A_Number.Companion.isInt($this$computeSliceType_u24lambda_u249)) {
            return fallback;
        }
        int endLower = A_Number.Companion.getExtractInt($this$computeSliceType_u24lambda_u249);
        A_Number $this$computeSliceType_u24lambda_u2410 = A_Type.Companion.getUpperBound(endIndexType);
        boolean bl5 = false;
        int endUpper = !A_Number.Companion.isInt($this$computeSliceType_u24lambda_u2410) ? Integer.MAX_VALUE : A_Number.Companion.getExtractInt($this$computeSliceType_u24lambda_u2410);
        if (startLower > endUpper) {
            return InstanceTypeDescriptor.Companion.instanceType(TupleDescriptor.Companion.getEmptyTuple());
        }
        int variationLimit = Math.min(A_Tuple.Companion.getTupleSize(A_Type.Companion.getTypeTuple(tupleType)) + 1, sizeUpper);
        int smearDelta = startUpper - startLower;
        Iterable $this$map$iv = new IntRange(startLower, Math.max(startLower, Math.min(endUpper, variationLimit)));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection2 = destination$iv$iv;
            boolean bl6 = false;
            collection2.add(A_Type.Companion.unionOfTypesAtThrough(tupleType, (int)it, (int)Math.min((long)it + (long)smearDelta, Integer.MAX_VALUE)));
        }
        List leadingTypes = (List)destination$iv$iv;
        int minSize = Math.max(endLower - startUpper + 1, 0);
        int maxSize = Math.min(endUpper, sizeUpper) - startLower + 1;
        A_Number maxSizeObject = endUpper == Integer.MAX_VALUE && sizeUpper == Integer.MAX_VALUE ? InfinityDescriptor.Companion.getPositiveInfinity() : (A_Number)IntegerDescriptor.Companion.fromInt(maxSize);
        return TupleTypeDescriptor.Companion.tupleTypeForSizesTypesDefaultType(IntegerRangeTypeDescriptor.Companion.integerRangeType(IntegerDescriptor.Companion.fromInt(minSize), true, maxSizeObject, maxSizeObject.isFinite()), ObjectTupleDescriptor.Companion.tupleFromList(leadingTypes), (A_Type)CollectionsKt.last(leadingTypes)).makeImmutable();
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getMostGeneralTupleType(), IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), IntegerRangeTypeDescriptor.Companion.getWholeNumbers()), TupleTypeDescriptor.Companion.getMostGeneralTupleType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

