/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer;

import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operation.L2_JUMP;
import avail.interpreter.levelTwo.operation.L2_PHI_PSEUDO_OPERATION;
import avail.optimizer.L2ControlFlowGraph;
import avail.optimizer.L2Generator;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.reoptimizer.L2Regenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0016J\u000e\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0016J\u0006\u0010%\u001a\u00020\u0005J\u0006\u0010&\u001a\u00020\rJ\u0014\u0010'\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0006\u0010)\u001a\u00020\u0014J\u0016\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\rJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u0006\u0010-\u001a\u00020\u001dJ\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160.J\u0006\u0010/\u001a\u00020\u001dJ\u000e\u00100\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0016J\u000e\u00101\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0016J\u0006\u00102\u001a\u00020\u001dJ\u0016\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u0016J$\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u0002082\b\b\u0002\u00109\u001a\u00020\u00052\n\b\u0002\u0010:\u001a\u0004\u0018\u00010;J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160.J\b\u0010<\u001a\u00020\u0003H\u0016R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006="}, d2={"Lavail/optimizer/L2BasicBlock;", "", "name", "", "isLoopHead", "", "zone", "Lavail/optimizer/L2ControlFlowGraph$Zone;", "(Ljava/lang/String;ZLavail/optimizer/L2ControlFlowGraph$Zone;)V", "hasControlFlowAtEnd", "hasStartedCodeGeneration", "instructions", "", "Lavail/interpreter/levelTwo/L2Instruction;", "<set-?>", "isIrremovable", "()Z", "setLoopHead", "(Z)V", "offset", "", "predecessorEdges", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "successorEdges", "getZone", "()Lavail/optimizer/L2ControlFlowGraph$Zone;", "setZone", "(Lavail/optimizer/L2ControlFlowGraph$Zone;)V", "addInstruction", "", "instruction", "manifest", "Lavail/optimizer/L2ValueManifest;", "addPredecessorEdge", "predecessorEdge", "addSuccessorEdge", "successorEdge", "currentlyReachable", "finalInstruction", "generateOn", "output", "indexAfterEntryPointAndPhis", "insertInstruction", "index", "justAddInstruction", "makeIrremovable", "", "readdedControlFlowInstruction", "removePredecessorEdge", "removeSuccessorEdge", "removedControlFlowInstruction", "replacePredecessorEdge", "oldPredecessorEdge", "newPredecessorEdge", "startIn", "generator", "Lavail/optimizer/L2Generator;", "generatePhis", "regenerator", "Lavail/optimizer/reoptimizer/L2Regenerator;", "toString", "avail"})
public final class L2BasicBlock {
    @NotNull
    private final String name;
    private boolean isLoopHead;
    @Nullable
    private L2ControlFlowGraph.Zone zone;
    @NotNull
    private final List<L2Instruction> instructions;
    @NotNull
    private final List<L2PcOperand> successorEdges;
    @NotNull
    private final List<L2PcOperand> predecessorEdges;
    private int offset;
    private boolean isIrremovable;
    private boolean hasStartedCodeGeneration;
    private boolean hasControlFlowAtEnd;

    public L2BasicBlock(@NotNull String name, boolean isLoopHead, @Nullable L2ControlFlowGraph.Zone zone) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
        this.isLoopHead = isLoopHead;
        this.zone = zone;
        this.instructions = new ArrayList();
        this.successorEdges = new ArrayList();
        this.predecessorEdges = new ArrayList();
        this.offset = -1;
    }

    public /* synthetic */ L2BasicBlock(String string2, boolean bl, L2ControlFlowGraph.Zone zone, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            zone = null;
        }
        this(string2, bl, zone);
    }

    public final boolean isLoopHead() {
        return this.isLoopHead;
    }

    public final void setLoopHead(boolean bl) {
        this.isLoopHead = bl;
    }

    @Nullable
    public final L2ControlFlowGraph.Zone getZone() {
        return this.zone;
    }

    public final void setZone(@Nullable L2ControlFlowGraph.Zone zone) {
        this.zone = zone;
    }

    public final boolean isIrremovable() {
        return this.isIrremovable;
    }

    @NotNull
    public final String name() {
        return this.name;
    }

    public final void makeIrremovable() {
        this.isIrremovable = true;
    }

    public final int offset() {
        return this.offset;
    }

    @NotNull
    public final List<L2Instruction> instructions() {
        return this.instructions;
    }

    @NotNull
    public final L2Instruction finalInstruction() {
        return this.instructions.get(this.instructions.size() - 1);
    }

    @NotNull
    public final List<L2PcOperand> predecessorEdges() {
        return this.predecessorEdges;
    }

    public final void addPredecessorEdge(@NotNull L2PcOperand predecessorEdge) {
        Intrinsics.checkNotNullParameter(predecessorEdge, "predecessorEdge");
        boolean bl = predecessorEdge.sourceBlock().hasStartedCodeGeneration;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.predecessorEdges.add(predecessorEdge);
        if (this.hasStartedCodeGeneration) {
            L2Instruction instruction2;
            L2Operation operation;
            L2ValueManifest predecessorManifest = predecessorEdge.manifest();
            int n = this.instructions.size();
            for (int i2 = 0; i2 < n && (operation = (instruction2 = this.instructions.get(i2)).getOperation()).isPhi(); ++i2) {
                L2Operation $this$cast$iv = operation;
                boolean $i$f$cast = false;
                L2_PHI_PSEUDO_OPERATION phiOperation = (L2_PHI_PSEUDO_OPERATION)$this$cast$iv;
                phiOperation.updateLoopHeadPhi(predecessorManifest, instruction2);
            }
        }
    }

    public final void removePredecessorEdge(@NotNull L2PcOperand predecessorEdge) {
        Intrinsics.checkNotNullParameter(predecessorEdge, "predecessorEdge");
        boolean bl = predecessorEdge.sourceBlock().hasStartedCodeGeneration;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (this.hasStartedCodeGeneration) {
            L2Instruction instruction2;
            int index2 = this.predecessorEdges.indexOf(predecessorEdge);
            this.predecessorEdges.remove(index2);
            int n = this.instructions.size();
            for (int i2 = 0; i2 < n && (instruction2 = this.instructions.get(i2)).getOperation().isPhi(); ++i2) {
                L2Operation $this$cast$iv = instruction2.getOperation();
                boolean $i$f$cast = false;
                L2_PHI_PSEUDO_OPERATION phiOperation = (L2_PHI_PSEUDO_OPERATION)$this$cast$iv;
                L2Instruction replacement2 = phiOperation.withoutIndex(instruction2, index2);
                instruction2.justRemoved();
                this.instructions.set(i2, replacement2);
                replacement2.justInserted();
            }
        }
        this.predecessorEdges.remove(predecessorEdge);
    }

    @NotNull
    public final List<L2PcOperand> successorEdges() {
        return this.successorEdges;
    }

    public final void addSuccessorEdge(@NotNull L2PcOperand successorEdge) {
        Intrinsics.checkNotNullParameter(successorEdge, "successorEdge");
        this.successorEdges.add(successorEdge);
    }

    public final void removeSuccessorEdge(@NotNull L2PcOperand successorEdge) {
        Intrinsics.checkNotNullParameter(successorEdge, "successorEdge");
        boolean success2 = this.successorEdges.remove(successorEdge);
        if (_Assertions.ENABLED && !success2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void startIn(@NotNull L2Generator generator, boolean generatePhis, @Nullable L2Regenerator regenerator2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(generator, "generator");
        generator.getCurrentManifest().clear();
        if (this.isIrremovable) {
            return;
        }
        Iterable iterable = this.predecessorEdges;
        L2ValueManifest l2ValueManifest = generator.getCurrentManifest();
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            L2PcOperand l2PcOperand = (L2PcOperand)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(p0.manifest());
        }
        l2ValueManifest.populateFromIntersection((List)destination$iv$iv, generator, generatePhis, this.isLoopHead, regenerator2);
    }

    public static /* synthetic */ void startIn$default(L2BasicBlock l2BasicBlock, L2Generator l2Generator, boolean bl, L2Regenerator l2Regenerator, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            l2Regenerator = null;
        }
        l2BasicBlock.startIn(l2Generator, bl, l2Regenerator);
    }

    public final void addInstruction(@NotNull L2Instruction instruction2, @NotNull L2ValueManifest manifest2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(manifest2, "manifest");
        boolean bl2 = this.isIrremovable || !((Collection)this.predecessorEdges()).isEmpty() ? true : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.justAddInstruction(instruction2);
        instruction2.justAdded(manifest2);
    }

    private final void justAddInstruction(L2Instruction instruction2) {
        boolean bl;
        boolean bl2 = bl = !this.hasControlFlowAtEnd;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        bl = Intrinsics.areEqual(instruction2.basicBlock(), this);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (instruction2.getOperation().isPhi()) {
            this.instructions.add(0, instruction2);
        } else {
            this.instructions.add(instruction2);
        }
        this.hasStartedCodeGeneration = true;
        this.hasControlFlowAtEnd = instruction2.getAltersControlFlow();
    }

    /*
     * WARNING - void declaration
     */
    public final int indexAfterEntryPointAndPhis() {
        Iterable $this$forEachIndexed$iv = this.instructions;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void instruction2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            L2Instruction l2Instruction = (L2Instruction)item$iv;
            int i2 = n;
            boolean bl = false;
            if (instruction2.isEntryPoint() || instruction2.getOperation().isPhi()) continue;
            return i2;
        }
        return this.instructions.size() - 1;
    }

    public final void insertInstruction(int index2, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        boolean bl = Intrinsics.areEqual(instruction2.basicBlock(), this);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.instructions.add(index2, instruction2);
        this.hasStartedCodeGeneration = true;
        instruction2.justInserted();
    }

    public final void replacePredecessorEdge(@NotNull L2PcOperand oldPredecessorEdge, @NotNull L2PcOperand newPredecessorEdge) {
        Intrinsics.checkNotNullParameter(oldPredecessorEdge, "oldPredecessorEdge");
        Intrinsics.checkNotNullParameter(newPredecessorEdge, "newPredecessorEdge");
        this.predecessorEdges.set(this.predecessorEdges.indexOf(oldPredecessorEdge), newPredecessorEdge);
    }

    public final void removedControlFlowInstruction() {
        this.hasControlFlowAtEnd = false;
    }

    public final void readdedControlFlowInstruction() {
        this.hasControlFlowAtEnd = true;
    }

    public final boolean currentlyReachable() {
        return (this.isIrremovable || !((Collection)this.predecessorEdges).isEmpty()) && !this.hasControlFlowAtEnd;
    }

    public final void generateOn(@NotNull List<L2Instruction> output) {
        int counter;
        Intrinsics.checkNotNullParameter(output, "output");
        boolean changed = false;
        do {
            L2Instruction previousInstruction;
            changed = false;
            if (!(!((Collection)output).isEmpty()) || (previousInstruction = output.get(output.size() - 1)).getOperation() != L2_JUMP.INSTANCE || !Intrinsics.areEqual(L2_JUMP.jumpTarget(previousInstruction).targetBlock(), this)) continue;
            output.remove(output.size() - 1);
            changed = true;
        } while (changed);
        this.offset = counter = output.size();
        for (L2Instruction instruction2 : this.instructions) {
            if (!instruction2.getShouldEmit()) continue;
            instruction2.setOffset(counter++);
            output.add(instruction2);
        }
    }

    @NotNull
    public String toString() {
        Object suffix = "";
        if (this.instructions.size() > 0) {
            int firstOffset = this.instructions.get(0).getOffset();
            int lastOffset = CollectionsKt.last(this.instructions).getOffset();
            if (firstOffset != -1 && lastOffset != -1) {
                suffix = " [" + firstOffset + ".." + lastOffset + "]";
            }
        }
        String hex2 = Integer.toHexString(this.hashCode());
        return "BasicBlock(" + this.name + ")" + (String)suffix + " [" + hex2 + "]";
    }
}

