/*
 * Decompiled with CFR 0.152.
 */
package avail.resolver;

import avail.builder.ModuleName;
import avail.builder.ModuleNameResolver;
import avail.builder.ModuleRoot;
import avail.builder.ResolvedModuleName;
import avail.builder.UnresolvedModuleException;
import avail.error.ErrorCode;
import avail.files.AbstractFileWrapper;
import avail.files.FileErrorCode;
import avail.files.FileManager;
import avail.files.ManagedFileWrapper;
import avail.resolver.ResolverReference;
import avail.utility.Strings;
import java.io.File;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.artifact.ResourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000e\b&\u0018\u00002\u00020\u0001:\u0001`B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010)\u001a\u00020'H\u0016J:\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u00032\f\u0010,\u001a\b\u0012\u0004\u0012\u00020'0-2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0004\u0012\u00020'0%H&JB\u00101\u001a\u00020'2\u0006\u0010+\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\f\u0010,\u001a\b\u0012\u0004\u0012\u00020'0-2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0004\u0012\u00020'0%H&J:\u00103\u001a\u00020'2\u0006\u0010+\u001a\u00020\u00032\f\u0010,\u001a\b\u0012\u0004\u0012\u00020'0-2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0004\u0012\u00020'0%H&J:\u00104\u001a\u00020'2\u0006\u0010+\u001a\u00020\u00032\f\u0010,\u001a\b\u0012\u0004\u0012\u00020'0-2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0004\u0012\u00020'0%H&J\u0016\u00105\u001a\u00020'2\f\u00106\u001a\b\u0012\u0004\u0012\u00020'0-H\u0016J\u0016\u00107\u001a\u0002082\u0006\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020\u0016J\"\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010+\u001a\u00020=2\u0006\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020@H\u0016J\u000e\u0010A\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0003J\u000e\u0010B\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u0003J\u0012\u0010D\u001a\u0004\u0018\u00010\u00162\u0006\u0010+\u001a\u00020\u0003H\u0016J8\u0010E\u001a\u00020'2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020'0G2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0004\u0012\u00020'0%H\u0016J@\u0010H\u001a\u00020'2\u0006\u0010+\u001a\u00020\u00032\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020'0G2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0004\u0012\u00020'0%H\u0016JP\u0010J\u001a\u00020'2\u0006\u0010K\u001a\u00020\n2\u0006\u0010:\u001a\u00020\u00162\u001a\u0010L\u001a\u0016\u0012\u0004\u0012\u00020M\u0012\u0006\u0012\u0004\u0018\u00010$\u0012\u0004\u0012\u00020'0%2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0004\u0012\u00020'0%H&J\u001e\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00160O2\u0006\u0010P\u001a\u00020\u00032\b\b\u0002\u0010Q\u001a\u00020\nJ@\u0010R\u001a\u00020'2\u0006\u0010:\u001a\u00020\u00162\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u00020'0G2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0004\u0012\u00020'0%H&JF\u0010T\u001a\u00020'2\u0006\u0010:\u001a\u00020\u00162\u0018\u0010F\u001a\u0014\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u00020'0%2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0004\u0012\u00020'0%H&J8\u0010U\u001a\u00020'2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020'0G2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0004\u0012\u00020'0%H&J\b\u0010V\u001a\u00020\nH&JF\u0010W\u001a\u00020'2\u0006\u0010X\u001a\u00020\n2\u0018\u0010Y\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160O\u0012\u0004\u0012\u00020'0G2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0004\u0012\u00020'0%H&JB\u0010Z\u001a\u00020'2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010[\u001a\u00020M2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020'0-2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0004\u0012\u00020'0%H&J \u0010\\\u001a\u00020$2\u0018\u0010]\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020'0%J\u000e\u0010^\u001a\u00020'2\u0006\u00109\u001a\u00020$J\u001e\u0010_\u001a\u00020\n*\u00020\u00162\u0006\u0010P\u001a\u00020\u00032\b\b\u0002\u0010Q\u001a\u00020\nH\u0002R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R/\u0010#\u001a \u0012\u0004\u0012\u00020$\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020'0%0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010 \u00a8\u0006a"}, d2={"Lavail/resolver/ModuleRootResolver;", "", "name", "", "uri", "Ljava/net/URI;", "fileManager", "Lavail/files/FileManager;", "(Ljava/lang/String;Ljava/net/URI;Lavail/files/FileManager;)V", "canSave", "", "getCanSave", "()Z", "getFileManager", "()Lavail/files/FileManager;", "moduleRoot", "Lavail/builder/ModuleRoot;", "getModuleRoot$annotations", "()V", "getModuleRoot", "()Lavail/builder/ModuleRoot;", "moduleRootTree", "Lavail/resolver/ResolverReference;", "getModuleRootTree$avail", "()Lavail/resolver/ResolverReference;", "setModuleRootTree$avail", "(Lavail/resolver/ResolverReference;)V", "getName", "()Ljava/lang/String;", "referenceMap", "", "getReferenceMap", "()Ljava/util/Map;", "getUri", "()Ljava/net/URI;", "watchEventSubscriptions", "Ljava/util/UUID;", "Lkotlin/Function2;", "Lavail/resolver/ModuleRootResolver$WatchEventType;", "", "getWatchEventSubscriptions", "close", "createDirectory", "qualifiedName", "completion", "Lkotlin/Function0;", "failureHandler", "Lavail/error/ErrorCode;", "", "createFile", "mimeType", "createPackage", "deleteResource", "executeTask", "task", "fileWrapper", "Lavail/files/AbstractFileWrapper;", "id", "reference", "find", "Lavail/builder/ModuleNameResolver$ModuleNameResolutionResult;", "Lavail/builder/ModuleName;", "initialCanonicalName", "moduleNameResolver", "Lavail/builder/ModuleNameResolver;", "fullResourceURI", "getQualifiedName", "targetURI", "getResolverReference", "provideModuleRootTree", "successHandler", "Lkotlin/Function1;", "provideResolverReference", "withReference", "readFile", "bypassFileManager", "withContents", "", "referencesMatchingAbbreviation", "", "abbreviation", "ignoreCase", "refreshResolverMetaData", "", "refreshResolverReferenceDigest", "resolve", "resolvesToValidModuleRoot", "rootManifest", "forceRefresh", "withList", "saveFile", "fileContents", "subscribeRootWatcher", "watchAction", "unsubscribeRootWatcher", "matchesAbbreviation", "WatchEventType", "avail"})
public abstract class ModuleRootResolver {
    @NotNull
    private final String name;
    @NotNull
    private final URI uri;
    @NotNull
    private final FileManager fileManager;
    @NotNull
    private final ModuleRoot moduleRoot;
    @NotNull
    private final Map<String, ResolverReference> referenceMap;
    @NotNull
    private final Map<UUID, Function2<WatchEventType, ResolverReference, Unit>> watchEventSubscriptions;
    @Nullable
    private ResolverReference moduleRootTree;

    public ModuleRootResolver(@NotNull String name, @NotNull URI uri, @NotNull FileManager fileManager) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(uri, "uri");
        Intrinsics.checkNotNullParameter(fileManager, "fileManager");
        this.name = name;
        this.uri = uri;
        this.fileManager = fileManager;
        this.moduleRoot = new ModuleRoot(this.name, this);
        this.referenceMap = new LinkedHashMap();
        Map map = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkNotNullExpressionValue(map, "synchronizedMap(mutableMapOf())");
        this.watchEventSubscriptions = map;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final URI getUri() {
        return this.uri;
    }

    @NotNull
    public final FileManager getFileManager() {
        return this.fileManager;
    }

    public abstract boolean getCanSave();

    @NotNull
    public final ModuleRoot getModuleRoot() {
        return this.moduleRoot;
    }

    public static /* synthetic */ void getModuleRoot$annotations() {
    }

    @NotNull
    protected final Map<String, ResolverReference> getReferenceMap() {
        return this.referenceMap;
    }

    @NotNull
    public final Map<UUID, Function2<WatchEventType, ResolverReference, Unit>> getWatchEventSubscriptions() {
        return this.watchEventSubscriptions;
    }

    @Nullable
    public final ResolverReference getModuleRootTree$avail() {
        return this.moduleRootTree;
    }

    public final void setModuleRootTree$avail(@Nullable ResolverReference resolverReference) {
        this.moduleRootTree = resolverReference;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResolverReference> referencesMatchingAbbreviation(@NotNull String abbreviation, boolean ignoreCase) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(abbreviation, "abbreviation");
        Iterable $this$filter$iv = this.referenceMap.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResolverReference it = (ResolverReference)element$iv$iv;
            boolean bl = false;
            if (!(it.isModule() && this.matchesAbbreviation(it, abbreviation, ignoreCase))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((List)destination$iv$iv);
    }

    public static /* synthetic */ List referencesMatchingAbbreviation$default(ModuleRootResolver moduleRootResolver, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: referencesMatchingAbbreviation");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return moduleRootResolver.referencesMatchingAbbreviation(string2, bl);
    }

    private final boolean matchesAbbreviation(ResolverReference $this$matchesAbbreviation, String abbreviation, boolean ignoreCase) {
        return !((Collection)Strings.matchesAbbreviation$default(Strings.INSTANCE, $this$matchesAbbreviation.getQualifiedName(), abbreviation, false, ignoreCase, 2, null)).isEmpty();
    }

    static /* synthetic */ boolean matchesAbbreviation$default(ModuleRootResolver moduleRootResolver, ResolverReference resolverReference, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: matchesAbbreviation");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return moduleRootResolver.matchesAbbreviation(resolverReference, string2, bl);
    }

    public void provideModuleRootTree(@NotNull Function1<? super ResolverReference, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(successHandler, "successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        this.executeTask(new Function0<Unit>(this, successHandler, failureHandler){
            final /* synthetic */ ModuleRootResolver this$0;
            final /* synthetic */ Function1<ResolverReference, Unit> $successHandler;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            {
                this.this$0 = $receiver;
                this.$successHandler = $successHandler;
                this.$failureHandler = $failureHandler;
                super(0);
            }

            public final void invoke() {
                block2: {
                    Unit unit;
                    ResolverReference resolverReference = this.this$0.getModuleRootTree$avail();
                    if (resolverReference != null) {
                        ResolverReference resolverReference2 = resolverReference;
                        this.$successHandler.invoke(resolverReference2);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit != null) break block2;
                    this.this$0.resolve(this.$successHandler, this.$failureHandler);
                }
            }
        });
    }

    public abstract void resolve(@NotNull Function1<? super ResolverReference, Unit> var1, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> var2);

    public void executeTask(@NotNull Function0<Unit> task2) {
        Intrinsics.checkNotNullParameter(task2, "task");
        this.fileManager.executeFileTask(task2);
    }

    public void close() {
    }

    @NotNull
    public final UUID subscribeRootWatcher(@NotNull Function2<? super WatchEventType, ? super ResolverReference, Unit> watchAction) {
        Intrinsics.checkNotNullParameter(watchAction, "watchAction");
        UUID id = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(id, "id");
        this.watchEventSubscriptions.put(id, watchAction);
        return id;
    }

    public final void unsubscribeRootWatcher(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter(id, "id");
        this.watchEventSubscriptions.remove(id);
    }

    public abstract boolean resolvesToValidModuleRoot();

    @Nullable
    public ModuleNameResolver.ModuleNameResolutionResult find(@NotNull ModuleName qualifiedName2, @NotNull ModuleName initialCanonicalName, @NotNull ModuleNameResolver moduleNameResolver) {
        boolean bl;
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter(initialCanonicalName, "initialCanonicalName");
        Intrinsics.checkNotNullParameter(moduleNameResolver, "moduleNameResolver");
        String[] stringArray = new String[]{"/"};
        List components = CollectionsKt.toMutableList(StringsKt.split$default((CharSequence)initialCanonicalName.getQualifiedName(), stringArray, false, 0, 6, null));
        boolean bl2 = bl = components.size() > 1;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = ((CharSequence)components.get(0)).length() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        while (components.size() >= 2) {
            ResolverReference resolved;
            components.remove(components.size() - 2);
            String name = CollectionsKt.joinToString$default(components, "/", null, null, 0, null, null, 62, null);
            if (this.referenceMap.get(name) == null) continue;
            boolean bl4 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[resolved.getType().ordinal()]) {
                case 1: {
                    List representativeComponents = CollectionsKt.toMutableList(components);
                    representativeComponents.add(CollectionsKt.last(representativeComponents));
                    String representativeName = CollectionsKt.joinToString$default(representativeComponents, "/", null, null, 0, null, null, 62, null);
                    ResolverReference rep = this.referenceMap.get(representativeName);
                    return rep == null ? new ModuleNameResolver.ModuleNameResolutionResult(new UnresolvedModuleException(null, representativeName, this)) : new ModuleNameResolver.ModuleNameResolutionResult(new ResolvedModuleName(rep.getModuleName(), moduleNameResolver.getModuleRoots(), rep, initialCanonicalName.isRename()));
                }
                case 2: {
                    return new ModuleNameResolver.ModuleNameResolutionResult(new ResolvedModuleName(resolved.getModuleName(), moduleNameResolver.getModuleRoots(), resolved, initialCanonicalName.isRename()));
                }
            }
        }
        return null;
    }

    public void provideResolverReference(@NotNull String qualifiedName2, @NotNull Function1<? super ResolverReference, Unit> withReference, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter(withReference, "withReference");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        String qname = StringsKt.replace$default(qualifiedName2, ".avail", "", false, 4, null);
        ResolverReference resolverReference = this.referenceMap.get(qname);
        if (resolverReference != null) {
            ResolverReference reference = resolverReference;
            boolean bl = false;
            withReference.invoke(reference);
            return;
        }
        failureHandler.invoke(FileErrorCode.FILE_NOT_FOUND, null);
    }

    @Nullable
    public ResolverReference getResolverReference(@NotNull String qualifiedName2) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        return this.referenceMap.get(qualifiedName2);
    }

    public abstract void refreshResolverReferenceDigest(@NotNull ResolverReference var1, @NotNull Function2<? super byte[], ? super Long, Unit> var2, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> var3);

    public abstract void refreshResolverMetaData(@NotNull ResolverReference var1, @NotNull Function1<? super Long, Unit> var2, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> var3);

    public abstract void rootManifest(boolean var1, @NotNull Function1<? super List<ResolverReference>, Unit> var2, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> var3);

    public abstract void readFile(boolean var1, @NotNull ResolverReference var2, @NotNull Function2<? super byte[], ? super UUID, Unit> var3, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> var4);

    public abstract void createFile(@NotNull String var1, @NotNull String var2, @NotNull Function0<Unit> var3, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> var4);

    public abstract void createPackage(@NotNull String var1, @NotNull Function0<Unit> var2, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> var3);

    public abstract void createDirectory(@NotNull String var1, @NotNull Function0<Unit> var2, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> var3);

    public abstract void deleteResource(@NotNull String var1, @NotNull Function0<Unit> var2, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> var3);

    public abstract void saveFile(@NotNull ResolverReference var1, @NotNull byte[] var2, @NotNull Function0<Unit> var3, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> var4);

    @NotNull
    public final AbstractFileWrapper fileWrapper(@NotNull UUID id, @NotNull ResolverReference reference) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(reference, "reference");
        return new ManagedFileWrapper(id, reference, this.fileManager);
    }

    @NotNull
    public final URI fullResourceURI(@NotNull String qualifiedName2) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        return new URI(URLEncoder.encode(this.uri + "/" + qualifiedName2, StandardCharsets.UTF_8.toString()));
    }

    @NotNull
    public final String getQualifiedName(@NotNull String targetURI) {
        Intrinsics.checkNotNullParameter(targetURI, "targetURI");
        String string2 = new File(this.uri.getPath()).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "File(uri.path).toString()");
        String uriPath = string2;
        boolean bl = StringsKt.startsWith$default(targetURI, uriPath, false, 2, null);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ModuleRootResolver$getQualifiedName$22 = false;
            String $i$a$-assert-ModuleRootResolver$getQualifiedName$22 = targetURI + " is not in ModuleRoot, " + this.moduleRoot;
            throw new AssertionError((Object)$i$a$-assert-ModuleRootResolver$getQualifiedName$22);
        }
        String[] $i$a$-assert-ModuleRootResolver$getQualifiedName$22 = new String[]{uriPath};
        String relative = (String)StringsKt.split$default((CharSequence)targetURI, $i$a$-assert-ModuleRootResolver$getQualifiedName$22, false, 0, 6, null).get(1);
        String cleansedRelative = StringsKt.replace$default(relative, ".avail", "", false, 4, null);
        return "/" + this.moduleRoot.getName() + (StringsKt.startsWith$default(relative, "/", false, 2, null) ? "" : "/") + cleansedRelative;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lavail/resolver/ModuleRootResolver$WatchEventType;", "", "(Ljava/lang/String;I)V", "CREATE", "MODIFY", "DELETE", "avail"})
    public static final class WatchEventType
    extends Enum<WatchEventType> {
        public static final /* enum */ WatchEventType CREATE = new WatchEventType();
        public static final /* enum */ WatchEventType MODIFY = new WatchEventType();
        public static final /* enum */ WatchEventType DELETE = new WatchEventType();
        private static final /* synthetic */ WatchEventType[] $VALUES;

        public static WatchEventType[] values() {
            return (WatchEventType[])$VALUES.clone();
        }

        public static WatchEventType valueOf(String value) {
            return Enum.valueOf(WatchEventType.class, value);
        }

        static {
            $VALUES = watchEventTypeArray = new WatchEventType[]{WatchEventType.CREATE, WatchEventType.MODIFY, WatchEventType.DELETE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceType.values().length];
            try {
                nArray[ResourceType.PACKAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.MODULE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

