/*
 * Decompiled with CFR 0.152.
 */
package avail.stacks;

import avail.AvailRuntime;
import avail.builder.ModuleName;
import avail.builder.ModuleNameResolver;
import avail.compiler.ModuleHeader;
import avail.descriptor.tuples.A_Tuple;
import avail.stacks.LinkingFileMap;
import avail.stacks.StacksErrorLog;
import avail.stacks.StacksSynchronizer;
import avail.stacks.module.CommentsModule;
import avail.utility.IO;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0018J\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0013H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lavail/stacks/StacksGenerator;", "", "outputPath", "Ljava/nio/file/Path;", "resolver", "Lavail/builder/ModuleNameResolver;", "(Ljava/nio/file/Path;Lavail/builder/ModuleNameResolver;)V", "errorLog", "Lavail/stacks/StacksErrorLog;", "getErrorLog", "()Lavail/stacks/StacksErrorLog;", "jsonPath", "linkPrefix", "", "linkingFileMap", "Lavail/stacks/LinkingFileMap;", "logPath", "moduleToComments", "", "Lavail/stacks/module/CommentsModule;", "providedDocumentPath", "getResolver", "()Lavail/builder/ModuleNameResolver;", "add", "", "header", "Lavail/compiler/ModuleHeader;", "commentTokens", "Lavail/descriptor/tuples/A_Tuple;", "clear", "generate", "runtime", "Lavail/AvailRuntime;", "outermostModule", "Lavail/builder/ModuleName;", "updateModuleToComments", "commentModule", "Companion", "avail"})
public final class StacksGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path outputPath;
    @NotNull
    private final ModuleNameResolver resolver;
    @NotNull
    private Path providedDocumentPath;
    @NotNull
    private Path jsonPath;
    @NotNull
    private final String linkPrefix;
    @NotNull
    private final Path logPath;
    @NotNull
    private final StacksErrorLog errorLog;
    @NotNull
    private final LinkingFileMap linkingFileMap;
    @NotNull
    private Map<String, CommentsModule> moduleToComments;
    @NotNull
    private static final Path defaultDocumentationPath;

    public StacksGenerator(@NotNull Path outputPath, @NotNull ModuleNameResolver resolver) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter(outputPath, "outputPath");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        this.outputPath = outputPath;
        this.resolver = resolver;
        if (!(!Files.exists(this.outputPath, new LinkOption[0]) || Files.isDirectory(this.outputPath, new LinkOption[0]))) {
            boolean bl = false;
            String string2 = this.outputPath + " exists and is not a directory";
            throw new IllegalArgumentException(string2.toString());
        }
        this.linkPrefix = "index.html#/method";
        this.linkingFileMap = new LinkingFileMap();
        Path path = this.outputPath.resolve("json");
        Intrinsics.checkNotNullExpressionValue(path, "outputPath.resolve(\"json\")");
        this.jsonPath = path;
        Path path2 = this.outputPath.resolve("logs");
        Intrinsics.checkNotNullExpressionValue(path2, "outputPath.resolve(\"logs\")");
        this.logPath = path2;
        this.errorLog = new StacksErrorLog(this.logPath);
        this.providedDocumentPath = this.outputPath;
        this.moduleToComments = new LinkedHashMap();
    }

    @NotNull
    public final ModuleNameResolver getResolver() {
        return this.resolver;
    }

    @NotNull
    public final StacksErrorLog getErrorLog() {
        return this.errorLog;
    }

    public final synchronized void add(@NotNull ModuleHeader header, @NotNull A_Tuple commentTokens) {
        Intrinsics.checkNotNullParameter(header, "header");
        Intrinsics.checkNotNullParameter(commentTokens, "commentTokens");
        CommentsModule commentsModule = new CommentsModule(header, commentTokens, this.errorLog, this.resolver, this.moduleToComments, this.linkingFileMap, this.linkPrefix);
        this.updateModuleToComments(commentsModule);
    }

    private final void updateModuleToComments(CommentsModule commentModule) {
        this.moduleToComments.put(commentModule.getModuleName(), commentModule);
    }

    public final synchronized void generate(@NotNull AvailRuntime runtime, @NotNull ModuleName outermostModule) throws IOException {
        Intrinsics.checkNotNullParameter(runtime, "runtime");
        Intrinsics.checkNotNullParameter(outermostModule, "outermostModule");
        String string2 = "</ol>\n<h4>Error Count: %d</h4>\n</body>\n</html>";
        Object[] objectArray = new Object[]{this.errorLog.errorCount()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
        String string4 = string3;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
        byte[] byArray = string4.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        ByteBuffer closeHTML = ByteBuffer.wrap(byArray);
        Intrinsics.checkNotNullExpressionValue(closeHTML, "closeHTML");
        this.errorLog.addLogEntry(closeHTML, 0);
        CommentsModule commentsModule = this.moduleToComments.get(outermostModule.getQualifiedName());
        Intrinsics.checkNotNull(commentsModule);
        CommentsModule outerMost = commentsModule;
        try {
            Files.createDirectories(this.outputPath, new FileAttribute[0]);
            Files.createDirectories(this.providedDocumentPath, new FileAttribute[0]);
            Files.createDirectories(this.jsonPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int fileToOutPutCount = outerMost.calculateFinalImplementationGroupsMap(this.linkingFileMap, this.outputPath, runtime, "/library-documentations");
        if (fileToOutPutCount > 0) {
            StacksSynchronizer synchronizer = new StacksSynchronizer(fileToOutPutCount);
            CommentsModule commentsModule2 = this.moduleToComments.get(outermostModule.getQualifiedName());
            Intrinsics.checkNotNull(commentsModule2);
            commentsModule2.writeMethodsToJSONFiles(this.providedDocumentPath, synchronizer, runtime, this.linkingFileMap, this.errorLog);
            synchronizer.waitForWorkUnitsToComplete();
        }
        Path path = this.jsonPath.resolve("internalLink.json");
        Intrinsics.checkNotNullExpressionValue(path, "jsonPath.resolve(\"internalLink.json\")");
        this.linkingFileMap.writeInternalLinksToJSON(path);
        Path path2 = this.jsonPath.resolve("categories.json");
        Intrinsics.checkNotNullExpressionValue(path2, "jsonPath.resolve(\"categories.json\")");
        this.linkingFileMap.writeCategoryLinksToJSON(path2);
        Path path3 = this.jsonPath.resolve("categoriesDescriptions.json");
        Intrinsics.checkNotNullExpressionValue(path3, "jsonPath.resolve(\"categoriesDescriptions.json\")");
        this.linkingFileMap.writeCategoryDescriptionToJSON(path3, this.errorLog);
        Path path4 = this.jsonPath.resolve("moduleDescriptions.json");
        Intrinsics.checkNotNullExpressionValue(path4, "jsonPath.resolve(\"moduleDescriptions.json\")");
        this.linkingFileMap.writeModuleCommentsToJSON(path4, this.errorLog);
        AsynchronousFileChannel asynchronousFileChannel = this.errorLog.file();
        Intrinsics.checkNotNull(asynchronousFileChannel);
        IO.INSTANCE.close(asynchronousFileChannel);
        this.clear();
    }

    public final synchronized void clear() {
        this.moduleToComments.clear();
        this.linkingFileMap.clear();
    }

    static {
        Path path = Paths.get("resources/stacks", new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(\"resources/stacks\")");
        defaultDocumentationPath = path;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lavail/stacks/StacksGenerator$Companion;", "", "()V", "defaultDocumentationPath", "Ljava/nio/file/Path;", "getDefaultDocumentationPath", "()Ljava/nio/file/Path;", "getOuterTemplate", "", "templateFilePath", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path getDefaultDocumentationPath() {
            return defaultDocumentationPath;
        }

        @NotNull
        public final String getOuterTemplate(@NotNull Path templateFilePath) throws IOException {
            Intrinsics.checkNotNullParameter(templateFilePath, "templateFilePath");
            FileInputStream templateFile = new FileInputStream(((Object)templateFilePath).toString());
            FileChannel channel = templateFile.getChannel();
            ByteBuffer buf = ByteBuffer.allocate((int)channel.size());
            channel.read(buf);
            Intrinsics.checkNotNullExpressionValue(channel, "channel");
            IO.INSTANCE.close(channel);
            IO.INSTANCE.close(templateFile);
            byte[] byArray = buf.array();
            Intrinsics.checkNotNullExpressionValue(byArray, "buf.array()");
            byte[] byArray2 = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            Charset charset2 = charset;
            return new String(byArray2, charset2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

