/*
 * Decompiled with CFR 0.152.
 */
package avail.stacks.comment;

import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.StringDescriptor;
import avail.stacks.CommentGroup;
import avail.stacks.LinkingFileMap;
import avail.stacks.StacksDescription;
import avail.stacks.StacksErrorLog;
import avail.stacks.comment.AvailComment;
import avail.stacks.comment.signature.CommentSignature;
import avail.stacks.module.StacksImportModule;
import avail.stacks.tags.StacksAliasTag;
import avail.stacks.tags.StacksAuthorTag;
import avail.stacks.tags.StacksCategoryTag;
import avail.stacks.tags.StacksForbidsTag;
import avail.stacks.tags.StacksSeeTag;
import avail.stacks.tokens.QuotedStacksToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007\u0012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0016J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0000J(\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0018H\u0016R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006/"}, d2={"Lavail/stacks/comment/GrammaticalRestrictionComment;", "Lavail/stacks/comment/AvailComment;", "signature", "Lavail/stacks/comment/signature/CommentSignature;", "commentStartLine", "", "author", "", "Lavail/stacks/tags/StacksAuthorTag;", "sees", "Lavail/stacks/tags/StacksSeeTag;", "description", "Lavail/stacks/StacksDescription;", "categories", "Lavail/stacks/tags/StacksCategoryTag;", "aliases", "Lavail/stacks/tags/StacksAliasTag;", "forbids", "", "Lavail/stacks/tags/StacksForbidsTag;", "(Lavail/stacks/comment/signature/CommentSignature;ILjava/util/List;Ljava/util/List;Lavail/stacks/StacksDescription;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "hashID", "modules", "", "", "getModules$avail", "()Ljava/util/List;", "addImplementationToImportModule", "", "name", "Lavail/descriptor/tuples/A_String;", "importModule", "Lavail/stacks/module/StacksImportModule;", "addToImplementationGroup", "commentGroup", "Lavail/stacks/CommentGroup;", "mergeGrammaticalRestrictionImplementations", "implementation", "toJSON", "linkingFileMap", "Lavail/stacks/LinkingFileMap;", "nameOfGroup", "errorLog", "Lavail/stacks/StacksErrorLog;", "jsonWriter", "Lorg/availlang/json/JSONWriter;", "toString", "avail"})
public final class GrammaticalRestrictionComment
extends AvailComment {
    @NotNull
    private final Map<Integer, StacksForbidsTag> forbids;
    @NotNull
    private final List<String> modules;
    private final int hashID;

    public GrammaticalRestrictionComment(@NotNull CommentSignature signature2, int commentStartLine, @NotNull List<StacksAuthorTag> author, @NotNull List<StacksSeeTag> sees, @NotNull StacksDescription description2, @NotNull List<StacksCategoryTag> categories, @NotNull List<StacksAliasTag> aliases, @NotNull Map<Integer, StacksForbidsTag> forbids) {
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(author, "author");
        Intrinsics.checkNotNullParameter(sees, "sees");
        Intrinsics.checkNotNullParameter(description2, "description");
        Intrinsics.checkNotNullParameter(categories, "categories");
        Intrinsics.checkNotNullParameter(aliases, "aliases");
        Intrinsics.checkNotNullParameter(forbids, "forbids");
        super(signature2, commentStartLine, author, sees, description2, categories, aliases, false);
        this.forbids = forbids;
        this.modules = new ArrayList();
        this.modules.add(signature2.getModule());
        this.hashID = StringDescriptor.Companion.stringFrom(signature2.getName()).hash();
    }

    @NotNull
    public final List<String> getModules$avail() {
        return this.modules;
    }

    @Override
    public void addToImplementationGroup(@NotNull CommentGroup commentGroup) {
        Intrinsics.checkNotNullParameter(commentGroup, "commentGroup");
        commentGroup.addGrammaticalRestriction(this);
    }

    public final void mergeGrammaticalRestrictionImplementations(@NotNull GrammaticalRestrictionComment implementation) {
        Intrinsics.checkNotNullParameter(implementation, "implementation");
        this.modules.add(implementation.getSignature$avail().getModule());
        Iterator<Integer> iterator2 = implementation.forbids.keySet().iterator();
        while (iterator2.hasNext()) {
            StacksForbidsTag it;
            int arity = ((Number)iterator2.next()).intValue();
            if (this.forbids.containsKey(arity)) {
                StacksForbidsTag v;
                if (this.forbids.get(arity) == null) continue;
                boolean bl = false;
                if (implementation.forbids.get(arity) == null) continue;
                boolean bl2 = false;
                it.getForbidMethods().addAll((Collection<QuotedStacksToken>)v.getForbidMethods());
                continue;
            }
            if (implementation.forbids.get(arity) == null) continue;
            boolean bl = false;
            Integer n = arity;
            this.forbids.put(n, it);
        }
    }

    @Override
    public void addImplementationToImportModule(@NotNull A_String name, @NotNull StacksImportModule importModule) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(importModule, "importModule");
        importModule.addGrammaticalImplementation(name, this);
    }

    @Override
    public void toJSON(@NotNull LinkingFileMap linkingFileMap, @NotNull String nameOfGroup, @NotNull StacksErrorLog errorLog, @NotNull JSONWriter jsonWriter2) {
        Intrinsics.checkNotNullParameter(linkingFileMap, "linkingFileMap");
        Intrinsics.checkNotNullParameter(nameOfGroup, "nameOfGroup");
        Intrinsics.checkNotNullParameter(errorLog, "errorLog");
        Intrinsics.checkNotNullParameter(jsonWriter2, "jsonWriter");
        jsonWriter2.write("grammaticalRestrictions");
        jsonWriter2.startArray();
        Iterator<Integer> iterator2 = this.forbids.keySet().iterator();
        while (iterator2.hasNext()) {
            int arity = ((Number)iterator2.next()).intValue();
            StacksForbidsTag stacksForbidsTag = this.forbids.get(arity);
            if (stacksForbidsTag == null) continue;
            stacksForbidsTag.toJSON(linkingFileMap, this.hashID, errorLog, 1, jsonWriter2);
        }
        jsonWriter2.endArray();
    }

    @NotNull
    public String toString() {
        return this.getSignature$avail().toString();
    }
}

