/*
 * Decompiled with CFR 0.152.
 */
package avail.stacks.scanner;

import avail.descriptor.tokens.A_Token;
import avail.descriptor.tuples.A_String;
import avail.stacks.LinkingFileMap;
import avail.stacks.StacksParser;
import avail.stacks.comment.AvailComment;
import avail.stacks.exceptions.StacksCommentBuilderException;
import avail.stacks.exceptions.StacksScannerException;
import avail.stacks.scanner.AbstractStacksScanner;
import avail.stacks.tokens.AbstractStacksToken;
import avail.stacks.tokens.StacksToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000 #2\u00020\u0001:\u0002#$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\r\u0010\u001b\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\u001cJ\u0006\u0010\u001d\u001a\u00020\u0017J\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u001e\u001a\u00020\u0017J\u0006\u0010\u001f\u001a\u00020\u0017J\u0006\u0010 \u001a\u00020\u0017J\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010!\u001a\u00020\u0017J\u0006\u0010\"\u001a\u00020\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lavail/stacks/scanner/StacksScanner;", "Lavail/stacks/scanner/AbstractStacksScanner;", "commentToken", "Lavail/descriptor/tokens/A_Token;", "moduleName", "", "(Lavail/descriptor/tokens/A_Token;Ljava/lang/String;)V", "addedParagraphHTMLTag", "", "commentEndsStandardly", "commentStartLine", "", "commentStartsStandardly", "hasHTMLTag", "moduleLeafName", "getModuleLeafName", "()Ljava/lang/String;", "newlineCount", "sectionStartLocations", "", "getSectionStartLocations$avail", "()Ljava/util/List;", "addHTMLTokens", "", "htmlTags", "addedParagraphHTMLTagFalse", "addedParagraphHTMLTagTrue", "atEnd", "atEnd$avail", "decrementNewLineCount", "hasHTMLTagFalse", "hasHTMLTagTrue", "incrementNewlineCount", "resetNewlineCount", "scan", "Companion", "ScannerAction", "avail"})
public final class StacksScanner
extends AbstractStacksScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean commentEndsStandardly;
    private int newlineCount;
    private boolean hasHTMLTag;
    private boolean addedParagraphHTMLTag;
    private final boolean commentStartsStandardly;
    private final int commentStartLine;
    @NotNull
    private final String moduleLeafName;
    @NotNull
    private final List<Integer> sectionStartLocations;

    public StacksScanner(@NotNull A_Token commentToken, @NotNull String moduleName2) {
        Intrinsics.checkNotNullParameter(commentToken, "commentToken");
        Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
        super(moduleName2);
        this.sectionStartLocations = new ArrayList();
        this.resetNewlineCount();
        this.hasHTMLTagFalse();
        this.addedParagraphHTMLTagFalse();
        String string2 = moduleName2.substring(StringsKt.lastIndexOf$default((CharSequence)moduleName2, '/', 0, false, 6, null) + 1);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
        this.moduleLeafName = string2;
        String commentString = A_String.Companion.asNativeString(commentToken.string());
        this.tokenString(commentString);
        this.commentStartLine = commentToken.lineNumber();
        String string3 = this.getTokenString().substring(this.getTokenString().length() - 2);
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
        this.commentEndsStandardly = Intrinsics.areEqual(string3, "*/");
        String string4 = this.getTokenString().substring(0, 3);
        Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        this.commentStartsStandardly = Intrinsics.areEqual(string4, "/**");
        this.lineNumber(commentToken.lineNumber());
        this.filePosition(commentToken.start());
        this.startOfTokenLinePosition(0);
    }

    @NotNull
    public final String getModuleLeafName() {
        return this.moduleLeafName;
    }

    @NotNull
    public final List<Integer> getSectionStartLocations$avail() {
        return this.sectionStartLocations;
    }

    public final void incrementNewlineCount() {
        int n = this.newlineCount;
        this.newlineCount = n + 1;
    }

    public final void decrementNewLineCount() {
        int n = this.newlineCount;
        this.newlineCount = n + -1;
    }

    public final int newlineCount() {
        return this.newlineCount;
    }

    public final void resetNewlineCount() {
        this.newlineCount = 0;
    }

    public final boolean hasHTMLTag() {
        return this.hasHTMLTag;
    }

    public final void hasHTMLTagTrue() {
        this.hasHTMLTag = true;
    }

    public final void hasHTMLTagFalse() {
        this.hasHTMLTag = false;
    }

    public final boolean addedParagraphHTMLTag() {
        return this.addedParagraphHTMLTag;
    }

    public final void addedParagraphHTMLTagTrue() {
        this.addedParagraphHTMLTag = true;
    }

    public final void addedParagraphHTMLTagFalse() {
        this.addedParagraphHTMLTag = false;
    }

    @Override
    public boolean atEnd$avail() {
        return this.commentEndsStandardly ? this.getPosition() == this.getTokenString().length() - 2 : this.getPosition() == this.getTokenString().length();
    }

    public final void scan() throws StacksScannerException {
        if (this.commentStartsStandardly) {
            this.position(3);
        } else {
            this.position(0);
        }
        while (!this.atEnd$avail()) {
            this.startOfToken(this.getPosition());
            ScannerAction.Companion.forCodePoint(this.next()).scan$avail(this);
        }
    }

    public final void addHTMLTokens(@NotNull String htmlTags) {
        Intrinsics.checkNotNullParameter(htmlTags, "htmlTags");
        StacksToken token = StacksToken.Companion.create(htmlTags, this.getPosition() + this.getFilePosition(), this.getLineNumber(), this.startOfTokenLinePosition(), this.getModuleName$avail());
        this.getOutputTokens().add(token);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0080\u0001\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H \u00a2\u0006\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0011"}, d2={"Lavail/stacks/scanner/StacksScanner$ScannerAction;", "", "(Ljava/lang/String;I)V", "scan", "", "scanner", "Lavail/stacks/scanner/StacksScanner;", "scan$avail", "DOUBLE_QUOTE", "BRACKET", "KEYWORD_START", "NEWLINE", "SLASH", "STANDARD_CHARACTER", "WHITESPACE", "ZERO_WIDTH_WHITESPACE", "Companion", "avail"})
    public static final abstract class ScannerAction
    extends Enum<ScannerAction> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ ScannerAction DOUBLE_QUOTE;
        public static final /* enum */ ScannerAction BRACKET;
        public static final /* enum */ ScannerAction KEYWORD_START;
        public static final /* enum */ ScannerAction NEWLINE;
        public static final /* enum */ ScannerAction SLASH;
        public static final /* enum */ ScannerAction STANDARD_CHARACTER;
        public static final /* enum */ ScannerAction WHITESPACE;
        public static final /* enum */ ScannerAction ZERO_WIDTH_WHITESPACE;
        private static final /* synthetic */ ScannerAction[] $VALUES;

        private ScannerAction() {
        }

        public abstract void scan$avail(@NotNull StacksScanner var1) throws StacksScannerException;

        public static ScannerAction[] values() {
            return (ScannerAction[])$VALUES.clone();
        }

        public static ScannerAction valueOf(String value) {
            return Enum.valueOf(ScannerAction.class, value);
        }

        public /* synthetic */ ScannerAction(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            DOUBLE_QUOTE = new DOUBLE_QUOTE("DOUBLE_QUOTE", 0);
            BRACKET = new BRACKET("BRACKET", 1);
            KEYWORD_START = new KEYWORD_START("KEYWORD_START", 2);
            NEWLINE = new NEWLINE("NEWLINE", 3);
            SLASH = new SLASH("SLASH", 4);
            STANDARD_CHARACTER = new STANDARD_CHARACTER("STANDARD_CHARACTER", 5);
            WHITESPACE = new WHITESPACE("WHITESPACE", 6);
            ZERO_WIDTH_WHITESPACE = new ZERO_WIDTH_WHITESPACE("ZERO_WIDTH_WHITESPACE", 7);
            $VALUES = scannerActionArray = new ScannerAction[]{ScannerAction.DOUBLE_QUOTE, ScannerAction.BRACKET, ScannerAction.KEYWORD_START, ScannerAction.NEWLINE, ScannerAction.SLASH, ScannerAction.STANDARD_CHARACTER, ScannerAction.WHITESPACE, ScannerAction.ZERO_WIDTH_WHITESPACE};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/StacksScanner$ScannerAction$Companion;", "", "()V", "forCodePoint", "Lavail/stacks/scanner/StacksScanner$ScannerAction;", "c", "", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ScannerAction forCodePoint(char c) {
                char cp = c;
                return cp < '\u10000' ? ScannerAction.values()[AbstractStacksScanner.Companion.getDispatchTable$avail()[cp]] : (Character.isSpaceChar(c) || Character.isWhitespace(c) ? WHITESPACE : STANDARD_CHARACTER);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0002J\u0015\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lavail/stacks/scanner/StacksScanner$ScannerAction$DOUBLE_QUOTE;", "Lavail/stacks/scanner/StacksScanner$ScannerAction;", "parseUnicodeEscapes", "", "scanner", "Lavail/stacks/scanner/StacksScanner;", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "scan", "scan$avail", "avail"})
        static final class DOUBLE_QUOTE
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            DOUBLE_QUOTE() {
                void var1_1;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void scan$avail(@NotNull StacksScanner scanner) throws StacksScannerException {
                Intrinsics.checkNotNullParameter(scanner, "scanner");
                int literalStartingLine = scanner.getLineNumber();
                if (scanner.atEnd$avail()) {
                    String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Unterminated string literal.</li>";
                    Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.getLineNumber()};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                    throw new StacksScannerException(string3, scanner);
                }
                char c = scanner.next();
                scanner.resetBeingTokenized();
                boolean canErase = true;
                int erasurePosition = 0;
                while (true) {
                    if (c == '\"') {
                        scanner.addQuotedToken$avail();
                        scanner.resetBeingTokenized();
                        return;
                    }
                    char c2 = c;
                    if (c2 == '\\') {
                        if (scanner.atEnd$avail()) {
                            String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Encountered end of file after backslash in string literal.\n";
                            Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.getLineNumber()};
                            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
                            throw new StacksScannerException(string5, scanner);
                        }
                        char c3 = scanner.next();
                        if (c3 == 'n') {
                            scanner.beingTokenized().append('\n');
                        } else if (c3 == 'r') {
                            scanner.beingTokenized().append('\r');
                        } else if (c3 == 't') {
                            scanner.beingTokenized().append('\t');
                        } else if (c3 == '\\') {
                            scanner.beingTokenized().append('\\');
                        } else if (c3 == '\"') {
                            scanner.beingTokenized().append('\"');
                        } else if (c3 == '\r') {
                            if (!scanner.atEnd$avail()) {
                                scanner.peekFor$avail('\n');
                            }
                            canErase = true;
                        } else if (c3 == '\n') {
                            canErase = true;
                        } else if (c3 == '|') {
                            if (!canErase) {
                                String string6 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: The input before  \"\\|\" contains non-whitespace.</li>";
                                Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.getLineNumber()};
                                String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                                Intrinsics.checkNotNullExpressionValue(string7, "format(format, *args)");
                                throw new StacksScannerException(string7, scanner);
                            }
                            scanner.beingTokenized().setLength(erasurePosition);
                            canErase = false;
                        } else if (c3 == '(') {
                            this.parseUnicodeEscapes(scanner, scanner.beingTokenized());
                        } else {
                            if (c3 == '[') {
                                scanner.lineNumber(literalStartingLine);
                                throw new StacksScannerException("Power strings are not yet supported", scanner);
                            }
                            String string8 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Backslash escape should be followed by one of n , r, t, \\, \", (, [, |, or a line break.</li>";
                            Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.getLineNumber()};
                            String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue(string9, "format(format, *args)");
                            throw new StacksScannerException(string9, scanner);
                        }
                        erasurePosition = scanner.beingTokenized().length();
                    } else if (c2 == '\r') {
                        if (!scanner.atEnd$avail()) {
                            scanner.peekFor$avail('\n');
                        }
                        scanner.beingTokenized().append('\n');
                        canErase = true;
                        erasurePosition = scanner.beingTokenized().length();
                    } else if (c2 == '\n') {
                        scanner.beingTokenized().append('\n');
                        canErase = true;
                        erasurePosition = scanner.beingTokenized().length();
                    } else if (c2 == '*') {
                        if (!canErase) {
                            scanner.beingTokenized().append('*');
                            erasurePosition = scanner.beingTokenized().length();
                        }
                    } else {
                        scanner.beingTokenized().append(c);
                        if (canErase && !Character.isWhitespace(c)) {
                            canErase = false;
                        }
                    }
                    if (scanner.atEnd$avail()) {
                        scanner.lineNumber(literalStartingLine);
                        String string10 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Unterminated string literal.</li>";
                        Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.getLineNumber()};
                        String string11 = String.format(string10, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue(string11, "format(format, *args)");
                        throw new StacksScannerException(string11, scanner);
                    }
                    c = scanner.next();
                }
            }

            private final void parseUnicodeEscapes(StacksScanner scanner, StringBuilder stringBuilder) throws StacksScannerException {
                boolean bl;
                if (scanner.atEnd$avail()) {
                    String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Expected hexadecimal Unicode codepoints separated by commas</li>";
                    Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.getLineNumber()};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                    throw new StacksScannerException(string3, scanner);
                }
                char c = scanner.next();
                while (c != ')') {
                    char c2;
                    int value = 0;
                    int digitCount = 0;
                    while (c != ',' && c != ')') {
                        c2 = c;
                        boolean bl2 = '0' <= c2 ? c2 < ':' : false;
                        if (bl2) {
                            value = (value << 4) + c - 48;
                            ++digitCount;
                        } else {
                            boolean bl3 = 'A' <= c2 ? c2 < 'G' : false;
                            if (bl3) {
                                value = (value << 4) + c - 65 + 10;
                                ++digitCount;
                            } else {
                                boolean bl4 = 'a' <= c2 ? c2 < 'g' : false;
                                if (bl4) {
                                    value = (value << 4) + c - 97 + 10;
                                    ++digitCount;
                                } else {
                                    String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Expected a hex digit or comma or closing parenthesis</li>";
                                    Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.getLineNumber()};
                                    String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                                    Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
                                    throw new StacksScannerException(string5, scanner);
                                }
                            }
                        }
                        if (digitCount > 6) {
                            String string6 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Expected at most six hex digits per comma-separated Unicode entry</li>";
                            Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.getLineNumber()};
                            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue(string7, "format(format, *args)");
                            throw new StacksScannerException(string7, scanner);
                        }
                        c = scanner.next();
                    }
                    if (digitCount == 0) {
                        String string8 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Expected a comma-separated list of Unicode code points, each being one to six (upper case) hexadecimal digits</li>";
                        Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.getLineNumber()};
                        String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue(string9, "format(format, *args)");
                        throw new StacksScannerException(string9, scanner);
                    }
                    char c3 = 1 <= digitCount ? (digitCount < 7 ? (char)'\u0001' : '\u0000') : (c2 = '\u0000');
                    if (_Assertions.ENABLED && c2 == '\u0000') {
                        String string10 = "Assertion failed";
                        throw new AssertionError((Object)string10);
                    }
                    if (value > 0x10FFFF) {
                        String string11 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: The maximum allowed code point for a Unicode character is U+10FFFF</li>";
                        Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.getLineNumber()};
                        String string12 = String.format(string11, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue(string12, "format(format, *args)");
                        throw new StacksScannerException(string12, scanner);
                    }
                    stringBuilder.appendCodePoint(value);
                    char c4 = c2 = c == ',' || c == ')' ? (char)'\u0001' : '\u0000';
                    if (_Assertions.ENABLED && c2 == '\u0000') {
                        String string13 = "Assertion failed";
                        throw new AssertionError((Object)string13);
                    }
                    if (c != ',') continue;
                    c = scanner.next();
                }
                boolean bl5 = bl = c == ')';
                if (_Assertions.ENABLED && !bl) {
                    String string14 = "Assertion failed";
                    throw new AssertionError((Object)string14);
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/StacksScanner$ScannerAction$BRACKET;", "Lavail/stacks/scanner/StacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/StacksScanner;", "scan$avail", "avail"})
        static final class BRACKET
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            BRACKET() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull StacksScanner scanner) throws StacksScannerException {
                Intrinsics.checkNotNullParameter(scanner, "scanner");
                int startOfBracket = scanner.getPosition();
                int startOfBracketLineNumber = scanner.getLineNumber();
                int startOfBracketTokenLinePosition = scanner.startOfTokenLinePosition();
                while (Character.isSpaceChar(scanner.peek$avail()) || Character.isWhitespace(scanner.peek$avail())) {
                    scanner.next();
                    if (!scanner.atEnd$avail()) continue;
                    scanner.position(startOfBracket);
                    scanner.lineNumber(startOfBracketLineNumber);
                    scanner.startOfTokenLinePosition(startOfBracketTokenLinePosition);
                    scanner.addCurrentToken$avail();
                    return;
                }
                if (!scanner.peekFor$avail('@')) {
                    if (scanner.getPosition() != startOfBracket + 1) {
                        scanner.position(startOfBracket);
                        scanner.addCurrentToken$avail();
                        return;
                    }
                    return;
                }
                while (!scanner.peekFor$avail('}')) {
                    char c = scanner.next();
                    if (c == '\"') {
                        c = scanner.next();
                        int literalStartingLine = scanner.getLineNumber();
                        while (c != '\"') {
                            if (c == '\\') {
                                if (scanner.atEnd$avail()) {
                                    String string2 = "\n<li><strong>%s</strong><em> Line #: %d </em>: Scanner Error: Encountered end of file after backslash in string literal.\n";
                                    Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.getLineNumber()};
                                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                                    Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                                    throw new StacksScannerException(string3, scanner);
                                }
                                scanner.next();
                            }
                            if (scanner.atEnd$avail()) {
                                scanner.lineNumber(literalStartingLine);
                                String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Unterminated string literal.</li>";
                                Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.getLineNumber()};
                                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                                Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
                                throw new StacksScannerException(string5, scanner);
                            }
                            c = scanner.next();
                        }
                    }
                    if (!scanner.atEnd$avail()) continue;
                    scanner.position(startOfBracket);
                    scanner.lineNumber(startOfBracketLineNumber);
                    scanner.startOfTokenLinePosition(startOfBracketTokenLinePosition);
                    return;
                }
                scanner.addBracketedToken$avail();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/StacksScanner$ScannerAction$KEYWORD_START;", "Lavail/stacks/scanner/StacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/StacksScanner;", "scan$avail", "avail"})
        static final class KEYWORD_START
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            KEYWORD_START() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull StacksScanner scanner) throws StacksScannerException {
                Intrinsics.checkNotNullParameter(scanner, "scanner");
                while (!Character.isSpaceChar(scanner.peek$avail()) && !Character.isWhitespace(scanner.peek$avail())) {
                    scanner.next();
                }
                AbstractStacksToken specialToken = scanner.addKeywordToken$avail();
                if (specialToken.isSectionToken()) {
                    scanner.getSectionStartLocations$avail().add(scanner.getOutputTokens().size() - 1);
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/StacksScanner$ScannerAction$NEWLINE;", "Lavail/stacks/scanner/StacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/StacksScanner;", "scan$avail", "avail"})
        static final class NEWLINE
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            NEWLINE() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull StacksScanner scanner) throws StacksScannerException {
                Intrinsics.checkNotNullParameter(scanner, "scanner");
                scanner.incrementNewlineCount();
                while (Character.isSpaceChar(scanner.peek$avail()) || Character.isWhitespace(scanner.peek$avail())) {
                    char cp = scanner.next();
                    if (Companion.forCodePoint(cp) == this) {
                        scanner.incrementNewlineCount();
                    }
                    if (!scanner.peekFor$avail('*') || Companion.forCodePoint(cp = scanner.next()) != this) continue;
                    scanner.incrementNewlineCount();
                }
                if (scanner.peek$avail() == '<') {
                    scanner.hasHTMLTagTrue();
                }
                if (!scanner.hasHTMLTag() && scanner.newlineCount() > 1 && Companion.forCodePoint(scanner.peek$avail()) != SLASH && Companion.forCodePoint(scanner.peek$avail()) != KEYWORD_START) {
                    if (scanner.addedParagraphHTMLTag()) {
                        scanner.addHTMLTokens("</p>\n<p>");
                    } else {
                        scanner.addHTMLTokens("<p>");
                    }
                    scanner.addedParagraphHTMLTagTrue();
                }
                if (scanner.hasHTMLTag() && scanner.newlineCount() > 1 && scanner.addedParagraphHTMLTag() && Companion.forCodePoint(scanner.peek$avail()) != SLASH && Companion.forCodePoint(scanner.peek$avail()) != KEYWORD_START) {
                    scanner.addHTMLTokens("</p>");
                    scanner.hasHTMLTagFalse();
                }
                if ((Companion.forCodePoint(scanner.peek$avail()) == KEYWORD_START || scanner.atEnd$avail()) && scanner.addedParagraphHTMLTag()) {
                    scanner.addHTMLTokens("</p>");
                    scanner.hasHTMLTagFalse();
                    scanner.addedParagraphHTMLTagFalse();
                }
                scanner.resetNewlineCount();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/StacksScanner$ScannerAction$SLASH;", "Lavail/stacks/scanner/StacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/StacksScanner;", "scan$avail", "avail"})
        static final class SLASH
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            SLASH() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull StacksScanner scanner) throws StacksScannerException {
                Intrinsics.checkNotNullParameter(scanner, "scanner");
                if (!scanner.peekFor$avail('*')) {
                    while (Character.isSpaceChar(scanner.peek$avail()) || Character.isWhitespace(scanner.peek$avail())) {
                        scanner.next();
                    }
                    scanner.addCurrentToken$avail();
                } else {
                    int startLine = scanner.getLineNumber();
                    int depth2 = 1;
                    do {
                        if (scanner.atEnd$avail()) {
                            String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Expected a close comment (*/) to correspond with the open comment (/*) on line #%d</li>";
                            Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.getLineNumber(), startLine};
                            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                            throw new StacksScannerException(string3, scanner);
                        }
                        if (scanner.peekFor$avail('/') && scanner.peekFor$avail('*')) {
                            ++depth2;
                            continue;
                        }
                        if (scanner.peekFor$avail('*')) {
                            if (!scanner.peekFor$avail('/')) continue;
                            --depth2;
                            continue;
                        }
                        scanner.next();
                    } while (depth2 != 0);
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/StacksScanner$ScannerAction$STANDARD_CHARACTER;", "Lavail/stacks/scanner/StacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/StacksScanner;", "scan$avail", "avail"})
        static final class STANDARD_CHARACTER
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            STANDARD_CHARACTER() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull StacksScanner scanner) throws StacksScannerException {
                Intrinsics.checkNotNullParameter(scanner, "scanner");
                while (!Character.isSpaceChar(scanner.peek$avail()) && !Character.isWhitespace(scanner.peek$avail())) {
                    scanner.next();
                }
                scanner.addCurrentToken$avail();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/StacksScanner$ScannerAction$WHITESPACE;", "Lavail/stacks/scanner/StacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/StacksScanner;", "scan$avail", "avail"})
        static final class WHITESPACE
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            WHITESPACE() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull StacksScanner scanner) {
                Intrinsics.checkNotNullParameter(scanner, "scanner");
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/StacksScanner$ScannerAction$ZERO_WIDTH_WHITESPACE;", "Lavail/stacks/scanner/StacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/StacksScanner;", "scan$avail", "avail"})
        static final class ZERO_WIDTH_WHITESPACE
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            ZERO_WIDTH_WHITESPACE() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull StacksScanner scanner) {
                Intrinsics.checkNotNullParameter(scanner, "scanner");
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lavail/stacks/scanner/StacksScanner$Companion;", "", "()V", "processCommentString", "Lavail/stacks/comment/AvailComment;", "commentToken", "Lavail/descriptor/tokens/A_Token;", "moduleName", "", "linkingFileMap", "Lavail/stacks/LinkingFileMap;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final AvailComment processCommentString(@NotNull A_Token commentToken, @NotNull String moduleName2, @NotNull LinkingFileMap linkingFileMap) throws StacksScannerException, StacksCommentBuilderException {
            Intrinsics.checkNotNullParameter(commentToken, "commentToken");
            Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
            Intrinsics.checkNotNullParameter(linkingFileMap, "linkingFileMap");
            StacksScanner scanner = new StacksScanner(commentToken, moduleName2);
            scanner.scan();
            if (scanner.getSectionStartLocations$avail().isEmpty()) {
                String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Malformed comment; has no distinguishing main tags.</li>";
                Object[] objectArray = new Object[]{scanner.getModuleLeafName(), scanner.commentStartLine};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                String errorMessage2 = string3;
                throw new StacksScannerException(errorMessage2, scanner);
            }
            return StacksParser.Companion.parseCommentString(scanner.getOutputTokens(), scanner.getSectionStartLocations$avail(), scanner.getModuleName$avail(), scanner.commentStartLine, linkingFileMap);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

