/*
 * Decompiled with CFR 0.152.
 */
package avail.utility.fsm;

import avail.utility.fsm.StateMachine;
import avail.utility.fsm.StateSummary;
import avail.utility.fsm.StateTransitionArc;
import avail.utility.fsm.ValidationException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\u000e\b\u0002\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u0002*\u000e\b\u0003\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u0002*\u0004\b\u0004\u0010\u00062\u00020\u0007B=\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00020\t\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00030\t\u00a2\u0006\u0002\u0010\rJ/\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00028\u00002\b\u0010\u001a\u001a\u0004\u0018\u00018\u00022\b\u0010\u001b\u001a\u0004\u0018\u00018\u00032\u0006\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ9\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00028\u00002\b\u0010\u001f\u001a\u0004\u0018\u00018\u00012\b\u0010\u001a\u001a\u0004\u0018\u00018\u00022\b\u0010\u001b\u001a\u0004\u0018\u00018\u00032\u0006\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010 J$\u0010!\u001a \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\"J'\u0010#\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00028\u00032\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010%J'\u0010&\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00028\u00022\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00020\u00130\u0010\u00a2\u0006\u0002\u0010%J3\u0010(\u001a \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u00172\u0006\u0010)\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010*J#\u0010+\u001a\u00020\u00112\u0006\u0010)\u001a\u00028\u00002\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000-H\u0002\u00a2\u0006\u0002\u0010.J\u001b\u0010/\u001a\u00020\u00112\u0006\u0010)\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0003\u00a2\u0006\u0002\u00100J\u001b\u00101\u001a\u00020\u00112\u0006\u0010)\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0003\u00a2\u0006\u0002\u00100J\u0013\u00102\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020\u0011H\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00028\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00028\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00020\u00130\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010\u0016\u001a,\u0012\u0004\u0012\u00028\u0000\u0012\"\u0012 \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u00170\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lavail/utility/fsm/StateMachineFactory;", "State", "", "Event", "GuardKey", "ActionKey", "Memento", "", "stateType", "Ljava/lang/Class;", "eventType", "guardKeyType", "actionKeyType", "(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;)V", "actionMap", "Ljava/util/EnumMap;", "Lkotlin/Function1;", "", "guardMap", "", "initialState", "Ljava/lang/Enum;", "summaries", "Lavail/utility/fsm/StateSummary;", "addAutomaticTransition", "startState", "guardKey", "actionKey", "endState", "(Ljava/lang/Enum;Ljava/lang/Enum;Ljava/lang/Enum;Ljava/lang/Enum;)V", "addTransition", "event", "(Ljava/lang/Enum;Ljava/lang/Enum;Ljava/lang/Enum;Ljava/lang/Enum;Ljava/lang/Enum;)V", "createStateMachine", "Lavail/utility/fsm/StateMachine;", "defineAction", "action", "(Ljava/lang/Enum;Lkotlin/jvm/functions/Function1;)V", "defineGuard", "guard", "getSummary", "state", "(Ljava/lang/Enum;)Lavail/utility/fsm/StateSummary;", "recursivelyReachState", "reachable", "Ljava/util/EnumSet;", "(Ljava/lang/Enum;Ljava/util/EnumSet;)V", "setEntryAction", "(Ljava/lang/Enum;Ljava/lang/Enum;)V", "setExitAction", "setInitialState", "(Ljava/lang/Enum;)V", "validate", "avail"})
public final class StateMachineFactory<State extends Enum<State>, Event extends Enum<Event>, GuardKey extends Enum<GuardKey>, ActionKey extends Enum<ActionKey>, Memento> {
    @NotNull
    private final Class<State> stateType;
    @NotNull
    private final Class<Event> eventType;
    @NotNull
    private final Class<GuardKey> guardKeyType;
    @NotNull
    private final Class<ActionKey> actionKeyType;
    @NotNull
    private final EnumMap<GuardKey, Function1<Memento, Boolean>> guardMap;
    @NotNull
    private final EnumMap<ActionKey, Function1<Memento, Unit>> actionMap;
    @NotNull
    private final EnumMap<State, StateSummary<State, Event, GuardKey, ActionKey, Memento>> summaries;
    @Nullable
    private State initialState;

    public StateMachineFactory(@NotNull Class<State> stateType, @NotNull Class<Event> eventType, @NotNull Class<GuardKey> guardKeyType, @NotNull Class<ActionKey> actionKeyType) {
        Intrinsics.checkNotNullParameter(stateType, "stateType");
        Intrinsics.checkNotNullParameter(eventType, "eventType");
        Intrinsics.checkNotNullParameter(guardKeyType, "guardKeyType");
        Intrinsics.checkNotNullParameter(actionKeyType, "actionKeyType");
        this.stateType = stateType;
        this.eventType = eventType;
        this.guardKeyType = guardKeyType;
        this.actionKeyType = actionKeyType;
        this.guardMap = new EnumMap(this.guardKeyType);
        this.actionMap = new EnumMap(this.actionKeyType);
        this.summaries = new EnumMap(this.stateType);
    }

    public final void setInitialState(@NotNull State initialState) {
        Intrinsics.checkNotNullParameter(initialState, "initialState");
        this.initialState = initialState;
    }

    private final StateSummary<State, Event, GuardKey, ActionKey, Memento> getSummary(State state) {
        EnumMap<State, StateSummary<State, Event, GuardKey, ActionKey, Memento>> enumMap = this.summaries;
        Intrinsics.checkNotNull(enumMap, "null cannot be cast to non-null type kotlin.collections.MutableMap<State of avail.utility.fsm.StateMachineFactory, avail.utility.fsm.StateSummary<State of avail.utility.fsm.StateMachineFactory, Event of avail.utility.fsm.StateMachineFactory, GuardKey of avail.utility.fsm.StateMachineFactory, ActionKey of avail.utility.fsm.StateMachineFactory, Memento of avail.utility.fsm.StateMachineFactory>>");
        StateSummary stateSummary = TypeIntrinsics.asMutableMap(enumMap).computeIfAbsent(state, arg_0 -> StateMachineFactory.getSummary$lambda$0(new Function1<State, StateSummary<State, Event, GuardKey, ActionKey, Memento>>(this){
            final /* synthetic */ StateMachineFactory<State, Event, GuardKey, ActionKey, Memento> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final StateSummary<State, Event, GuardKey, ActionKey, Memento> invoke(@NotNull State s) {
                Intrinsics.checkNotNullParameter(s, "s");
                return new StateSummary<State, Event, GuardKey, ActionKey, Memento>(s, StateMachineFactory.access$getEventType$p(this.this$0));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(stateSummary, "private fun getSummary(s\u2026teSummary(s, eventType) }");
        return stateSummary;
    }

    public final void setEntryAction(@NotNull State state, @NotNull ActionKey actionKey) {
        boolean bl;
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(actionKey, "actionKey");
        boolean bl2 = bl = this.getSummary(state).getEntryActionKey() == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.getSummary(state).setEntryActionKey(actionKey);
    }

    public final void setExitAction(@NotNull State state, @NotNull ActionKey actionKey) {
        boolean bl;
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(actionKey, "actionKey");
        boolean bl2 = bl = this.getSummary(state).getExitActionKey() == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.getSummary(state).setExitActionKey(actionKey);
    }

    public final void addTransition(@NotNull State startState, @Nullable Event event, @Nullable GuardKey guardKey, @Nullable ActionKey actionKey, @NotNull State endState) {
        boolean bl;
        Intrinsics.checkNotNullParameter(startState, "startState");
        Intrinsics.checkNotNullParameter(endState, "endState");
        boolean bl2 = bl = event != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.getSummary(startState).addTransitionArc(event, new StateTransitionArc(event, guardKey, actionKey, endState));
    }

    public final void addAutomaticTransition(@NotNull State startState, @Nullable GuardKey guardKey, @Nullable ActionKey actionKey, @NotNull State endState) {
        Intrinsics.checkNotNullParameter(startState, "startState");
        Intrinsics.checkNotNullParameter(endState, "endState");
        this.getSummary(startState).addTransitionArc(null, new StateTransitionArc(null, guardKey, actionKey, endState));
    }

    public final void defineGuard(@NotNull GuardKey guardKey, @NotNull Function1<? super Memento, Boolean> guard) {
        boolean bl;
        Intrinsics.checkNotNullParameter(guardKey, "guardKey");
        Intrinsics.checkNotNullParameter(guard, "guard");
        boolean bl2 = bl = !this.guardMap.containsKey(guardKey);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        ((Map)this.guardMap).put(guardKey, guard);
    }

    public final void defineAction(@NotNull ActionKey actionKey, @NotNull Function1<? super Memento, Unit> action2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(actionKey, "actionKey");
        Intrinsics.checkNotNullParameter(action2, "action");
        boolean bl2 = bl = !this.actionMap.containsKey(actionKey);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        ((Map)this.actionMap).put(actionKey, action2);
    }

    private final void recursivelyReachState(State state, EnumSet<State> reachable) {
        if (!reachable.contains(state)) {
            reachable.add(state);
            for (StateTransitionArc<State, Event, GuardKey, ActionKey, Memento> arc : this.getSummary(state).allTransitionArcs()) {
                this.recursivelyReachState(arc.getNewState(), reachable);
            }
        }
    }

    private final void validate() throws ValidationException {
        State State2 = this.initialState;
        if (State2 == null) {
            throw new ValidationException("no start state is specified");
        }
        State startState = State2;
        EnumSet<State> statesReached = EnumSet.noneOf(this.stateType);
        Intrinsics.checkNotNullExpressionValue(statesReached, "statesReached");
        this.recursivelyReachState(startState, statesReached);
        if (statesReached.size() != this.stateType.getEnumConstants().length) {
            throw new ValidationException("some states of " + this.stateType.getCanonicalName() + " are unreachable");
        }
        EnumSet<Event> eventsHandled = EnumSet.noneOf(this.eventType);
        State[] StateArray = this.stateType.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(StateArray, "stateType.enumConstants");
        Enum[] enumArray = (Enum[])StateArray;
        int n = enumArray.length;
        for (int j = 0; j < n; ++j) {
            Enum state = enumArray[j];
            Intrinsics.checkNotNullExpressionValue(state, "state");
            eventsHandled.addAll(this.getSummary(state).transitionEvents());
        }
        if (eventsHandled.size() != this.eventType.getEnumConstants().length) {
            throw new ValidationException("some events of " + this.eventType.getCanonicalName() + " are unhandled");
        }
        if (this.guardMap.keySet().size() != this.guardKeyType.getEnumConstants().length) {
            throw new ValidationException("some guard keys of " + this.guardKeyType.getCanonicalName() + " are not bound to guards");
        }
        EnumSet<GuardKey> guardKeysInvoked = EnumSet.noneOf(this.guardKeyType);
        State[] StateArray2 = this.stateType.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(StateArray2, "stateType.enumConstants");
        for (Enum state : (Enum[])StateArray2) {
            Intrinsics.checkNotNullExpressionValue(state, "state");
            for (StateTransitionArc<Enum, Event, GuardKey, ActionKey, Memento> stateTransitionArc : this.getSummary(state).allTransitionArcs()) {
                GuardKey guardKey = stateTransitionArc.getGuardKey();
                if (guardKey == null) continue;
                guardKeysInvoked.add(guardKey);
            }
        }
        if (guardKeysInvoked.size() != this.guardKeyType.getEnumConstants().length) {
            throw new ValidationException("some guard keys of " + this.guardKeyType.getCanonicalName() + " are never invoked");
        }
        State[] StateArray3 = this.stateType.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(StateArray3, "stateType.enumConstants");
        Enum[] enumArray2 = (Enum[])StateArray3;
        int n2 = enumArray2.length;
        for (n = 0; n < n2; ++n) {
            Enum state;
            state = enumArray2[n];
            Set unguardedArcsFound = new LinkedHashSet();
            Intrinsics.checkNotNullExpressionValue(state, "state");
            for (StateTransitionArc<Enum, Event, GuardKey, ActionKey, Memento> arc : this.getSummary(state).allTransitionArcs()) {
                Event event = arc.getEvent();
                if (CollectionsKt.contains(unguardedArcsFound, event)) {
                    throw new ValidationException("state " + state + " has an unreachable arc for event " + event + " due to a previous unguarded arc for the same event");
                }
                if (arc.getGuardKey() != null) continue;
                Event Event2 = event;
                Intrinsics.checkNotNull(Event2);
                unguardedArcsFound.add(Event2);
            }
        }
        if (this.actionMap.keySet().size() != this.actionKeyType.getEnumConstants().length) {
            throw new ValidationException("some action keys of " + this.actionKeyType.getCanonicalName() + " are not bound to actions");
        }
        EnumSet<ActionKey> actionKeysInvoked = EnumSet.noneOf(this.actionKeyType);
        State[] StateArray4 = this.stateType.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(StateArray4, "stateType.enumConstants");
        for (Enum state : (Enum[])StateArray4) {
            ActionKey exitKey;
            Intrinsics.checkNotNullExpressionValue(state, "state");
            for (StateTransitionArc<Enum, Event, GuardKey, ActionKey, Memento> arc : this.getSummary(state).allTransitionArcs()) {
                ActionKey actionKey = arc.getActionKey();
                if (actionKey == null) continue;
                actionKeysInvoked.add(actionKey);
            }
            ActionKey ActionKey = this.getSummary(state).getEntryActionKey();
            if (ActionKey != null) {
                actionKeysInvoked.add(ActionKey);
            }
            if ((exitKey = this.getSummary(state).getExitActionKey()) == null) continue;
            actionKeysInvoked.add(exitKey);
        }
        if (actionKeysInvoked.size() != this.actionKeyType.getEnumConstants().length) {
            throw new ValidationException("some action keys of " + this.actionKeyType.getCanonicalName() + " are never invoked");
        }
    }

    @NotNull
    public final StateMachine<State, Event, GuardKey, ActionKey, Memento> createStateMachine() throws ValidationException {
        this.validate();
        for (StateSummary<State, Event, GuardKey, ActionKey, Memento> summary : this.summaries.values()) {
            summary.populateGuardsAndActions((Map)this.guardMap, (Map)this.actionMap);
        }
        State State2 = this.initialState;
        Intrinsics.checkNotNull(State2);
        Collection<StateSummary<State, Event, GuardKey, ActionKey, Memento>> collection2 = this.summaries.values();
        Intrinsics.checkNotNullExpressionValue(collection2, "summaries.values");
        return new StateMachine<State, Event, GuardKey, ActionKey, Memento>(State2, collection2);
    }

    private static final StateSummary getSummary$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (StateSummary)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Class access$getEventType$p(StateMachineFactory $this) {
        return $this.eventType;
    }
}

