/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleAwareClassDescriptorKt;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerLiteralTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.SimpleTypeWithAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeAliasExpander;
import kotlin.reflect.jvm.internal.impl.types.TypeAliasExpansion;
import kotlin.reflect.jvm.internal.impl.types.TypeAliasExpansionReportStrategy;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KotlinTypeFactory {
    @NotNull
    public static final KotlinTypeFactory INSTANCE = new KotlinTypeFactory();
    @NotNull
    private static final Function1<KotlinTypeRefiner, SimpleType> EMPTY_REFINED_TYPE_FACTORY = EMPTY_REFINED_TYPE_FACTORY.1.INSTANCE;

    private KotlinTypeFactory() {
    }

    private final MemberScope computeMemberScope(TypeConstructor constructor, List<? extends TypeProjection> arguments2, KotlinTypeRefiner kotlinTypeRefiner) {
        MemberScope memberScope2;
        ClassifierDescriptor descriptor2 = constructor.getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor = descriptor2;
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            memberScope2 = ((TypeParameterDescriptor)descriptor2).getDefaultType().getMemberScope();
        } else if (classifierDescriptor instanceof ClassDescriptor) {
            KotlinTypeRefiner refinerToUse;
            KotlinTypeRefiner kotlinTypeRefiner2 = kotlinTypeRefiner;
            if (kotlinTypeRefiner2 == null) {
                kotlinTypeRefiner2 = refinerToUse = DescriptorUtilsKt.getKotlinTypeRefiner(DescriptorUtilsKt.getModule(descriptor2));
            }
            memberScope2 = arguments2.isEmpty() ? ModuleAwareClassDescriptorKt.getRefinedUnsubstitutedMemberScopeIfPossible((ClassDescriptor)descriptor2, refinerToUse) : ModuleAwareClassDescriptorKt.getRefinedMemberScopeIfPossible((ClassDescriptor)descriptor2, TypeConstructorSubstitution.Companion.create(constructor, arguments2), refinerToUse);
        } else if (classifierDescriptor instanceof TypeAliasDescriptor) {
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue(((TypeAliasDescriptor)descriptor2).getName().toString(), "descriptor.name.toString()");
            memberScope2 = ErrorUtils.createErrorScope(ErrorScopeKind.SCOPE_FOR_ABBREVIATION_TYPE, true, stringArray);
        } else {
            if (constructor instanceof IntersectionTypeConstructor) {
                return ((IntersectionTypeConstructor)constructor).createScopeForKotlinType();
            }
            throw new IllegalStateException("Unsupported classifier: " + descriptor2 + " for constructor: " + constructor);
        }
        return memberScope2;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SimpleType simpleType(@NotNull TypeAttributes attributes, @NotNull TypeConstructor constructor, @NotNull List<? extends TypeProjection> arguments2, boolean nullable, @Nullable KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        if (attributes.isEmpty() && arguments2.isEmpty() && !nullable && constructor.getDeclarationDescriptor() != null) {
            ClassifierDescriptor classifierDescriptor = constructor.getDeclarationDescriptor();
            Intrinsics.checkNotNull(classifierDescriptor);
            SimpleType simpleType2 = classifierDescriptor.getDefaultType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "constructor.declarationDescriptor!!.defaultType");
            return simpleType2;
        }
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(attributes, constructor, arguments2, nullable, INSTANCE.computeMemberScope(constructor, arguments2, kotlinTypeRefiner), (Function1<? super KotlinTypeRefiner, ? extends SimpleType>)new Function1<KotlinTypeRefiner, SimpleType>(constructor, arguments2, attributes, nullable){
            final /* synthetic */ TypeConstructor $constructor;
            final /* synthetic */ List<TypeProjection> $arguments;
            final /* synthetic */ TypeAttributes $attributes;
            final /* synthetic */ boolean $nullable;
            {
                this.$constructor = $constructor;
                this.$arguments = $arguments;
                this.$attributes = $attributes;
                this.$nullable = $nullable;
                super(1);
            }

            @Nullable
            public final SimpleType invoke(@NotNull KotlinTypeRefiner refiner) {
                Intrinsics.checkNotNullParameter(refiner, "refiner");
                ExpandedTypeOrRefinedConstructor expandedTypeOrRefinedConstructor = KotlinTypeFactory.access$refineConstructor(KotlinTypeFactory.INSTANCE, this.$constructor, refiner, this.$arguments);
                if (expandedTypeOrRefinedConstructor == null) {
                    return null;
                }
                ExpandedTypeOrRefinedConstructor expandedTypeOrRefinedConstructor2 = expandedTypeOrRefinedConstructor;
                SimpleType simpleType2 = expandedTypeOrRefinedConstructor2.getExpandedType();
                if (simpleType2 != null) {
                    SimpleType it = simpleType2;
                    boolean bl = false;
                    return it;
                }
                TypeConstructor typeConstructor2 = expandedTypeOrRefinedConstructor2.getRefinedConstructor();
                Intrinsics.checkNotNull(typeConstructor2);
                return KotlinTypeFactory.simpleType(this.$attributes, typeConstructor2, this.$arguments, this.$nullable, refiner);
            }
        });
    }

    public static /* synthetic */ SimpleType simpleType$default(TypeAttributes typeAttributes, TypeConstructor typeConstructor2, List list2, boolean bl, KotlinTypeRefiner kotlinTypeRefiner, int n, Object object) {
        if ((n & 0x10) != 0) {
            kotlinTypeRefiner = null;
        }
        return KotlinTypeFactory.simpleType(typeAttributes, typeConstructor2, list2, bl, kotlinTypeRefiner);
    }

    @JvmStatic
    @NotNull
    public static final SimpleType computeExpandedType(@NotNull TypeAliasDescriptor $this$computeExpandedType, @NotNull List<? extends TypeProjection> arguments2) {
        Intrinsics.checkNotNullParameter($this$computeExpandedType, "<this>");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        return new TypeAliasExpander(TypeAliasExpansionReportStrategy.DO_NOTHING.INSTANCE, false).expand(TypeAliasExpansion.Companion.create(null, $this$computeExpandedType, arguments2), TypeAttributes.Companion.getEmpty());
    }

    private final ExpandedTypeOrRefinedConstructor refineConstructor(TypeConstructor constructor, KotlinTypeRefiner kotlinTypeRefiner, List<? extends TypeProjection> arguments2) {
        ClassifierDescriptor classifierDescriptor;
        block5: {
            block4: {
                ClassifierDescriptor basicDescriptor = constructor.getDeclarationDescriptor();
                classifierDescriptor = basicDescriptor;
                if (classifierDescriptor == null) break block4;
                ClassifierDescriptor it = classifierDescriptor;
                boolean bl = false;
                ClassifierDescriptor classifierDescriptor2 = kotlinTypeRefiner.refineDescriptor(it);
                classifierDescriptor = classifierDescriptor2;
                if (classifierDescriptor2 != null) break block5;
            }
            return null;
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        if (descriptor2 instanceof TypeAliasDescriptor) {
            return new ExpandedTypeOrRefinedConstructor(KotlinTypeFactory.computeExpandedType((TypeAliasDescriptor)descriptor2, arguments2), null);
        }
        TypeConstructor typeConstructor2 = descriptor2.getTypeConstructor().refine(kotlinTypeRefiner);
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "descriptor.typeConstruct\u2026refine(kotlinTypeRefiner)");
        TypeConstructor refinedConstructor = typeConstructor2;
        return new ExpandedTypeOrRefinedConstructor(null, refinedConstructor);
    }

    @JvmStatic
    @NotNull
    public static final SimpleType simpleTypeWithNonTrivialMemberScope(@NotNull TypeAttributes attributes, @NotNull TypeConstructor constructor, @NotNull List<? extends TypeProjection> arguments2, boolean nullable, @NotNull MemberScope memberScope2) {
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(memberScope2, "memberScope");
        SimpleTypeImpl it = new SimpleTypeImpl(constructor, arguments2, nullable, memberScope2, (Function1<? super KotlinTypeRefiner, ? extends SimpleType>)new Function1<KotlinTypeRefiner, SimpleType>(constructor, arguments2, attributes, nullable, memberScope2){
            final /* synthetic */ TypeConstructor $constructor;
            final /* synthetic */ List<TypeProjection> $arguments;
            final /* synthetic */ TypeAttributes $attributes;
            final /* synthetic */ boolean $nullable;
            final /* synthetic */ MemberScope $memberScope;
            {
                this.$constructor = $constructor;
                this.$arguments = $arguments;
                this.$attributes = $attributes;
                this.$nullable = $nullable;
                this.$memberScope = $memberScope;
                super(1);
            }

            @Nullable
            public final SimpleType invoke(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
                Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
                ExpandedTypeOrRefinedConstructor expandedTypeOrRefinedConstructor = KotlinTypeFactory.access$refineConstructor(KotlinTypeFactory.INSTANCE, this.$constructor, kotlinTypeRefiner, this.$arguments);
                if (expandedTypeOrRefinedConstructor == null) {
                    return null;
                }
                ExpandedTypeOrRefinedConstructor expandedTypeOrRefinedConstructor2 = expandedTypeOrRefinedConstructor;
                SimpleType simpleType2 = expandedTypeOrRefinedConstructor2.getExpandedType();
                if (simpleType2 != null) {
                    SimpleType it = simpleType2;
                    boolean bl = false;
                    return it;
                }
                TypeConstructor typeConstructor2 = expandedTypeOrRefinedConstructor2.getRefinedConstructor();
                Intrinsics.checkNotNull(typeConstructor2);
                return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(this.$attributes, typeConstructor2, this.$arguments, this.$nullable, this.$memberScope);
            }
        });
        boolean bl = false;
        return attributes.isEmpty() ? (SimpleType)it : (SimpleType)new SimpleTypeWithAttributes(it, attributes);
    }

    @JvmStatic
    @NotNull
    public static final SimpleType simpleTypeWithNonTrivialMemberScope(@NotNull TypeAttributes attributes, @NotNull TypeConstructor constructor, @NotNull List<? extends TypeProjection> arguments2, boolean nullable, @NotNull MemberScope memberScope2, @NotNull Function1<? super KotlinTypeRefiner, ? extends SimpleType> refinedTypeFactory) {
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(memberScope2, "memberScope");
        Intrinsics.checkNotNullParameter(refinedTypeFactory, "refinedTypeFactory");
        SimpleTypeImpl it = new SimpleTypeImpl(constructor, arguments2, nullable, memberScope2, refinedTypeFactory);
        boolean bl = false;
        return attributes.isEmpty() ? (SimpleType)it : (SimpleType)new SimpleTypeWithAttributes(it, attributes);
    }

    @JvmStatic
    @NotNull
    public static final SimpleType simpleNotNullType(@NotNull TypeAttributes attributes, @NotNull ClassDescriptor descriptor2, @NotNull List<? extends TypeProjection> arguments2) {
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        TypeConstructor typeConstructor2 = descriptor2.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "descriptor.typeConstructor");
        return KotlinTypeFactory.simpleType$default(attributes, typeConstructor2, arguments2, false, null, 16, null);
    }

    @JvmStatic
    @NotNull
    public static final SimpleType simpleType(@NotNull SimpleType baseType, @NotNull TypeAttributes annotations2, @NotNull TypeConstructor constructor, @NotNull List<? extends TypeProjection> arguments2, boolean nullable) {
        Intrinsics.checkNotNullParameter(baseType, "baseType");
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        return KotlinTypeFactory.simpleType$default(annotations2, constructor, arguments2, nullable, null, 16, null);
    }

    public static /* synthetic */ SimpleType simpleType$default(SimpleType simpleType2, TypeAttributes typeAttributes, TypeConstructor typeConstructor2, List list2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            typeAttributes = simpleType2.getAttributes();
        }
        if ((n & 4) != 0) {
            typeConstructor2 = simpleType2.getConstructor();
        }
        if ((n & 8) != 0) {
            list2 = simpleType2.getArguments();
        }
        if ((n & 0x10) != 0) {
            bl = simpleType2.isMarkedNullable();
        }
        return KotlinTypeFactory.simpleType(simpleType2, typeAttributes, typeConstructor2, list2, bl);
    }

    @JvmStatic
    @NotNull
    public static final UnwrappedType flexibleType(@NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        Intrinsics.checkNotNullParameter(lowerBound, "lowerBound");
        Intrinsics.checkNotNullParameter(upperBound, "upperBound");
        if (Intrinsics.areEqual(lowerBound, upperBound)) {
            return lowerBound;
        }
        return new FlexibleTypeImpl(lowerBound, upperBound);
    }

    @JvmStatic
    @NotNull
    public static final SimpleType integerLiteralType(@NotNull TypeAttributes attributes, @NotNull IntegerLiteralTypeConstructor constructor, boolean nullable) {
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        String[] stringArray = new String[]{"unknown integer literal type"};
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(attributes, constructor, CollectionsKt.emptyList(), nullable, ErrorUtils.createErrorScope(ErrorScopeKind.INTEGER_LITERAL_TYPE_SCOPE, true, stringArray));
    }

    public static final /* synthetic */ ExpandedTypeOrRefinedConstructor access$refineConstructor(KotlinTypeFactory $this, TypeConstructor constructor, KotlinTypeRefiner kotlinTypeRefiner, List arguments2) {
        return $this.refineConstructor(constructor, kotlinTypeRefiner, arguments2);
    }

    private static final class ExpandedTypeOrRefinedConstructor {
        @Nullable
        private final SimpleType expandedType;
        @Nullable
        private final TypeConstructor refinedConstructor;

        public ExpandedTypeOrRefinedConstructor(@Nullable SimpleType expandedType, @Nullable TypeConstructor refinedConstructor) {
            this.expandedType = expandedType;
            this.refinedConstructor = refinedConstructor;
        }

        @Nullable
        public final SimpleType getExpandedType() {
            return this.expandedType;
        }

        @Nullable
        public final TypeConstructor getRefinedConstructor() {
            return this.refinedConstructor;
        }
    }
}

