/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact;

import java.io.File;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.availlang.artifact.AvailArtifactException;
import org.availlang.artifact.DigestUtility;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004J\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"Lorg/availlang/artifact/DigestUtility;", "", "()V", "createDigest", "", "rootPath", "digestAlgorithm", "parseDigest", "", "", "digestFileContent", "writeDigestFile", "", "targetFile", "Ljava/io/File;", "avail-artifact"})
public final class DigestUtility {
    @NotNull
    public static final DigestUtility INSTANCE = new DigestUtility();

    private DigestUtility() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String createDigest(@NotNull String rootPath, @NotNull String digestAlgorithm) {
        void $this$forEach$iv;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(rootPath, "rootPath");
        Intrinsics.checkNotNullParameter(digestAlgorithm, "digestAlgorithm");
        File root = new File(rootPath);
        if (!root.isDirectory()) {
            throw new AvailArtifactException("Failed to create a module root digest; provided root path, " + rootPath + ", is not a directory");
        }
        StringBuilder $this$createDigest_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Sequence sequence = SequencesKt.filter(FilesKt.walk$default(root, null, 1, null), createDigest.1.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file2 = (File)element$iv;
            boolean bl2 = false;
            MessageDigest digest = MessageDigest.getInstance(digestAlgorithm);
            digest.update(FilesKt.readBytes(file2));
            byte[] byArray = digest.digest();
            Intrinsics.checkNotNullExpressionValue(byArray, "digest.digest()");
            String hex2 = ArraysKt.joinToString$default(byArray, (CharSequence)"", null, null, 0, null, (Function1)createDigest.1.2.hex.1.INSTANCE, 30, null);
            $this$createDigest_u24lambda_u241.append(StringsKt.replace$default(FilesKt.toRelativeString(file2, root), "\\", "/", false, 4, null) + ":" + hex2 + "\n");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static /* synthetic */ String createDigest$default(DigestUtility digestUtility, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "SHA-256";
        }
        return digestUtility.createDigest(string2, string3);
    }

    public final void writeDigestFile(@NotNull String rootPath, @NotNull File targetFile, @NotNull String digestAlgorithm) {
        Intrinsics.checkNotNullParameter(rootPath, "rootPath");
        Intrinsics.checkNotNullParameter(targetFile, "targetFile");
        Intrinsics.checkNotNullParameter(digestAlgorithm, "digestAlgorithm");
        FilesKt.writeText$default(targetFile, this.createDigest(rootPath, digestAlgorithm), null, 2, null);
    }

    public static /* synthetic */ void writeDigestFile$default(DigestUtility digestUtility, String string2, File file2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "SHA-256";
        }
        digestUtility.writeDigestFile(string2, file2, string3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, byte[]> parseDigest(@NotNull String digestFileContent) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(digestFileContent, "digestFileContent");
        Map digests = new LinkedHashMap();
        Iterable $this$filter$iv = StringsKt.lines(digestFileContent);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)p0).length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object element$iv$iv;
            String line = (String)element$iv;
            boolean bl = false;
            element$iv$iv = new String[]{":"};
            List list2 = StringsKt.split$default((CharSequence)line, element$iv$iv, false, 0, 6, null);
            String innerFileName = (String)list2.get(0);
            String digestString = (String)list2.get(1);
            int n = 0;
            int n2 = digestString.length() >>> 1;
            byte[] byArray = new byte[n2];
            while (n < n2) {
                int n3 = n++;
                String string2 = digestString.substring(n3 << 1, (n3 << 1) + 2);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                byArray[n3] = (byte)Integer.parseInt(string2, CharsKt.checkRadix(16));
            }
            byte[] digestBytes = byArray;
            digests.put(innerFileName, digestBytes);
        }
        return digests;
    }
}

